/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.mrelib.util;

import cz.zcu.mre.mrelib.Const;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.RDFDataMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RDFDataAccess {
    private static final Logger LOG = LoggerFactory.getLogger(RDFDataAccess.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Model readModelFromFile(File file, String baseURI, String serialization) {
        Model model = ModelFactory.createDefaultModel();
        Reader fi = null;
        try {
            fi = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Const.CHARSET));
            model.read(fi, baseURI, serialization);
        }
        catch (FileNotFoundException ex) {
            LOG.error(null, (Throwable)ex);
        }
        finally {
            try {
                if (fi != null) {
                    fi.close();
                }
            }
            catch (IOException ex) {
                LOG.error(null, (Throwable)ex);
            }
        }
        return model;
    }

    public static Model readModel(String filename, String serialization) {
        Model model = ModelFactory.createDefaultModel();
        TypedInputStream in = RDFDataMgr.open((String)filename);
        if (in == null) {
            LOG.error("File '{}' not found.", (Object)filename);
        } else {
            model.read((InputStream)in, "https://mre.zcu.cz/id/", serialization);
        }
        return model;
    }

    public static Model readModel(InputStream is, String baseURI, String serialization) {
        Model model = ModelFactory.createDefaultModel();
        if (is == null) {
            LOG.error("Null input stream when reading model.");
        } else {
            model.read(is, baseURI, serialization);
        }
        return model;
    }

    public static Model readModel(InputStream is, String serialization) {
        Model model = ModelFactory.createDefaultModel();
        if (is == null) {
            LOG.error("Null input stream when reading model.");
        } else {
            model.read(is, "https://mre.zcu.cz/id/", serialization);
        }
        return model;
    }

    public static void writeModel(Model model, String outputFile, String serialization) {
        if (outputFile == null || outputFile.isEmpty()) {
            LOG.error("Output file name is null or empty.");
            return;
        }
        try (FileOutputStream fout = new FileOutputStream(outputFile);){
            model.write((OutputStream)fout, serialization);
        }
        catch (FileNotFoundException e) {
            LOG.error(null, (Throwable)e);
        }
        catch (IOException e) {
            LOG.error(null, (Throwable)e);
        }
    }

    public static InputStream getInputStream(File file) {
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            LOG.error(null, (Throwable)e);
        }
        return is;
    }

    public static void exportRDFModel(Model model, File exportFile, String serialization) {
        try {
            if (!exportFile.createNewFile()) {
                LOG.error("File for RDF data export cannot be created {}", (Object)exportFile.getAbsolutePath());
                return;
            }
        }
        catch (IOException ex) {
            LOG.error(null, (Throwable)ex);
        }
        try (FileOutputStream fos = new FileOutputStream(exportFile);){
            model.write((OutputStream)fos, serialization);
            fos.close();
        }
        catch (FileNotFoundException e) {
            LOG.error("Export file not found or no write access to {}", (Object)exportFile.getAbsolutePath());
            LOG.error(null, (Throwable)e);
        }
        catch (IOException e) {
            LOG.error(null, (Throwable)e);
        }
    }

    private RDFDataAccess() {
    }
}

