/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.mrelib.util;

import cz.zcu.mre.mrelib.Const;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.List;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeleteStatementUtil {
    private static final int TRIPLE_SIZE = 3;
    private static final Logger LOG = LoggerFactory.getLogger(DeleteStatementUtil.class);

    public static void deleteData(Model model, List<File> conditionFiles) {
        conditionFiles.stream().forEach(file -> {
            BufferedReader br = null;
            try {
                String condition;
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((File)file), Const.CHARSET));
                while ((condition = br.readLine()) != null) {
                    if (condition.startsWith("#")) continue;
                    LOG.info("REMOVE at {} and condition is: {}", (Object)new Date(), (Object)condition);
                    String[] parts = condition.split("[\t ]+", 3);
                    Object s = DeleteStatementUtil.getTripleComponent(model, parts[0], 0);
                    Object p = DeleteStatementUtil.getTripleComponent(model, parts[1], 1);
                    Object o = DeleteStatementUtil.getTripleComponent(model, parts[2], 2);
                    long sizeBefore = model.size();
                    model.removeAll((Resource)s, (Property)p, (RDFNode)o);
                    long sizeAfter = model.size();
                    LOG.info("REMOVED {} statements. Model size is {} and it was {} statements.", new Object[]{sizeBefore - sizeAfter, sizeAfter, sizeBefore});
                }
            }
            catch (FileNotFoundException e) {
                LOG.error(null, (Throwable)e);
            }
            catch (IOException e) {
                LOG.error(null, (Throwable)e);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        LOG.error(null, (Throwable)e);
                    }
                }
            }
        });
    }

    public static Object getTripleComponent(Model model, String text, int position) {
        String column = text;
        Resource o = null;
        if (column.startsWith("?") || column.startsWith("$")) {
            return o;
        }
        if (column.startsWith("<") && column.endsWith(">")) {
            column = column.substring(1, column.length() - 1);
            if (position == 0 || position == 2) {
                o = model.createResource(column);
            } else if (position == 1) {
                o = model.createProperty(column);
            }
            return o;
        }
        if (column.startsWith("\"") && column.endsWith("\"")) {
            column = column.substring(1, column.length() - 1);
            return model.createLiteral(column);
        }
        return o;
    }

    private DeleteStatementUtil() {
    }
}

