/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.mrelib;

import cz.zcu.mre.mrelib.util.PropertiesUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PrefixMap
extends HashMap<String, String> {
    private static final Logger LOG = LoggerFactory.getLogger(PrefixMap.class);
    private static final long serialVersionUID = 3326085308866620462L;
    public static final String PREFIX_FILE = "prefix.properties";
    private static final String[] HIDDEN_ONTOLOGY = new String[]{"dct", "foaf", "nfo", "xml", "xsd", "fsl", "rdf", "rdfs", "mre"};
    private static final PrefixMap INSTANCE = new PrefixMap();
    private final Map<String, String> title = new HashMap<String, String>();
    private final List<String> hiddenOntologyPrefixes = new ArrayList<String>();

    public static synchronized PrefixMap get() {
        return INSTANCE;
    }

    public static String uri(String prefix) {
        if (!PrefixMap.get().containsKey(prefix)) {
            LOG.warn("There is a missing URI for prefix {}", (Object)prefix);
        }
        return (String)PrefixMap.get().get(prefix);
    }

    private PrefixMap() {
        this.initialize();
    }

    private void initialize() {
        this.hiddenOntologyPrefixes.addAll(Arrays.asList(HIDDEN_ONTOLOGY));
        this.put("acl", "http://www.w3.org/ns/auth/acl#");
        this.put("adms", "http://www.w3.org/ns/adms#");
        this.put("daml", "http://www.daml.org/2001/03/daml+oil#");
        this.put("dc10", "http://purl.org/dc/elements/1.0/");
        this.put("dc", "http://purl.org/dc/elements/1.1/");
        this.put("dct", "http://purl.org/dc/terms/");
        this.put("dcm", "https://mre.zcu.cz/ontology/dcm.owl#");
        this.put("dcmsedi", "http://semantic-dicom.org/dcm#");
        this.put("dcmsediext", "http://semantic-dicom.org/dcm-ext#");
        this.put("dscl", "https://mre.zcu.cz/ontology/dscl.owl#");
        this.put("ds", "https://mre.zcu.cz/ontology/dasta.owl#");
        this.put("foaf", "http://xmlns.com/foaf/0.1/");
        this.put("form", "https://mre.zcu.cz/ontology/form.owl#");
        this.put("fsl", "http://www.w3.org/2004/09/fresnel#");
        this.put("gr", "http://purl.org/goodrelations/v1#");
        this.put("ibd", "https://mre.zcu.cz/ontology/ibd.owl#");
        this.put("ibdt", "https://mre.zcu.cz/ontology/ibdt.owl#");
        this.put("icd10", "http://purl.bioontology.org/ontology/ICD10/");
        this.put("id", "https://mre.zcu.cz/id/");
        this.put("im", "https://mre.zcu.cz/ontology/image#");
        this.put("imm", "https://mre.zcu.cz/ontology/image-mapping.owl#");
        this.put("mre", "https://mre.zcu.cz/ontology/mre.owl#");
        this.put("nao", "http://www.semanticdesktop.org/ontologies/2007/08/15/nao#");
        this.put("nco", "http://www.semanticdesktop.org/ontologies/2007/03/22/nco#");
        this.put("nexif", "http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#");
        this.put("nfo", "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#");
        this.put("nie", "http://www.semanticdesktop.org/ontologies/2007/01/19/nie#");
        this.put("nihss", "https://mre.zcu.cz/ontology/nihss.owl#");
        this.put("nrl", "http://www.semanticdesktop.org/ontologies/2007/08/15/nrl#");
        this.put("cc", "http://creativecommons.org/ns#");
        this.put("org", "http://www.w3.org/ns/org#");
        this.put("owl", "http://www.w3.org/2002/07/owl#");
        this.put("pop", "https://mre.zcu.cz/ontology/pop.owl#");
        this.put("prov", "http://www.w3.org/ns/prov#");
        this.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.put("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        this.put("sd", "http://www.w3.org/ns/sparql-service-description#");
        this.put("sits", "https://mre.zcu.cz/ontology/sits.owl#");
        this.put("skos", "http://www.w3.org/2004/02/skos/core#");
        this.put("stroke", "https://mre.zcu.cz/ontology/stroke.owl#");
        this.put("tdb", "https://mre.zcu.cz/ontology/tdb.owl#");
        this.put("time", "http://www.w3.org/2006/time#");
        this.put("tzont", "http://www.w3.org/2006/timezone#");
        this.put("vann", "http://purl.org/vocab/vann/");
        this.put("vcard", "http://www.w3.org/2006/vcard/ns#");
        this.put("void", "http://vocab.deri.ie/void#");
        this.put("vs", "http://www.w3.org/2003/06/sw-vocab-status/ns#");
        this.put("xml", "http://www.w3.org/XML/1998/namespace");
        this.put("xsd", "http://www.w3.org/2001/XMLSchema#");
        Properties properties = PropertiesUtil.readConfigs(PREFIX_FILE);
        properties.stringPropertyNames().forEach((? super T name) -> {
            if (!name.endsWith("title") && !name.endsWith("label")) {
                if (this.containsKey(name)) {
                    LOG.warn("Prefix {} already defined.", name);
                } else {
                    this.put(name, properties.getProperty((String)name));
                }
            } else {
                this.title.put(name.replaceAll("\\.title", "").replaceAll("\\.label", ""), properties.getProperty((String)name));
            }
        });
    }

    public void addProperties(Properties props) {
        if (props == null) {
            return;
        }
        props.stringPropertyNames().stream().forEach((? super T key) -> this.put(key, (String)props.get(key)));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.entrySet().stream().map(key -> {
            sb.append("PREFIX ");
            sb.append((String)key.getKey());
            return key;
        }).map(key -> {
            sb.append(": <");
            sb.append((String)key.getValue());
            return key;
        }).forEach((? super T item) -> sb.append(">\n"));
        return sb.toString();
    }

    public Map<String, String> getTitles() {
        return this.title;
    }

    public List<String> getHiddenOntologyPrefixes() {
        return this.hiddenOntologyPrefixes;
    }

    public void setHiddenOntologyPrefixes(List<String> hiddenOntologyList) {
        this.hiddenOntologyPrefixes.clear();
        this.hiddenOntologyPrefixes.addAll(hiddenOntologyList);
    }

    public List<String> getTitleOrderedPrefixes() {
        ArrayList<String> list = new ArrayList<String>(this.keySet());
        Collections.sort(list, (o1, o2) -> this.getTitles().get(o1).compareTo(this.getTitles().get(o2)));
        return list;
    }

    public String prefix(String uri) {
        for (Map.Entry pairs : this.entrySet()) {
            if (!pairs.getValue().equals(uri)) continue;
            return (String)pairs.getKey();
        }
        LOG.warn("There is a missing prefix for URI {}", (Object)uri);
        return null;
    }

    @Override
    public Object clone() {
        return super.clone();
    }
}

