/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfs;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdfs.GraphRDFS;
import org.apache.jena.rdfs.SetupRDFS;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphWrapper;
import org.apache.jena.sparql.core.DatasetGraphWrapperView;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.Context;

public class DatasetGraphRDFS
extends DatasetGraphWrapper
implements DatasetGraphWrapperView {
    private final SetupRDFS setup;

    public DatasetGraphRDFS(DatasetGraph dsg, SetupRDFS setup) {
        super(dsg);
        this.setup = setup;
    }

    public DatasetGraphRDFS(DatasetGraph dsg, SetupRDFS setup, Context cxt) {
        super(dsg, cxt);
        this.setup = setup;
    }

    @Override
    public Graph getDefaultGraph() {
        Graph base = this.getG().getDefaultGraph();
        return new GraphRDFS(base, this.setup);
    }

    @Override
    public Graph getUnionGraph() {
        Graph base = this.getG().getUnionGraph();
        return new GraphRDFS(base, this.setup);
    }

    @Override
    public Graph getGraph(Node graphNode) {
        Graph base = this.getG().getGraph(graphNode);
        if (base == null) {
            return null;
        }
        return new GraphRDFS(base, this.setup);
    }

    @Override
    public Iterator<Quad> find(Quad quad) {
        return this.find(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    @Override
    public Iterator<Quad> find(Node g, Node s, Node p, Node o) {
        Iterator<Quad> iter = this.findInf(g, s, p, o);
        if (iter == null) {
            return Iter.nullIterator();
        }
        return iter;
    }

    private Iterator<Quad> findInf(Node g, Node s, Node p, Node o) {
        if (g != null && g.isConcrete()) {
            return this.findOneGraphInf(g, s, p, o);
        }
        Iter<Quad> iter1 = this.findOneGraphInf(Quad.defaultGraphIRI, s, p, o);
        Iterator<Quad> iter2 = this.findAllNamedGraphInf(s, p, o);
        return iter1.append(iter2);
    }

    private Iterator<Quad> findAllNamedGraphInf(Node s, Node p, Node o) {
        return Iter.flatMap(this.listGraphNodes(), gn -> this.findOneGraphInf((Node)gn, s, p, o));
    }

    private Iter<Quad> findOneGraphInf(Node g, Node s, Node p, Node o) {
        if (!g.isConcrete()) {
            throw new IllegalStateException();
        }
        return Iter.iter((Iterator)this.getGraph(g).find(s, p, o)).map(t -> Quad.create(g, t));
    }

    @Override
    public Iterator<Quad> findNG(Node g, Node s, Node p, Node o) {
        if (Quad.isDefaultGraph(g)) {
            throw new IllegalArgumentException("Default graph in findNG call");
        }
        if (g == null) {
            g = Node.ANY;
        }
        if (g == Node.ANY) {
            return this.findAllNamedGraphInf(s, p, o);
        }
        return this.findOneGraphInf(g, s, p, o);
    }

    @Override
    public boolean contains(Quad quad) {
        return this.contains(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Node g, Node s, Node p, Node o) {
        Iterator<Quad> iter = this.find(g, s, p, o);
        try {
            boolean bl = iter.hasNext();
            return bl;
        }
        finally {
            Iter.close(iter);
        }
    }
}

