/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.trans.bplustree;

import org.apache.jena.dboe.base.block.Block;
import org.apache.jena.dboe.base.block.BlockType;
import org.apache.jena.dboe.base.page.BlockConverter;
import org.apache.jena.dboe.base.page.PageBlockMgr;
import org.apache.jena.dboe.base.record.RecordFactory;
import org.apache.jena.dboe.base.recordbuffer.RecordBufferPage;
import org.apache.jena.dboe.base.recordbuffer.RecordBufferPageMgr;
import org.apache.jena.dboe.trans.bplustree.BPTreeRecords;
import org.apache.jena.dboe.trans.bplustree.BPlusTree;

public final class BPTreeRecordsMgr
extends PageBlockMgr<BPTreeRecords> {
    private final RecordBufferPageMgr rBuffPageMgr;
    private final BPlusTree bpTree;

    BPTreeRecordsMgr(BPlusTree bpTree, RecordFactory recordFactory, RecordBufferPageMgr rBuffPageMgr) {
        super(null, rBuffPageMgr.getBlockMgr());
        this.bpTree = bpTree;
        super.setConverter((BlockConverter)new Block2BPTreeRecords(this, recordFactory));
        this.rBuffPageMgr = rBuffPageMgr;
    }

    public BPTreeRecords create() {
        return (BPTreeRecords)super.create(BlockType.RECORD_BLOCK);
    }

    public RecordBufferPageMgr getRecordBufferPageMgr() {
        return this.rBuffPageMgr;
    }

    public BPlusTree getBPTree() {
        return this.bpTree;
    }

    boolean isWritable(int id) {
        return false;
    }

    public void startRead() {
        this.rBuffPageMgr.startRead();
    }

    public void finishRead() {
        this.rBuffPageMgr.finishRead();
    }

    public void startUpdate() {
        this.rBuffPageMgr.startUpdate();
    }

    public void finishUpdate() {
        this.rBuffPageMgr.finishUpdate();
    }

    public void close() {
        this.rBuffPageMgr.close();
    }

    static class Block2BPTreeRecords
    implements BlockConverter<BPTreeRecords> {
        private RecordBufferPageMgr.Block2RecordBufferPage recordBufferConverter;
        private BPTreeRecordsMgr recordsMgr;

        Block2BPTreeRecords(BPTreeRecordsMgr mgr, RecordFactory recordFactory) {
            this.recordsMgr = mgr;
            this.recordBufferConverter = new RecordBufferPageMgr.Block2RecordBufferPage(recordFactory);
        }

        public BPTreeRecords fromBlock(Block block) {
            RecordBufferPage rbp = this.recordBufferConverter.fromBlock(block);
            return new BPTreeRecords(this.recordsMgr, rbp);
        }

        public Block toBlock(BPTreeRecords t) {
            return this.recordBufferConverter.toBlock(t.getRecordBufferPage());
        }

        public BPTreeRecords createFromBlock(Block block, BlockType bType) {
            RecordBufferPage rbp = this.recordBufferConverter.createFromBlock(block, bType);
            return new BPTreeRecords(this.recordsMgr, rbp);
        }
    }
}

