/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.metamed.extractor.dicom;

import cz.zcu.mre.metamed.extractor.dicom.DicomAttribute;
import cz.zcu.mre.metamed.extractor.dicom.DicomInformationEntity;
import cz.zcu.mre.metamed.extractor.dicom.DicomRealWorldObject;
import cz.zcu.mre.mrelib.PrefixMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;

public final class DicomOntologyBuilderSchema {
    public static final String Q_RWO_STRUCTURE = "SELECT ?realWorld ?realWorldLabel ?dicomIE ?dicomIELabel  ?moduleAttributeLine ?attribute ?attributeLabel ?attributeGroup ?attributeElement ?attributeVR WHERE {?realWorld rdf:type dcm:Real_World_Object_CLASS . ?realWorld rdfs:label ?realWorldLabel . FILTER(LANG(?realWorldLabel) = \"\") ?realWorld dcm:has_DICOM_IE ?dicomIE . ?dicomIE dcm:Module_Attributes_or_Macros ?moduleAttributeLine . ?dicomIE rdfs:label ?dicomIELabel . ?moduleAttributeLine dcm:Attribute_Data_Element_or_Macro ?attribute .?attribute rdfs:label ?attributeLabel .?attribute dcm:Group ?attributeGroup .?attribute dcm:Element ?attributeElement .?attribute dcm:Data_Element_VR ?attributeVR . } ";
    public static final String Q_ALL_ATTRIBUTES = "SELECT ?attribute ?attributeLabel ?attributeGroup ?attributeElement WHERE {  ?attribute rdf:type dcm:DICOM_Element_CLASS . ?attribute rdfs:label ?attributeLabel . ?attribute dcm:Group ?attributeGroup . ?attribute dcm:Element ?attributeElement . }";
    private static DicomOntologyBuilderSchema instance = null;
    private final Map<String, DicomRealWorldObject> realWorldObjects = new HashMap<String, DicomRealWorldObject>();
    private final Map<String, DicomInformationEntity> informationEntities = new HashMap<String, DicomInformationEntity>();
    private final Map<Integer, DicomAttribute> attributes = new HashMap<Integer, DicomAttribute>();
    private Model model = null;

    public static synchronized DicomOntologyBuilderSchema instance() {
        if (instance == null) {
            instance = new DicomOntologyBuilderSchema();
        }
        return instance;
    }

    private DicomOntologyBuilderSchema() {
    }

    public Property getProperty(String uri, String name) {
        return this.model.getProperty(uri + name);
    }

    public Resource getResource(String uri, String name) {
        return this.model.getResource(uri + name);
    }

    public void initialize(PrefixMap prefixMap, Model m) {
        if (m == null) {
            throw new NullPointerException("The model is null.");
        }
        this.model = m;
        this.dicomAllAttributes(prefixMap);
        this.dicomBuildObjects(prefixMap);
    }

    private void dicomAllAttributes(PrefixMap prefixMap) {
        Query query = QueryFactory.create((String)(prefixMap.toString() + Q_ALL_ATTRIBUTES));
        try (QueryExecution qe = QueryExecutionFactory.create((Query)query, (Model)this.model);){
            ResultSet result = qe.execSelect();
            while (result.hasNext()) {
                QuerySolution qs = result.next();
                this.createAttribute(qs);
            }
        }
    }

    private void dicomBuildObjects(PrefixMap prefixMap) {
        Query query = QueryFactory.create((String)(prefixMap.toString() + Q_RWO_STRUCTURE));
        try (QueryExecution qe = QueryExecutionFactory.create((Query)query, (Model)this.model);){
            ResultSet result = qe.execSelect();
            while (result.hasNext()) {
                DicomInformationEntity ie;
                DicomRealWorldObject rwo;
                QuerySolution qs = result.next();
                if (this.realWorldObjects.containsKey(qs.getLiteral("realWorldLabel").getString())) {
                    rwo = this.realWorldObjects.get(qs.getLiteral("realWorldLabel").getString());
                } else {
                    rwo = new DicomRealWorldObject();
                    rwo.setRealWorldObject(qs.getResource("realWorld"));
                    rwo.setLabel(qs.getLiteral("realWorldLabel").getString());
                    this.realWorldObjects.put(rwo.getLabel(), rwo);
                }
                if (this.informationEntities.containsKey(qs.getLiteral("dicomIELabel").getString())) {
                    ie = this.informationEntities.get(qs.getLiteral("dicomIELabel").getString());
                } else {
                    ie = new DicomInformationEntity();
                    ie.setInformationEntity(qs.getResource("dicomIE"));
                    ie.setLabel(qs.getLiteral("dicomIELabel").getString());
                    ie.setParent(rwo);
                    this.informationEntities.put(ie.getLabel(), ie);
                }
                if (!rwo.getIE().contains(ie)) {
                    rwo.getIE().add(ie);
                }
                DicomAttribute attr = this.createAttribute(qs);
                attr.setModuleAttributeLine(qs.getResource("moduleAttributeLine").toString());
                attr.setParent(ie);
                ie.getAttributes().add(attr);
            }
        }
    }

    private DicomAttribute createAttribute(QuerySolution qs) {
        DicomAttribute attr = null;
        try {
            int tag = Integer.decode("0x" + qs.getLiteral("attributeGroup").getString() + qs.getLiteral("attributeElement").getString());
            if (this.attributes.containsKey(tag)) {
                attr = this.attributes.get(tag);
            } else {
                attr = new DicomAttribute();
                attr.setAttribute(this.model.getProperty(qs.getResource("attribute").getURI()));
                attr.setElement(qs.getLiteral("attributeElement").getString());
                attr.setGroup(qs.getLiteral("attributeGroup").getString());
                attr.setLabel(qs.getLiteral("attributeLabel").getString());
                attr.setTag(tag);
                attr.setModuleAttributeLine(null);
                attr.setParent(null);
                this.attributes.put(attr.getTag(), attr);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return attr;
    }

    protected Map<Integer, DicomAttribute> getAttributes() {
        return this.attributes;
    }

    protected Map<String, DicomInformationEntity> getInformationEntities() {
        return this.informationEntities;
    }

    protected Map<String, DicomRealWorldObject> getRealWorldObjects() {
        return this.realWorldObjects;
    }
}

