/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.metamed.extractor.dicom;

import cz.zcu.mre.metamed.extractor.AbstractExtractor;
import cz.zcu.mre.metamed.extractor.dicom.DicomInformationEntity;
import cz.zcu.mre.metamed.extractor.dicom.DicomOntologyBuilderSchema;
import cz.zcu.mre.metamed.extractor.dicom.DicomRealWorldObject;
import cz.zcu.mre.mrelib.PrefixMap;
import cz.zcu.mre.mrelib.util.DateUtil;
import cz.zcu.mre.mrelib.util.HashGenerator;
import cz.zcu.mre.vocab.DCM;
import cz.zcu.mre.vocab.DS;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.impl.XSDDateType;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.DC_11;
import org.apache.jena.vocabulary.RDF;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.imageio.plugins.dcm.DicomMetaData;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.util.TagUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DICOMExtractor
extends AbstractExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(DICOMExtractor.class);
    private static final long serialVersionUID = -3081165054182905893L;
    private static final String BUILD_IN_ONTOLOGY_FILE = "/cz/zcu/mre/extractor/dicom/dcm.owl";
    private static DicomOntologyBuilderSchema schema = null;
    private Attributes metadata;

    public DICOMExtractor() {
        this.setExtractorName(DICOMExtractor.class.getName());
        this.setFileType("dicom");
        this.preinitialize();
    }

    public DICOMExtractor(Model model) {
        super(model);
    }

    private synchronized void preinitialize() {
        if (schema == null) {
            schema = DicomOntologyBuilderSchema.instance();
            Model dicomModel = ModelFactory.createDefaultModel();
            InputStream inputStream = DICOMExtractor.class.getResourceAsStream(BUILD_IN_ONTOLOGY_FILE);
            dicomModel.read("https://mre.zcu.cz/ontology/dcm.owl#");
            if (dicomModel.isEmpty()) {
                dicomModel.read(inputStream, null, "RDF/XML");
            }
            schema.initialize(PrefixMap.get(), dicomModel);
            try {
                inputStream.close();
            }
            catch (IOException ex) {
                LOG.error(null, (Throwable)ex);
            }
        }
    }

    public void initialize() {
    }

    public final void read(File file) {
        this.extractFileMetaData(file);
        try (DicomInputStream dis = new DicomInputStream(file);){
            Attributes dcmMetadata = dis.readFileMetaInformation();
            Attributes dcmDataset = dis.readDataset();
            dis.close();
            DicomMetaData dmd = new DicomMetaData(dcmMetadata, dcmDataset);
            this.metadata = dmd.getAttributes();
            for (int i : dmd.getAttributes().tags()) {
                LOG.debug("File {} has tag {}", (Object)this.getFileName(), (Object)TagUtils.toHexString((int)i));
            }
        }
        catch (IOException ex) {
            LOG.error(null, (Throwable)ex);
        }
        if (this.metadata == null) {
            this.setFile(null);
            return;
        }
        this.setFile(file);
        Resource rImage = this.imageObject();
        Resource rEquipment = this.equipmentObject();
        Resource rFrameOfReference = this.frameOfReferenceObject();
        Resource rPatient = this.patientObject();
        Resource rSeries = this.seriesObject();
        Resource rStudy = this.studyObject();
        Resource rModalityPerformedProcedureStep = this.modalityPerformedProcedureStepObject();
        Resource rVisit = this.visitObject();
        if (rPatient != null) {
            this.appendToDataset(rPatient);
            if (rStudy != null) {
                this.getModel().add(rStudy, (Property)DCM.BELONGS_TO, (RDFNode)rPatient);
                this.getModel().add(rPatient, (Property)DCM.HAS_STUDY, (RDFNode)rStudy);
                String patientID = this.metadata.getString(0x100020, "").trim();
                Resource rDASTAPatient = this.getModel().getResource("https://mre.zcu.cz/id/" + HashGenerator.sha1Text((String)patientID));
                this.getModel().add(rDASTAPatient, (Property)DS.IMAGING_STUDY, (RDFNode)rStudy);
                this.getModel().add(rStudy, (Property)DCM.BELONGS_TO, (RDFNode)rDASTAPatient);
            }
            if (rVisit != null) {
                this.getModel().add(rPatient, (Property)DCM.MAKES_VISIT, (RDFNode)rVisit);
                this.getModel().add(rVisit, (Property)DCM.MADE_BY_PATIENT, (RDFNode)rPatient);
            }
        }
        if (rStudy != null) {
            this.appendToDataset(rStudy);
            if (rSeries != null) {
                this.getModel().add(rStudy, (Property)DCM.CONTAINS_SERIES, (RDFNode)rSeries);
                this.getModel().add(rSeries, (Property)DCM.CONTAINED_BY_STUDY, (RDFNode)rStudy);
            }
            if (rVisit != null) {
                this.getModel().add(rStudy, (Property)DCM.IS_INCLUDED_I, (RDFNode)rVisit);
                this.getModel().add(rStudy, (Property)DCM.IS_INCLUDED_IN, (RDFNode)rVisit);
                this.getModel().add(rVisit, (Property)DCM.INCLUDES_STUDY, (RDFNode)rStudy);
            }
            if (rModalityPerformedProcedureStep != null) {
                this.getModel().add(rStudy, (Property)DCM.IS_COMPRISED_OF, (RDFNode)rModalityPerformedProcedureStep);
                this.getModel().add(rModalityPerformedProcedureStep, (Property)DCM.COMPRISES, (RDFNode)rStudy);
                this.getModel().add(rModalityPerformedProcedureStep, (Property)DCM.INCLUDES, (RDFNode)rStudy);
            }
        }
        if (rSeries != null) {
            if (rImage != null) {
                this.getModel().add(rSeries, (Property)DCM.CONTAINS, (RDFNode)rImage);
                this.getModel().add(rImage, (Property)DCM.CONTAINS_SERIES, (RDFNode)rSeries);
                this.getModel().add(rImage, (Property)DCM.INCLUDES, (RDFNode)rSeries);
            }
            if (rEquipment != null) {
                this.getModel().add(rSeries, (Property)DCM.IS_CREATED_BY, (RDFNode)rEquipment);
                this.getModel().add(rEquipment, (Property)DCM.CREATES, (RDFNode)rSeries);
            }
            if (rFrameOfReference != null) {
                this.getModel().add(rSeries, (Property)DCM.IS_SPATIALLY_DEFINED_BY, (RDFNode)rFrameOfReference);
            }
            if (rVisit != null) {
                this.getModel().add(rSeries, (Property)DCM.IS_INCLUDED_I, (RDFNode)rVisit);
            }
        }
        this.metadata = null;
    }

    public void appendFileResourceToDataset() {
    }

    private Resource patientObject() {
        String name = "Patient";
        return this.buildRealWorldObject("Patient", 0x100020, null);
    }

    private Resource studyObject() {
        String name = "Study";
        return this.buildRealWorldObject("Study", 0x200010, null);
    }

    private Resource seriesObject() {
        String name = "Series";
        return this.buildRealWorldObject("Series", 0x20000E, null);
    }

    private Resource modalityPerformedProcedureStepObject() {
        return null;
    }

    private Resource equipmentObject() {
        String name = "Equipment";
        return this.buildRealWorldObject("Equipment", 0x181000, null);
    }

    private Resource frameOfReferenceObject() {
        String name = "Frame_of_Reference";
        return this.buildRealWorldObject("Frame_of_Reference", 0x200052, null);
    }

    private Resource imageObject() {
        String name = "CT_Image";
        Resource resource = this.buildRealWorldObject("CT_Image", 0x540400, this.getFileHashValue());
        if (resource != null) {
            this.addFileMetaData(resource);
        }
        return resource;
    }

    private Resource visitObject() {
        return null;
    }

    private Resource buildRealWorldObject(String name, int identificationTag, String identification) {
        DicomRealWorldObject rwo = schema.getRealWorldObjects().get(name);
        String id = identification;
        String label = this.getRealWorldObjectTitle(identificationTag);
        if (rwo == null) {
            LOG.error("Real World Object {} does not exist in DICOM Ontology.", (Object)name);
            return null;
        }
        if (identificationTag == 0x200010) {
            id = this.getStudyID();
        } else if (id == null) {
            id = this.metadata.getString(identificationTag, "").trim();
        }
        if (id == null || id.isEmpty()) {
            return null;
        }
        Resource resource = this.getModel().getResource("https://mre.zcu.cz/id/" + HashGenerator.sha1Text((String)id));
        Resource rClass = this.getModel().getResource("https://mre.zcu.cz/ontology/dcm.owl#" + name);
        this.getModel().add(resource, RDF.type, (RDFNode)rClass);
        if (identificationTag != 0x200010) {
            this.rdf().update(resource, DC_11.title, (Object)label);
        }
        this.buildInformationEntity(resource, rwo);
        return resource;
    }

    private String getRealWorldObjectTitle(int identificationTag) {
        StringBuilder sb = new StringBuilder();
        switch (identificationTag) {
            case 0x100020: {
                String patientID = this.metadata.getString(0x100020, "").trim();
                String patientName = this.metadata.getString(0x100010, "").trim();
                String patientSex = this.metadata.getString(0x100040, "").trim();
                String patientAge = this.metadata.getString(0x101010, "").trim();
                sb.append(patientName);
                sb.append(" (");
                sb.append(patientID);
                sb.append(", ");
                sb.append(patientSex);
                if (patientAge != null) {
                    sb.append(", ");
                    sb.append(patientAge);
                }
                sb.append(")");
                break;
            }
            case 0x200010: {
                String patientID = this.metadata.getString(0x100020, "").trim();
                Date studyDate = this.metadata.getDate(524320);
                Date studyTime = this.metadata.getDate(524336);
                String studyDesc = this.metadata.getString(528432, "").trim();
                String studyDiag = this.metadata.getString(528512, "").trim();
                String studyID = this.metadata.getString(0x200010, "").trim();
                sb.append(patientID);
                sb.append(", ");
                sb.append(DateUtil.format((Date)studyDate, (String)"yyyy-MM-dd"));
                sb.append(" ");
                sb.append(DateUtil.format((Date)studyTime, (String)"HH:mm:ss"));
                if (!studyDesc.isEmpty()) {
                    sb.append(" ");
                    sb.append(studyDesc);
                }
                if (studyDiag.isEmpty() && studyID.isEmpty()) break;
                sb.append(" (");
                if (!studyDiag.isEmpty()) {
                    sb.append("dg. ");
                    sb.append(studyDiag);
                }
                if (!studyDiag.isEmpty() && !studyID.isEmpty()) {
                    sb.append(", ");
                }
                if (!studyID.isEmpty()) {
                    sb.append("ID ");
                    sb.append(studyID);
                }
                sb.append(")");
                break;
            }
            case 0x20000E: {
                Date seriesDate = this.metadata.getDate(524321);
                Date seriesTime = this.metadata.getDate(524337);
                String seriesBodyPart = this.metadata.getString(1572885, "").trim();
                String seriesModality = this.metadata.getString(524384, "").trim();
                String seriesDescription = this.metadata.getString(528446, "").trim();
                String seriesProtocolName = this.metadata.getString(1577008, "").trim();
                sb.append(DateUtil.format((Date)seriesDate, (String)"yyyy-MM-dd"));
                sb.append(" ");
                sb.append(DateUtil.format((Date)seriesTime, (String)"HH:mm:ss"));
                sb.append(" ");
                if (!seriesBodyPart.isEmpty()) {
                    sb.append(seriesBodyPart);
                    sb.append("/");
                }
                sb.append(seriesModality);
                if (!seriesDescription.isEmpty()) {
                    sb.append(" ");
                    sb.append(seriesDescription);
                }
                if (seriesProtocolName.isEmpty()) break;
                sb.append(" ");
                sb.append(seriesProtocolName);
                break;
            }
            case 0x181000: {
                String stationName = this.metadata.getString(528400, "").trim();
                String softwareVersions = this.metadata.getString(1576992, "").trim();
                String deviceSerialNumber = this.metadata.getString(0x181000, "").trim();
                String deviceDesc = this.metadata.getString(0x500020, "").trim();
                sb.append(stationName);
                sb.append(" (");
                sb.append(softwareVersions);
                if (!deviceDesc.isEmpty()) {
                    sb.append(", ");
                    sb.append(deviceDesc);
                }
                sb.append(", s/n: ");
                sb.append(deviceSerialNumber);
                sb.append(")");
                break;
            }
            case 0x200052: {
                break;
            }
            case 0x540400: {
                String instanceNumber = this.metadata.getString(2097171, "").trim();
                String imageType = this.metadata.getString(524296, "").trim();
                sb.append(instanceNumber);
                if (imageType.isEmpty()) break;
                sb.append(" (");
                sb.append(imageType);
                sb.append(")");
                break;
            }
        }
        if (sb.length() <= 0) {
            return this.metadata.getString(identificationTag, "").trim();
        }
        return sb.toString();
    }

    private void buildInformationEntity(Resource parent, DicomRealWorldObject rwo) {
        rwo.getIE().stream().forEach(informationEntity -> this.buildAttributes(parent, (DicomInformationEntity)informationEntity));
    }

    private void buildAttributes(Resource parent, DicomInformationEntity informationEntity) {
        informationEntity.getAttributes().stream().filter(attr -> this.metadata.contains(attr.getTag())).forEach(attr -> this.extractElementValue(parent, attr.getTag()));
    }

    private void extractElementValue(Resource parent, int tag) {
        try {
            String value;
            switch (tag) {
                case 524368: 
                case 0x200010: {
                    value = this.getStudyID();
                    break;
                }
                case 0x400009: 
                case 0x401001: {
                    return;
                }
                default: {
                    value = this.metadata.getString(tag, "").trim();
                }
            }
            if (value != null && !value.isEmpty() && schema.getAttributes().get(tag) != null) {
                if (this.metadata.getVR(tag) != null) {
                    switch (this.metadata.getVR(tag)) {
                        case DA: {
                            Date date = this.metadata.getDate(tag);
                            this.getModel().add(parent, schema.getAttributes().get(tag).getAttribute(), DateUtil.format((Date)date, (String)"yyyy-MM-dd"), (RDFDatatype)XSDDateType.XSDdate);
                            break;
                        }
                        case DT: {
                            Date date = this.metadata.getDate(tag);
                            this.getModel().add(parent, schema.getAttributes().get(tag).getAttribute(), DateUtil.format((Date)date, (String)"yyyy-MM-dd'T'HH:mm:ssZ"), (RDFDatatype)XSDDateType.XSDdateTime);
                            break;
                        }
                        case TM: {
                            Date date = this.metadata.getDate(tag);
                            this.getModel().add(parent, schema.getAttributes().get(tag).getAttribute(), DateUtil.format((Date)date, (String)"HH:mm:ssZ"), (RDFDatatype)XSDDateType.XSDtime);
                            break;
                        }
                        case UI: {
                            LOG.debug("Ignore UI tag {}", (Object)tag);
                            break;
                        }
                        default: {
                            this.rdf().add(parent, schema.getAttributes().get(tag).getAttribute(), value.replaceAll("_", " ").replaceAll("\\^", " ").trim());
                            break;
                        }
                    }
                }
            } else if (schema.getAttributes().get(tag) == null) {
                LOG.warn("Missing tag {} in the DICOM ontology while processing file {}", (Object)TagUtils.toHexString((int)tag), (Object)this.getFile().getAbsolutePath());
            }
        }
        catch (UnsupportedOperationException e) {
            LOG.error(null, (Throwable)e);
        }
    }

    private String getStudyID() {
        Long value = 0L;
        String id = this.metadata.getString(0x200010, "").trim();
        if (!id.isEmpty() && id.matches("\\d+")) {
            try {
                value = Long.valueOf(id);
            }
            catch (NumberFormatException e) {
                LOG.error("StudyID is not a long number.");
            }
            if (value > 99999L) {
                return id;
            }
            if (this.getFileName().matches("^\\d+\\_\\d+\\.[DdIi][CcMm][MmAa]$")) {
                String[] parts = this.getFileName().split("_");
                LOG.debug("Using filename Study_ID {} for {}", (Object)parts[0], (Object)this.getFileName());
                return parts[0].trim();
            }
            return value.toString();
        }
        return null;
    }
}

