/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdf.model;

import java.util.Set;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.AssemblerHelp;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphMemFactory;
import org.apache.jena.graph.compose.Union;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.ontology.ProfileRegistry;
import org.apache.jena.ontology.impl.OntModelImpl;
import org.apache.jena.ontology.models.ModelMaker;
import org.apache.jena.ontology.models.ModelMakerImpl;
import org.apache.jena.ontology.models.SimpleGraphMaker;
import org.apache.jena.rdf.model.InfModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactoryBase;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.impl.InfModelImpl;
import org.apache.jena.rdf.model.impl.ModelCom;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.ReasonerRegistry;
import org.apache.jena.sys.JenaSystem;

public class ModelFactory
extends ModelFactoryBase {
    private ModelFactory() {
    }

    public static Model assembleModelFrom(Model singleRoot) {
        return ModelFactory.assembleModelFrom(AssemblerHelp.singleModelRoot(singleRoot));
    }

    public static Set<Resource> findAssemblerRoots(Model m) {
        return AssemblerHelp.findAssemblerRoots(m);
    }

    public static Model assembleModelFrom(Resource root) {
        return Assembler.general().openModel(root);
    }

    public static Model createDefaultModel() {
        return ModelFactory.createModelForGraph(GraphMemFactory.createDefaultGraphSameValue());
    }

    public static Model createModelSameTerm() {
        return ModelFactory.createModelForGraph(GraphMemFactory.createDefaultGraphSameTerm());
    }

    public static Model createModelSameValue() {
        return ModelFactory.createModelForGraph(GraphMemFactory.createDefaultGraphSameValue());
    }

    public static Model createModelForGraph(Graph g) {
        return new ModelCom(g);
    }

    public static ModelMaker createMemModelMaker() {
        return new ModelMakerImpl(new SimpleGraphMaker());
    }

    public static InfModel createRDFSModel(Model model) {
        Reasoner reasoner = ReasonerRegistry.getRDFSReasoner();
        InfGraph graph = reasoner.bind(model.getGraph());
        return new InfModelImpl(graph);
    }

    public static InfModel createRDFSModel(Model schema, Model model) {
        Reasoner reasoner = ReasonerRegistry.getRDFSReasoner();
        InfGraph graph = reasoner.bindSchema(schema.getGraph()).bind(model.getGraph());
        return new InfModelImpl(graph);
    }

    public static InfModel createInfModel(Reasoner reasoner, Model model) {
        InfGraph graph = reasoner.bind(model.getGraph());
        return new InfModelImpl(graph);
    }

    public static InfModel createInfModel(Reasoner reasoner, Model schema, Model model) {
        InfGraph graph = reasoner.bindSchema(schema.getGraph()).bind(model.getGraph());
        return new InfModelImpl(graph);
    }

    public static InfModel createInfModel(InfGraph g) {
        return new InfModelImpl(g);
    }

    public static OntModel createOntologyModel() {
        return ModelFactory.createOntologyModel(ProfileRegistry.OWL_LANG);
    }

    public static OntModel createOntologyModel(String languageURI) {
        return ModelFactory.createOntologyModel(OntModelSpec.getDefaultSpec(languageURI), null);
    }

    public static OntModel createOntologyModel(OntModelSpec spec, ModelMaker maker, Model base) {
        OntModelSpec _spec = new OntModelSpec(spec);
        _spec.setImportModelMaker(maker);
        return ModelFactory.createOntologyModel(_spec, base);
    }

    public static OntModel createOntologyModel(OntModelSpec spec, Model base) {
        return new OntModelImpl(spec, base);
    }

    public static OntModel createOntologyModel(OntModelSpec spec) {
        return new OntModelImpl(spec);
    }

    public static Model createUnion(Model m1, Model m2) {
        return ModelFactory.createModelForGraph(new Union(m1.getGraph(), m2.getGraph()));
    }

    static {
        JenaSystem.init();
    }
}

