/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.metamed.extractor.image.util;

import com.drew.metadata.TagDescriptor;
import cz.zcu.mre.metamed.extractor.image.mapping.IndividualData;
import cz.zcu.mre.metamed.extractor.image.util.DateUtil;
import cz.zcu.mre.mrelib.Const;
import java.text.DecimalFormat;
import java.util.Date;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;

public final class ValueTransformator {
    public static final int CODE_VERSION = 1;
    public static final int CODE_DMS_TO_FLOAT = 2;
    public static final int CODE_BYTES_TO_STRING = 3;
    public static final int CODE_RATIONAL_TO_FLOAT = 4;
    public static final int CODE_BYTES_VERSION = 5;
    public static final int CODE_BITS_PER_SAMPLE = 6;
    public static final int CODE_JFIF_RESUNIT_TO_EXIF = 8;
    public static final int CODE_PNG_CHROM_VALUES_TO_FRACTION = 9;
    public static final int CODE_PNG_COLORTYPE_TO_EXIF = 10;
    public static final int CODE_INT_TO_BOOL = 11;
    public static final int CODE_ADD_TIME_TO_DATE = 12;
    public static final int CODE_REMOVE_TEXT = 13;
    public static final int CODE_BYTES_TO_HEX = 14;
    public static final int CODE_DIGITAL_ZOOM_RATIO = 15;
    public static final int CODE_VALUE_DIVISION = 16;
    public static final int CODE_INDEXED_DESCRIPTION = 17;
    public static final int ANGLE_TOKENS_COUNT = 6;
    public static final int ANGLE_NUMBERS = 3;
    public static final int ANGLE_MINUTES = 60;
    public static final int PNG_PIXEL_GREYSCALE = 0;
    public static final int PNG_PIXEL_RGB = 2;
    public static final int PNG_PIXEL_PALLETE = 3;
    public static final int PNG_PIXEL_GREYSCALE_ALPHA = 4;
    public static final int PNG_PIXEL_RGB_ALPHA = 6;
    public static final int BYTE_MAX_VALUE = 255;
    public static final int BYTE_MAX_VALUE_SINGLE_LETTER = 16;
    public static final int VALUE_DECIMAL_9 = 9;
    public static final double VALUE_WITH_ONE_DECIMAL = 0.1;

    public static String dataTransformation(String value, IndividualData iData) {
        String extractedValue = value;
        int code = Integer.MIN_VALUE;
        StmtIterator i = iData.getTransformation().listProperties();
        while (i.hasNext()) {
            Statement st = (Statement)i.next();
            if (!st.getPredicate().getLocalName().equals("decCode")) continue;
            code = st.getObject().asLiteral().getInt();
        }
        if (code > Integer.MIN_VALUE) {
            extractedValue = ValueTransformator.transform(code, iData.getTransformationParameter(), extractedValue);
        }
        return extractedValue;
    }

    public static String transform(int code, String param, String input) {
        String in = input;
        if (in == null || in.trim().length() < 1) {
            return "";
        }
        in = in.trim();
        switch (code) {
            case 1: {
                return in.trim().replace(' ', '.');
            }
            case 2: {
                return ValueTransformator.dmsToDecimal(in);
            }
            case 3: {
                return ValueTransformator.bytesToString(in);
            }
            case 4: {
                return ValueTransformator.rationalToDecimal(in, param);
            }
            case 5: {
                return ValueTransformator.bytesVersion(in, param);
            }
            case 6: {
                return ValueTransformator.bitsPerSample(in);
            }
            case 8: {
                return ValueTransformator.jfifResUnitToExif(in);
            }
            case 9: {
                return ValueTransformator.pngChromaticitiesFraction(in);
            }
            case 10: {
                return ValueTransformator.pngColorTypeToExif(in);
            }
            case 11: {
                return ValueTransformator.intToBoolean(in);
            }
            case 12: {
                return ValueTransformator.addTimeToDate(in);
            }
            case 13: {
                return ValueTransformator.removeText(in);
            }
            case 14: {
                return ValueTransformator.bytesToHex(in);
            }
            case 15: {
                return ValueTransformator.digitalZoomRatio(in);
            }
            case 16: {
                return ValueTransformator.valueDivision(in, param);
            }
            case 17: {
                return ValueTransformator.indexedDescription(in, param);
            }
        }
        return in;
    }

    private static int getIntParameter(String param) {
        try {
            if (param != null) {
                int paramInt = Integer.parseInt(param);
                return paramInt;
            }
        }
        catch (NumberFormatException e) {
            return Integer.MIN_VALUE;
        }
        return Integer.MIN_VALUE;
    }

    private static String dmsToDecimal(String in) {
        String[] tokens = in.split("[ /]+");
        if (tokens.length != 6) {
            return "";
        }
        double value = 0.0;
        try {
            for (int i = 0; i < 3; ++i) {
                if (Integer.parseInt(tokens[2 * i]) == 0 || Integer.parseInt(tokens[2 * i + 1]) == 0) continue;
                value += (double)Integer.parseInt(tokens[2 * i]) / Double.parseDouble(tokens[2 * i + 1]) / Math.pow(60.0, i);
            }
            DecimalFormat df = new DecimalFormat("0.0000");
            return df.format(value).replaceAll(",", ".");
        }
        catch (NumberFormatException e) {
            return "";
        }
    }

    private static String rationalToDecimal(String in, String param) {
        String clean = in.replaceAll("[a-zA-Z]", "");
        String[] tokens = clean.split("[ /]+");
        if (tokens.length % 2 != 0 || tokens.length == 0) {
            return clean;
        }
        int format = ValueTransformator.getIntParameter(param);
        StringBuilder formatString = new StringBuilder();
        formatString.append("0.0");
        for (int i = 1; i < format; ++i) {
            formatString.append("0");
        }
        StringBuilder out = new StringBuilder();
        try {
            for (int i = 0; i < tokens.length / 2; ++i) {
                Double value = Double.parseDouble(tokens[2 * i]) / Double.parseDouble(tokens[2 * i + 1]);
                DecimalFormat df = new DecimalFormat(formatString.toString());
                out.append(df.format(value)).append(" ");
            }
        }
        catch (NumberFormatException e) {
            return "";
        }
        return out.toString().trim().replaceAll(",", ".");
    }

    private static String bytesToString(String in) {
        String[] tokens = in.split("[ ]+");
        StringBuilder value = new StringBuilder();
        int firstZeroChar = -1;
        try {
            for (int i = 0; i < tokens.length; ++i) {
                int code = Integer.parseInt(tokens[i]);
                if (code == 0) {
                    if (firstZeroChar >= 0) continue;
                    firstZeroChar = i;
                    continue;
                }
                value.append((char)code);
            }
            if (firstZeroChar > 1) {
                value.delete(0, firstZeroChar);
            }
        }
        catch (NumberFormatException e) {
            return in;
        }
        return value.toString();
    }

    private static String bytesVersion(String in, String param) {
        int paramInt = ValueTransformator.getIntParameter(param);
        String[] tokens = in.split("[ ]+");
        int[] values = new int[tokens.length];
        try {
            for (int i = 0; i < tokens.length; ++i) {
                values[i] = Integer.parseInt(tokens[i]);
            }
        }
        catch (NumberFormatException e) {
            return "";
        }
        if (paramInt > 0 && paramInt < tokens.length) {
            return TagDescriptor.convertBytesToVersionString((int[])values, (int)paramInt);
        }
        return "";
    }

    private static String bitsPerSample(String in) {
        String[] tokens = in.split("[ ]+");
        return tokens[0];
    }

    private static String jfifResUnitToExif(String in) {
        String[] tokens = in.split("[ ]+");
        try {
            int value = Integer.parseInt(tokens[0]);
            return "" + ++value;
        }
        catch (NumberFormatException e) {
            return "";
        }
    }

    private static String pngChromaticitiesFraction(String in) {
        try {
            Integer.parseInt(in.trim());
        }
        catch (NumberFormatException e) {
            return "";
        }
        return in.trim() + "/100000";
    }

    private static String pngColorTypeToExif(String in) {
        try {
            int value = Integer.parseInt(in);
            switch (value) {
                case 0: {
                    return "1";
                }
                case 2: {
                    return "3";
                }
                case 3: {
                    return "1";
                }
                case 4: {
                    return "2";
                }
                case 6: {
                    return "4";
                }
            }
            return "";
        }
        catch (NumberFormatException e) {
            return "";
        }
    }

    private static String intToBoolean(String in) {
        try {
            int value = Integer.parseInt(in);
            if (value > 0) {
                return "true";
            }
            return "false";
        }
        catch (NumberFormatException e) {
            return "";
        }
    }

    private static String addTimeToDate(String in) {
        String[] tokens = in.split("[;]+");
        if (tokens.length == 2) {
            Date date1 = DateUtil.stringToDateUnknownPattern(tokens[0]);
            Date date2 = DateUtil.stringToDateUnknownPattern(tokens[1]);
            if (date1 != null && date2 != null) {
                Date date3 = new Date(date1.getTime() + date2.getTime());
                return date3.toString();
            }
            return in;
        }
        return in;
    }

    private static String bytesToHex(String in) {
        String[] tokens = in.split("[ ]+");
        StringBuilder out = new StringBuilder();
        try {
            for (String token : tokens) {
                int value = Integer.parseInt(token);
                if (value < 0 || value > 255) {
                    return "";
                }
                if (value < 16) {
                    out.append("0");
                }
                String hex = Integer.toHexString(value);
                out.append(hex);
            }
        }
        catch (NumberFormatException e) {
            return "";
        }
        return out.toString();
    }

    private static String digitalZoomRatio(String in) {
        if (in.trim().toLowerCase(Const.LOCALE).startsWith("no") || in.trim().toLowerCase(Const.LOCALE).equals("off") || in.toLowerCase(Const.LOCALE).contains("not used")) {
            return "0";
        }
        if (in.trim().toLowerCase(Const.LOCALE).startsWith("unknown")) {
            return "";
        }
        return in.replaceAll("[a-zA-Z]", "");
    }

    private static String valueDivision(String in, String param) {
        Double value;
        int paramInt = ValueTransformator.getIntParameter(param);
        try {
            value = Double.parseDouble(in);
            if (paramInt == 0 || paramInt == Integer.MIN_VALUE) {
                return "";
            }
            value = value / (double)paramInt;
        }
        catch (NumberFormatException e) {
            return "";
        }
        StringBuilder formatString = new StringBuilder();
        formatString.append("0.0");
        if (value <= 9.0) {
            formatString.append("0");
        }
        if (value < 0.1) {
            formatString.append("0");
        }
        DecimalFormat df = new DecimalFormat(formatString.toString());
        return df.format(value).replaceAll(",", ".");
    }

    private static String indexedDescription(String in, String param) {
        String delimiter = ";";
        try {
            int index = Integer.parseInt(in);
            String[] tokens = param.split(";");
            if (tokens.length > index) {
                return tokens[index].trim();
            }
            return "";
        }
        catch (NumberFormatException e) {
            return "";
        }
    }

    private static String removeText(String in) {
        String out = in.replaceAll("f/", "");
        return out.replaceAll("[a-zA-Z]", "").trim();
    }

    private ValueTransformator() {
    }
}

