/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.metamed.extractor.image.util;

import cz.zcu.mre.metamed.extractor.image.mapping.IndividualData;
import cz.zcu.mre.mrelib.Const;
import cz.zcu.mre.mrelib.util.RDFUtil;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.ontology.Individual;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtractorUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ExtractorUtil.class);

    public static IndividualData getMappingDefinition(Individual ontTag) {
        IndividualData iData = new IndividualData(ontTag.getLocalName());
        StmtIterator i = ontTag.listProperties();
        block34: while (i.hasNext()) {
            Statement st = (Statement)i.next();
            switch (st.getPredicate().getLocalName()) {
                case "mapsToNS": {
                    iData.setNamespace(st.getObject().asLiteral().getLexicalForm());
                    continue block34;
                }
                case "mapsToProperty": {
                    iData.setAttribute(st.getObject().asLiteral().getLexicalForm());
                    continue block34;
                }
                case "nodeTypeNS": {
                    iData.setTypeNamespace(st.getObject().asLiteral().getLexicalForm());
                    continue block34;
                }
                case "nodeTypeClass": {
                    iData.setTypeClass(st.getObject().asLiteral().getLexicalForm());
                    continue block34;
                }
                case "decCode": {
                    iData.setTag(st.getObject().asLiteral().getInt());
                    continue block34;
                }
                case "dataTransformation": {
                    iData.setTransformation((Individual)st.getObject().as(Individual.class));
                    continue block34;
                }
                case "dataTransformationParameter": {
                    iData.setTransformationParameter(st.getObject().asLiteral().getLexicalForm());
                    continue block34;
                }
                case "expectedDatatype": {
                    XSDDatatype type = ExtractorUtil.getExpectedXSDDatatype(st.getObject().asLiteral().getLexicalForm());
                    iData.setDatatype(type);
                    continue block34;
                }
                case "isAggregatedIn": {
                    iData.setAggregatedIn((Individual)st.getObject().as(Individual.class));
                    continue block34;
                }
                case "concatAfter": {
                    iData.setFollows((Individual)st.getObject().as(Individual.class));
                    continue block34;
                }
                case "concatBefore": {
                    iData.setPrecedes((Individual)st.getObject().as(Individual.class));
                    continue block34;
                }
                case "useDescription": {
                    iData.setDescriptionUsed(st.getObject().asLiteral().getBoolean());
                    continue block34;
                }
                case "splitDelimiter": {
                    iData.setSplitDelimiter(st.getObject().asLiteral().getLexicalForm());
                    continue block34;
                }
                case "duplicateTo": {
                    iData.setDuplicateTo((Individual)st.getObject().as(Individual.class));
                    continue block34;
                }
                case "valueAsNode": {
                    iData.setWritenAsNode(st.getObject().asLiteral().getBoolean());
                    continue block34;
                }
            }
            LOG.warn("Missing mapping for ''{}'' predicate.", (Object)st.getPredicate().getLocalName());
        }
        return iData;
    }

    public static XSDDatatype getExpectedXSDDatatype(String s) {
        String lower = s.toLowerCase(Const.LOCALE);
        if (lower.contains("string")) {
            return XSDDatatype.XSDstring;
        }
        if (lower.contains("int")) {
            return XSDDatatype.XSDinteger;
        }
        if (lower.contains("float") || lower.contains("real")) {
            return XSDDatatype.XSDfloat;
        }
        if (lower.contains("date")) {
            return XSDDatatype.XSDdateTime;
        }
        if (lower.contains("boolean")) {
            return XSDDatatype.XSDboolean;
        }
        return null;
    }

    public static boolean isDefinitionGraphCycle(IndividualData iData, CYCLEDETECT property) {
        HashSet<String> iDataFound = new HashSet<String>();
        while (true) {
            if (iDataFound.contains(iData.getId())) {
                return true;
            }
            iDataFound.add(iData.getId());
            Individual nextInd = null;
            if (property == CYCLEDETECT.AGGREGATED_IN) {
                nextInd = iData.getAggregatedIn();
            } else if (property == CYCLEDETECT.DUPLICATE_TO) {
                nextInd = iData.getDuplicateTo();
            }
            if (nextInd == null) break;
            iData = ExtractorUtil.getMappingDefinition(nextInd);
        }
        return false;
    }

    public static synchronized void renameNodes(HashMap<String, Resource> createdTypedNodes, RDFUtil rdf) {
        createdTypedNodes.values().stream().filter(r -> !r.equals(createdTypedNodes.get("root"))).forEach(r -> {
            ArrayList<CallSite> strings = new ArrayList<CallSite>();
            StmtIterator i = r.listProperties();
            while (i.hasNext()) {
                Statement st = (Statement)i.next();
                strings.add((CallSite)((Object)(st.getPredicate().getURI() + st.getObject().toString())));
            }
            Collections.sort(strings);
            ResourceUtils.renameResource((Resource)r, (String)rdf.mreResource(((Object)strings).toString()).getURI());
        });
    }

    private ExtractorUtil() {
    }

    public static enum CYCLEDETECT {
        AGGREGATED_IN,
        DUPLICATE_TO;

    }
}

