/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.metamed.extractor.image.commons;

import cz.zcu.mre.mrelib.MREException;
import cz.zcu.mre.mrelib.util.PropertiesUtil;
import java.io.Serializable;
import java.util.Properties;

public final class ExtractorSetting
implements Serializable {
    private static final long serialVersionUID = 9078563181045802722L;
    private static final String CONFIG_FILE_NAME = "image/image.properties";
    private static ExtractorSetting instance;
    private String mappingOwlFileName;
    private String immNS;
    private String mappingOwlFileURL;
    private String imageOwlFileName;
    private String imageNS;
    private String imageOwlFileURL;
    private int connectionTimeout;
    private int readTimeout;

    public static synchronized ExtractorSetting getInstance() {
        if (instance == null) {
            instance = new ExtractorSetting();
        }
        return instance;
    }

    private ExtractorSetting() {
        try {
            Properties settings = PropertiesUtil.readConfigs((String)CONFIG_FILE_NAME);
            this.mappingOwlFileName = settings.getProperty("mappingOwlFileName");
            this.immNS = settings.getProperty("immNS");
            this.mappingOwlFileURL = settings.getProperty("mappingOwlFileURL");
            this.imageOwlFileName = settings.getProperty("imageOwlFileName");
            this.imageNS = settings.getProperty("imageNS");
            this.imageOwlFileURL = settings.getProperty("imageOwlFileURL");
            this.connectionTimeout = Integer.parseInt(settings.getProperty("connectionTimeout"));
            this.readTimeout = Integer.parseInt(settings.getProperty("readTimeout"));
        }
        catch (NullPointerException e) {
            throw new MREException("Extraction configuration file not found: " + System.getProperty("user.home") + "/.mre/image/image.properties", -1);
        }
        catch (NumberFormatException e) {
            throw new MREException("invalid value for numeric parameter in config file: " + System.getProperty("user.home") + "/.mre/image/image.properties");
        }
        String invalidValue = this.validateConfig();
        if (invalidValue != null) {
            throw new MREException("Invalid value for parameter in configuration file: " + System.getProperty("user.home") + "/.mre/image/image.properties ; " + invalidValue);
        }
    }

    private String validateConfig() {
        if (this.mappingOwlFileName == null) {
            return "mappingOwlFileName";
        }
        if (this.immNS == null) {
            return "immNS";
        }
        if (this.mappingOwlFileURL == null) {
            return "mappingOwlFileURL";
        }
        if (this.imageOwlFileName == null) {
            return "imageOwlFileName";
        }
        if (this.imageNS == null) {
            return "imageNS";
        }
        if (this.imageOwlFileURL == null) {
            return "imageOwlFileURL";
        }
        if (this.connectionTimeout <= 0) {
            return "connectionTimeout";
        }
        if (this.readTimeout <= 0) {
            return "readTimeout";
        }
        return null;
    }

    public String getImmNS() {
        return this.immNS;
    }

    public String getImageOwlFileName() {
        return this.imageOwlFileName;
    }

    public String getImageNS() {
        return this.imageNS;
    }

    public String getImageOwlFileURL() {
        return this.imageOwlFileURL;
    }

    public String getMappingOwlFileName() {
        return this.mappingOwlFileName;
    }

    public String getMappingOwlFileURL() {
        return this.mappingOwlFileURL;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }
}

