/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.metamed.extractor.image.commons;

import com.drew.metadata.Directory;
import com.drew.metadata.Tag;
import cz.zcu.mre.metamed.extractor.image.commons.ExtractorSetting;
import cz.zcu.mre.metamed.extractor.image.mapping.IndividualData;
import cz.zcu.mre.metamed.extractor.image.util.DateUtil;
import cz.zcu.mre.metamed.extractor.image.util.ExtractorUtil;
import cz.zcu.mre.metamed.extractor.image.util.ValueTransformator;
import cz.zcu.mre.mrelib.Const;
import cz.zcu.mre.mrelib.MREException;
import cz.zcu.mre.mrelib.util.PropertiesUtil;
import cz.zcu.mre.mrelib.util.RDFUtil;
import cz.zcu.mre.vocab.NEXIF;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.OntDocumentManager;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtractorLogic
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(ExtractorLogic.class);
    private static final long serialVersionUID = 4116903900379873366L;
    public static final String IMAGE_RESOURCE_CODE = "root";
    private static final Resource R_NEXIF_IMAGE = NEXIF.PHOTO;
    private static final String CONFIGURATION_FOLDER = "/.mre/image/";
    private static final String PREFIX_FILE_NAME = "image/prefix.properties";
    private static final String PREFIX_EXTRA_CHAR = "2";
    public static final int STATS_LENGTH = 4;
    public static final int STAT_ADDED = 0;
    public static final int STAT_MISSING = 1;
    public static final int STAT_EMPTY = 2;
    public static final int STAT_NOVALUE = 3;
    private static final String FILTERED_CHARS = "[\\p{Cntrl}[\\ufff0-\\uffff]]";
    private static final Map<Model, ExtractorLogic> INSTANCES = new HashMap<Model, ExtractorLogic>();
    private static final ExtractorSetting SETTING = ExtractorSetting.getInstance();
    private Model model = null;
    private OntModel ontModel = null;
    private RDFUtil rdf = null;

    public static synchronized ExtractorLogic getInstance(Model model) {
        if (model == null) {
            throw new NullPointerException("Null RDF model.");
        }
        if (INSTANCES.containsKey(model)) {
            return INSTANCES.get(model);
        }
        ExtractorLogic instance = new ExtractorLogic(model);
        INSTANCES.put(model, instance);
        return instance;
    }

    public static void printStatistics(int[] stats, String filename) {
        LOG.info("STATS: {} triples added, {} values empty/unknown, {} definitions missing, {} definitions empty, {}", new Object[]{stats[0], stats[3], stats[1], stats[2], filename});
    }

    private ExtractorLogic(Model m) {
        this.model = m;
        this.rdf = new RDFUtil(m);
        this.initialize();
    }

    private void initialize() {
        OntDocumentManager mgr = new OntDocumentManager();
        OntModelSpec s = new OntModelSpec(OntModelSpec.OWL_MEM);
        s.setDocumentManager(mgr);
        this.ontModel = ModelFactory.createOntologyModel((OntModelSpec)s, null);
        this.loadOntology(SETTING.getImmNS(), SETTING.getMappingOwlFileName(), SETTING.getMappingOwlFileURL());
        this.loadOntology(SETTING.getImageNS(), SETTING.getImageOwlFileName(), SETTING.getImageOwlFileURL());
        File file = new File(System.getProperty("user.home") + CONFIGURATION_FOLDER);
        if (file.mkdirs()) {
            LOG.info("Created configuration folder {}", (Object)file.getAbsolutePath());
        }
        try {
            Properties prefixes = PropertiesUtil.readConfigs((String)PREFIX_FILE_NAME);
            prefixes.stringPropertyNames().stream().forEach(prefix -> {
                if (this.model.getNsPrefixURI(prefix) == null) {
                    this.model.setNsPrefix(prefix, prefixes.getProperty((String)prefix));
                } else if (!this.model.getNsPrefixURI(prefix).equals(prefixes.getProperty((String)prefix))) {
                    this.model.setNsPrefix(prefix + PREFIX_EXTRA_CHAR, prefixes.getProperty((String)prefix));
                }
            });
        }
        catch (NullPointerException e) {
            LOG.warn("Prefix definition file not found: {} /.mre/image/prefix.properties", (Object)System.getProperty("user.home"));
        }
    }

    public RDFUtil getRDFUtil() {
        return this.rdf;
    }

    public OntModel getOntModel() {
        return this.ontModel;
    }

    public Logger getLogger() {
        return LOG;
    }

    private void loadOntology(String namespace, String filename, String owlFileURL) {
        TypedInputStream in = RDFDataMgr.open((String)filename);
        if (in != null) {
            this.ontModel.read((InputStream)in, namespace);
        } else {
            LOG.warn("Ontology file {} not found. Trying to download ontology from Internet.", (Object)filename);
            try {
                FileUtils.copyURLToFile((URL)new URL(owlFileURL), (File)new File(filename));
            }
            catch (IOException e) {
                LOG.error(null, (Throwable)e);
            }
            in = RDFDataMgr.open((String)filename);
            if (in != null) {
                this.ontModel.read((InputStream)in, namespace);
            } else {
                LOG.error("Ontology download failed: {}", (Object)owlFileURL);
                throw new MREException("Ontology files needed for metadata extraction could not be acquired. Terminating extraction process.", -1);
            }
        }
    }

    public void processTag(Tag tag, IndividualData iData, Directory directory, Set<Integer> tagsDone, HashMap<String, Resource> createdTypedNodes, int[] stats) {
        Resource node;
        String extractedValue;
        if (iData.getDuplicateTo() != null) {
            if (ExtractorUtil.isDefinitionGraphCycle(iData, ExtractorUtil.CYCLEDETECT.DUPLICATE_TO)) {
                LOG.warn("Cycle found in duplicateTo definition of tag in {}. Skipping duplicateTo definition of: {}", (Object)SETTING.getMappingOwlFileName(), (Object)iData.getId());
            } else {
                IndividualData iData2 = ExtractorUtil.getMappingDefinition(iData.getDuplicateTo());
                this.processTag(tag, iData2, directory, tagsDone, createdTypedNodes, stats);
            }
        }
        if (!iData.isDefined().booleanValue()) {
            LOG.info("Mapping is empty for tag: {}", (Object)iData.getId());
            stats[2] = stats[2] + 1;
            return;
        }
        if (iData.needsConcat().booleanValue()) {
            extractedValue = this.concatValue(iData, directory, tagsDone);
        } else {
            extractedValue = iData.isDesriptionUsed() ? directory.getDescription(tag.getTagType()) : directory.getString(tag.getTagType());
            if (extractedValue != null) {
                extractedValue = extractedValue.trim();
            }
            if (iData.getTransformation() != null) {
                extractedValue = ValueTransformator.dataTransformation(extractedValue, iData);
            }
        }
        if (iData.getAggregatedIn() != null) {
            if (ExtractorUtil.isDefinitionGraphCycle(iData, ExtractorUtil.CYCLEDETECT.AGGREGATED_IN)) {
                LOG.warn("Cycle found in aggregatedIn definition of tag in {}. Skipping tag: {}", (Object)SETTING.getMappingOwlFileName(), (Object)iData.getId());
                node = null;
            } else {
                node = this.getTypedNode(iData, createdTypedNodes, stats);
            }
        } else {
            node = createdTypedNodes.get(IMAGE_RESOURCE_CODE);
        }
        if (node != null) {
            this.addValueWithType(node, iData, extractedValue, stats);
        }
    }

    private Resource getTypedNode(IndividualData childData, HashMap<String, Resource> createdTypedNodes, int[] stats) {
        IndividualData parentData = ExtractorUtil.getMappingDefinition(childData.getAggregatedIn());
        if (createdTypedNodes.containsKey(parentData.getId())) {
            return createdTypedNodes.get(parentData.getId());
        }
        Resource s = createdTypedNodes.get(IMAGE_RESOURCE_CODE);
        if (parentData.getAggregatedIn() != null) {
            s = this.getTypedNode(parentData, createdTypedNodes, stats);
        }
        this.model.enterCriticalSection(false);
        Resource newNode = this.model.createResource();
        this.model.leaveCriticalSection();
        if (parentData.isTyped().booleanValue()) {
            Property nodeType = this.rdf.property(parentData.getTypeNamespace(), parentData.getTypeClass());
            this.rdf.triple(newNode, RDF.type, (Resource)nodeType);
            stats[0] = stats[0] + 1;
        }
        Property p = this.rdf.property(parentData.getNamespace(), parentData.getAttribute());
        this.rdf.triple(s, p, newNode);
        stats[0] = stats[0] + 1;
        createdTypedNodes.put(parentData.getId(), newNode);
        return newNode;
    }

    private void addValueWithType(Resource resource, IndividualData iData, String extractedValue, int[] stats) {
        if (StringUtils.isEmpty((CharSequence)extractedValue)) {
            stats[3] = stats[3] + 1;
            return;
        }
        String cleanValue = extractedValue.replaceAll(FILTERED_CHARS, " ").trim();
        if (cleanValue.length() > 0 && !cleanValue.toLowerCase(Const.LOCALE).startsWith("unknown") && !cleanValue.toLowerCase(Const.LOCALE).startsWith("undefined")) {
            String[] tokens;
            if (iData.getSplitDelimiter() != null) {
                try {
                    tokens = cleanValue.split(iData.getSplitDelimiter());
                }
                catch (PatternSyntaxException e) {
                    LOG.warn("Defined delimiter {} is not valid regex pattern. Value will not be split.", (Object)iData.getSplitDelimiter());
                    tokens = new String[]{cleanValue};
                }
            } else {
                tokens = new String[]{cleanValue};
            }
            Property property = this.rdf.property(iData.getNamespace(), iData.getAttribute());
            for (String token : tokens) {
                token = token.trim();
                if (iData.isWrittenAsNode()) {
                    Individual ind = this.ontModel.getIndividual(SETTING.getImageNS() + iData.getAttribute() + "_" + token);
                    if (ind == null) {
                        LOG.info("Individual is not defined: {}{}_{}", new Object[]{SETTING.getImageNS(), iData.getAttribute(), token});
                        stats[3] = stats[3] + 1;
                        continue;
                    }
                    this.rdf.triple(resource, property, (Resource)ind);
                    continue;
                }
                if (iData.getDatatype() != null) {
                    if (iData.getDatatype() == XSDDatatype.XSDdateTime) {
                        Date date = DateUtil.stringToDateUnknownPattern(token);
                        if (date != null) {
                            this.rdf.triple(resource, property, date, (RDFDatatype)XSDDatatype.XSDdateTime);
                            stats[0] = stats[0] + 1;
                            continue;
                        }
                        LOG.info("Unknown date format for: {}", (Object)token);
                        stats[3] = stats[3] + 1;
                        continue;
                    }
                    if (iData.getDatatype().isValid(token)) {
                        this.model.enterCriticalSection(false);
                        Literal literal = this.model.createTypedLiteral(token, (RDFDatatype)iData.getDatatype());
                        this.model.leaveCriticalSection();
                        this.rdf.add(resource, property, literal);
                        stats[0] = stats[0] + 1;
                        continue;
                    }
                    LOG.info("Invalid lexical form: {}, {}", (Object)iData.getDatatype(), (Object)token);
                    stats[3] = stats[3] + 1;
                    continue;
                }
                this.rdf.add(resource, property, token);
                stats[0] = stats[0] + 1;
            }
        } else {
            stats[3] = stats[3] + 1;
        }
    }

    private String concatValue(IndividualData iData, Directory directory, Set<Integer> tagsDone) {
        StringBuilder sb = new StringBuilder();
        HashSet<String> tagsDoneInLoop = new HashSet<String>();
        while (iData.getFollows() != null) {
            if (tagsDoneInLoop.contains(iData.getId())) {
                LOG.warn("Cycle found in concatAfter definition of tags in {}. Skipping tags. {}", (Object)SETTING.getMappingOwlFileName(), (Object)iData.getId());
                return "";
            }
            tagsDoneInLoop.add(iData.getId());
            iData = ExtractorUtil.getMappingDefinition(iData.getFollows());
        }
        boolean next = true;
        tagsDoneInLoop = new HashSet();
        while (next) {
            if (tagsDoneInLoop.contains(iData.getId())) {
                LOG.warn("Cycle found in concatAfter definition of tags in {}. Skipping tags. {}", (Object)SETTING.getMappingOwlFileName(), (Object)iData.getId());
                return "";
            }
            tagsDoneInLoop.add(iData.getId());
            if (directory.containsTag(iData.getTag())) {
                String extractedValue = iData.isDesriptionUsed() ? directory.getDescription(iData.getTag()) : directory.getString(iData.getTag());
                if (extractedValue != null) {
                    extractedValue = extractedValue.trim();
                }
                if (iData.getTransformation() != null) {
                    extractedValue = ValueTransformator.dataTransformation(extractedValue, iData);
                }
                if (iData.getDatatype() == XSDDatatype.XSDdateTime) {
                    sb.append(extractedValue).append("; ");
                } else {
                    sb.append(extractedValue).append(" ");
                }
                tagsDone.add(iData.getTag());
            }
            if (iData.getPrecedes() != null) {
                iData = ExtractorUtil.getMappingDefinition(iData.getPrecedes());
                continue;
            }
            next = false;
        }
        if (iData.getDatatype() == XSDDatatype.XSDdateTime && iData.getTransformation() != null) {
            return ValueTransformator.dataTransformation(sb.toString().trim(), iData);
        }
        return sb.toString().trim();
    }

    public Resource getNexifImage() {
        return R_NEXIF_IMAGE;
    }
}

