/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.metamed.extractor.image;

import com.drew.imaging.tiff.TiffMetadataReader;
import com.drew.imaging.tiff.TiffProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.ExifInteropDirectory;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import com.drew.metadata.exif.ExifThumbnailDirectory;
import com.drew.metadata.exif.GpsDirectory;
import com.drew.metadata.exif.makernotes.CanonMakernoteDirectory;
import com.drew.metadata.exif.makernotes.CasioType1MakernoteDirectory;
import com.drew.metadata.exif.makernotes.CasioType2MakernoteDirectory;
import com.drew.metadata.exif.makernotes.FujifilmMakernoteDirectory;
import com.drew.metadata.exif.makernotes.KodakMakernoteDirectory;
import com.drew.metadata.exif.makernotes.KyoceraMakernoteDirectory;
import com.drew.metadata.exif.makernotes.LeicaMakernoteDirectory;
import com.drew.metadata.exif.makernotes.NikonType1MakernoteDirectory;
import com.drew.metadata.exif.makernotes.NikonType2MakernoteDirectory;
import com.drew.metadata.exif.makernotes.OlympusMakernoteDirectory;
import com.drew.metadata.exif.makernotes.PanasonicMakernoteDirectory;
import com.drew.metadata.exif.makernotes.PentaxMakernoteDirectory;
import com.drew.metadata.exif.makernotes.RicohMakernoteDirectory;
import com.drew.metadata.exif.makernotes.SanyoMakernoteDirectory;
import com.drew.metadata.exif.makernotes.SigmaMakernoteDirectory;
import com.drew.metadata.exif.makernotes.SonyType1MakernoteDirectory;
import com.drew.metadata.exif.makernotes.SonyType6MakernoteDirectory;
import cz.zcu.mre.metamed.extractor.AbstractExtractor;
import cz.zcu.mre.metamed.extractor.image.commons.ExtractorLogic;
import cz.zcu.mre.metamed.extractor.image.commons.ExtractorSetting;
import cz.zcu.mre.metamed.extractor.image.mapping.IndividualData;
import cz.zcu.mre.metamed.extractor.image.util.ExtractorUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TIFFExtractor
extends AbstractExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(TIFFExtractor.class);
    private static final long serialVersionUID = -1181639875032672489L;
    public static final String MIME = "image/tiff";
    private static final HashMap<Class, String> POSSIBLE_DIRECTORIES = new HashMap();
    private ExtractorLogic ext = null;
    private OntModel ontModel = null;
    private ExtractorSetting setting = null;

    public TIFFExtractor() {
        this.setExtractorName(TIFFExtractor.class.getName());
        this.setFileType(MIME);
    }

    public TIFFExtractor(Model model) {
        super(model);
    }

    public final void initialize() {
        this.ext = ExtractorLogic.getInstance(this.getModel());
        this.ontModel = this.ext.getOntModel();
        this.setting = ExtractorSetting.getInstance();
    }

    public final void read(File file) {
        int[] stats = new int[4];
        this.extractFileMetaData(file);
        Resource resource = this.rdf().mreResource(this.getFileHashValue());
        this.addFileMetaData(resource);
        this.rdf().triple(resource, RDF.type, ExtractorLogic.getInstance((Model)this.ontModel).getNexifImage());
        HashMap<String, Resource> createdTypedNodes = new HashMap<String, Resource>();
        createdTypedNodes.put("root", resource);
        try {
            Metadata metadata = TiffMetadataReader.readMetadata((File)file);
            for (Directory directory : metadata.getDirectories()) {
                String dirCode = POSSIBLE_DIRECTORIES.get(directory.getClass());
                if (dirCode == null) {
                    LOG.info("Mapping is not defined for {}", (Object)directory.getClass().getName());
                    continue;
                }
                HashSet<Integer> tagsDone = new HashSet<Integer>();
                for (Tag tag : directory.getTags()) {
                    if (tagsDone.contains(tag.getTagType())) continue;
                    Individual ontTag = this.ontModel.getIndividual(this.setting.getImmNS() + dirCode + "_" + tag.getTagTypeHex());
                    if (ontTag == null) {
                        LOG.info("Tag not defined: {}_{}", (Object)dirCode, (Object)tag.getTagTypeHex());
                        stats[1] = stats[1] + 1;
                        continue;
                    }
                    IndividualData iData = ExtractorUtil.getMappingDefinition(ontTag);
                    this.ext.processTag(tag, iData, directory, tagsDone, createdTypedNodes, stats);
                }
                if (!directory.hasErrors()) continue;
                for (String error : directory.getErrors()) {
                    LOG.error("External extraction library error: {} in file {}", (Object)error, (Object)file.getAbsoluteFile());
                }
            }
        }
        catch (TiffProcessingException | IOException ex) {
            LOG.error("{} in file {}", (Object)ex, (Object)file.getAbsoluteFile());
        }
        ExtractorUtil.renameNodes(createdTypedNodes, this.rdf());
        ExtractorLogic.printStatistics(stats, this.getFileName());
        if (stats[0] == 0 && stats[1] > 0) {
            LOG.warn("No mapping definition was found. Namespace of the mapping ontology might be incorrectly defined in image.properties. Namespace used: {}", (Object)this.setting.getImmNS());
        }
    }

    static {
        POSSIBLE_DIRECTORIES.put(ExifIFD0Directory.class, "exifIFD0");
        POSSIBLE_DIRECTORIES.put(ExifSubIFDDirectory.class, "exifSubIFD");
        POSSIBLE_DIRECTORIES.put(ExifThumbnailDirectory.class, "exifThumbnail");
        POSSIBLE_DIRECTORIES.put(ExifInteropDirectory.class, "exifInterop");
        POSSIBLE_DIRECTORIES.put(GpsDirectory.class, "gps");
        POSSIBLE_DIRECTORIES.put(CanonMakernoteDirectory.class, "canon");
        POSSIBLE_DIRECTORIES.put(CasioType1MakernoteDirectory.class, "casio1");
        POSSIBLE_DIRECTORIES.put(CasioType2MakernoteDirectory.class, "casio2");
        POSSIBLE_DIRECTORIES.put(FujifilmMakernoteDirectory.class, "fujifilm");
        POSSIBLE_DIRECTORIES.put(KodakMakernoteDirectory.class, "kodak");
        POSSIBLE_DIRECTORIES.put(KyoceraMakernoteDirectory.class, "kyocera");
        POSSIBLE_DIRECTORIES.put(LeicaMakernoteDirectory.class, "leica");
        POSSIBLE_DIRECTORIES.put(NikonType1MakernoteDirectory.class, "nikon1");
        POSSIBLE_DIRECTORIES.put(NikonType2MakernoteDirectory.class, "nikon2");
        POSSIBLE_DIRECTORIES.put(OlympusMakernoteDirectory.class, "olympus");
        POSSIBLE_DIRECTORIES.put(PanasonicMakernoteDirectory.class, "panasonic");
        POSSIBLE_DIRECTORIES.put(PentaxMakernoteDirectory.class, "pentax");
        POSSIBLE_DIRECTORIES.put(RicohMakernoteDirectory.class, "ricoh");
        POSSIBLE_DIRECTORIES.put(SanyoMakernoteDirectory.class, "sanyo");
        POSSIBLE_DIRECTORIES.put(SigmaMakernoteDirectory.class, "sigma");
        POSSIBLE_DIRECTORIES.put(SonyType1MakernoteDirectory.class, "sony1");
        POSSIBLE_DIRECTORIES.put(SonyType6MakernoteDirectory.class, "sony6");
    }
}

