/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.metamed.extractor.image;

import com.drew.imaging.png.PngMetadataReader;
import com.drew.imaging.png.PngProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import com.drew.metadata.icc.IccDirectory;
import com.drew.metadata.png.PngChromaticitiesDirectory;
import com.drew.metadata.png.PngDirectory;
import com.drew.metadata.xmp.XmpDirectory;
import cz.zcu.mre.metamed.extractor.AbstractExtractor;
import cz.zcu.mre.metamed.extractor.image.commons.ExtractorLogic;
import cz.zcu.mre.metamed.extractor.image.commons.ExtractorSetting;
import cz.zcu.mre.metamed.extractor.image.mapping.IndividualData;
import cz.zcu.mre.metamed.extractor.image.util.ExtractorUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PNGExtractor
extends AbstractExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(PNGExtractor.class);
    private static final long serialVersionUID = 6265588204236318087L;
    public static final String MIME = "image/png";
    private static final HashMap<Class, String> POSSIBLE_DIRECTORIES = new HashMap();
    private ExtractorLogic ext = null;
    private OntModel ontModel = null;
    private ExtractorSetting setting = null;

    public PNGExtractor() {
        this.setExtractorName(PNGExtractor.class.getName());
        this.setFileType(MIME);
    }

    public PNGExtractor(Model model) {
        super(model);
    }

    public final void initialize() {
        this.ext = ExtractorLogic.getInstance(this.getModel());
        this.ontModel = this.ext.getOntModel();
        this.setting = ExtractorSetting.getInstance();
    }

    public final void read(File file) {
        int[] stats = new int[4];
        this.extractFileMetaData(file);
        Resource resource = this.rdf().mreResource(this.getFileHashValue());
        this.addFileMetaData(resource);
        this.rdf().triple(resource, RDF.type, ExtractorLogic.getInstance((Model)this.ontModel).getNexifImage());
        HashMap<String, Resource> createdTypedNodes = new HashMap<String, Resource>();
        createdTypedNodes.put("root", resource);
        try {
            Metadata metadata = PngMetadataReader.readMetadata((File)file);
            for (Directory directory : metadata.getDirectories()) {
                String dirCode = POSSIBLE_DIRECTORIES.get(directory.getClass());
                if (dirCode == null) {
                    LOG.info("Mapping is not defined for {}", (Object)directory.getClass().getName());
                    continue;
                }
                HashSet<Integer> tagsDone = new HashSet<Integer>();
                for (Tag tag : directory.getTags()) {
                    if (tagsDone.contains(tag.getTagType())) continue;
                    Individual ontTag = this.ontModel.getIndividual(this.setting.getImmNS() + dirCode + "_" + tag.getTagTypeHex());
                    if (ontTag == null) {
                        LOG.info("Tag not defined: {}_{}", (Object)dirCode, (Object)tag.getTagTypeHex());
                        stats[1] = stats[1] + 1;
                        continue;
                    }
                    IndividualData iData = ExtractorUtil.getMappingDefinition(ontTag);
                    this.ext.processTag(tag, iData, directory, tagsDone, createdTypedNodes, stats);
                }
                if (!directory.hasErrors()) continue;
                for (String error : directory.getErrors()) {
                    LOG.error("External extraction library error: {} in file {}", (Object)error, (Object)file.getAbsoluteFile());
                }
            }
        }
        catch (PngProcessingException | IOException ex) {
            LOG.error("{} in file {}", (Object)ex, (Object)file.getAbsoluteFile());
        }
        ExtractorUtil.renameNodes(createdTypedNodes, this.rdf());
        LOG.info("STATS: {} triples added, {} values empty/unknown, {} definitions missing, {} definitions empty, {}", new Object[]{stats[0], stats[3], stats[1], stats[2], this.getFileName()});
        ExtractorLogic.printStatistics(stats, this.getFileName());
        if (stats[0] == 0 && stats[1] > 0) {
            LOG.warn("No mapping definition was found. Namespace of the mapping ontology might be incorrectly defined in image.properties. Namespace used: {}", (Object)this.setting.getImmNS());
        }
    }

    static {
        POSSIBLE_DIRECTORIES.put(XmpDirectory.class, "xmp");
        POSSIBLE_DIRECTORIES.put(IccDirectory.class, "icc");
        POSSIBLE_DIRECTORIES.put(PngDirectory.class, "png");
        POSSIBLE_DIRECTORIES.put(PngChromaticitiesDirectory.class, "pngChrom");
    }
}

