/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.common;

import java.util.Objects;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.graph.Node;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.common.BaseEnhNodeFactoryImpl;
import org.apache.jena.ontapi.common.EnhNodeFactory;
import org.apache.jena.ontapi.common.OntEnhGraph;
import org.apache.jena.ontapi.common.OntEnhNodeFactories;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.util.iterator.ExtendedIterator;

public class WrappedEnhNodeFactory
extends BaseEnhNodeFactoryImpl {
    private final Class<? extends RDFNode> type;

    public WrappedEnhNodeFactory(Class<? extends RDFNode> type) {
        this.type = Objects.requireNonNull(type);
    }

    public static WrappedEnhNodeFactory of(Class<? extends RDFNode> type) {
        return new WrappedEnhNodeFactory(type);
    }

    public EnhNodeFactory getDelegate(EnhGraph g) throws OntJenaException {
        return this.getFactory(g);
    }

    protected EnhNodeFactory getFactory(EnhGraph g) throws OntJenaException {
        return OntEnhGraph.asPersonalityModel(g).getOntPersonality().getObjectFactory(this.type);
    }

    @Override
    public ExtendedIterator<EnhNode> iterator(EnhGraph eg) {
        return this.getDelegate(eg).iterator(eg);
    }

    @Override
    public boolean canWrap(Node node, EnhGraph eg) {
        return this.getDelegate(eg).canWrap(node, eg);
    }

    @Override
    public EnhNode createInstance(Node node, EnhGraph eg) {
        return this.getDelegate(eg).createInstance(node, eg);
    }

    @Override
    public EnhNode wrap(Node node, EnhGraph eg) {
        return this.getDelegate(eg).wrap(node, eg);
    }

    public String toString() {
        return String.format("Factory[%s]", OntEnhNodeFactories.viewAsString(this.type));
    }
}

