/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.metamed.extractor;

import cz.zcu.mre.metamed.extractor.AbstractScanner;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLScanner
extends AbstractScanner {
    private static final Logger LOG = LoggerFactory.getLogger(XMLScanner.class);

    public XMLScanner() {
        this.setName(XMLScanner.class.getName());
        this.setFileType("application/xml");
    }

    @Override
    public void initialize() {
    }

    @Override
    public void read(File file) {
        try {
            this.setFile(file);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(file);
            document.getDocumentElement().normalize();
            Element rootElement = document.getDocumentElement();
            this.scanAttributes(rootElement);
            NodeList nodeList = rootElement.getElementsByTagName("*");
            this.scanChildNodes(nodeList);
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            LOG.error(ex.toString());
        }
        this.writeOutput();
    }

    private void scanAttributes(Node node) {
        if (node == null) {
            return;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return;
        }
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node tempNode = namedNodeMap.item(i);
            LOG.debug(this.getParentPath(node) + "@" + tempNode.getNodeName() + " = " + tempNode.getNodeValue());
            this.getFileContent().add(this.getParentPath(node) + "@" + tempNode.getNodeName(), tempNode.getNodeValue());
        }
    }

    private String getParentPath(Node node) {
        if (node == null) {
            return "";
        }
        Node parent = node.getParentNode();
        if (parent != null) {
            return this.getParentPath(parent) + "/" + node.getNodeName();
        }
        if (node.getNodeName() == null || node.getNodeName().equals("null")) {
            return "";
        }
        return "";
    }

    private void scanChildNodes(NodeList nodeList) {
        if (nodeList == null) {
            return;
        }
        for (int temp = 0; temp < nodeList.getLength(); ++temp) {
            Node node = nodeList.item(temp);
            if (node.getNodeType() != 1) continue;
            if (node.hasAttributes()) {
                this.scanAttributes(node);
            }
            if (node.hasChildNodes()) {
                this.scanChildNodes(node.getChildNodes());
            }
            String textContent = node.getTextContent();
            if (node.getChildNodes().getLength() != 1 || textContent == null || textContent.isEmpty()) continue;
            LOG.debug(this.getParentPath(node) + " = " + textContent);
            this.getFileContent().add(this.getParentPath(node), textContent);
        }
    }
}

