/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.metamed.extractor;

import cz.zcu.mre.mrelib.concurent.Scanner;
import cz.zcu.mre.mrelib.data.FileContent;
import cz.zcu.mre.mrelib.data.FileTypeDeterminer;
import cz.zcu.mre.mrelib.util.DateUtil;
import cz.zcu.mre.mrelib.util.HashGenerator;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Level;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScanner
implements Scanner {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractScanner.class);
    private static final long serialVersionUID = -3587729648021015256L;
    private String name;
    private FileContent fileContent = null;
    private String fileHashValue = null;
    private long fileLength = 0L;
    private String fileLastModified = null;
    private File file;
    private String filePath = null;
    private String fileName = null;
    private String fileType;
    private String fileFormat;
    private int priority = 0;
    private File fileOutput = null;

    public AbstractScanner() {
    }

    public AbstractScanner(File f) {
        this();
        this.setFile(f);
    }

    public final void setFile(File f) {
        if (f == null || !f.exists() || !f.canRead()) {
            LOG.warn("Null file is not allowed in AbstractScanner");
            return;
        }
        if (this.fileContent != null) {
            this.fileContent.empty();
        }
        this.file = f;
        this.scanFileMetaData();
        this.addFileMetaData();
    }

    protected final void scanFileMetaData() {
        this.filePath = this.file.getPath();
        this.fileName = this.file.getName();
        this.fileLength = this.file.length();
        this.fileFormat = FileTypeDeterminer.determineType(this.file);
        this.fileLastModified = DateUtil.format(new Date(this.file.lastModified()), "yyyy-MM-dd'T'HH:mm:ss");
        this.fileHashValue = HashGenerator.sha1(this.file);
    }

    protected final void addFileMetaData() {
        this.fileContent = new FileContent(this.file);
        this.fileContent.add("filePath", this.filePath);
        this.fileContent.add("fileName", this.fileName);
        this.fileContent.add("fileFormat", this.fileFormat);
        this.fileContent.add("fileLastModified", this.fileLastModified);
        this.fileContent.add("fileLength", this.fileLength);
        this.fileContent.add("fileHashValue", this.fileHashValue);
    }

    protected final void setFileType(String type) {
        this.fileType = type;
    }

    @Override
    public final String getFileType() {
        return this.fileType;
    }

    @Override
    public final boolean hasSupport(File f) {
        return this.getFileType().equals(FileTypeDeterminer.determineType(f));
    }

    public final void setFileContent(FileContent output) {
        if (output == null) {
            throw new NullPointerException("Model is null.");
        }
        this.fileContent = output;
    }

    @Override
    public final int getPriority() {
        return this.priority;
    }

    @Override
    public final void setPriority(int value) {
        this.priority = value;
    }

    public final String getFileHashValue() {
        return this.fileHashValue;
    }

    public final long getFileLength() {
        return this.fileLength;
    }

    public final String getFileLastModified() {
        return this.fileLastModified;
    }

    public final File getFile() {
        return this.file;
    }

    public final String getFilePath() {
        return this.filePath;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final String getFileFormat() {
        return this.fileFormat;
    }

    @Override
    public FileContent getFileContent() {
        return this.fileContent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public File getFileOutput() {
        return this.fileOutput;
    }

    @Override
    public void setFileOutput(File fileOutput) {
        this.fileOutput = fileOutput;
    }

    protected void writeOutput() {
        try {
            FileUtils.write((File)this.getFileOutput(), (CharSequence)this.fileContent.toString(), (String)"UTF8", (boolean)true);
        }
        catch (IOException ex) {
            java.util.logging.Logger.getLogger(AbstractScanner.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

