/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.metamed.extractor;

import cz.zcu.mre.mrelib.concurent.Extractor;
import cz.zcu.mre.mrelib.data.FileTypeDeterminer;
import cz.zcu.mre.mrelib.util.DateUtil;
import cz.zcu.mre.mrelib.util.HashGenerator;
import cz.zcu.mre.mrelib.util.RDFUtil;
import cz.zcu.mre.vocab.MRE;
import cz.zcu.mre.vocab.NFO;
import java.io.File;
import java.util.Date;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.impl.XSDDateType;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.DC;
import org.apache.jena.vocabulary.DCTerms;
import org.apache.jena.vocabulary.RDF;

public abstract class AbstractExtractor
implements Extractor {
    private static final long serialVersionUID = -3587729648021015216L;
    public static final String DEFAULT_HASH_ALGORITHM = "SHA-1";
    private static final int DATE_LENGTH = 10;
    private Model model;
    private RDFUtil rdf = null;
    private Property propertyRDFType;
    private Property propertyDCTitle;
    private Property propertyFilename;
    private Property propertyFilePath;
    private Property propertyFileLastModified;
    private Property propertyFileSize;
    private Property propertyHasHash;
    private Resource resourceClassFileHash;
    private Property propertyHashAlgorithm;
    private Property propertyHashValue;
    private Property propertyFileFormat;
    private String fileHashValue = null;
    private String hashAlgorithm = "SHA-1";
    private long fileLength = 0L;
    private String fileLastModified = null;
    private File file;
    private String filePath = null;
    private String fileName = null;
    private String fileType;
    private String fileFormat;
    private String extractorName;
    private Property propertyMREHasData;
    private Resource resourceDataset;
    private Resource resourceClassMREDataset;
    private Resource resourceClassMREDataSource;
    private Resource resourceDataSource;
    private Property propertyMREHasDataSource;
    private String dataSourceLabelValue;
    private String datasetDateValue;
    private Resource resourceForDataset;
    private int priority = 0;

    public AbstractExtractor() {
    }

    public AbstractExtractor(Model m) {
        this();
        this.setModel(m);
    }

    public final void extractFileMetaData(File f) {
        if (f == null) {
            return;
        }
        this.file = f;
        this.filePath = this.file.getPath();
        this.fileName = this.file.getName();
        this.fileLength = this.file.length();
        this.fileFormat = FileTypeDeterminer.determineType(this.file);
        this.fileLastModified = DateUtil.format(new Date(this.file.lastModified()), "yyyy-MM-dd'T'HH:mm:ss");
        this.fileHashValue = HashGenerator.sha1(this.file);
        this.datasetDateValue = this.fileLastModified.substring(0, 10);
    }

    protected final void addFileMetaData(Resource resource) {
        this.model.enterCriticalSection(false);
        this.model.add(resource, this.propertyFilePath, this.filePath);
        this.model.removeAll(resource, this.propertyFilename, null);
        this.model.add(resource, this.propertyFilename, this.fileName);
        this.model.removeAll(resource, this.propertyFileFormat, null);
        this.model.add(resource, this.propertyFileFormat, this.fileFormat);
        this.model.removeAll(resource, this.propertyFileLastModified, null);
        this.model.add(resource, this.propertyFileLastModified, this.fileLastModified, (RDFDatatype)XSDDateType.XSDdateTime);
        this.model.removeAll(resource, this.propertyFileSize, null);
        this.model.add(resource, this.propertyFileSize, Long.toString(this.fileLength));
        Resource resourceHash = this.model.createResource("https://mre.zcu.cz/id/" + HashGenerator.sha1Text(resource.toString().concat("hash")), this.resourceClassFileHash);
        this.model.add(resourceHash, this.propertyHashAlgorithm, this.hashAlgorithm);
        this.model.removeAll(resourceHash, this.propertyHashValue, null);
        this.model.add(resourceHash, this.propertyHashValue, this.fileHashValue);
        this.model.add(resource, this.propertyHasHash, (RDFNode)resourceHash);
        this.resourceDataset = this.model.createResource("https://mre.zcu.cz/id/" + HashGenerator.sha1Text(this.dataSourceLabelValue + this.datasetDateValue));
        this.model.add(this.resourceDataset, this.propertyRDFType, (RDFNode)this.resourceClassMREDataset);
        this.model.add(this.resourceDataset, this.propertyDCTitle, this.dataSourceLabelValue + " " + this.datasetDateValue);
        if (this.dataSourceLabelValue != null) {
            this.resourceDataSource = this.model.createResource("https://mre.zcu.cz/id/" + HashGenerator.sha1Text(this.dataSourceLabelValue));
            this.model.add(this.resourceDataSource, this.propertyRDFType, (RDFNode)this.resourceClassMREDataSource);
            this.model.add(this.resourceDataSource, this.propertyDCTitle, this.dataSourceLabelValue);
            this.model.add(this.resourceDataset, this.propertyMREHasDataSource, (RDFNode)this.resourceDataSource);
        }
        this.resourceForDataset = resource;
        this.appendFileResourceToDataset();
        this.model.leaveCriticalSection();
    }

    @Override
    public void appendFileResourceToDataset() {
        this.appendToDataset(this.resourceForDataset);
    }

    @Override
    public void appendToDataset(Resource resource) {
        this.model.add(this.resourceDataset, this.propertyMREHasData, (RDFNode)resource);
    }

    protected final void setFileType(String type) {
        this.fileType = type;
    }

    @Override
    public final String getFileType() {
        return this.fileType;
    }

    @Override
    public final String getName() {
        return this.extractorName;
    }

    protected final void setExtractorName(String name) {
        this.extractorName = name;
    }

    @Override
    public final boolean hasSupport(File f) {
        return this.getFileType().equals(FileTypeDeterminer.determineType(f));
    }

    @Override
    public final Model getModel() {
        return this.model;
    }

    @Override
    public final void setModel(Model m) {
        if (m == null) {
            throw new NullPointerException("Model is null.");
        }
        this.model = m;
        this.rdf = new RDFUtil(m);
        this.propertyRDFType = RDF.type;
        this.propertyDCTitle = DC.title;
        this.propertyFilePath = MRE.FILE_PATH;
        this.propertyFilename = NFO.FILE_NAME;
        this.propertyFileLastModified = NFO.FILE_LAST_MODIFIED;
        this.propertyFileSize = NFO.FILE_SIZE;
        this.propertyFileFormat = DCTerms.format;
        this.resourceClassFileHash = NFO.FILE_HASH;
        this.propertyHasHash = NFO.HAS_HASH;
        this.propertyHashAlgorithm = NFO.HASH_ALGORITHM;
        this.propertyHashValue = NFO.HASH_VALUE;
        this.resourceClassMREDataSource = MRE.DATA_SOURCE_CLASS1;
        this.propertyMREHasDataSource = MRE.HAS_DATA_SOURCE;
        this.resourceClassMREDataset = MRE.DATASET_CLASS;
        this.propertyMREHasData = MRE.HAS_DATA;
    }

    @Override
    public final void setDataSourceLabel(String label) {
        this.dataSourceLabelValue = label;
    }

    @Override
    public final int getPriority() {
        return this.priority;
    }

    @Override
    public final void setPriority(int value) {
        this.priority = value;
    }

    public final String getDatasetDate() {
        return this.datasetDateValue;
    }

    public final void setDatasetDate(String value) {
        this.datasetDateValue = value;
    }

    public final String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public final void setHashAlgorithm(String algorithm) {
        this.hashAlgorithm = algorithm;
    }

    public final Property getPropertyRDFType() {
        return this.propertyRDFType;
    }

    public final Property getPropertyDCTitle() {
        return this.propertyDCTitle;
    }

    public final Property getPropertyFilename() {
        return this.propertyFilename;
    }

    public final Property getPropertyFilePath() {
        return this.propertyFilePath;
    }

    public final Property getPropertyFileLastModified() {
        return this.propertyFileLastModified;
    }

    public final Property getPropertyFileSize() {
        return this.propertyFileSize;
    }

    public final Property getPropertyHasHash() {
        return this.propertyHasHash;
    }

    public final Resource getResourceClassFileHash() {
        return this.resourceClassFileHash;
    }

    public final Property getPropertyHashAlgorithm() {
        return this.propertyHashAlgorithm;
    }

    public final Property getPropertyHashValue() {
        return this.propertyHashValue;
    }

    public final Property getPropertyFileFormat() {
        return this.propertyFileFormat;
    }

    public final String getFileHashValue() {
        return this.fileHashValue;
    }

    public final long getFileLength() {
        return this.fileLength;
    }

    public final String getFileLastModified() {
        return this.fileLastModified;
    }

    public final File getFile() {
        return this.file;
    }

    public final String getFilePath() {
        return this.filePath;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final String getFileFormat() {
        return this.fileFormat;
    }

    public final Property getPropertyMREHasData() {
        return this.propertyMREHasData;
    }

    public final Resource getResourceDataset() {
        return this.resourceDataset;
    }

    public final Resource getResourceClassMREDataset() {
        return this.resourceClassMREDataset;
    }

    public final Resource getResourceClassMREDataSource() {
        return this.resourceClassMREDataSource;
    }

    public final Resource getResourceDataSource() {
        return this.resourceDataSource;
    }

    public final Property getPropertyMREHasDataSource() {
        return this.propertyMREHasDataSource;
    }

    public final String getDataSourceLabelValue() {
        return this.dataSourceLabelValue;
    }

    public final String getDatasetDateValue() {
        return this.datasetDateValue;
    }

    public final void setFile(File f) {
        this.file = f;
        this.extractFileMetaData(f);
    }

    public RDFUtil rdf() {
        return this.rdf;
    }
}

