/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.metamed.extractor.dasta;

import cz.zcu.mre.metamed.extractor.AbstractExtractor;
import cz.zcu.mre.mrelib.data.XMLParser;
import cz.zcu.mre.mrelib.util.DateUtil;
import cz.zcu.mre.vocab.DS;
import cz.zcu.mre.vocab.NFO;
import java.io.File;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.DC_11;
import org.apache.jena.vocabulary.RDF;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DASTAExtractor
extends AbstractExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(DASTAExtractor.class);
    private static final long serialVersionUID = -6811115254057224970L;
    public static final String XSD_DATETIME_DASTA_DT = "yyyy-MM-dd'T'HH:mm";
    private static final int ICD_DIAG_LENGTH = 4;
    private final XMLParser parser = new XMLParser();
    private Resource rDASTA;
    private Resource rPatient;
    private Resource rClinicalEvent;

    public DASTAExtractor() {
        this.setExtractorName(DASTAExtractor.class.getName());
        this.setFileType("dasta");
    }

    public DASTAExtractor(Model model) {
        super(model);
    }

    public void initialize() {
    }

    public void read(File file) {
        this.extractFileMetaData(file);
        this.parser.parseXML(file);
        this.rDASTA = this.createDASTA();
        if (this.rDASTA != null) {
            this.rdf().triple(this.getResourceDataset(), this.getPropertyMREHasData(), this.rDASTA);
        }
    }

    private void addStringProperty(Resource r, String n, String xpath, String a) {
        Property property = this.rdf().property("https://mre.zcu.cz/ontology/dasta.owl#", n);
        String value = this.parser.attributeValue(xpath, a);
        this.rdf().triple(r, property, value);
    }

    private void addDateProperty(Resource r, String n, String xpath, String a, XSDDatatype t) {
        Property property = this.rdf().property("https://mre.zcu.cz/ontology/dasta.owl#", n);
        String value = this.parser.attributeValue(xpath, a);
        Date date = DateUtil.stringToDate((String)"yyyy-MM-dd'T'HH:mm:ss", (String)value);
        this.rdf().triple(r, property, date, (RDFDatatype)t);
    }

    private Resource createDASTA() {
        String xpath = "/dasta";
        this.rDASTA = this.rdf().mreResource(this.getFileHashValue());
        this.rdf().triple(this.rDASTA, RDF.type, (Resource)DS.DASTA);
        this.rdf().update(this.rDASTA, DC_11.title, (Object)this.getFile().getName());
        this.addFileMetaData(this.rDASTA);
        String value = this.parser.attributeValue(xpath, "bin_priloha");
        if (value != null && !value.isEmpty()) {
            if (value.equals("B")) {
                this.rdf().triple(this.rDASTA, (Property)DS.CONTAINS_BINARY_ATTACHMENT, Boolean.TRUE);
            } else {
                this.rdf().triple(this.rDASTA, (Property)DS.CONTAINS_BINARY_ATTACHMENT, Boolean.FALSE);
            }
        }
        String propName = "datetimeBlockCreated";
        String attribute = "dat_vb";
        this.addDateProperty(this.rDASTA, propName, xpath, attribute, XSDDatatype.XSDdateTime);
        propName = "fileId";
        attribute = "id_soubor";
        this.addStringProperty(this.rDASTA, propName, xpath, attribute);
        propName = "fileCode";
        attribute = "ozn_soub";
        this.addStringProperty(this.rDASTA, propName, xpath, attribute);
        propName = "urgentFlag";
        attribute = "ur";
        this.addStringProperty(this.rDASTA, propName, xpath, attribute);
        value = this.parser.attributeValue(xpath, "typ_odesm");
        Resource rTABTO = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "TAB_TO", "_", value, false, false);
        this.rdf().triple(this.rDASTA, (Property)DS.FILE_TYPE_CODE, rTABTO);
        value = this.parser.attributeValue(xpath, "verze_ds");
        Resource rVERDS = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "V_DS", "_", value, false, false);
        this.rdf().triple(this.rDASTA, (Property)DS.DASTA_VERSION, rVERDS);
        value = this.parser.attributeValue(xpath, "verze_nclp");
        Resource rVERNLCP = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "V_NLCP", "_", value, false, false);
        this.rdf().triple(this.rDASTA, (Property)DS.NCLP_VERSION, rVERNLCP);
        Resource rSourceInformationSystem = this.createSourceInformationSystem();
        this.rdf().triple(this.rDASTA, (Property)DS.INFORMATION_SYSTEM, rSourceInformationSystem);
        Resource rRecipientDepartment = this.createRecipientDepartment();
        this.rdf().triple(this.rDASTA, (Property)DS.RECIPIENT, rRecipientDepartment);
        Resource rOriginatorDepartment = this.createOriginatorDepartment();
        this.rdf().triple(this.rDASTA, (Property)DS.ORIGINATOR, rOriginatorDepartment);
        this.rPatient = this.createPatient();
        this.rdf().triple(this.rDASTA, (Property)DS.PATIENT, this.rPatient);
        this.rClinicalEvent = this.createMedicalExamination();
        if (this.rClinicalEvent != null) {
            this.rdf().triple(this.rDASTA, (Property)DS.CLINICAL_EVENT, this.rClinicalEvent);
            this.rdf().triple(this.rPatient, (Property)DS.CLINICAL_EVENT, this.rClinicalEvent);
            Set<Resource> diagnosis = this.createDiagnosis();
            diagnosis.forEach(rDiagnosis -> this.rdf().triple(this.rClinicalEvent, (Property)DS.DIAGNOSIS, rDiagnosis));
        }
        this.createLaboratoryExamination(this.rPatient);
        return this.rDASTA;
    }

    private Resource createSourceInformationSystem() {
        String xpath = "/dasta/zdroj_is";
        String vLicCis = this.parser.attributeValue(xpath, "liccis_prog");
        String vVerProg = this.parser.attributeValue(xpath, "verze_prog");
        String vKodProg = this.parser.attributeValue(xpath, "kod_prog");
        String vKodFirmy = this.parser.attributeValue(xpath, "kod_firmy");
        Resource rTABKF = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "TABKF", "_", vKodFirmy, false, false);
        String id = vKodFirmy + vKodProg + vVerProg;
        Resource r = this.rdf().mreResource(id);
        this.rdf().triple(r, RDF.type, (Resource)DS.INFORMATION_SYSTEM_CLASS);
        if (vLicCis != null && !vLicCis.isEmpty()) {
            this.rdf().triple(r, (Property)DS.APPLICATION_LICENSE_NUMBER, vLicCis);
        }
        if (vVerProg != null && !vVerProg.isEmpty()) {
            this.rdf().triple(r, (Property)DS.APPLICATION_VERSION, vVerProg);
        }
        if (vKodProg != null && !vKodProg.isEmpty()) {
            this.rdf().triple(r, (Property)DS.APPLICATION_CODE_NAME, vKodProg);
        }
        this.rdf().triple(r, (Property)DS.APPLICATION_COMPANY_NAME, rTABKF);
        if (vVerProg != null || vKodProg != null) {
            this.rdf().update(r, DC_11.title, (Object)(vKodProg + " " + vVerProg));
        }
        return r;
    }

    protected final Resource createPatient() {
        Resource rUrgentData;
        Resource rWeight;
        Resource rHeight;
        Resource rPatientAddress;
        Date date;
        Resource rPOHLAV;
        String xpath = "/dasta/is/ip";
        StringBuilder label = new StringBuilder();
        String value = this.parser.attributeValue(xpath, "id_pac");
        this.rPatient = this.rdf().mreResource(value);
        this.rdf().triple(this.rPatient, RDF.type, (Resource)DS.PATIENT_CLASS);
        this.rdf().triple(this.rPatient, (Property)DS.PATIENT_ID, value);
        value = this.parser.elementValue("/dasta/is/ip/prijmeni");
        if (value != null && !value.isEmpty()) {
            this.rdf().triple(this.rPatient, (Property)DS.LAST_NAME, value);
            label.append(value);
        }
        if ((value = this.parser.elementValue("/dasta/is/ip/jmeno")) != null && !value.isEmpty()) {
            this.rdf().triple(this.rPatient, (Property)DS.FIRST_NAME, value);
            label.append(" ").append(value);
        }
        if ((value = this.parser.elementValue("/dasta/is/ip/sex")) != null && !value.isEmpty()) {
            label.append(" (").append(value).append(")");
            switch (value) {
                case "M": {
                    this.rdf().triple(this.rPatient, RDF.type, (Resource)DS.MALE);
                    rPOHLAV = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "POHLAV", "_", "1", false, false);
                    Resource rNCLPTPS = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "NCLPTPS", "_", value, false, false);
                    this.rdf().triple(this.rPatient, (Property)DS.SEX_NCLPTPS, rNCLPTPS);
                    break;
                }
                case "F": {
                    this.rdf().triple(this.rPatient, RDF.type, (Resource)DS.FEMALE);
                    rPOHLAV = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "POHLAV", "_", "2", false, false);
                    Resource rNCLPTPS = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "NCLPTPS", "_", value, false, false);
                    this.rdf().triple(this.rPatient, (Property)DS.SEX_NCLPTPS, rNCLPTPS);
                    break;
                }
                default: {
                    rPOHLAV = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "POHLAV", "_", "3", false, false);
                    break;
                }
            }
        } else {
            rPOHLAV = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "POHLAV", "_", "0", false, false);
        }
        this.rdf().update(this.rPatient, (Property)DS.SEX, (Object)value);
        this.rdf().update(this.rPatient, (Property)DS.SEX_POHLAV, (Object)rPOHLAV);
        value = this.parser.elementValue("/dasta/is/ip/rod_prijm");
        if (value != null && !value.isEmpty()) {
            this.rdf().update(this.rPatient, (Property)DS.MAIDEN_NAME, (Object)value);
        }
        if ((value = this.parser.elementValue("/dasta/is/ip/titul_pred")) != null && !value.isEmpty()) {
            this.rdf().update(this.rPatient, (Property)DS.TITLE_BEFORE, (Object)value);
        }
        if ((value = this.parser.elementValue("/dasta/is/ip/titul_za")) != null && !value.isEmpty()) {
            this.rdf().update(this.rPatient, (Property)DS.TITLE_AFTER, (Object)value);
        }
        if ((value = this.parser.elementValue("/dasta/is/ip/jine_idu")) != null && !value.isEmpty()) {
            this.rdf().update(this.rPatient, (Property)DS.PATIENT_ID2, (Object)value);
        }
        if ((value = this.parser.elementValue("/dasta/is/ip/dat_dn")) != null && !value.isEmpty()) {
            date = DateUtil.stringToDate((String)"yyyy-MM-dd", (String)value);
            this.rdf().triple(this.rPatient, (Property)DS.DATETIME_BIRTH, date, (RDFDatatype)XSDDatatype.XSDdate);
            label.append(" * ").append(value);
        }
        if ((value = this.parser.elementValue("/dasta/is/ip/dat_de")) != null && !value.isEmpty()) {
            date = DateUtil.stringToDate((String)"yyyy-MM-dd", (String)value);
            this.rdf().triple(this.rPatient, (Property)DS.DATETIME_DEATH, date, (RDFDatatype)XSDDatatype.XSDdate);
            label.append(" \u271d ").append(value);
        }
        if ((rPatientAddress = this.createPatientAddress()) != null) {
            this.rdf().update(this.rPatient, (Property)DS.ADDRESS, (Object)rPatientAddress);
        }
        if ((rHeight = this.createHeight()) != null) {
            this.rdf().triple(this.rPatient, (Property)DS.HEIGHT, rHeight);
        }
        if ((rWeight = this.createWeight()) != null) {
            this.rdf().triple(this.rPatient, (Property)DS.WEIGHT, rWeight);
        }
        if ((rUrgentData = this.createUrgentData()) != null) {
            this.rdf().triple(this.rPatient, (Property)DS.URGENT_DATA, rUrgentData);
        }
        this.rdf().update(this.rPatient, DC_11.title, (Object)label.toString());
        return this.rPatient;
    }

    private Resource createRecipientDepartment() {
        String xpath = "/dasta/pm";
        String vICP = this.parser.attributeValue(xpath, "icp");
        String vJmeno = this.parser.elementValue(xpath + "/a/jmeno");
        Resource r = this.rdf().mreResource(vICP + vJmeno);
        this.rdf().triple(r, RDF.type, (Resource)DS.RECIPIENT_DEPARTMENT);
        if (vICP != null && !vICP.isEmpty()) {
            this.rdf().triple(r, (Property)DS.ICP, vICP);
        }
        if (vJmeno != null && !vJmeno.isEmpty()) {
            this.rdf().triple(r, (Property)DS.DEPARTMENT_NAME, vJmeno);
            this.rdf().update(r, DC_11.title, (Object)vJmeno);
        }
        return r;
    }

    private Resource createOriginatorDepartment() {
        String xpath = "/dasta/is";
        String vICP = this.parser.attributeValue(xpath, "icp");
        String vJmeno = this.parser.elementValue(xpath + "/a/jmeno");
        Resource r = this.rdf().mreResource(vICP + vJmeno);
        this.rdf().triple(r, RDF.type, (Resource)DS.ORIGINATOR_DEPARTMENT);
        if (vICP != null && !vICP.isEmpty()) {
            this.rdf().triple(r, (Property)DS.ICP, vICP);
        }
        if (vJmeno != null && !vJmeno.isEmpty()) {
            this.rdf().update(r, (Property)DS.DEPARTMENT_NAME, (Object)vJmeno);
            this.rdf().update(r, DC_11.title, (Object)vJmeno);
        }
        return r;
    }

    private Resource createMedicalExamination() {
        Resource rLZTZOV;
        StringBuilder label = new StringBuilder();
        if (!this.parser.exist("/dasta/is/ip/z")) {
            return null;
        }
        String value = this.parser.attributeValue("/dasta/is/ip/z", "oznaceni_o");
        Resource r = this.rdf().mreResource(value);
        this.rdf().triple(r, RDF.type, (Resource)DS.MEDICAL_EXAMINATION);
        this.rdf().add(r, (Property)DS.IMAGING_STUDY_NUMBER, value);
        value = this.parser.attributeValue("/dasta/is/ip/z", "zadost");
        if (value != null && !value.isEmpty()) {
            rLZTZOV = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "LZTZOV", "_", value, false, false);
            this.rdf().triple(r, (Property)DS.DSCL_EXAMINATION_REQUEST, rLZTZOV);
        }
        if ((value = this.parser.attributeValue("/dasta/is/ip/z", "vznik")) != null && !value.isEmpty()) {
            rLZTZOV = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "LZTOZV", "_", value, false, false);
            this.rdf().triple(r, (Property)DS.DSCL_EXAMINATION_ORIGIN, rLZTZOV);
        }
        if ((value = this.parser.attributeValue("/dasta/is/ip/z", "stav")) != null && !value.isEmpty()) {
            Resource rLZSZZ = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "LZSZZ", "_", value, false, false);
            this.rdf().triple(r, (Property)DS.DSCL_EXAMINATION_STATE, rLZSZZ);
        }
        if ((value = this.parser.attributeValue("/dasta/is/ip/z", "obsah")) != null && !value.isEmpty()) {
            Resource rLZSOZ = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "LZSOZ", "_", value, false, false);
            this.rdf().triple(r, (Property)DS.DSCL_EXAMINATION_CONTENT, rLZSOZ);
        }
        if ((value = this.parser.elementValue("/dasta/is/ip/z/dat_du")) != null && !value.isEmpty()) {
            Date date = DateUtil.stringToDate((String)XSD_DATETIME_DASTA_DT, (String)value);
            this.rdf().triple(r, (Property)DS.DATETIME_EVENT, date, (RDFDatatype)XSDDatatype.XSDdateTime);
            label.append(value.replace('T', ' ')).append(": ");
        }
        if ((value = this.parser.elementValue("/dasta/is/ip/z/nazev")) != null && !value.isEmpty()) {
            this.rdf().add(r, (Property)DS.REPORT_TITLE, value);
            label.append(value);
        }
        if ((value = this.parser.elementValue("/dasta/is/ip/z/text/ptext")) != null && !value.isEmpty()) {
            this.rdf().triple(r, (Property)DS.REPORT_TEXT, value);
        }
        Resource rOriginatorDepartment = this.createOriginatorDepartment();
        this.rdf().triple(r, (Property)DS.ORIGINATOR, rOriginatorDepartment);
        this.createAttachmentList(r);
        this.rdf().update(r, DC_11.title, (Object)label.toString());
        return r;
    }

    private Set<Resource> createDiagnosis() {
        HashSet<Resource> set = new HashSet<Resource>();
        List dgz = this.parser.nodes("/dasta/is/ip/dg/dgz");
        if (dgz != null) {
            dgz.stream().filter(dgzObject -> dgzObject != null).map(dgzObject -> {
                StringBuilder label = new StringBuilder();
                String typDg = this.parser.attributeValue(dgzObject, "typ_dg");
                OntClass rDiagnosisType = typDg != null && typDg.equals("T") ? DS.PERMANENT_DIAGNOSIS : DS.ACTUAL_DIAGNOSIS;
                String rDiag = this.parser.elementValue((Content)dgzObject, "diag");
                Resource rMKN105 = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "MKN10_5", "_", rDiag, false, false);
                Element nDiag = this.parser.getNode(dgzObject, "diag");
                String vPoradi = this.parser.attributeValue(nDiag, "poradi");
                String vDatDu = this.parser.elementValue((Content)dgzObject, "dat_du");
                String vSpecDg = this.parser.elementValue((Content)dgzObject, "spec_dg");
                String id = this.rPatient.toString() + rDiag + vDatDu;
                Resource rDiagnosis = this.rdf().mreResource(id);
                this.rdf().triple(rDiagnosis, RDF.type, (Resource)rDiagnosisType);
                this.rdf().triple(rDiagnosis, (Property)DS.PATIENT, this.rPatient);
                this.rdf().triple(rDiagnosis, (Property)DS.DIAG_CODE, rMKN105);
                if (vPoradi != null && !vPoradi.isEmpty()) {
                    this.rdf().add(rDiagnosis, (Property)DS.DIAG_ORDER, vPoradi);
                }
                if (vDatDu != null && !vDatDu.isEmpty()) {
                    Date date = DateUtil.stringToDate((String)"yyyy-MM-dd", (String)vDatDu);
                    this.rdf().triple(rDiagnosis, (Property)DS.DATETIME_EVENT, date, (RDFDatatype)XSDDatatype.XSDdate);
                    label.append(vDatDu);
                }
                label.append(" (").append(vPoradi).append(") ");
                if (rDiag != null) {
                    if (rDiag.length() != 4) {
                        label.append(rDiag);
                    } else {
                        label.append(rDiag.substring(0, 3).concat(".").concat(rDiag.substring(3)));
                    }
                }
                if (vSpecDg != null && !vSpecDg.isEmpty()) {
                    this.rdf().add(rDiagnosis, (Property)DS.DIAG_DETAIL, vSpecDg);
                    label.append(" - ").append(vSpecDg);
                }
                this.rdf().update(rDiagnosis, DC_11.title, (Object)label.toString());
                return rDiagnosis;
            }).forEachOrdered(rDiagnosis -> set.add((Resource)rDiagnosis));
        }
        return set;
    }

    private void createAttachmentList(Resource resource) {
        List attachmentList = this.parser.nodes("/dasta/is/ip/z/priloha");
        for (Element attachmentElement : attachmentList) {
            String filename = this.parser.attributeValue(attachmentElement, "zdroj");
            if (filename == null || filename.endsWith("DCM") || filename.endsWith("dcm")) continue;
            OntClass rFileType = NFO.FILE_DATA_OBJECT;
            Resource rFile = this.rdf().mreResource(filename.toLowerCase() + this.getHashAlgorithm() + this.getFileHashValue());
            this.rdf().triple(resource, (Property)DS.ATTACHMENT, rFile);
            this.rdf().triple(rFile, RDF.type, (Resource)rFileType);
            this.rdf().triple(rFile, this.getPropertyFilename(), filename);
            this.rdf().update(rFile, DC_11.title, (Object)filename);
        }
    }

    private void createLaboratoryExamination(Resource resource) {
        String title = "Laboratory Report";
        if (!this.parser.exist("/dasta/is/ip/v")) {
            return;
        }
        List vrList = this.parser.nodes("/dasta/is/ip/v/vr");
        for (Element node : vrList) {
            if (node == null) continue;
            String vKlicNclp = this.parser.attributeValue(node, "klic_nclp");
            Resource rNCLPPOL = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "NCLPPOL", "_", vKlicNclp, false, false);
            String vDatDu = this.parser.elementValue((Content)node, "dat_du");
            Date dDatDu = DateUtil.stringToDate((String)"yyyy-MM-dd", (String)vDatDu);
            String vTypCispol = this.parser.attributeValue(node, "typ_cispol");
            String vStavVys = this.parser.attributeValue(node, "stav_vys");
            Resource rLVSVN = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "LVSVN", "_", vStavVys, false, false);
            String vIdLoIs = this.parser.attributeValue(node, "id_lo_is");
            String id = resource.toString() + vIdLoIs + vKlicNclp + vDatDu;
            Resource rLabExam = this.rdf().mreResource(id);
            this.rdf().triple(rLabExam, RDF.type, (Resource)DS.LABORATORY_REPORT);
            this.rdf().triple(rLabExam, (Property)DS.LAB_ITEM_KEY, rNCLPPOL);
            this.rdf().triple(rLabExam, (Property)DS.DATETIME_EVENT, dDatDu, (RDFDatatype)XSDDatatype.XSDdateTime);
            this.rdf().triple(rLabExam, (Property)DS.LAB_ITEM_LOCAL_OR_NATIONAL_FLAG, vTypCispol);
            this.rdf().triple(rLabExam, (Property)DS.LAB_RESULT_STATE, rLVSVN);
            this.rdf().triple(rLabExam, (Property)DS.LAB_BLOCK_ID, vIdLoIs);
            this.rdf().triple(this.rDASTA, (Property)DS.CLINICAL_EVENT, rLabExam);
            this.rdf().triple(resource, (Property)DS.CLINICAL_EVENT, rLabExam);
            String vTypSdelVys = this.parser.attributeValue(node, "typ_sdel_vys");
            if (!vTypSdelVys.isEmpty()) {
                Resource rLVTSVN = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "LVTSVN", "_", vTypSdelVys, false, false);
                this.rdf().triple(rLabExam, (Property)DS.LAB_RESULT_TYPE, rLVTSVN);
            }
            String vIndOpravSd = this.parser.attributeValue(node, "ind_oprav_sd");
            Resource rLVIOSN = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "LVIOSN", "_", vIndOpravSd, false, false);
            this.rdf().triple(rLabExam, (Property)DS.LAB_CORRECTION_FLAG, rLVIOSN);
            String vTyppolFh = this.parser.attributeValue(node, "typpol_fh");
            Resource rNCLPFH = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "NCLPFH", "_", vTyppolFh, false, false);
            this.rdf().triple(rLabExam, (Property)DS.LAB_VALUE_FORMAT_TYPE, rNCLPFH);
            String value = this.parser.attributeValue(node, "urg_info");
            if (!value.isEmpty()) {
                Resource rLVUIN = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "LVUIN", "_", value, false, false);
                this.rdf().triple(rLabExam, (Property)DS.LAB_FINDING_URGENT_FLAG, rLVUIN);
            }
            if (!(value = this.parser.attributeValue(node, "urg_zprac")).isEmpty()) {
                Resource rLVUZN = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "LVUZN", "_", value, false, false);
                this.rdf().triple(rLabExam, (Property)DS.LAB_URGENT_PROCESSING_FLAG, rLVUZN);
            }
            if (!(value = this.parser.attributeValue(node, "ind_vazb_fv")).isEmpty()) {
                Resource rLVIVFVN = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "LVIVFVN", "_", value, false, false);
                this.rdf().triple(rLabExam, (Property)DS.LAB_RELATIONSHIP_FUNCTIONAL_EXAMINATION, rLVIVFVN);
            }
            if (!(value = this.parser.attributeValue(node, "kolize")).isEmpty()) {
                Resource rNCLPMTV = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "NCLPMTV", "_", value, false, false);
                this.rdf().triple(rLabExam, (Property)DS.LAB_COLLISION_TYPE, rNCLPMTV);
            }
            if (!(value = this.parser.elementValue((Content)node, "nazev_lclp")).isEmpty()) {
                this.rdf().triple(rLabExam, (Property)DS.LAB_LOCAL_NAME, value);
                title = value;
            }
            if (!(value = this.parser.elementValue((Content)node, "duverne")).isEmpty()) {
                if (value.equals("A")) {
                    this.rdf().triple(rLabExam, (Property)DS.LAB_CONFIDENTAL, Boolean.TRUE);
                } else {
                    this.rdf().triple(rLabExam, (Property)DS.LAB_CONFIDENTAL, Boolean.FALSE);
                }
            }
            if (!(value = this.parser.elementValue((Content)node, "pp")).isEmpty()) {
                this.rdf().add(rLabExam, (Property)DS.LAB_TEXT_FOR_PATIENT, value);
            }
            String titleByType = "";
            if (this.parser.exist((Content)node, "vrn")) {
                titleByType = this.addLaboratoryVRN_NumericValue(rLabExam, this.parser.getNode(node, "vrn"));
            } else if (this.parser.exist((Content)node, "vrx")) {
                titleByType = this.addLaboratoryVRX_UnformalizedTextValue(rLabExam, this.parser.getNode(node, "vrx"));
            } else if (this.parser.exist((Content)node, "vrb")) {
                titleByType = this.addLaboratoryVRB_TextBlock(rLabExam, this.parser.getNode(node, "vrb"));
            } else if (this.parser.exist((Content)node, "vrf")) {
                titleByType = this.addLaboratoryVRF_FormalizedTextValues(rLabExam, this.parser.getNode(node, "vrf"));
            } else if (this.parser.exist((Content)node, "vrs")) {
                titleByType = this.addLaboratoryVRS_StructuredFormalizedTextValue(rLabExam, this.parser.getNode(node, "vrs"));
            } else if (this.parser.exist((Content)node, "vrr")) {
                titleByType = this.addVRRLaboratoryExamination(rLabExam, this.parser.getNode(node, "vrr"));
            } else if (this.parser.exist((Content)node, "vrp")) {
                titleByType = this.addVRPLaboratoryExamination(rLabExam, this.parser.getNode(node, "vrp"));
            } else if (this.parser.exist((Content)node, "vrd")) {
                titleByType = this.addVRDLaboratoryExamination(rLabExam, this.parser.getNode(node, "vrd"));
            } else if (this.parser.exist((Content)node, "vrk")) {
                titleByType = this.addVRKLaboratoryExamination(rLabExam, this.parser.getNode(node, "vrk"));
            } else if (this.parser.exist((Content)node, "vro")) {
                titleByType = this.addVROLaboratoryExamination(rLabExam, this.parser.getNode(node, "vro"));
            } else if (this.parser.exist((Content)node, "vrz")) {
                titleByType = this.addVRZLaboratoryExamination(rLabExam, this.parser.getNode(node, "vrz"));
            }
            this.rdf().update(rLabExam, DC_11.title, (Object)(vDatDu + ": " + title + " " + titleByType));
        }
    }

    private String addLaboratoryVRN_NumericValue(Resource resource, Element vrn) {
        String vPriznakKvant = this.parser.attributeValue(vrn, "priznak_kvant");
        Resource rLVPHKN = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "LVPHKN", "_", vPriznakKvant, false, false);
        this.rdf().triple(resource, (Property)DS.LAB_NUMBER_QUANTITY_FLAG, rLVPHKN);
        Element nNazvy = this.parser.getNode(vrn, "nazvy");
        String vJednotka = this.addNamesElement(resource, nNazvy);
        String vHodnota = this.parser.elementValue((Content)vrn, "hodnota");
        this.rdf().add(resource, (Property)DS.LAB_NUMBER_VALUE, vHodnota);
        String numericTitle = vHodnota + " " + vJednotka;
        Element nSkala = this.parser.getNode(vrn, "skala");
        if (nSkala != null) {
            String value = this.parser.attributeValue(nSkala, "typ");
            if (!value.isEmpty()) {
                Resource rLVVIST = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "LVVIST", "_", value, false, false);
                this.rdf().triple(resource, (Property)DS.LAB_SCALE_TYPE, rLVVIST);
            }
            if (!(value = this.parser.attributeValue(nSkala, "algoritmus")).isEmpty()) {
                Resource rNCLPAVIS = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "NCLPAVIS", "_", value, false, false);
                this.rdf().triple(resource, (Property)DS.LAB_ALGORITHM, rNCLPAVIS);
            }
            if (!(value = this.parser.attributeValue(nSkala, "atribut")).isEmpty()) {
                Resource rLVVISA = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "LVVISA", "_", value, false, false);
                this.rdf().triple(resource, (Property)DS.LAB_SCALE_ATTRIBUTE, rLVVISA);
            }
            if (!(value = this.parser.elementValue((Content)nSkala, "s1")).isEmpty()) {
                this.rdf().add(resource, (Property)DS.LAB_SCALE1, value);
            }
            if (!(value = this.parser.elementValue((Content)nSkala, "s2")).isEmpty()) {
                this.rdf().add(resource, (Property)DS.LAB_SCALE2, value);
            }
            if (!(value = this.parser.elementValue((Content)nSkala, "s3")).isEmpty()) {
                this.rdf().add(resource, (Property)DS.LAB_SCALE3, value);
            }
            value = this.parser.elementValue((Content)nSkala, "s4");
            this.rdf().add(resource, (Property)DS.LAB_SCALE4, value);
            value = this.parser.elementValue((Content)nSkala, "s5");
            this.rdf().add(resource, (Property)DS.LAB_SCALE5, value);
            value = this.parser.elementValue((Content)nSkala, "s6");
            if (!value.isEmpty()) {
                this.rdf().add(resource, (Property)DS.LAB_SCALE6, value);
            }
            if (!(value = this.parser.elementValue((Content)nSkala, "s7")).isEmpty()) {
                this.rdf().add(resource, (Property)DS.LAB_SCALE7, value);
            }
            if (!(value = this.parser.elementValue((Content)nSkala, "s8")).isEmpty()) {
                this.rdf().add(resource, (Property)DS.LAB_SCALE8, value);
            }
        }
        return numericTitle;
    }

    public final String addNamesElement(Resource resource, Element node) {
        String vProcedura;
        String vJednotka;
        String vDruhVeliciny;
        String vKomponenta;
        String vMaterial;
        String vSystem = this.parser.attributeValue(node, "system");
        if (!vSystem.isEmpty()) {
            Resource rNCLPSYST = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "NCLPSYST", "_", vSystem, false, false);
            this.rdf().triple(resource, (Property)DS.LAB_SYSTEM, rNCLPSYST);
        }
        if (!(vMaterial = this.parser.attributeValue(node, "material")).isEmpty()) {
            Resource rNCLPMAT = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "NCLPMAT", "_", vMaterial, false, false);
            this.rdf().triple(resource, (Property)DS.LAB_MATERIAL, rNCLPMAT);
        }
        if (!(vKomponenta = this.parser.attributeValue(node, "komponenta")).isEmpty()) {
            Resource rNCLPKOMP = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "NCLPKOMP", "_", vKomponenta, false, false);
            this.rdf().triple(resource, (Property)DS.LAB_COMPONENT, rNCLPKOMP);
        }
        if (!(vDruhVeliciny = this.parser.attributeValue(node, "druh_veliciny")).isEmpty()) {
            Resource rNCLPDRVL = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "NCLPDRVL", "_", vDruhVeliciny, false, false);
            this.rdf().triple(resource, (Property)DS.LAB_VALUE_KIND, rNCLPDRVL);
        }
        if (!(vJednotka = this.parser.attributeValue(node, "jednotka")).isEmpty()) {
            this.rdf().add(resource, (Property)DS.LAB_VALUE_UNIT, vJednotka);
        }
        if (!(vProcedura = this.parser.attributeValue(node, "procedura")).isEmpty()) {
            Resource rNCLPPROC = this.rdf().resource("https://mre.zcu.cz/ontology/dscl.owl#", "NCLPPROC", "_", vProcedura, false, false);
            this.rdf().triple(resource, (Property)DS.LAB_PROCEDURE, rNCLPPROC);
        }
        return vJednotka;
    }

    private Resource createPatientAddress() {
        Object title = "";
        String vDop = this.parser.elementValue("/dasta/is/ip/a/dop1");
        String vMesto = this.parser.elementValue("/dasta/is/ip/a/mesto");
        String vPsc = this.parser.elementValue("/dasta/is/ip/a/psc");
        if (vMesto == null && vPsc == null) {
            return null;
        }
        Resource r = this.rdf().mreResource(vPsc + vMesto);
        this.rdf().triple(r, RDF.type, (Resource)DS.PERMANENT_ADDRESS);
        if (vDop != null && !vDop.isEmpty()) {
            this.rdf().update(r, (Property)DS.ADDRESS_CITY_PART, (Object)vDop);
        }
        if (vMesto != null && !vMesto.isEmpty()) {
            this.rdf().update(r, (Property)DS.ADDRESS_CITY, (Object)vMesto);
            title = (String)title + vMesto;
        }
        if (vPsc != null && !vPsc.isEmpty()) {
            this.rdf().update(r, (Property)DS.ADDRESS_ZIP, (Object)vPsc);
            title = (String)title + " (" + vPsc + ")";
        }
        if (!((String)title).isEmpty()) {
            this.rdf().update(r, DC_11.title, title);
        }
        return r;
    }

    private Resource createHeight() {
        return null;
    }

    private Resource createWeight() {
        return null;
    }

    private Resource createUrgentData() {
        return null;
    }

    private String addLaboratoryVRF_FormalizedTextValues(Resource resource, Element node) {
        LOG.warn("VRF not supported yet.");
        return "VRF not supported yet.";
    }

    private String addLaboratoryVRS_StructuredFormalizedTextValue(Resource resource, Element vrs) {
        LOG.warn("VRS not supported yet.");
        return "VRS not supported yet.";
    }

    private String addLaboratoryVRX_UnformalizedTextValue(Resource resource, Element vrx) {
        String vHodnota = this.parser.elementValue((Content)vrx, "hodnota_nt");
        this.rdf().add(resource, (Property)DS.LAB_VALUE_UNFORMALISED_SHORT_TEXT, vHodnota);
        return vHodnota;
    }

    private String addVRRLaboratoryExamination(Resource resource, Element vrr) {
        LOG.warn("VRR not supported yet.");
        return "VRR not supported yet.";
    }

    private String addLaboratoryVRB_TextBlock(Resource resource, Element vrb) {
        String vText = this.parser.elementValue((Content)vrb, "text");
        this.rdf().add(resource, (Property)DS.LAB_VALUE_TEXT_BLOCK, vText);
        return vText;
    }

    private String addVRPLaboratoryExamination(Resource resource, Element vrp) {
        return "Empty laboratory examination.";
    }

    private String addVRDLaboratoryExamination(Resource resource, Element vrd) {
        String vDate = this.parser.elementValue((Content)vrd, "dat_dv");
        this.rdf().add(resource, (Property)DS.LAB_RESULT_ON_DATE, vDate);
        return "Result will be on " + vDate;
    }

    private String addVRKLaboratoryExamination(Resource resource, Element vrk) {
        LOG.warn("VRK not supported yet.");
        return "VRK not supported yet.";
    }

    private String addVROLaboratoryExamination(Resource resource, Element vro) {
        LOG.warn("VRO not supported yet.");
        return "VRO not supported yet.";
    }

    private String addVRZLaboratoryExamination(Resource resource, Element vrz) {
        String vText = this.parser.elementValue((Content)vrz, "text");
        this.rdf().add(resource, (Property)DS.LAB_VALUE_TEXT_BLOCK, vText);
        return vText;
    }

    public XMLParser getParser() {
        return this.parser;
    }

    public Resource getDastaResource() {
        return this.rDASTA;
    }

    public void setDastaResource(Resource resource) {
        this.rDASTA = resource;
    }
}

