/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.metamed.extractor.stroke;

import cz.zcu.mre.metamed.extractor.AbstractExtractor;
import cz.zcu.mre.metamed.extractor.stroke.StrokeEncapsulatedInDASTAExtractor;
import cz.zcu.mre.metamed.extractor.stroke.XMLElementMedicalc;
import cz.zcu.mre.mrelib.PrefixMap;
import cz.zcu.mre.mrelib.data.XMLParser;
import cz.zcu.mre.mrelib.util.DateUtil;
import cz.zcu.mre.mrelib.util.RDFUtil;
import cz.zcu.mre.vocab.FORM;
import cz.zcu.mre.vocab.NIE;
import cz.zcu.mre.vocab.STROKE;
import java.io.File;
import java.io.FilenameFilter;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.DC_11;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.XSD;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrokeExtractor
extends AbstractExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(StrokeExtractor.class);
    static final Set<String> IGNORED_ATTRIBUTES = new HashSet<String>(Arrays.asList("datum_prov", "klinudal_id", "kod_typu", "kod_spec", "pacient_id", "stav_provedeni", "stav_exportu", "stav_dokumentace", "prov_prac_id", "prov_uzv_id", "ambpece_id", "hospsta_id", "modul_id", "poz_intext", "poz_prac_id", "poz_uzv_id", "poz_extzar_id", "doklad_id", "datum_kon", "datum_poz", "zacatek_poz", "konec_poz", "datum_obj", "konec_obj", "poradi_obj", "xplatce_id", "prov_extzar_id", "super_klinudal_id", "ext_klinudal_id", "terapie", "pristkx_id", "images", "datum_cek", "faktura_id", "nazev_udalosti", "klinudal_uid", "stav_fakturace", "podpis", "ikt_jednot_pocet_dni", "pacient_zemrel", "zaraz_pozn", "zaver"));
    protected static final String MEDICALC_EMPTY_TEXT = "TESTOVAC\u00cd REPORT";
    private static final int DATE_LENGTH = 10;
    private static final String PATIENT_ID_LENGTH = "%1$10s";
    private static final String TIMEPOINT_PREFIX = "t_";
    private static final Map<String, XMLElementMedicalc> MEDICALC_XML_ELEMENTS = new HashMap<String, XMLElementMedicalc>();
    private static final Map<OntResource, Map<String, Individual>> VOCABULARIES_MAP = new HashMap<OntResource, Map<String, Individual>>();
    private final XMLParser parser = new XMLParser();
    private OntModel ontology = null;
    private String patientID;
    private LocalDate patientBirthDate;
    private LocalDate patientDeathDate;
    private String patientSex;
    private Integer patientAge = null;
    private String patientAddressCity = null;
    private String patientAddressZIP = null;
    private String strokeId = null;
    private String strokeSITSId = null;
    private LocalDate strokeDate = null;
    private String strokeConclusion = null;
    private String stringDatumTromZahajeni = null;
    private String stringDatumTromKonec = null;
    private Resource resourcePatientDasta;
    private Resource resourcePatientStroke;
    private Resource resourceStroke;

    public StrokeExtractor() {
        this.setExtractorName(StrokeExtractor.class.getName());
        this.setFileType("medicalcxml");
    }

    public StrokeExtractor(Model model) {
        super(model);
    }

    public final void initialize() {
        this.ontology = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        this.ontology.read("https://mre.zcu.cz/ontology/stroke.owl#");
        this.initializeSupportedMedicalcElementsMap(this.ontology);
        this.initializeVocabularies(this.ontology);
    }

    private void initializeSupportedMedicalcElementsMap(OntModel model) {
        ExtendedIterator supportedMedicalcElements = model.listIndividuals((Resource)STROKE.XMLELEMENT_MEDICALC);
        while (supportedMedicalcElements.hasNext()) {
            Individual individual = (Individual)supportedMedicalcElements.next();
            String xmlElement = individual.getPropertyValue((Property)STROKE.MAPPED_FROM_MEDICALC_ELEMENT).asLiteral().getString();
            XMLElementMedicalc xmlElementMedicalc = new XMLElementMedicalc(xmlElement, individual);
            MEDICALC_XML_ELEMENTS.put(xmlElement, xmlElementMedicalc);
        }
    }

    private void initializeVocabularies(OntModel model) {
        ExtendedIterator vocabularyClassesIterator = model.listClasses().filterKeep(ontClass -> {
            LOG.debug("Found class {}", ontClass);
            return ontClass.getLocalName().endsWith("Vocab");
        });
        while (vocabularyClassesIterator.hasNext()) {
            OntClass ontClass2 = (OntClass)vocabularyClassesIterator.next();
            ExtendedIterator vocabularyItemIterator = model.listIndividuals((Resource)ontClass2);
            while (vocabularyItemIterator.hasNext()) {
                String code;
                Map<Object, Object> items;
                Individual item = (Individual)vocabularyItemIterator.next();
                LOG.debug("Found class {} item {}", (Object)ontClass2, (Object)item);
                if (!ontClass2.getLocalName().endsWith("Vocab")) continue;
                if (VOCABULARIES_MAP.containsKey(ontClass2)) {
                    items = VOCABULARIES_MAP.get(ontClass2);
                } else {
                    items = new HashMap();
                    VOCABULARIES_MAP.put((OntResource)ontClass2, items);
                }
                if (item.getPropertyValue((Property)FORM.CODE) != null) {
                    code = item.getPropertyValue((Property)FORM.CODE).asLiteral().getString();
                    if (code != null && !code.isEmpty()) {
                        items.put(code, item);
                    } else {
                        LOG.warn("Vocabulary {} item {} has missing {}", new Object[]{ontClass2, item, FORM.CODE});
                    }
                }
                if (item.getPropertyValue((Property)FORM.VOCABULARY_ITEM_ID) == null) continue;
                code = item.getPropertyValue((Property)FORM.VOCABULARY_ITEM_ID).asLiteral().getString();
                if (code != null && !code.isEmpty()) {
                    items.put(code, item);
                    continue;
                }
                LOG.warn("Vocabulary {} item {} has missing {}", new Object[]{ontClass2, item, FORM.VOCABULARY_ITEM_ID});
            }
        }
    }

    public final void read(File file) {
        String recipientDepartment = null;
        this.patientID = null;
        this.patientBirthDate = null;
        this.patientDeathDate = null;
        this.patientSex = null;
        this.patientAge = null;
        this.patientAddressCity = null;
        this.patientAddressZIP = null;
        this.strokeDate = null;
        this.strokeConclusion = null;
        this.strokeId = null;
        this.strokeSITSId = null;
        this.resourcePatientDasta = null;
        this.resourcePatientStroke = null;
        this.stringDatumTromZahajeni = null;
        this.stringDatumTromKonec = null;
        this.parser.parseXML(file);
        this.extractFileMetaData(file);
        File dastaFile = this.getDastaFile(file);
        if (dastaFile != null) {
            StrokeEncapsulatedInDASTAExtractor strokeDasta = new StrokeEncapsulatedInDASTAExtractor(this.rdf().getModel());
            strokeDasta.initialize();
            strokeDasta.setDataSourceLabel(this.getDataSourceLabelValue());
            strokeDasta.read(dastaFile);
            this.resourcePatientDasta = strokeDasta.getResourcePatient();
            this.patientID = strokeDasta.getPatientID();
            this.patientBirthDate = strokeDasta.getPatientBirthDate();
            this.patientDeathDate = strokeDasta.getPatientDeathDate();
            this.patientSex = strokeDasta.getPatientSex();
            this.patientAddressCity = strokeDasta.getPatientAddressCity();
            this.patientAddressZIP = strokeDasta.getPatientAddressZIP();
            recipientDepartment = strokeDasta.getRecipientDeptartment();
        }
        LOG.debug("Parsed DASTA value - Patient: {}", (Object)this.resourcePatientDasta);
        LOG.debug("Parsed DASTA value --- patientID: {}", (Object)this.patientID);
        LOG.debug("Parsed DASTA value --- date of birth: {}", (Object)this.patientBirthDate);
        LOG.debug("Parsed DASTA value --- date of death: {}", (Object)this.patientDeathDate);
        LOG.debug("Parsed DASTA value --- sex: {}", (Object)this.patientSex);
        LOG.debug("Parsed DASTA value --- address - city: {}", (Object)this.patientAddressCity);
        LOG.debug("Parsed DASTA value --- address - zip: {}", (Object)this.patientAddressZIP);
        LOG.debug("Parsed DASTA value --- recipient department: {}", recipientDepartment);
        if (this.patientID == null) {
            LOG.warn("StrokeExtractor requires DASTA attribute '/dasta/is/ip@id_pac'. File {} omitted.", (Object)file.getAbsolutePath());
            return;
        }
        String zarazPozn = this.parser.elementValue("/data/zaraz_pozn");
        if (zarazPozn != null) {
            zarazPozn = zarazPozn.replaceAll(" ", "");
            String p = "[A-Z]{5}\\d{10}";
            Pattern pattern = Pattern.compile(p);
            Matcher matcher = pattern.matcher(zarazPozn);
            if (matcher.find()) {
                this.strokeSITSId = matcher.group();
            }
        }
        LOG.debug("Parsed MedicalcXML value - SITS Treatment ID: {}", (Object)this.strokeSITSId);
        String eventDate = this.parser.elementValue("/data/datum_vzniku");
        if (StringUtils.isEmpty((CharSequence)eventDate)) {
            eventDate = this.parser.elementValue("/data/datum_prov");
            if (StringUtils.isEmpty((CharSequence)eventDate)) {
                LOG.warn("StrokeExtractor missing attribute 'datum_vzniku' and 'datum_prov'. File {} omitted.", (Object)file.getAbsolutePath());
                return;
            }
            LOG.warn("StrokeExtractor use attribute 'datum_prov' instead of 'datum_vzniku' in {}", (Object)file.getAbsolutePath());
        }
        eventDate = eventDate.substring(0, 10);
        this.strokeDate = LocalDate.parse(eventDate);
        LOG.debug("Parsed MedicalcXML value - stroke date: {}", (Object)this.strokeDate);
        this.patientAge = this.patientBirthDate != null && this.strokeDate != null ? Integer.valueOf(Long.valueOf(ChronoUnit.YEARS.between(this.patientBirthDate, this.strokeDate)).intValue()) : null;
        LOG.debug("Stroke - patient age (computed): {}", (Object)this.patientAge);
        this.strokeId = "MRE-CZUHP-" + String.format(PATIENT_ID_LENGTH, this.patientID).replaceAll(" ", "0") + "-" + eventDate.replaceAll("-", "");
        LOG.debug("Stroke - MRE Stroke ID: {}", (Object)this.strokeId);
        this.resourceStroke = this.rdf().mreResource(this.strokeId);
        LOG.debug("Stroke - StrokeReport resource: {}", (Object)this.resourceStroke);
        this.strokeConclusion = this.parser.elementValue("/data/zaver");
        if (this.strokeConclusion != null) {
            this.strokeConclusion = this.strokeConclusion.replaceAll("!", "").replaceAll(MEDICALC_EMPTY_TEXT, "").trim();
        }
        this.stringDatumTromZahajeni = this.parser.elementValue("/data/trom_dathod_zahajeni");
        this.stringDatumTromKonec = this.parser.elementValue("/data/trom_dathod_konce");
        this.rdf().triple(this.resourceStroke, RDF.type, (Resource)STROKE.STROKE_REPORT);
        this.rdf().update(this.resourceStroke, (Property)NIE.CONTENT_LAST_MODIFIED, (Object)this.getFileLastModified());
        this.addFileMetaData(this.resourceStroke);
        this.rdf().triple(this.getResourceDataset(), this.getPropertyMREHasData(), this.resourceStroke);
        this.resourcePatientStroke = ResourceFactory.createResource((String)("https://mre.zcu.cz/id/stroke-" + String.format(PATIENT_ID_LENGTH, this.patientID).replaceAll(" ", "0") + "-" + this.strokeDate.toString().replace("-", "") + "-Patient-baseline"));
        this.rdf().triple(this.resourcePatientStroke, RDF.type, (Resource)STROKE.PATIENT);
        this.rdf().triple(this.resourcePatientStroke, (Property)STROKE.IN_TIMEPOINT, (Resource)STROKE.T_BASELINE);
        LOG.debug("Stroke - StrokeReport resource: {}", (Object)this.resourcePatientStroke);
        this.rdf().update(this.resourceStroke, (Property)STROKE.HAS_PATIENT, (Object)this.resourcePatientStroke);
        if (this.patientID != null) {
            this.rdf().update(this.resourcePatientStroke, (Property)STROKE.PATIENT_ID, (Object)this.patientID);
        }
        if (this.patientBirthDate != null) {
            this.rdf().update(this.resourcePatientStroke, (Property)STROKE.BIRTH_DATE, (Object)this.patientBirthDate);
        }
        if (this.patientDeathDate != null) {
            this.rdf().update(this.resourcePatientStroke, (Property)STROKE.DEATH_DATE, (Object)this.patientDeathDate);
        }
        if (this.patientSex != null && !this.patientSex.isEmpty()) {
            this.rdf().update(this.resourcePatientStroke, (Property)STROKE.SEX, (Object)this.patientSex);
        }
        if (this.patientAge != null) {
            this.rdf().update(this.resourcePatientStroke, (Property)STROKE.AGE, (Object)this.patientAge);
        }
        if (this.strokeDate != null) {
            this.rdf().update(this.resourcePatientStroke, (Property)STROKE.STROKE_DATE, (Object)this.strokeDate);
        }
        if (this.strokeConclusion != null && !this.strokeConclusion.isEmpty()) {
            this.rdf().update(this.resourcePatientStroke, (Property)STROKE.CONCLUSION, (Object)this.strokeConclusion);
        }
        if (this.patientAddressCity != null && !this.patientAddressCity.isEmpty()) {
            this.rdf().update(this.resourcePatientStroke, (Property)STROKE.ADDRESS_CITY, (Object)this.patientAddressCity);
        }
        if (this.patientAddressZIP != null && !this.patientAddressZIP.isEmpty()) {
            this.rdf().update(this.resourcePatientStroke, (Property)STROKE.ADDRESS_ZIP, (Object)this.patientAddressZIP);
        }
        this.rdf().update(this.resourceStroke, (Property)STROKE.ID, (Object)this.strokeId);
        if (this.strokeSITSId == null || this.strokeSITSId.isEmpty()) {
            this.rdf().update(this.resourceStroke, DC_11.title, (Object)this.strokeId);
            this.rdf().update(this.resourcePatientStroke, DC_11.title, (Object)this.strokeId);
        } else {
            this.rdf().update(this.resourceStroke, (Property)STROKE.ID_SITS, (Object)this.strokeSITSId);
            String title = this.strokeId.concat(" (").concat(this.strokeSITSId).concat(")");
            this.rdf().update(this.resourceStroke, DC_11.title, (Object)title);
            this.rdf().update(this.resourcePatientStroke, DC_11.title, (Object)title);
        }
        if (this.resourcePatientDasta != null) {
            this.rdf().triple(this.resourceStroke, (Property)STROKE.BELONGS_TO_PATIENT, this.resourcePatientDasta);
        }
        List elements = this.parser.nodes("/data/*");
        elements.stream().filter(element -> element != null && !IGNORED_ATTRIBUTES.contains(element.getName()) && element.getValue() != null && !element.getValue().isEmpty()).forEach(element -> this.parseElement((Element)element));
    }

    private void parseElement(Element element) {
        String incorrectDate;
        if (element == null) {
            LOG.error("Cannot parse a null element.");
            return;
        }
        String elementName = element.getName();
        if (!MEDICALC_XML_ELEMENTS.containsKey(elementName)) {
            LOG.warn("Element {} is not mapped to any property of Stroke Ontology (missing individual of the stroke:XMLElementMedicalc class and property stroke:mappedFromMedicalcElement with value '{}')", (Object)elementName, (Object)elementName);
            return;
        }
        XMLElementMedicalc xmlElementMedicalc = MEDICALC_XML_ELEMENTS.get(elementName);
        if (xmlElementMedicalc == null || xmlElementMedicalc.getProperty() == null || xmlElementMedicalc.getProperty().getURI() == null || this.ontology.getOntProperty(xmlElementMedicalc.getProperty().getURI()) == null) {
            LOG.info("Element {} is mapped but the required property '{}' is missing in the Stroke Ontology", (Object)elementName, (Object)(xmlElementMedicalc != null && xmlElementMedicalc.getProperty() != null ? xmlElementMedicalc.getProperty().getURI() : "null"));
            return;
        }
        OntResource domain = this.ontology.getOntProperty(xmlElementMedicalc.getProperty().getURI()).getDomain();
        OntResource range = this.ontology.getOntProperty(xmlElementMedicalc.getProperty().getURI()).getRange();
        Property hasInstance = ResourceFactory.createProperty((String)("https://mre.zcu.cz/ontology/stroke.owl#has" + domain.getLocalName()));
        Resource timepoint = xmlElementMedicalc.getTimepoint();
        String instanceSubject = "https://mre.zcu.cz/id/stroke-" + String.format(PATIENT_ID_LENGTH, this.patientID).replaceAll(" ", "0") + "-" + this.strokeDate.toString().replace("-", "") + "-" + domain.getLocalName() + "-" + timepoint.getLocalName().replace(TIMEPOINT_PREFIX, "");
        Resource property = xmlElementMedicalc.getProperty();
        String value = element.getValue();
        if (value.equals(incorrectDate = "1899-12-30")) {
            LOG.debug("Incorrect date detected: '" + value + "' (with missing time) for " + property.getLocalName() + " -- ignored.");
            value = null;
        } else if (value.startsWith(incorrectDate)) {
            LOG.debug("Incorrect date detected: '" + value + "' for " + property.getLocalName());
            Date dateTromZahajeni = null;
            if (this.stringDatumTromZahajeni != null) {
                if (this.stringDatumTromZahajeni.length() == 10) {
                    LOG.debug("Missing time " + this.stringDatumTromZahajeni + " for " + property.getLocalName());
                    dateTromZahajeni = DateUtil.stringToDate((String)"yyyy-MM-dd", (String)this.stringDatumTromZahajeni);
                } else {
                    dateTromZahajeni = DateUtil.stringToDate((String)"yyyy-MM-dd'T'HH:mm:ss", (String)this.stringDatumTromZahajeni);
                }
            }
            String stringTromPrvniKontaktZahajeni = null;
            Date dateTromPrvniKontaktZahajeni = null;
            if (this.stringDatumTromZahajeni != null && this.stringDatumTromZahajeni.length() >= 10) {
                stringTromPrvniKontaktZahajeni = value.replace(incorrectDate, this.stringDatumTromZahajeni.substring(0, 10));
                dateTromPrvniKontaktZahajeni = DateUtil.stringToDate((String)"yyyy-MM-dd'T'HH:mm:ss", (String)stringTromPrvniKontaktZahajeni);
                LOG.debug("Incorrect date - option 1: Fix date by value of trom_dathod_zahajeni is " + String.valueOf(dateTromPrvniKontaktZahajeni) + " for " + property.getLocalName());
            }
            Date dateTromKonec = null;
            if (this.stringDatumTromKonec != null) {
                if (this.stringDatumTromKonec.length() == 10) {
                    LOG.debug("Missing time " + this.stringDatumTromKonec + " for " + property.getLocalName());
                    dateTromKonec = DateUtil.stringToDate((String)"yyyy-MM-dd", (String)this.stringDatumTromKonec);
                } else {
                    dateTromKonec = DateUtil.stringToDate((String)"yyyy-MM-dd'T'HH:mm:ss", (String)this.stringDatumTromKonec);
                }
            }
            String stringTromPrvniKontaktKonec = null;
            Date dateTromPrvniKontaktKonec = null;
            if (this.stringDatumTromKonec != null && this.stringDatumTromKonec.length() >= 10) {
                stringTromPrvniKontaktKonec = value.replace(incorrectDate, this.stringDatumTromKonec.substring(0, 10));
                dateTromPrvniKontaktKonec = DateUtil.stringToDate((String)"yyyy-MM-dd'T'HH:mm:ss", (String)stringTromPrvniKontaktKonec);
                LOG.debug("Incorrect date - option 2: Fix date by value of trom_dathod_konce is " + this.stringDatumTromKonec + " for " + property.getLocalName());
            }
            if (dateTromZahajeni != null && dateTromPrvniKontaktZahajeni != null && dateTromZahajeni.before(dateTromPrvniKontaktZahajeni)) {
                value = stringTromPrvniKontaktZahajeni;
                LOG.debug("Final solution of incorrect date is based on trom_dathod_zahajeni: " + String.valueOf(dateTromPrvniKontaktZahajeni) + " for " + property.getLocalName());
            } else if (dateTromKonec != null && dateTromPrvniKontaktKonec != null && dateTromKonec.after(dateTromPrvniKontaktKonec)) {
                value = stringTromPrvniKontaktKonec;
                LOG.debug("Final solution of incorrect date is based on trom_dathod_konce: " + String.valueOf(dateTromPrvniKontaktKonec) + " for " + property.getLocalName());
            }
            if (dateTromKonec != null && dateTromPrvniKontaktKonec != null && dateTromKonec.before(dateTromPrvniKontaktKonec)) {
                LOG.debug("Trombectonomy's first contact datetime is after thrombectomy end: " + String.valueOf(dateTromPrvniKontaktKonec) + ". This wrong value was accepted.");
            }
            if (dateTromZahajeni == null || dateTromKonec == null) {
                LOG.debug("Ignored incorrect date due to missing trom_dathod_zahajeni and trom_dathod_konce.");
                value = null;
            }
            LOG.debug("Incorrect date for " + property.getLocalName() + " fixed as " + value);
        }
        Object[] transformedValue = this.transformMedicalcValueToStrokeOntology(elementName, domain, range, value);
        Resource resourceInstance = ResourceFactory.createResource((String)instanceSubject);
        LOG.debug("StrokeReport --{}--> {} --{}--> {}", new Object[]{hasInstance.getLocalName(), resourceInstance, property.getLocalName(), Arrays.toString(transformedValue)});
        this.rdf().triple(this.resourceStroke, hasInstance, resourceInstance);
        this.rdf().update(resourceInstance, RDF.type, (Object)domain);
        this.rdf().update(resourceInstance, (Property)STROKE.IN_TIMEPOINT, (Object)timepoint);
        this.rdf().update(resourceInstance, DC_11.title, (Object)(domain.getLocalName() + " (" + timepoint.getLocalName().replaceFirst(TIMEPOINT_PREFIX, "") + ")"));
        Property itemProperty = ResourceFactory.createProperty((String)property.getURI());
        this.rdf().getModel().removeAll(resourceInstance, itemProperty, null);
        for (Object o : transformedValue) {
            if (o == null) continue;
            try {
                this.rdf().triple(resourceInstance, itemProperty, RDFUtil.objectToLiteral((Object)o));
            }
            catch (Exception e) {
                LOG.error(e.getMessage() + " in file " + this.getFileName());
            }
        }
    }

    private Object[] transformMedicalcValueToStrokeOntology(String elementName, OntResource domain, OntResource range, String value) {
        Object[] transformed = new Object[]{value};
        if (elementName == null || domain == null || range == null || value == null) {
            LOG.warn("Transformation of {} with value '{}' ignored due to null (value, domain or range)", (Object)elementName, (Object)value);
            return transformed;
        }
        if (range.getURI().equals(XSD.xstring.getURI())) {
            return transformed;
        }
        String transformToType = PrefixMap.get().prefix(range.getNameSpace()) + ":" + range.getLocalName();
        if (transformToType.startsWith("xsd")) {
            transformed = new Object[]{this.transformXSDDatatype(value, transformToType)};
        } else if (transformToType.endsWith("Vocab")) {
            transformed = this.transformVocab(value, range);
        } else {
            LOG.warn("Unknown required rdfs:range={} for the value '{}'", (Object)range, (Object)value);
        }
        LOG.debug("Transformed {} attribute with value '{}' to '{}' of type {}", new Object[]{elementName, value, transformed, transformToType});
        return transformed;
    }

    private Object transformXSDDatatype(String value, String transformToType) {
        Object transformed = value;
        switch (transformToType) {
            case "xsd:boolean": {
                transformed = switch (value.toLowerCase()) {
                    case "a" -> Boolean.TRUE;
                    case "n" -> Boolean.FALSE;
                    default -> Boolean.valueOf(value);
                };
                break;
            }
            case "xsd:integer": 
            case "xsd:int": {
                transformed = Integer.valueOf(value);
                break;
            }
            case "xsd:long": {
                transformed = Long.valueOf(value);
                break;
            }
            case "xsd:float": {
                transformed = Float.valueOf(value.replace(',', '.'));
                break;
            }
            case "xsd:double": {
                transformed = Double.valueOf(value);
                break;
            }
            case "xsd:date": {
                transformed = LocalDate.parse(value);
                break;
            }
            case "xsd:dateTime": {
                transformed = value;
                break;
            }
            case "xsd:time": {
                String fixedTime = value.substring(value.indexOf(84) + 1);
                transformed = fixedTime;
                break;
            }
            default: {
                LOG.warn("Not supported XSD datatype for transformation: {}", (Object)transformToType);
            }
        }
        return transformed;
    }

    private Object[] transformVocab(String value, OntResource range) {
        Object[] transformed = new Object[]{value};
        Map<String, Individual> mapOfValues = VOCABULARIES_MAP.get(range);
        if (mapOfValues == null) {
            LOG.warn("Vocabulary {} is not supported. Value '{}' is not converted.", (Object)range.getLocalName(), (Object)value);
            return transformed;
        }
        if (mapOfValues.containsKey(value)) {
            transformed = new Object[]{mapOfValues.get(value)};
        } else if ("InvolvedVascularTerritorryVocab".equals(range.getLocalName())) {
            String[] multipleValues = value.split("(?<=\\G.{2})");
            transformed = new Object[multipleValues.length];
            int i = 0;
            for (String singleItemCode : multipleValues) {
                if (mapOfValues.containsKey(singleItemCode)) {
                    transformed[i++] = mapOfValues.get(singleItemCode);
                    LOG.debug("Vocabulary {} contain value for code '{}' from value of multiple items in the format of '{}' string", new Object[]{range.getLocalName(), singleItemCode, value});
                    continue;
                }
                transformed[i++] = singleItemCode;
                LOG.warn("Vocabulary {} does not contain value for code '{}' from value of multiple items in format '{}'", new Object[]{range.getLocalName(), singleItemCode, value});
            }
        } else {
            LOG.warn("Vocabulary {} does not contain value for code '{}'", (Object)range.getLocalName(), (Object)value);
        }
        return transformed;
    }

    private File getDastaFile(File file) {
        String dasta = file.getName().split("_")[0];
        File[] filesList = file.getParentFile().listFiles(new FilenameFilterImpl(dasta));
        if (filesList != null && filesList.length > 0) {
            return filesList[0];
        }
        return null;
    }

    static class FilenameFilterImpl
    implements FilenameFilter {
        private final String fileName;

        FilenameFilterImpl(String name) {
            this.fileName = name;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.matches(this.fileName.concat(".[Xx][Mm][Ll]"));
        }
    }
}

