/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.metamed.extractor.stroke;

import cz.zcu.mre.metamed.extractor.dasta.DASTAExtractor;
import cz.zcu.mre.vocab.DS;
import java.io.File;
import java.time.LocalDate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.DC_11;
import org.apache.jena.vocabulary.RDF;

public class StrokeEncapsulatedInDASTAExtractor
extends DASTAExtractor {
    private static final long serialVersionUID = 2955047312901607821L;
    private Resource resourcePatient;
    private String patientID = null;
    private LocalDate patientBirthDate;
    private LocalDate patientDeathDate;
    private String patientSex;
    private String patientAddressCity;
    private String patientAddressZIP;
    private String recipientDeptartment = null;

    public StrokeEncapsulatedInDASTAExtractor() {
        this.setExtractorName(StrokeEncapsulatedInDASTAExtractor.class.getName());
        this.setFileType("dasta_for_medicalcxml");
        this.setPriority(Integer.MIN_VALUE);
    }

    public StrokeEncapsulatedInDASTAExtractor(Model model) {
        super(model);
    }

    public final void read(File file) {
        Matcher m;
        this.extractFileMetaData(file);
        this.setDastaResource(this.rdf().mreResource(this.getFileHashValue()));
        this.rdf().triple(this.getDastaResource(), RDF.type, (Resource)DS.DASTA);
        this.rdf().update(this.getDastaResource(), DC_11.title, (Object)file.getName());
        this.addFileMetaData(this.getDastaResource());
        this.getParser().parseXML(file);
        this.patientID = this.getParser().attributeValue("/dasta/is/ip", "id_pac");
        this.patientSex = this.getParser().elementValue("/dasta/is/ip/sex");
        String value = this.getParser().elementValue("/dasta/is/ip/dat_dn");
        if (value != null && !value.isEmpty()) {
            this.patientBirthDate = LocalDate.parse(value);
        }
        if ((value = this.getParser().elementValue("/dasta/is/ip/dat_de")) != null && !value.isEmpty()) {
            this.patientDeathDate = LocalDate.parse(value);
        }
        this.patientAddressCity = this.getParser().elementValue("/dasta/is/ip/a/mesto");
        this.patientAddressZIP = this.getParser().elementValue("/dasta/is/ip/a/psc");
        this.resourcePatient = this.createPatient();
        if (this.resourcePatient != null) {
            this.rdf().triple(this.getResourceDataset(), this.getPropertyMREHasData(), this.resourcePatient);
            this.rdf().triple(this.getDastaResource(), (Property)DS.PATIENT, this.resourcePatient);
        }
        Pattern pattern = Pattern.compile("([A-Z]{2,})");
        String recipientFullName = this.getParser().elementValue("/dasta/pm/a/jmeno");
        if (recipientFullName == null || recipientFullName.isEmpty()) {
            recipientFullName = this.getParser().elementValue("/dasta/is/a/jmeno");
        }
        if ((m = pattern.matcher(recipientFullName)).find()) {
            this.recipientDeptartment = m.group();
        }
    }

    public final Resource getResourcePatient() {
        return this.resourcePatient;
    }

    public final String getPatientID() {
        return this.patientID;
    }

    public LocalDate getPatientBirthDate() {
        return this.patientBirthDate;
    }

    public LocalDate getPatientDeathDate() {
        return this.patientDeathDate;
    }

    public String getPatientSex() {
        return this.patientSex;
    }

    public String getRecipientDeptartment() {
        return this.recipientDeptartment;
    }

    public String getPatientAddressCity() {
        return this.patientAddressCity;
    }

    public String getPatientAddressZIP() {
        return this.patientAddressZIP;
    }
}

