/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.metamed.extract;

import cz.zcu.mre.metamed.MetaMed;
import cz.zcu.mre.mrelib.concurent.Reader;
import cz.zcu.mre.mrelib.data.FileTypeDeterminer;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderLoader
extends HashMap<String, List<Reader>> {
    private static final Logger LOG = LoggerFactory.getLogger(ReaderLoader.class);
    private static final long serialVersionUID = -1341218148730764583L;

    public ReaderLoader(Class clazz) {
        ServiceLoader<Reader> serviceLoader = ServiceLoader.load(clazz);
        this.findReaders(serviceLoader);
    }

    public final Reader getReader(File file) {
        String type = FileTypeDeterminer.determineType((File)file);
        return this.getReader(type);
    }

    public final Reader getReader(String fileType) {
        if (this.containsKey(fileType) && this.get(fileType) != null) {
            return (Reader)((List)this.get(fileType)).get(0);
        }
        return null;
    }

    public final List<Reader> getReaders(File file) {
        String type = FileTypeDeterminer.determineType((File)file);
        return this.getReaders(type);
    }

    public final List<Reader> getReaders(String fileType) {
        if (this.containsKey(fileType)) {
            return (List)this.get(fileType);
        }
        return null;
    }

    private synchronized void findReaders(ServiceLoader<Reader> serviceLoader) {
        try {
            for (Reader reader : serviceLoader) {
                List<Reader> readers;
                if (MetaMed.getConfig().getPriorities().containsKey(reader.getName()) && MetaMed.getConfig().getPriorities().get(reader.getClass().getName()) == Integer.MIN_VALUE || reader.getPriority() == Integer.MIN_VALUE) {
                    LOG.info("Disabled {} file type: {}", (Object)reader.getName(), (Object)reader.getFileType());
                }
                if (this.containsKey(reader.getFileType())) {
                    LOG.debug("Reader for an existing file type {}", (Object)reader.getFileType());
                    readers = (List)this.get(reader.getFileType());
                } else {
                    LOG.debug("Reader has a new file type {}", (Object)reader.getFileType());
                    readers = new ArrayList();
                    this.put(reader.getFileType(), readers);
                }
                readers.add(reader);
                LOG.info("Enabled {} file type: {} with priority: {}", new Object[]{reader.getName(), reader.getFileType(), reader.getPriority()});
            }
        }
        catch (ServiceConfigurationError serviceError) {
            LOG.error("Error during ReaderLoader initialization", (Throwable)serviceError);
        }
    }

    @Override
    public Object clone() {
        return super.clone();
    }
}

