/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.metamed.extract;

import cz.zcu.mre.metamed.extract.ExtractionWorker;
import cz.zcu.mre.mrelib.concurent.AbstractExtractorFarmer;
import cz.zcu.mre.mrelib.concurent.Worker;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractionFarmer
extends AbstractExtractorFarmer {
    private static final Logger LOG = LoggerFactory.getLogger(ExtractionFarmer.class);
    private final Queue<File> queue = new ConcurrentLinkedQueue<File>();
    private Model model = null;
    private final List<Model> threadModels = new ArrayList<Model>();
    private String dataSourceLabel = null;

    public ExtractionFarmer(int threadCount, List<File> dataFiles, Model model, String dataSourceLabel) {
        super(threadCount);
        this.queue.addAll(dataFiles);
        this.model = model;
        this.dataSourceLabel = dataSourceLabel;
    }

    public final ExtractionWorker createWorker() {
        Model workerModel;
        if (this.getThreadCount() == 1) {
            workerModel = this.model;
        } else {
            workerModel = ModelFactory.createDefaultModel();
            workerModel.setNsPrefixes(this.model.getNsPrefixMap());
        }
        this.threadModels.add(workerModel);
        ExtractionWorker worker = new ExtractionWorker(this.getWorkers().size(), this.queue, workerModel, this.dataSourceLabel);
        return worker;
    }

    public void onBeforeStartEvent(Worker worker) {
    }

    public void onAfterStartEvent(Worker worker) {
    }

    public final void onBeforeFarmerEndEvent() {
        this.getWorkers().stream().forEach(worker -> {
            try {
                ((Thread)worker).join();
            }
            catch (InterruptedException ex) {
                LOG.error(null, (Throwable)ex);
            }
        });
    }

    public final List<Model> getThreadModels() {
        return this.threadModels;
    }

    public final Model getMergedThreadModels() {
        if (this.getThreadCount() != 1) {
            this.threadModels.stream().forEach(tModel -> this.model.add(tModel.listStatements()));
        }
        return this.model;
    }

    public final void setDataSourceLabel(String label) {
        this.dataSourceLabel = label;
    }
}

