/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.metamed.extract;

import cz.zcu.mre.metamed.MetaMed;
import cz.zcu.mre.metamed.extract.ReaderLoader;
import cz.zcu.mre.mrelib.concurent.Reader;
import cz.zcu.mre.mrelib.concurent.Worker;
import cz.zcu.mre.mrelib.data.FileTypeDeterminer;
import cz.zcu.mre.mrelib.util.ConsoleProgressBar;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWorker
extends Thread
implements Worker {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWorker.class);
    private int thread = 0;
    private final Queue<File> queue;
    private ReaderLoader loader = null;
    private ConsoleProgressBar cpb;

    protected AbstractWorker(int thread, Queue<File> q) {
        this.thread = thread;
        this.queue = q;
    }

    @Override
    public void run() {
        if (this.getThread() == 0 && System.console() != null) {
            this.cpb = new ConsoleProgressBar(this.getQueue().size());
            this.cpb.start();
        }
        try {
            File file;
            while ((file = this.getQueue().poll()) != null) {
                if (this.cpb != null) {
                    this.cpb.increment();
                }
                if (!file.isFile() || !file.canRead()) continue;
                String fileType = FileTypeDeterminer.determineType((File)file);
                if (fileType == null) {
                    LOG.error("Skipping an unknown file type {}", (Object)file.getName());
                    continue;
                }
                List<Reader> readers = this.getFileTypeReaders(fileType);
                if (readers == null) {
                    LOG.debug("No file type reader available for {}", (Object)fileType);
                    continue;
                }
                for (Reader reader : readers) {
                    if (!this.isReaderEnabled(reader)) {
                        LOG.debug("Ignore disabled reader on file {}", (Object)file.getAbsolutePath());
                        continue;
                    }
                    long milliseconds0 = new Date().getTime();
                    try {
                        reader.read(file);
                    }
                    catch (Exception e) {
                        LOG.error("Reader exception: " + e.getMessage() + " in file " + file.getAbsolutePath());
                        LOG.error("Reader exception: " + e.toString() + " in file " + file.getAbsolutePath());
                    }
                    if (!MetaMed.getConfig().isVerbose()) continue;
                    long milliseconds1 = new Date().getTime();
                    LOG.info("#{}\t{}\t{}\t{} ms\t{}", new Object[]{this.thread, fileType, reader.getName(), milliseconds1 - milliseconds0, file.getAbsolutePath()});
                }
            }
        }
        catch (RuntimeException e) {
            LOG.error(null, (Throwable)e);
        }
        if (this.cpb != null) {
            this.cpb.close();
        }
    }

    protected Queue<File> getQueue() {
        return this.queue;
    }

    public int getThread() {
        return this.thread;
    }

    protected ReaderLoader getLoader() {
        return this.loader;
    }

    protected void setLoader(ReaderLoader loader) {
        this.loader = loader;
    }

    protected boolean isReaderEnabled(Reader reader) {
        return (!MetaMed.getConfig().getPriorities().containsKey(reader.getName()) || MetaMed.getConfig().getPriorities().get(reader.getName()) != Integer.MIN_VALUE) && reader.getPriority() != Integer.MIN_VALUE;
    }

    public List<Reader> getFileTypeReaders(String fileType) {
        return this.getLoader().getReaders(fileType);
    }
}

