/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.metamed;

import cz.zcu.mre.metamed.MetaMed;
import cz.zcu.mre.mrelib.util.FileUtil;
import cz.zcu.mre.mrelib.util.PropertiesUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.jena.rdf.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetaMedConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(MetaMedConfiguration.class);
    public static final int DEFAULT_THREAD_COUNT = 1;
    public static final String DEFAULT_GRAPH = MetaMed.class.getSimpleName().toLowerCase();
    public static final String CONNECTION_FILE = "connection.properties";
    private static final String DEFAULT_SOURCE_LABEL = "undefined";
    private Boolean verbose = Boolean.FALSE;
    private Boolean extract = Boolean.FALSE;
    private String graphName = null;
    private List<File> dataFiles = new ArrayList<File>();
    private File outputDirectory = null;
    private Map<String, String> queries = new HashMap<String, String>();
    private Map<String, Integer> priorities = new HashMap<String, Integer>();
    private List<String> outputFormat = new ArrayList<String>();
    private String importFormat = null;
    private List<File> importFiles = new ArrayList<File>();
    private String exportFormat = null;
    private File exportFile = null;
    private Boolean operationEmptyGraph = Boolean.FALSE;
    private Boolean useInMemoryGraph = Boolean.TRUE;
    private Boolean useFileGraph = Boolean.FALSE;
    private Boolean useVirtuosoGraph = Boolean.FALSE;
    private String offlineDirectory = null;
    private int threadCount = 1;
    private final Properties connectionProperties = new Properties();
    private boolean size = false;
    private String prefixMapOutputFile = null;
    private List<File> deleteStatementFiles = new ArrayList<File>();
    private Boolean mergeThreadGraphs = Boolean.FALSE;
    private List<Model> threadGraphs = null;
    private String dataSourceLabel = "undefined";
    private File scanContent = null;

    public String getGraphName() {
        return this.graphName;
    }

    public void setGraphName(String name) {
        this.graphName = name;
    }

    public File getExportFile() {
        return this.exportFile;
    }

    public void setExportFile(File file) {
        this.exportFile = file;
    }

    public String getExportFormat() {
        return this.exportFormat;
    }

    public void setExportFormat(String format) {
        this.exportFormat = format;
    }

    public List<File> getImportFiles() {
        return this.importFiles;
    }

    public void setImportFiles(List<File> files) {
        this.importFiles = files;
    }

    public String getImportFormat() {
        return this.importFormat;
    }

    public void setImportFormat(String format) {
        this.importFormat = format;
    }

    public List<File> getDataFiles() {
        return this.dataFiles;
    }

    public void setDataFiles(List<File> files) {
        this.dataFiles = files;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File dir) {
        this.outputDirectory = dir;
    }

    public List<String> getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(List<String> format) {
        this.outputFormat = format;
    }

    public Map<String, String> getQueries() {
        return this.queries;
    }

    public void setQueries(Map<String, String> q) {
        this.queries = q;
    }

    public Map<String, Integer> getPriorities() {
        return this.priorities;
    }

    public void setPriorities(Map<String, Integer> p) {
        this.priorities = p;
    }

    public Boolean isOperationEmptyGraph() {
        return this.operationEmptyGraph;
    }

    public void setOperationEmptyGraph(Boolean value) {
        this.operationEmptyGraph = value;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int count) {
        this.threadCount = count;
    }

    public Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    public String getOfflineDirectory() {
        return this.offlineDirectory;
    }

    public void setOfflineDirectory(String dir) {
        this.offlineDirectory = dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionProperties(File file) {
        this.connectionProperties.clear();
        if (file == null) {
            this.loadDefaultConnectionProperties();
        } else {
            FileInputStream fis = null;
            try {
                LOG.info("INFO command-line connection configuration file: {}", (Object)file);
                fis = new FileInputStream(file);
                this.connectionProperties.load(fis);
            }
            catch (IOException ex) {
                LOG.error(null, (Throwable)ex);
                this.loadDefaultConnectionProperties();
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ex) {
                        LOG.error(null, (Throwable)ex);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDefaultConnectionProperties() {
        File file = new File(FileUtil.USER_HOME_PATH + PropertiesUtil.configsRelativePath((String)CONNECTION_FILE));
        if (!file.isFile() || !file.canRead()) {
            if (this.isVerbose()) {
                LOG.error("WARN: Configuration file '{}' is missing in user's home directory.", (Object)file.getAbsolutePath());
            }
            if (FileUtil.IS_UNIX) {
                file = new File(FileUtil.UNIX_SYSTEM_LOCATION + PropertiesUtil.configsRelativePath((String)CONNECTION_FILE));
            } else if (FileUtil.IS_WINDOWS) {
                file = new File(FileUtil.WINDOWS_SYSTEM_LOCATION + PropertiesUtil.configsRelativePath((String)CONNECTION_FILE));
            }
            if (!file.isFile() || !file.canRead()) {
                LOG.error("ERROR: MetaMed''s system configuration file '{}' is missing.", (Object)file.getAbsolutePath());
                return;
            }
        }
        FileInputStream fis = null;
        try {
            if (this.isVerbose()) {
                LOG.info("INFO connection configuration file: {}", (Object)file);
            }
            fis = new FileInputStream(file);
            this.connectionProperties.load(fis);
        }
        catch (IOException ex) {
            LOG.error(null, (Throwable)ex);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    LOG.error(null, (Throwable)ex);
                }
            }
        }
        String url = null;
        if (this.connectionProperties.get("url") != null) {
            url = this.connectionProperties.get("url").toString();
        }
        if (url != null && url.contains("virtuoso")) {
            this.setUseInMemoryGraph(Boolean.FALSE);
            this.setUseFileGraph(Boolean.FALSE);
            this.setUseVirtuosoGraph(Boolean.TRUE);
        } else {
            this.setUseFileGraph(Boolean.FALSE);
            this.setUseInMemoryGraph(Boolean.TRUE);
            this.setUseVirtuosoGraph(Boolean.FALSE);
        }
    }

    public void setSize(boolean s) {
        this.size = s;
    }

    public boolean isSize() {
        return this.size;
    }

    public void setPrefixMapOutputFile(String filename) {
        this.prefixMapOutputFile = filename;
    }

    public String getPrefixMapOutputFile() {
        return this.prefixMapOutputFile;
    }

    public Boolean isUseInMemoryhGraph() {
        return this.useInMemoryGraph;
    }

    public void setUseInMemoryGraph(Boolean value) {
        this.useInMemoryGraph = value;
    }

    public Boolean isUseFileGraph() {
        return this.useFileGraph;
    }

    public void setUseFileGraph(Boolean value) {
        this.useFileGraph = value;
    }

    public Boolean isUseVirtuosoGraph() {
        return this.useVirtuosoGraph;
    }

    public void setUseVirtuosoGraph(Boolean value) {
        this.useVirtuosoGraph = value;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(Boolean value) {
        this.verbose = value;
    }

    public List<File> getDeleteStatementFiles() {
        return this.deleteStatementFiles;
    }

    public void setDeleteStatementFiles(List<File> files) {
        this.deleteStatementFiles = files;
    }

    public Boolean isMergeThreadGraphs() {
        return this.mergeThreadGraphs;
    }

    public void setMergeThreadGraphs(Boolean value) {
        this.mergeThreadGraphs = value;
    }

    public List<Model> getThreadGraphs() {
        if (this.threadGraphs == null) {
            this.threadGraphs = new ArrayList<Model>();
        }
        return this.threadGraphs;
    }

    public void setThreadGraphs(List<Model> graphs) {
        this.threadGraphs = graphs;
    }

    public String getDataSourceLabel() {
        return this.dataSourceLabel;
    }

    public void setDataSourceLabel(String label) {
        this.dataSourceLabel = label;
    }

    public File getScanContent() {
        return this.scanContent;
    }

    public void setScanContent(File scanContent) {
        this.scanContent = scanContent;
    }

    public Boolean getExtract() {
        return this.extract;
    }

    void setExtract(Boolean extract) {
        this.extract = extract;
    }
}

