/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.metamed;

import cz.zcu.mre.metamed.MetaMedConfiguration;
import cz.zcu.mre.metamed.MetaMedException;
import cz.zcu.mre.metamed.extract.ExtractionFarmer;
import cz.zcu.mre.metamed.extract.ScannerFarmer;
import cz.zcu.mre.mrelib.Const;
import cz.zcu.mre.mrelib.PrefixMap;
import cz.zcu.mre.mrelib.datasource.DataSource;
import cz.zcu.mre.mrelib.datasource.VirtuosoDS;
import cz.zcu.mre.mrelib.util.ConsoleProgressBar;
import cz.zcu.mre.mrelib.util.DeleteStatementUtil;
import cz.zcu.mre.mrelib.util.FileUtil;
import cz.zcu.mre.mrelib.util.RDFDataAccess;
import cz.zcu.mre.mrelib.util.RDFQuery;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.ontology.models.ModelMaker;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetaMed {
    private static final Logger LOG = LoggerFactory.getLogger(MetaMed.class);
    public static final Package PACKAGE = MetaMed.class.getPackage();
    private static final String USAGE = "java -Xms512m -Xmx2048m  -jar metamed-<version>.jar\n";
    private static final String HEADER = "\n---\nMetaMed v" + PACKAGE.getImplementationVersion() + "\nauthor Petr Vcelak <vcelak@kiv.zcu.cz)\nweb    https://mre.zcu.cz/metamed/\n---\n\nMetaMed is a meta data extraction tool for medical data file\nformats. It is a non-interactive command line open source\napplication. It can be also useful as a simple SPARQL query\ntool and even as a RDF serialization format converter.\n\nSupport input medical data files:\n* DASTA, DICOM, SITS\n\nRDF serialization formats support:\n * RDF/XML, RDF/XML-ABBREV, TURTLE, TTL, N3 and N-TRIPLE.\n\nSupported (query) output formats:\n * text, csv, tsv rdf, sse, json, xml and xmlstring.\n\nOptions:\n\n";
    private static final String FOOTER = "\nThis is free software; see the source for copying conditions. There is NO\nwarranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR\nPURPOSE, to the extent permitted by law.\n\n\n";
    private static final MetaMedConfiguration CONFIG = new MetaMedConfiguration();
    private static final int IMPORT_TIME_MIN_VALUE = 1000;
    private static DataSource dataSource = null;
    private static Model model;

    public static void main(String[] args) {
        try {
            MetaMed.parseCommandLine(MetaMed.options(), args);
            MetaMed.processExportPrefixes();
            MetaMed.processScanner();
            MetaMed.openPersistentModel();
            MetaMed.printModelSize();
            MetaMed.processEmpty();
            MetaMed.processImport();
            MetaMed.processExtraction();
            MetaMed.processDelete();
            MetaMed.processQueries();
            MetaMed.processExport();
            MetaMed.closePersistentModel();
        }
        catch (MetaMedException e) {
            if (e.getExit() != 0 && !StringUtils.isEmpty((CharSequence)e.getMessage())) {
                LOG.error(null, (Throwable)((Object)e));
            }
            if (e.isExit()) {
                System.exit(e.getExit());
            }
        }
        catch (RuntimeException e) {
            LOG.error("Catch runtime exception, exiting with error code.", (Throwable)e);
            System.exit(-1);
        }
        catch (Exception e) {
            LOG.error("General exception occured, exiting with error code.", (Throwable)e);
            System.exit(-1);
        }
    }

    private static Options options() {
        Options opts = new Options();
        opts.addOption("h", "help", false, "Print this message.");
        opts.addOption("v", "verbose", false, "Verbose output.");
        opts.addOption("s", "size", false, "Print graph size.");
        Option.Builder optionBuilder = Option.builder((String)"g");
        optionBuilder.longOpt("graph");
        optionBuilder.desc("Set the graph name. The graph name a mandatory option for all supported operations. (default is 'metamedGraph')");
        optionBuilder.hasArg();
        optionBuilder.argName("name");
        opts.addOption(optionBuilder.build());
        optionBuilder = Option.builder((String)"ds");
        optionBuilder.longOpt("data-source");
        optionBuilder.desc("Set the data source name.");
        optionBuilder.hasArg();
        optionBuilder.argName("code");
        opts.addOption(optionBuilder.build());
        optionBuilder = Option.builder((String)"d");
        optionBuilder.longOpt("input-data");
        optionBuilder.desc("Input data directory or file. The whole directory is process recursively.");
        optionBuilder.hasArgs();
        optionBuilder.argName("dir");
        opts.addOption(optionBuilder.build());
        optionBuilder = Option.builder((String)"list");
        optionBuilder.longOpt("file-list");
        optionBuilder.desc("List of input data files for (selective) processing in the file. Each file name  (relative or absolute) path is on one line. An input data (-d) option can append additional files for processing.");
        optionBuilder.hasArg();
        optionBuilder.argName("file");
        opts.addOption(optionBuilder.build());
        optionBuilder = Option.builder((String)"tc");
        optionBuilder.longOpt("thread-count");
        optionBuilder.desc("Number of threads used for input files meta data extraction. One thread is a default value.");
        optionBuilder.hasArg();
        optionBuilder.argName("count");
        opts.addOption(optionBuilder.build());
        optionBuilder = Option.builder((String)"p");
        optionBuilder.longOpt("priority");
        optionBuilder.desc("Extractor class priority. The syntax is extractor class name or code, colon, priority. Priority is a positive integer number. Default value is 0. It is possible to disable Extractor using priority value 'disabled'.");
        optionBuilder.hasArgs();
        optionBuilder.argName("extractor:priority");
        opts.addOption(optionBuilder.build());
        OptionGroup storageGroup = new OptionGroup();
        optionBuilder = Option.builder((String)"mem");
        optionBuilder.longOpt("graph-in-memory");
        optionBuilder.desc("Graph is in-memory only and it is destroyed when application exits. You can use -e there which will output the graph to a file  serialization (-ef) you need. It is useful e.g. for a conversion between two serialization formats. (default)");
        storageGroup.addOption(optionBuilder.build());
        optionBuilder = Option.builder((String)"fs");
        optionBuilder.longOpt("graph-file-system");
        optionBuilder.desc("Graph is in-memory only, but it is automatically backed from/to file system root directory. You have to specify a root directory for graph. Graph is always backed to the root directory. You can use -e  -ef which will duplicate output to an another serialization file format. Please be patient, the graph is written twice in this case.");
        optionBuilder.hasArg();
        optionBuilder.argName("rootdir");
        storageGroup.addOption(optionBuilder.build());
        optionBuilder = Option.builder((String)"virt");
        optionBuilder.longOpt("graph-virtuoso");
        optionBuilder.desc("Graph is in Virtuoso database. You have to specify a connection configuration property file.");
        optionBuilder.hasArg();
        optionBuilder.argName("auth");
        storageGroup.addOption(optionBuilder.build());
        opts.addOptionGroup(storageGroup);
        optionBuilder = Option.builder((String)"empty");
        optionBuilder.longOpt("empty-graph");
        optionBuilder.desc("Empty the graph.");
        opts.addOption(optionBuilder.build());
        optionBuilder = Option.builder((String)"i");
        optionBuilder.longOpt("import");
        optionBuilder.desc("Import RDF files(s) to the graph.");
        optionBuilder.hasArgs();
        optionBuilder.argName("file");
        opts.addOption(optionBuilder.build());
        optionBuilder = Option.builder((String)"if");
        optionBuilder.longOpt("import-format");
        optionBuilder.desc("Import serialization format for RDF files(s).");
        optionBuilder.hasArgs();
        optionBuilder.argName("format");
        opts.addOption(optionBuilder.build());
        optionBuilder = Option.builder((String)"e");
        optionBuilder.longOpt("export");
        optionBuilder.desc("Export the whole graph to a file.");
        optionBuilder.hasArg();
        optionBuilder.argName("file");
        opts.addOption(optionBuilder.build());
        optionBuilder = Option.builder((String)"ef");
        optionBuilder.longOpt("export-format");
        optionBuilder.desc("File serialization format for an output RDF file.");
        optionBuilder.hasArgs();
        optionBuilder.argName("format");
        opts.addOption(optionBuilder.build());
        opts.addOption("tmm", "thread-graphs-merge", false, "Enable merging graphs when more threads are used. It is automatically enabled when running queries or removing any statements. It is more efficient work out merging when you are extracting meta data.");
        optionBuilder = Option.builder((String)"r");
        optionBuilder.longOpt("remove");
        optionBuilder.desc("Remove statements from the graph. One statement per line. Subject, predicate and value are divided by a tabulator char only. Only URI out prefixes are allowed. Any content in s, p or o is possible when you use ? or $ char (before name).");
        optionBuilder.hasArgs();
        optionBuilder.argName("file");
        opts.addOption(optionBuilder.build());
        optionBuilder = Option.builder((String)"q");
        optionBuilder.longOpt("query");
        optionBuilder.desc("File or directory with files that contains a SPARQL query string. Prefixes are append automatically to each query.");
        optionBuilder.argName("file");
        optionBuilder.hasArgs();
        opts.addOption(optionBuilder.build());
        optionBuilder = Option.builder((String)"of");
        optionBuilder.longOpt("output-format");
        optionBuilder.desc("Output format - csv, json, ...");
        optionBuilder.hasArgs();
        optionBuilder.argName("fmt");
        opts.addOption(optionBuilder.build());
        optionBuilder = Option.builder((String)"o");
        optionBuilder.longOpt("output");
        optionBuilder.desc("Output directory. Query results will be stored there with an appropriate file extension based on an output format.");
        optionBuilder.hasArg();
        optionBuilder.argName("dir");
        opts.addOption(optionBuilder.build());
        optionBuilder = Option.builder((String)"pm");
        optionBuilder.longOpt("prefix-map");
        optionBuilder.desc("Export an application built-in prefix map into a text file.");
        optionBuilder.hasArg();
        optionBuilder.argName("file");
        opts.addOption(optionBuilder.build());
        optionBuilder = Option.builder((String)"scan");
        optionBuilder.longOpt("content-scanner");
        optionBuilder.hasArg();
        optionBuilder.argName("file");
        optionBuilder.desc("Extract file content.");
        opts.addOption(optionBuilder.build());
        optionBuilder = Option.builder((String)"extract");
        optionBuilder.longOpt("extract-rdf");
        optionBuilder.desc("Extract into RDF.");
        opts.addOption(optionBuilder.build());
        return opts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CommandLine parseCommandLine(Options options, String[] args) throws MetaMedException {
        File file;
        Object file2;
        CommandLine cl;
        block70: {
            cl = null;
            try {
                cl = new DefaultParser().parse(options, args);
            }
            catch (ParseException e) {
                if (cl != null) break block70;
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp(USAGE, HEADER, options, FOOTER, true);
                throw new MetaMedException("Please, use the help above. " + e.getMessage(), -1);
            }
        }
        if (cl.hasOption("h")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(USAGE, HEADER, options, FOOTER, true);
            throw new MetaMedException(0);
        }
        if (cl.hasOption("v")) {
            CONFIG.setVerbose(Boolean.TRUE);
        } else {
            CONFIG.setVerbose(Boolean.FALSE);
        }
        if (cl.hasOption("s")) {
            CONFIG.setSize(Boolean.TRUE);
        } else {
            CONFIG.setSize(Boolean.FALSE);
        }
        if (cl.hasOption("ds")) {
            CONFIG.setDataSourceLabel(cl.getOptionValue("data-source"));
        } else {
            CONFIG.setDataSourceLabel("unknown");
        }
        if (cl.hasOption("pm")) {
            CONFIG.setPrefixMapOutputFile(cl.getOptionValue("prefix-map"));
        }
        if (cl.hasOption("tc")) {
            CONFIG.setThreadCount(Integer.parseInt(cl.getOptionValue("thread-count")));
        }
        if (cl.hasOption("tmm")) {
            CONFIG.setMergeThreadGraphs(Boolean.TRUE);
        }
        if (cl.hasOption("fs")) {
            CONFIG.setOfflineDirectory(cl.getOptionValue("graph-file-system"));
            CONFIG.setUseInMemoryGraph(Boolean.FALSE);
            CONFIG.setUseFileGraph(Boolean.TRUE);
        }
        if (cl.hasOption("virt")) {
            File file22 = new File(cl.getOptionValue("graph-virtuoso"));
            if (file22.exists() && file22.isFile() && file22.canRead()) {
                CONFIG.setConnectionProperties(file22);
                CONFIG.setUseInMemoryGraph(Boolean.FALSE);
                CONFIG.setUseVirtuosoGraph(Boolean.TRUE);
            } else {
                throw new MetaMedException("Virtuoso's graph connection property file does not exist or it is not a readable file.", -1);
            }
        }
        if (!(cl.hasOption("mem") || cl.hasOption("fs") || cl.hasOption("virt"))) {
            CONFIG.setConnectionProperties(null);
        }
        if (cl.hasOption("g")) {
            CONFIG.setGraphName(cl.getOptionValue("graph"));
        } else if (CONFIG.getConnectionProperties().containsKey("graph")) {
            CONFIG.setGraphName(CONFIG.getConnectionProperties().getProperty("graph"));
        } else if (CONFIG.getConnectionProperties().containsKey("graph")) {
            CONFIG.setGraphName(CONFIG.getConnectionProperties().getProperty("graph"));
        } else {
            CONFIG.setGraphName(MetaMedConfiguration.DEFAULT_GRAPH);
        }
        if (cl.hasOption("o")) {
            file2 = new File(cl.getOptionValue("output"));
            if (((File)file2).exists() && ((File)file2).isDirectory()) {
                CONFIG.setOutputDirectory((File)file2);
            } else {
                throw new MetaMedException("Output directory does not exist or it is not a directory.", -1);
            }
        }
        if (cl.hasOption("of")) {
            CONFIG.getOutputFormat().addAll(Arrays.asList(cl.getOptionValues("output-format")));
        }
        if (cl.hasOption("q")) {
            for (String string : cl.getOptionValues("query")) {
                MetaMed.readQueryFile(string);
            }
            if (!CONFIG.getQueries().isEmpty() && !CONFIG.isMergeThreadGraphs().booleanValue()) {
                LOG.info(" WARNING: Enforce merging thread graphs.");
                CONFIG.setMergeThreadGraphs(Boolean.TRUE);
            }
        }
        if (cl.hasOption("q") && !cl.hasOption("o")) {
            throw new MetaMedException("You want to process queries, but output directory (-o) is missing.", -1);
        }
        if (cl.hasOption("d")) {
            for (String string : cl.getOptionValues("input-data")) {
                file = new File(string);
                MetaMed.addInputs(file);
            }
        }
        if (cl.hasOption("list")) {
            file2 = new File(cl.getOptionValue("file-list"));
            if (((File)file2).exists() && ((File)file2).canRead()) {
                BufferedReader in = null;
                try {
                    String line;
                    in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((File)file2), Const.CHARSET));
                    while ((line = in.readLine()) != null) {
                        File file3 = new File(line);
                        if (!file3.exists() || !file3.canRead()) continue;
                        MetaMed.addInputs(file3);
                    }
                }
                catch (IOException ex) {
                    LOG.error(null, (Throwable)ex);
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException ex) {
                        LOG.error(null, (Throwable)ex);
                    }
                }
            } else {
                throw new MetaMedException("File with list of files does not exist or is not readable (" + ((File)file2).getAbsolutePath() + ")", -1);
            }
        }
        if (CONFIG.getThreadCount() == 1) {
            Collections.sort(CONFIG.getDataFiles());
        }
        if (cl.hasOption("if")) {
            CONFIG.setImportFormat(cl.getOptionValue("import-format"));
        }
        if (!CONFIG.getImportFiles().isEmpty() && CONFIG.getImportFormat() == null) {
            throw new MetaMedException("You have to define import files serialization format (-if).", -1);
        }
        if (cl.hasOption("i")) {
            for (String string : cl.getOptionValues("import")) {
                file = new File(string);
                if (!file.isFile() || !file.canRead()) {
                    throw new MetaMedException("Import file " + file.getAbsolutePath() + " does not exist or you do not have permission to read.", -1);
                }
                CONFIG.getImportFiles().add(file);
            }
        }
        if (cl.hasOption("ef")) {
            CONFIG.setExportFormat(cl.getOptionValue("export-format"));
        }
        if (cl.hasOption("e")) {
            file2 = new File(cl.getOptionValue("export"));
            CONFIG.setExportFile((File)file2);
        }
        if (CONFIG.getExportFile() != null && CONFIG.getExportFormat() == null) {
            throw new MetaMedException("You have to define export file serialization format.", -1);
        }
        if (cl.hasOption("r")) {
            for (String string : cl.getOptionValues("remove")) {
                file = new File(string);
                if (file.isFile() && file.canRead()) {
                    CONFIG.getDeleteStatementFiles().add(file);
                    continue;
                }
                LOG.error("File with statements for removing is not accesible or does not exist.");
            }
            if (!CONFIG.getDeleteStatementFiles().isEmpty() && !CONFIG.isMergeThreadGraphs().booleanValue()) {
                LOG.warn("Enforce merging thread graphs.");
                CONFIG.setMergeThreadGraphs(Boolean.TRUE);
            }
        }
        if (cl.hasOption("empty")) {
            CONFIG.setOperationEmptyGraph(Boolean.TRUE);
        }
        if (cl.hasOption("p")) {
            for (String string : cl.getOptionValues("priority")) {
                String[] priority = string.split(":");
                Integer priorityNumber = Integer.getInteger(priority[1]);
                if (priority[1].equals("d") || priority[1].equals("dis") || priority[1].equals("disable") || priority[1].equals("disabled") || priority[1].equals("no") || priority[1].equals("n")) {
                    LOG.info("CONFIG EXTRACTOR DISABLED {}", (Object)priority[0]);
                    CONFIG.getPriorities().put(priority[0], Integer.MIN_VALUE);
                    continue;
                }
                if (priorityNumber < 0) continue;
                LOG.info("CONFIG EXTRACTOR {} priority {}", (Object)priority[0], (Object)priorityNumber);
                CONFIG.getPriorities().put(priority[0], priorityNumber);
            }
        }
        if (cl.hasOption("extract")) {
            CONFIG.setExtract(Boolean.TRUE);
            if (CONFIG.getDataFiles().isEmpty()) {
                throw new MetaMedException("Extract option without data specified.", -1);
            }
        }
        if (cl.hasOption("scan")) {
            file2 = new File(cl.getOptionValue("scan"));
            CONFIG.setScanContent((File)file2);
            if (CONFIG.getDataFiles().isEmpty()) {
                throw new MetaMedException("Scan option without data specified.", -1);
            }
        }
        return cl;
    }

    public static void addInputs(File input) {
        if (input == null) {
            return;
        }
        if (input.isDirectory()) {
            File[] files;
            if (CONFIG.isVerbose()) {
                LOG.info("OPEN DIRECTORY {}", (Object)input.getAbsolutePath());
            }
            if (!input.canRead()) {
                LOG.error("Cannot read directory {}", (Object)input.getAbsolutePath());
            }
            if ((files = input.listFiles()) == null) {
                LOG.error("Not directory or I/O error {}", (Object)input.getAbsolutePath());
                return;
            }
            for (File file : files) {
                MetaMed.addInputs(file);
            }
        } else if (input.exists()) {
            MetaMed.addInputFile(input);
        }
    }

    private static void addInputFile(File file) {
        if (!file.canRead()) {
            LOG.error("No read access to file {}", (Object)file.getAbsolutePath());
            return;
        }
        if (CONFIG.isVerbose()) {
            LOG.info("ADD data file {}", (Object)file.getAbsolutePath());
        }
        CONFIG.getDataFiles().add(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readQueryFile(String queryFile) {
        File file = new File(queryFile);
        StringBuilder sb = new StringBuilder();
        if (file.isDirectory()) {
            LOG.info("QUERY ADD directory {}", (Object)file.getAbsolutePath());
            File[] files = file.listFiles();
            if (files != null) {
                for (File f : files) {
                    MetaMed.readQueryFile(f.getAbsolutePath());
                }
            }
        } else if (file.isFile() && file.canRead()) {
            LOG.info("QUERY ADD file {}", (Object)file.getAbsolutePath());
            BufferedReader br = null;
            try {
                String s;
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Const.CHARSET));
                while ((s = br.readLine()) != null) {
                    if (s.startsWith("#") || s.startsWith("--") || s.startsWith("\\\\")) continue;
                    sb.append(s);
                    sb.append(" ");
                }
            }
            catch (IOException e) {
                LOG.error(null, (Throwable)e);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        LOG.error(null, (Throwable)e);
                    }
                }
            }
            CONFIG.getQueries().put(file.getName(), sb.toString().trim().replaceAll("/\\*(?>(?:(?>[^*]+)|\\*(?!/))*)\\*/", "").replaceAll(" +", " "));
        } else {
            LOG.error("QUERY ERROR - File with SPARQL is missing or you do not have access to {}", (Object)file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processExportPrefixes() throws MetaMedException {
        if (CONFIG.getPrefixMapOutputFile() == null) {
            return;
        }
        File outputFile = new File(CONFIG.getPrefixMapOutputFile());
        if (!outputFile.getParentFile().canWrite()) {
            throw new MetaMedException("Cannot write to the file '" + outputFile.getAbsolutePath() + "'.", -1);
        }
        String prefixes = PrefixMap.get().toString();
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(outputFile);
            ((OutputStream)outputStream).write(prefixes.getBytes(Const.CHARSET));
            outputStream.flush();
        }
        catch (FileNotFoundException ex) {
            LOG.error(null, (Throwable)ex);
        }
        catch (IOException ex) {
            LOG.error(null, (Throwable)ex);
        }
        finally {
            if (outputStream != null) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException ex) {
                    LOG.error(null, (Throwable)ex);
                }
            }
        }
    }

    private static void openPersistentModel() throws MetaMedException {
        if (CONFIG.isUseInMemoryhGraph().booleanValue()) {
            ModelMaker modelMaker = ModelFactory.createMemModelMaker();
            model = modelMaker.openModel(CONFIG.getGraphName(), false);
        } else if (CONFIG.isUseVirtuosoGraph().booleanValue() && !CONFIG.getConnectionProperties().isEmpty()) {
            dataSource = new VirtuosoDS(CONFIG.getConnectionProperties());
            model = dataSource.getModel(CONFIG.getGraphName());
        } else if (CONFIG.isUseFileGraph().booleanValue() && CONFIG.getOfflineDirectory() != null) {
            try {
                FileInputStream fis = FileUtils.openInputStream((File)new File(CONFIG.getOfflineDirectory() + CONFIG.getGraphName()));
                model = ModelFactory.createDefaultModel();
                model.read((InputStream)fis, "https://mre.zcu.cz/id/");
            }
            catch (IOException ex) {
                LOG.error(null, (Throwable)ex);
            }
        }
        if (model == null) {
            throw new MetaMedException("Unable to create presistent graph.", -1);
        }
        CONFIG.getThreadGraphs().add(model);
        model.setNsPrefixes((Map)PrefixMap.get());
    }

    private static void processEmpty() {
        if (CONFIG.isOperationEmptyGraph().booleanValue()) {
            model.removeAll();
            MetaMed.printModelSize();
        }
    }

    private static void processImport() {
        if (!CONFIG.getImportFiles().isEmpty()) {
            long initialModelSize = model.size();
            long milliseconds0 = new Date().getTime();
            if (CONFIG.isUseInMemoryhGraph().booleanValue()) {
                MetaMed.processImportInMemory();
            } else if (CONFIG.isUseVirtuosoGraph().booleanValue()) {
                MetaMed.processImportVirtuoso();
            }
            long importedTriples = model.size() - initialModelSize;
            long importTime = new Date().getTime() - milliseconds0;
            long importTime2 = importTime < 1000L ? 1000L : importTime;
            LOG.info("IMPORT FINISHED. Loaded was {} in total time of {} milliseconds; {} tpl/s", new Object[]{importedTriples, importTime, Float.valueOf((float)importedTriples / ((float)importTime2 / 1000.0f))});
            MetaMed.printModelSize();
        }
    }

    private static void processImportInMemory() {
        ConsoleProgressBar cpb = new ConsoleProgressBar(CONFIG.getImportFiles().size());
        cpb.start();
        for (File file : CONFIG.getImportFiles()) {
            Model m;
            boolean isGzipFile;
            InputStream is;
            block9: {
                LOG.info("IMPORT RDF data ({} format) from the file {}", (Object)CONFIG.getImportFormat(), (Object)file.getAbsolutePath());
                is = null;
                try {
                    is = RDFDataAccess.getInputStream((File)file);
                    GZIPInputStream isGzip = new GZIPInputStream(is);
                    isGzipFile = true;
                    m = RDFDataAccess.readModel((InputStream)isGzip, (String)"https://mre.zcu.cz/id/", (String)CONFIG.getImportFormat());
                    model.add(m);
                    m.close();
                    ((InputStream)isGzip).close();
                }
                catch (IOException ex) {
                    isGzipFile = false;
                    if (is == null) break block9;
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        LOG.error(null, (Throwable)e);
                    }
                }
            }
            if (!isGzipFile) {
                m = RDFDataAccess.readModelFromFile((File)file, (String)"https://mre.zcu.cz/id/", (String)CONFIG.getImportFormat());
                model.add(m);
                m.close();
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ex) {
                        LOG.error(null, (Throwable)ex);
                    }
                }
            }
            cpb.increment();
        }
    }

    private static void processImportVirtuoso() {
        ConsoleProgressBar cpb = new ConsoleProgressBar(CONFIG.getImportFiles().size());
        cpb.start();
        for (File file : CONFIG.getImportFiles()) {
            Statement statement;
            StmtIterator stmt;
            Model m;
            boolean isGzipFile;
            LOG.info("IMPORT RDF data ({} format) from the file {}", (Object)CONFIG.getImportFormat(), (Object)file.getAbsolutePath());
            InputStream is = null;
            try {
                is = RDFDataAccess.getInputStream((File)file);
                GZIPInputStream isGzip = new GZIPInputStream(is);
                isGzipFile = true;
                m = RDFDataAccess.readModel((InputStream)isGzip, (String)"https://mre.zcu.cz/id/", (String)CONFIG.getImportFormat());
                try {
                    model.add(m);
                }
                catch (Exception e) {
                    stmt = m.listStatements();
                    while (stmt.hasNext()) {
                        statement = stmt.nextStatement();
                        model.add(statement);
                    }
                }
                m.close();
                ((InputStream)isGzip).close();
            }
            catch (IOException ex) {
                isGzipFile = false;
            }
            if (!isGzipFile) {
                m = RDFDataAccess.readModelFromFile((File)file, (String)"https://mre.zcu.cz/id/", (String)CONFIG.getImportFormat());
                try {
                    model.add(m);
                }
                catch (Exception e) {
                    stmt = m.listStatements();
                    while (stmt.hasNext()) {
                        statement = stmt.nextStatement();
                        model.add(statement);
                    }
                }
                m.close();
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOG.error(null, (Throwable)e);
                }
            }
            cpb.increment();
        }
    }

    private static void processExtraction() {
        if (!CONFIG.getExtract().booleanValue()) {
            return;
        }
        long size = 0L;
        if (!CONFIG.getDataFiles().isEmpty()) {
            try {
                ExtractionFarmer farmer = new ExtractionFarmer(CONFIG.getThreadCount(), CONFIG.getDataFiles(), model, CONFIG.getDataSourceLabel());
                long ms00 = new Date().getTime();
                farmer.runWorkers();
                if (CONFIG.isMergeThreadGraphs().booleanValue()) {
                    model = farmer.getMergedThreadModels();
                    size = model.size();
                } else {
                    CONFIG.setThreadGraphs(farmer.getThreadModels());
                    size = CONFIG.getThreadGraphs().stream().map(tModel -> tModel.size()).reduce(size, (accumulator, item) -> accumulator + item);
                }
                long ms01 = new Date().getTime();
                LOG.info("EXTRACTION TIME\t{}\tms\t{}\t ms/file", (Object)(ms01 - ms00), (Object)((ms01 - ms00) / (long)CONFIG.getDataFiles().size()));
            }
            catch (Exception e) {
                throw new MetaMedException("Exception during extraction: " + e.getMessage(), -5);
            }
            MetaMed.printModelSize(size);
        }
    }

    private static void processScanner() {
        if (CONFIG.getScanContent() == null) {
            return;
        }
        if (!CONFIG.getDataFiles().isEmpty()) {
            try {
                ScannerFarmer farmer = new ScannerFarmer(CONFIG.getThreadCount(), CONFIG.getDataFiles(), CONFIG.getScanContent());
                long ms00 = new Date().getTime();
                farmer.runWorkers();
                long ms01 = new Date().getTime();
                LOG.info("SCANNER TIME\t{}\tms\t{}\t ms/file", (Object)(ms01 - ms00), (Object)((ms01 - ms00) / (long)CONFIG.getDataFiles().size()));
            }
            catch (Exception e) {
                throw new MetaMedException("Exception during scanning: " + e.getMessage(), -6);
            }
        }
    }

    private static void processDelete() {
        if (CONFIG.getDeleteStatementFiles() != null && !CONFIG.getDeleteStatementFiles().isEmpty()) {
            MetaMed.printModelSize();
            DeleteStatementUtil.deleteData((Model)model, CONFIG.getDeleteStatementFiles());
        }
    }

    private static void printModelSize(long size) {
        if (!CONFIG.isSize()) {
            return;
        }
        long printSize = size;
        if (size < 0L) {
            printSize = model.size();
        }
        if (CONFIG.getGraphName() == null) {
            LOG.info("GRAPH --in-memory-- has {} statements.", (Object)model.size());
        } else {
            LOG.info("GRAPH {} has {} statements.", (Object)CONFIG.getGraphName(), (Object)printSize);
        }
    }

    private static void printModelSize() {
        MetaMed.printModelSize(model.size());
    }

    private static void processQueries() {
        if (CONFIG.getQueries().isEmpty()) {
            return;
        }
        RDFQuery query = new RDFQuery(model);
        query.setOutputFormat(CONFIG.getOutputFormat());
        query.setOutputDirectory(CONFIG.getOutputDirectory());
        query.setThreadCount(CONFIG.getThreadCount());
        query.setVirtuoso(CONFIG.isUseVirtuosoGraph().booleanValue());
        RDFQuery.setExportFormat((String)CONFIG.getExportFormat());
        query.batchQuery(CONFIG.getQueries());
    }

    private static void processExport() {
        if (CONFIG.getExportFile() != null) {
            long milliseconds0 = new Date().getTime();
            if (CONFIG.getThreadCount() == 1 || CONFIG.isMergeThreadGraphs().booleanValue()) {
                MetaMed.printModelSize();
                RDFDataAccess.exportRDFModel((Model)model, (File)CONFIG.getExportFile(), (String)CONFIG.getExportFormat());
            } else {
                int i = 0;
                for (Model tModel : CONFIG.getThreadGraphs()) {
                    String filename = FileUtil.filename((String)CONFIG.getExportFile().getAbsolutePath()).concat("-" + i);
                    File tFile = new File(filename + FileUtil.fileExtension((String)CONFIG.getExportFile().getAbsolutePath()));
                    if (CONFIG.isSize()) {
                        LOG.info("EXPORT GRAPH in thread {} with {} statement(s) to {}.", new Object[]{i, tModel.size(), tFile.getAbsolutePath()});
                    }
                    RDFDataAccess.exportRDFModel((Model)tModel, (File)tFile, (String)CONFIG.getExportFormat());
                    ++i;
                }
            }
            long milliseconds1 = new Date().getTime();
            LOG.info("EXPORT TIME {} ms.", (Object)(milliseconds1 - milliseconds0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closePersistentModel() {
        block21: {
            if (CONFIG.isUseInMemoryhGraph().booleanValue()) {
                return;
            }
            if (CONFIG.isUseVirtuosoGraph().booleanValue()) {
                model.close();
                dataSource.close();
                return;
            }
            try {
                File file;
                if (!CONFIG.isUseFileGraph().booleanValue()) break block21;
                String path = "";
                if (CONFIG.getOfflineDirectory() != null) {
                    path = CONFIG.getOfflineDirectory();
                }
                String graph = MetaMedConfiguration.DEFAULT_GRAPH;
                if (CONFIG.getGraphName() != null && !CONFIG.getGraphName().isEmpty()) {
                    graph = CONFIG.getGraphName();
                }
                if (!(file = new File(path + graph)).createNewFile()) break block21;
                FileOutputStream fos = null;
                try {
                    fos = FileUtils.openOutputStream((File)file);
                    model = ModelFactory.createDefaultModel();
                    model.write((OutputStream)fos);
                }
                catch (IOException ex) {
                    LOG.error(null, (Throwable)ex);
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException ex) {
                            LOG.error(null, (Throwable)ex);
                        }
                    }
                }
            }
            catch (IOException ex) {
                LOG.error(null, (Throwable)ex);
            }
            finally {
                model.close();
            }
        }
    }

    public static MetaMedConfiguration getConfig() {
        return CONFIG;
    }

    private MetaMed() {
    }
}

