/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.stream;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.dcm4che3.imageio.codec.BytesWithImageImageDescriptor;
import org.dcm4che3.imageio.codec.ImageDescriptor;
import org.dcm4che3.imageio.codec.TransferSyntaxType;
import org.dcm4che3.io.DicomInputStream;

public class EncapsulatedPixelDataImageInputStream
extends MemoryCacheImageInputStream
implements BytesWithImageImageDescriptor {
    private final DicomInputStream dis;
    private final ImageDescriptor imageDescriptor;
    private final TransferSyntaxType tsType;
    private final byte[] basicOffsetTable;
    private final int frameStartWord;
    private int fragmStartWord;
    private long fragmEndPos;
    private long frameStartPos;
    private long frameEndPos = -1L;
    private boolean endOfStream;

    public EncapsulatedPixelDataImageInputStream(DicomInputStream dis, ImageDescriptor imageDescriptor) throws IOException {
        this(dis, imageDescriptor, TransferSyntaxType.forUID(dis.getTransferSyntax()));
    }

    public EncapsulatedPixelDataImageInputStream(DicomInputStream dis, ImageDescriptor imageDescriptor, TransferSyntaxType tsType) throws IOException {
        super((InputStream)dis);
        this.dis = dis;
        this.imageDescriptor = imageDescriptor;
        this.tsType = tsType;
        dis.readItemHeader();
        byte[] b = new byte[dis.length()];
        dis.readFully(b);
        this.basicOffsetTable = b;
        this.readItemHeader();
        this.frameStartWord = this.fragmStartWord;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    @Override
    public int read() throws IOException {
        if (this.endOfFrame()) {
            return -1;
        }
        return super.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.endOfFrame()) {
            return -1;
        }
        return super.read(b, off, Math.min(len, (int)((this.frameEndPos < 0L ? this.fragmEndPos : this.frameEndPos) - this.streamPos)));
    }

    public void seekCurrentFrame() throws IOException {
        this.seek(this.frameStartPos);
    }

    public boolean seekNextFrame() throws IOException {
        if (this.endOfStream) {
            return false;
        }
        if (this.frameEndPos >= 0L) {
            this.seek(this.frameEndPos);
            this.flush();
        } else {
            while (!this.endOfFrame()) {
                this.seek(this.fragmEndPos - 1L);
                super.read();
                this.flush();
            }
        }
        this.frameStartPos = this.streamPos;
        this.frameEndPos = -1L;
        return !this.endOfStream;
    }

    @Override
    public ByteBuffer getBytes() throws IOException {
        int read;
        byte[] array = new byte[8192];
        int length = 0;
        while ((read = this.read(array, length, array.length - length)) > 0) {
            if ((length += read) != array.length) continue;
            array = Arrays.copyOf(array, array.length << 1);
        }
        return ByteBuffer.wrap(array, 0, length);
    }

    private boolean readItemHeader() throws IOException {
        if (!this.dis.readItemHeader()) {
            this.endOfStream = true;
            return false;
        }
        this.fragmEndPos = this.streamPos + this.dis.unsignedLength();
        this.mark();
        this.fragmStartWord = super.read() << 8 | super.read();
        this.reset();
        return true;
    }

    private boolean endOfFrame() throws IOException {
        if (this.frameEndPos >= 0L) {
            return this.streamPos >= this.frameEndPos;
        }
        if (this.streamPos < this.fragmEndPos) {
            return false;
        }
        if (this.readItemHeader() && (!this.imageDescriptor.isMultiframe() || this.tsType.mayFrameSpanMultipleFragments() && this.fragmStartWord != this.frameStartWord)) {
            return false;
        }
        this.frameEndPos = this.streamPos;
        return true;
    }

    public boolean isEndOfStream() {
        return this.endOfStream;
    }
}

