/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.plugins.dcm;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.BulkData;
import org.dcm4che3.data.Fragments;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.image.BufferedImageUtils;
import org.dcm4che3.image.ColorModelFactory;
import org.dcm4che3.image.ICCProfile;
import org.dcm4che3.image.LookupTable;
import org.dcm4che3.image.LookupTableFactory;
import org.dcm4che3.image.Overlays;
import org.dcm4che3.image.PaletteColorModel;
import org.dcm4che3.image.PhotometricInterpretation;
import org.dcm4che3.image.StoredValue;
import org.dcm4che3.imageio.codec.ImageDescriptor;
import org.dcm4che3.imageio.codec.ImageReaderFactory;
import org.dcm4che3.imageio.codec.TransferSyntaxType;
import org.dcm4che3.imageio.codec.jpeg.PatchJPEGLS;
import org.dcm4che3.imageio.codec.jpeg.PatchJPEGLSImageInputStream;
import org.dcm4che3.imageio.plugins.dcm.DicomImageReadParam;
import org.dcm4che3.imageio.plugins.dcm.DicomMetaData;
import org.dcm4che3.imageio.stream.EncapsulatedPixelDataImageInputStream;
import org.dcm4che3.imageio.stream.ImageInputStreamAdapter;
import org.dcm4che3.imageio.stream.SegmentedInputImageStream;
import org.dcm4che3.io.BulkDataDescriptor;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.util.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DicomImageReader
extends ImageReader
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(DicomImageReader.class);
    public static final String POST_PIXEL_DATA = "postPixelData";
    static final ColorSpace sRGB = ColorSpace.getInstance(1000);
    private ImageInputStream iis;
    private DicomInputStream dis;
    private EncapsulatedPixelDataImageInputStream epdiis;
    private DicomMetaData metadata;
    private BulkData pixelData;
    private Fragments pixelDataFragments;
    private byte[] pixeldataBytes;
    private long pixelDataLength;
    private VR pixelDataVR;
    private File pixelDataFile;
    private int frames;
    private int flushedFrames;
    private int width;
    private int height;
    private ImageReader decompressor;
    private boolean rle;
    private PatchJPEGLS patchJpegLS;
    private int samples;
    private boolean banded;
    private int bitsStored;
    private int bitsAllocated;
    private int dataType;
    private int frameLength;
    private PhotometricInterpretation pmi;
    private PhotometricInterpretation pmiAfterDecompression;
    private ImageDescriptor imageDescriptor;
    private ICCProfile.ColorSpaceFactory colorSpaceFactory;

    public DicomImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        this.resetInternalState();
        if (input instanceof InputStream) {
            try {
                this.dis = input instanceof DicomInputStream ? (DicomInputStream)input : new DicomInputStream((InputStream)input);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        } else if (input instanceof DicomMetaData) {
            DicomMetaData metadata = (DicomMetaData)input;
            this.initPixelDataFromAttributes(metadata.getAttributes());
            this.initPixelDataFile();
            this.setMetadata(metadata);
        } else {
            this.iis = (ImageInputStream)input;
        }
    }

    private void initPixelDataFromAttributes(Attributes ds) {
        VR.Holder holder = new VR.Holder();
        Object value = ds.getValue(2145386512, holder);
        if (value != null) {
            this.imageDescriptor = new ImageDescriptor(ds);
            this.pixelDataVR = holder.vr;
            if (value instanceof BulkData) {
                this.pixelData = (BulkData)value;
                this.pixelDataLength = this.pixelData.longLength();
            } else if (value instanceof byte[]) {
                this.pixeldataBytes = (byte[])value;
                this.pixelDataLength = this.pixeldataBytes.length;
            } else {
                this.pixelDataFragments = (Fragments)value;
                this.pixelDataLength = -1L;
            }
        }
    }

    private void initPixelDataFile() {
        if (this.pixelData != null) {
            this.pixelDataFile = this.pixelData.getFile();
        } else if (this.pixelDataFragments != null) {
            this.pixelDataFile = this.pixelDataFragmentsFile(this.pixelDataFragments);
        }
    }

    private File pixelDataFragmentsFile(Fragments pixelDataFragments) {
        File f = null;
        for (Object frag : pixelDataFragments) {
            if (!(frag instanceof BulkData)) continue;
            if (f == null) {
                f = ((BulkData)frag).getFile();
                continue;
            }
            if (f.equals(((BulkData)frag).getFile())) continue;
            throw new UnsupportedOperationException("data fragments in individual bulk data files not supported");
        }
        return f;
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        this.readMetadata();
        return this.frames;
    }

    @Override
    public int getWidth(int frameIndex) throws IOException {
        this.readMetadata();
        this.checkIndex(frameIndex);
        return this.width;
    }

    @Override
    public int getHeight(int frameIndex) throws IOException {
        this.readMetadata();
        this.checkIndex(frameIndex);
        return this.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageTypeSpecifier getRawImageType(int frameIndex) throws IOException {
        this.readMetadata();
        this.checkIndex(frameIndex);
        ColorSpace cspace = this.colorSpaceOfFrame(frameIndex).orElse(sRGB);
        if (this.decompressor == null) {
            return this.createImageType(this.bitsStored, this.dataType, this.banded, cspace);
        }
        if (this.rle) {
            return this.createImageType(this.bitsStored, this.dataType, true, cspace);
        }
        this.openiis();
        try {
            this.decompressor.setInput(this.iisOfFrame(0));
            ImageTypeSpecifier imageTypeSpecifier = this.decompressor.getRawImageType(0);
            return imageTypeSpecifier;
        }
        finally {
            this.closeiis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int frameIndex) throws IOException {
        ImageTypeSpecifier imageType;
        this.readMetadata();
        this.checkIndex(frameIndex);
        ColorSpace cspace = this.colorSpaceOfFrame(frameIndex).orElse(sRGB);
        if (this.pmi.isMonochrome()) {
            imageType = this.createImageType(8, 0, false, cspace);
        } else if (this.decompressor == null) {
            imageType = this.createImageType(this.bitsStored, this.dataType, this.banded, cspace);
        } else if (this.rle) {
            imageType = this.createImageType(this.bitsStored, this.dataType, true, cspace);
        } else {
            this.openiis();
            try {
                this.decompressor.setInput(this.iisOfFrame(0));
                Iterator<ImageTypeSpecifier> iterator = this.decompressor.getImageTypes(0);
                return iterator;
            }
            finally {
                this.closeiis();
            }
        }
        return Collections.singletonList(imageType).iterator();
    }

    private void openiis() throws IOException {
        if (this.iis == null) {
            if (this.pixelDataFile != null) {
                this.iis = new FileImageInputStream(this.pixelDataFile);
            } else if (this.pixeldataBytes != null) {
                this.iis = new SegmentedInputImageStream(this.pixeldataBytes);
            }
        }
    }

    private void closeiis() throws IOException {
        if ((this.pixelDataFile != null || this.pixeldataBytes != null) && this.iis != null) {
            this.iis.close();
            this.iis = null;
        }
    }

    @Override
    public ImageReadParam getDefaultReadParam() {
        return new DicomImageReadParam();
    }

    @Override
    public DicomMetaData getStreamMetadata() throws IOException {
        this.readMetadata();
        return this.metadata;
    }

    @Override
    public DicomMetaData getStreamMetadata(String formatName, Set<String> nodeNames) throws IOException {
        DicomMetaData ret = this.getStreamMetadata();
        if (nodeNames != null && nodeNames.contains(POST_PIXEL_DATA)) {
            this.readPostPixeldata();
            return this.getStreamMetadata();
        }
        return ret;
    }

    @Override
    public IIOMetadata getImageMetadata(int frameIndex) throws IOException {
        return null;
    }

    @Override
    public boolean canReadRaster() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Raster readRaster(int frameIndex, ImageReadParam param) throws IOException {
        this.readMetadata();
        this.checkIndex(frameIndex);
        this.openiis();
        try {
            Object data;
            if (this.decompressor != null) {
                WritableRaster wr;
                this.decompressor.setInput(this.iisOfFrame(frameIndex));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Start decompressing frame #" + (frameIndex + 1));
                }
                Raster raster = wr = this.pmiAfterDecompression == this.pmi && this.decompressor.canReadRaster() ? this.decompressor.readRaster(0, this.decompressParam(param)) : this.decompressor.read(0, this.decompressParam(param)).getRaster();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Finished decompressing frame #" + (frameIndex + 1));
                }
                WritableRaster writableRaster = wr;
                return writableRaster;
            }
            WritableRaster wr = Raster.createWritableRaster(this.createSampleModel(this.dataType, this.banded), null);
            DataBuffer buf = wr.getDataBuffer();
            if (this.dis != null) {
                this.dis.skipFully((long)((frameIndex - this.flushedFrames) * this.frameLength));
                this.flushedFrames = frameIndex + 1;
            } else if (this.pixeldataBytes != null) {
                this.iis.setByteOrder(this.bigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
                this.iis.seek(frameIndex * this.frameLength);
            } else {
                this.iis.setByteOrder(this.bigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
                this.iis.seek(this.pixelData.offset() + (long)(frameIndex * this.frameLength));
            }
            if (buf instanceof DataBufferByte) {
                for (byte[] bs : data = ((DataBufferByte)buf).getBankData()) {
                    if (this.dis != null) {
                        this.dis.readFully(bs);
                        continue;
                    }
                    this.iis.readFully(bs);
                }
                if (this.pixelDataVR == VR.OW && this.bigEndian()) {
                    ByteUtils.swapShorts((byte[][])data);
                }
            } else {
                data = ((DataBufferUShort)buf).getData();
                if (this.dis != null) {
                    this.dis.readFully((short[])data, 0, ((byte[][])data).length);
                } else {
                    this.iis.readFully((short[])data, 0, ((byte[][])data).length);
                }
            }
            WritableRaster writableRaster = wr;
            return writableRaster;
        }
        finally {
            this.closeiis();
        }
    }

    private boolean bigEndian() {
        return this.metadata.bigEndian();
    }

    private String getTransferSyntaxUID() {
        return this.metadata.getTransferSyntaxUID();
    }

    private ImageReadParam decompressParam(ImageReadParam param) {
        ImageReadParam decompressParam = this.decompressor.getDefaultReadParam();
        ImageTypeSpecifier imageType = null;
        BufferedImage dest = null;
        if (param != null) {
            imageType = param.getDestinationType();
            dest = param.getDestination();
        }
        if (this.rle && imageType == null && dest == null) {
            imageType = this.createImageType(this.bitsStored, this.dataType, true, sRGB);
        }
        decompressParam.setDestinationType(imageType);
        decompressParam.setDestination(dest);
        return decompressParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage read(int frameIndex, ImageReadParam param) throws IOException {
        WritableRaster raster;
        this.readMetadata();
        this.checkIndex(frameIndex);
        BufferedImage bi = null;
        if (this.decompressor != null) {
            this.openiis();
            try {
                ImageInputStream iisOfFrame = this.iisOfFrame(frameIndex);
                iisOfFrame.length();
                this.decompressor.setInput(iisOfFrame);
                LOG.debug("Start decompressing frame #{}", (Object)(frameIndex + 1));
                bi = this.decompressor.read(0, this.decompressParam(param));
                LOG.debug("Finished decompressing frame #{}", (Object)(frameIndex + 1));
            }
            finally {
                this.closeiis();
            }
            raster = bi.getRaster();
        } else {
            raster = (WritableRaster)this.readRaster(frameIndex, param);
        }
        return this.pmi.isMonochrome() ? this.applyGrayscaleTransformations(frameIndex, param, raster) : this.applyColorTransformations(frameIndex, param, raster, bi);
    }

    private BufferedImage applyGrayscaleTransformations(int frameIndex, ImageReadParam param, WritableRaster raster) {
        int[] overlayGroupOffsets = this.getActiveOverlayGroupOffsets(param);
        byte[][] overlayData = new byte[overlayGroupOffsets.length][];
        for (int i = 0; i < overlayGroupOffsets.length; ++i) {
            overlayData[i] = this.extractOverlay(overlayGroupOffsets[i], raster);
        }
        PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(0, this.width, this.height, 1, this.width, new int[1]);
        raster = this.applyLUTs(raster, frameIndex, param, sm, 8);
        for (int i = 0; i < overlayGroupOffsets.length; ++i) {
            try {
                this.applyOverlayMonochrome(overlayGroupOffsets[i], raster, frameIndex, param, overlayData[i]);
                continue;
            }
            catch (IllegalArgumentException e) {
                LOG.info(DicomImageReader.ignoreInvalidOverlay(overlayGroupOffsets[i], e));
            }
        }
        ColorModel cm = ColorModelFactory.createMonochromeColorModel((int)8, (int)0);
        BufferedImage bi = new BufferedImage(cm, raster, false, null);
        return bi;
    }

    private BufferedImage applyColorTransformations(int frameIndex, ImageReadParam param, WritableRaster raster, BufferedImage bi) {
        int[] overlayGroupOffsets = this.getActiveOverlayGroupOffsets(param);
        Optional<ColorSpace> iccColorSpace = this.colorSpaceOfFrame(frameIndex);
        if (bi != null && this.pmi != PhotometricInterpretation.PALETTE_COLOR && bi.getColorModel().getColorSpace().getType() == (this.pmiAfterDecompression.isYBR() ? 3 : 5) && overlayGroupOffsets.length == 0 && !iccColorSpace.isPresent()) {
            return bi;
        }
        ColorSpace colorSpace = iccColorSpace.orElse(sRGB);
        ColorModel cm = this.createColorModel(this.bitsStored, this.dataType, colorSpace);
        if (cm.isCompatibleRaster(raster)) {
            bi = new BufferedImage(cm, raster, false, null);
        } else {
            if (bi == null) {
                DirectColorModel directColorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
                LOG.info("Missing Color Model information, assume {}", (Object)directColorModel);
                bi = new BufferedImage(directColorModel, bi.getRaster(), false, null);
            }
            bi = BufferedImageUtils.convertColor((BufferedImage)bi, (ColorModel)cm);
        }
        if (overlayGroupOffsets.length == 0) {
            return bi;
        }
        if (cm instanceof PaletteColorModel) {
            bi = BufferedImageUtils.convertPalettetoRGB((BufferedImage)bi, null);
        }
        for (int i = 0; i < overlayGroupOffsets.length; ++i) {
            try {
                this.applyOverlayColor(overlayGroupOffsets[i], bi.getRaster(), frameIndex, param, bi.getColorModel().getColorSpace());
                continue;
            }
            catch (IllegalArgumentException e) {
                LOG.info(DicomImageReader.ignoreInvalidOverlay(overlayGroupOffsets[i], e));
            }
        }
        return bi;
    }

    private static String ignoreInvalidOverlay(int overlayGroupOffset, IllegalArgumentException e) {
        return String.format("Ignore invalid Overlay (60%02X,eeee) with %s", overlayGroupOffset, e.getMessage());
    }

    private byte[] extractOverlay(int gg0000, WritableRaster raster) {
        Attributes attrs = this.metadata.getAttributes();
        if (attrs.getInt(0x60000100 | gg0000, 1) == 1) {
            return null;
        }
        int ovlyRows = attrs.getInt(0x60000010 | gg0000, 0);
        int ovlyColumns = attrs.getInt(0x60000011 | gg0000, 0);
        int bitPosition = attrs.getInt(0x60000102 | gg0000, 0);
        int mask = 1 << bitPosition;
        int length = ovlyRows * ovlyColumns;
        byte[] ovlyData = new byte[(length + 7 >>> 3) + 1 & 0xFFFFFFFE];
        if (bitPosition < this.bitsStored) {
            LOG.info("Ignore embedded overlay #{} from bit #{} < bits stored: {}", new Object[]{(gg0000 >>> 17) + 1, bitPosition, this.bitsStored});
        } else {
            Overlays.extractFromPixeldata((Raster)raster, (int)mask, (byte[])ovlyData, (int)0, (int)length);
        }
        return ovlyData;
    }

    public ImageInputStream iisOfFrame(int frameIndex) throws IOException {
        ImageInputStreamImpl iisOfFrame;
        if (this.epdiis != null) {
            this.seekFrame(frameIndex);
            iisOfFrame = this.epdiis;
        } else {
            if (this.pixelDataFragments == null) {
                return null;
            }
            iisOfFrame = new SegmentedInputImageStream(this.iis, this.pixelDataFragments, this.frames == 1 ? -1 : frameIndex);
            ((SegmentedInputImageStream)iisOfFrame).setImageDescriptor(this.imageDescriptor);
        }
        return this.patchJpegLS != null ? new PatchJPEGLSImageInputStream(iisOfFrame, this.patchJpegLS) : iisOfFrame;
    }

    public Optional<ColorSpace> colorSpaceOfFrame(int frameIndex) {
        ICCProfile.ColorSpaceFactory colorSpaceFactory = this.colorSpaceFactory;
        if (colorSpaceFactory == null) {
            this.colorSpaceFactory = colorSpaceFactory = ICCProfile.colorSpaceFactoryOf((Attributes)this.metadata.getAttributes());
        }
        return colorSpaceFactory.getColorSpace(frameIndex);
    }

    private void seekFrame(int frameIndex) throws IOException {
        assert (frameIndex >= this.flushedFrames);
        if (frameIndex == this.flushedFrames) {
            this.epdiis.seekCurrentFrame();
        } else {
            while (frameIndex > this.flushedFrames) {
                if (!this.epdiis.seekNextFrame()) {
                    throw new IOException("Data Fragments only contains " + (this.flushedFrames + 1) + " frames");
                }
                ++this.flushedFrames;
            }
        }
    }

    private void applyOverlayMonochrome(int gg0000, WritableRaster raster, int frameIndex, ImageReadParam param, byte[] ovlyData) {
        Attributes ovlyAttrs = this.metadata.getAttributes();
        int[] pixelValue = new int[]{255};
        if (param instanceof DicomImageReadParam) {
            DicomImageReadParam dParam = (DicomImageReadParam)param;
            pixelValue = new int[]{dParam.getOverlayGrayscaleValue() >> 8};
            Attributes psAttrs = dParam.getPresentationState();
            if (psAttrs != null) {
                if (psAttrs.containsValue(0x60003000 | gg0000)) {
                    ovlyAttrs = psAttrs;
                }
                pixelValue = Overlays.getRecommendedGrayscalePixelValue((Attributes)psAttrs, (int)gg0000, (int)8);
            }
        }
        Overlays.applyOverlay((int)(ovlyData != null ? 0 : frameIndex), (WritableRaster)raster, (Attributes)ovlyAttrs, (int)gg0000, (int[])pixelValue, (byte[])ovlyData);
    }

    private void applyOverlayColor(int gg0000, WritableRaster raster, int frameIndex, ImageReadParam param, ColorSpace cspace) {
        Attributes ovlyAttrs = this.metadata.getAttributes();
        int[] pixelValue = new int[]{255, 255, 255};
        if (param instanceof DicomImageReadParam) {
            DicomImageReadParam dParam = (DicomImageReadParam)param;
            pixelValue = dParam.getOverlayRGBPixelValue();
            Attributes psAttrs = dParam.getPresentationState();
            if (psAttrs != null) {
                if (psAttrs.containsValue(0x60003000 | gg0000)) {
                    ovlyAttrs = psAttrs;
                }
                pixelValue = Overlays.getRecommendedRGBPixelValue((Attributes)psAttrs, (int)gg0000, (ColorSpace)cspace);
            }
        }
        Overlays.applyOverlay((int)frameIndex, (WritableRaster)raster, (Attributes)ovlyAttrs, (int)gg0000, (int[])pixelValue, null);
    }

    private int[] getActiveOverlayGroupOffsets(ImageReadParam param) {
        if (param instanceof DicomImageReadParam) {
            DicomImageReadParam dParam = (DicomImageReadParam)param;
            Attributes psAttrs = dParam.getPresentationState();
            if (psAttrs != null) {
                return Overlays.getActiveOverlayGroupOffsets((Attributes)psAttrs);
            }
            return Overlays.getActiveOverlayGroupOffsets((Attributes)this.metadata.getAttributes(), (int)dParam.getOverlayActivationMask());
        }
        return Overlays.getActiveOverlayGroupOffsets((Attributes)this.metadata.getAttributes(), (int)65535);
    }

    private WritableRaster applyLUTs(WritableRaster raster, int frameIndex, ImageReadParam param, SampleModel sm, int outBits) {
        WritableRaster destRaster = sm.getDataType() == raster.getSampleModel().getDataType() ? raster : Raster.createWritableRaster(sm, null);
        Attributes imgAttrs = this.metadata.getAttributes();
        StoredValue sv = StoredValue.valueOf((Attributes)imgAttrs);
        LookupTableFactory lutParam = new LookupTableFactory(sv);
        DicomImageReadParam dParam = param instanceof DicomImageReadParam ? (DicomImageReadParam)param : new DicomImageReadParam();
        Attributes psAttrs = dParam.getPresentationState();
        if (psAttrs != null) {
            lutParam.setModalityLUT(psAttrs);
            lutParam.setVOI(this.selectVOILUT(psAttrs, imgAttrs.getString(524312), frameIndex + 1), 0, 0, false);
            lutParam.setPresentationLUT(psAttrs, false);
        } else {
            Attributes sharedFctGroups = imgAttrs.getNestedDataset(1375769129);
            Attributes frameFctGroups = imgAttrs.getNestedDataset(1375769136, frameIndex);
            if (LookupTableFactory.applyModalityLUT((Attributes)imgAttrs)) {
                lutParam.setModalityLUT(this.selectFctGroup(imgAttrs, sharedFctGroups, frameFctGroups, 2658629));
            }
            if (dParam.getWindowWidth() != 0.0f) {
                lutParam.setWindowCenter(dParam.getWindowCenter());
                lutParam.setWindowWidth(dParam.getWindowWidth());
            } else {
                lutParam.setVOI(this.selectFctGroup(imgAttrs, sharedFctGroups, frameFctGroups, 2658610), dParam.getWindowIndex(), dParam.getVOILUTIndex(), dParam.isPreferWindow());
            }
            if (dParam.isAutoWindowing()) {
                lutParam.autoWindowing(imgAttrs, (Raster)raster, dParam.isAddAutoWindow());
            }
            lutParam.setPresentationLUT(imgAttrs, dParam.isIgnorePresentationLUTShape());
        }
        LookupTable lut = lutParam.createLUT(outBits);
        lut.lookup((Raster)raster, (Raster)destRaster);
        return destRaster;
    }

    private Attributes selectFctGroup(Attributes imgAttrs, Attributes sharedFctGroups, Attributes frameFctGroups, int tag) {
        if (frameFctGroups == null) {
            return imgAttrs;
        }
        Attributes group = frameFctGroups.getNestedDataset(tag);
        if (group == null && sharedFctGroups != null) {
            group = sharedFctGroups.getNestedDataset(tag);
        }
        return group != null ? group : imgAttrs;
    }

    private Attributes selectVOILUT(Attributes psAttrs, String iuid, int frame) {
        Sequence voiLUTs = psAttrs.getSequence(2634000);
        if (voiLUTs != null) {
            for (Attributes voiLUT : voiLUTs) {
                Sequence refImgs = voiLUT.getSequence(528704);
                if (refImgs == null || refImgs.isEmpty()) {
                    return voiLUT;
                }
                for (Attributes refImg : refImgs) {
                    if (!iuid.equals(refImg.getString(528725))) continue;
                    int[] refFrames = refImg.getInts(528736);
                    if (refFrames == null || refFrames.length == 0) {
                        return voiLUT;
                    }
                    for (int refFrame : refFrames) {
                        if (refFrame != frame) continue;
                        return voiLUT;
                    }
                }
            }
        }
        return null;
    }

    private void readMetadata() throws IOException {
        if (this.metadata != null) {
            return;
        }
        if (this.dis != null) {
            Attributes fmi = this.dis.readFileMetaInformation();
            Attributes ds = this.dis.readDatasetUntilPixelData();
            if (this.dis.tag() == 2145386512) {
                this.imageDescriptor = new ImageDescriptor(ds);
                this.pixelDataVR = this.dis.vr();
                this.pixelDataLength = this.dis.unsignedLength();
                if (this.pixelDataLength == -1L) {
                    this.epdiis = new EncapsulatedPixelDataImageInputStream(this.dis, this.imageDescriptor);
                }
            } else {
                try {
                    this.dis.readAllAttributes(ds);
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
            }
            this.setMetadata(new DicomMetaData(fmi, ds));
            return;
        }
        if (this.iis == null) {
            throw new IllegalStateException("Input not set");
        }
        DicomInputStream dis = new DicomInputStream((InputStream)new ImageInputStreamAdapter(this.iis));
        dis.setIncludeBulkData(DicomInputStream.IncludeBulkData.URI);
        dis.setBulkDataDescriptor(BulkDataDescriptor.PIXELDATA);
        dis.setURI("java:iis");
        Attributes fmi = dis.readFileMetaInformation();
        Attributes ds = dis.readDatasetUntilPixelData();
        if (dis.tag() == 2145386512) {
            this.imageDescriptor = new ImageDescriptor(ds);
            this.pixelDataVR = dis.vr();
            this.pixelDataLength = dis.unsignedLength();
        } else {
            try {
                dis.readAllAttributes(ds);
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        this.setMetadata(new DicomMetaData(fmi, ds));
        this.initPixelDataIIS(dis);
    }

    private void initPixelDataIIS(DicomInputStream dis) throws IOException {
        if (this.pixelDataLength == 0L) {
            return;
        }
        if (this.pixelDataLength > 0L) {
            this.pixelData = new BulkData("pixeldata://", dis.getPosition(), (long)dis.length(), dis.bigEndian());
            this.metadata.getAttributes().setValue(2145386512, this.pixelDataVR, (Object)this.pixelData);
            return;
        }
        dis.readItemHeader();
        byte[] b = new byte[dis.length()];
        dis.readFully(b);
        long start = dis.getPosition();
        this.pixelDataFragments = new Fragments(this.pixelDataVR, dis.bigEndian(), this.frames);
        this.pixelDataFragments.add((Object)b);
        DicomImageReader.generateOffsetLengths(this.pixelDataFragments, this.frames, b, start);
    }

    public static void generateOffsetLengths(Fragments pixelData, int frames, byte[] basicOffsetTable, long start) {
        long lastOffset = 0L;
        BulkData lastFrag = null;
        for (int frame = 0; frame < frames; ++frame) {
            long offset = frame > 0 ? 1L : 0L;
            int offsetStart = frame * 4;
            if (basicOffsetTable.length >= offsetStart + 4 && (offset = (long)ByteUtils.bytesToIntLE((byte[])basicOffsetTable, (int)offsetStart)) != 1L) {
                if ((offset |= lastOffset & 0xFFFFFF00000000L) < lastOffset) {
                    offset += 0x100000000L;
                }
                lastOffset = offset;
                LOG.trace("Found offset {} for frame {}", (Object)offset, (Object)frame);
            }
            long position = -1L;
            if (offset != 1L) {
                position = start + offset + 8L;
            }
            BulkData frag = new BulkData("compressedPixelData://", position, -1L, false);
            if (lastFrag != null && position != -1L) {
                lastFrag.setLength(position - 8L - lastFrag.offset());
            }
            lastFrag = frag;
            pixelData.add((Object)frag);
            if (offset != 0L || frame <= 0) continue;
            start = -1L;
        }
    }

    private void setMetadata(DicomMetaData metadata) {
        this.metadata = metadata;
        Attributes ds = metadata.getAttributes();
        if (this.pixelDataLength != 0L) {
            this.frames = ds.getInt(0x280008, 1);
            this.width = ds.getInt(2621457, 0);
            this.height = ds.getInt(2621456, 0);
            this.samples = ds.getInt(0x280002, 1);
            this.banded = this.samples > 1 && ds.getInt(2621446, 0) != 0;
            this.bitsAllocated = ds.getInt(2621696, 8);
            this.bitsStored = ds.getInt(2621697, this.bitsAllocated);
            this.dataType = this.bitsAllocated <= 8 ? 0 : 1;
            this.pmi = PhotometricInterpretation.fromString((String)ds.getString(2621444, "MONOCHROME2"));
            if (this.pixelDataLength != -1L) {
                this.pmiAfterDecompression = this.pmi;
                this.frameLength = this.pmi.frameLength(this.width, this.height, this.samples, this.bitsAllocated);
            } else {
                Attributes fmi = metadata.getFileMetaInformation();
                if (fmi == null) {
                    throw new IllegalArgumentException("Missing File Meta Information for Data Set with compressed Pixel Data");
                }
                String tsuid = fmi.getString(131088);
                ImageReaderFactory.ImageReaderParam param = ImageReaderFactory.getImageReaderParam(tsuid);
                if (param == null) {
                    throw new UnsupportedOperationException("Unsupported Transfer Syntax: " + tsuid);
                }
                TransferSyntaxType tsType = TransferSyntaxType.forUID(tsuid);
                if (tsType.adjustBitsStoredTo12(ds)) {
                    LOG.info("Adjust invalid Bits Stored: {} of {} to 12", (Object)this.bitsStored, (Object)tsType);
                    this.bitsStored = 12;
                }
                this.pmiAfterDecompression = this.pmi.isYBR() && TransferSyntaxType.isYBRCompression(tsuid) ? PhotometricInterpretation.RGB : this.pmi;
                this.rle = tsuid.equals("1.2.840.10008.1.2.5");
                this.decompressor = ImageReaderFactory.getImageReader(param);
                LOG.debug("Decompressor: {}", (Object)this.decompressor.getClass().getName());
                this.patchJpegLS = param.patchJPEGLS;
            }
        }
    }

    private SampleModel createSampleModel(int dataType, boolean banded) {
        return this.pmi.createSampleModel(dataType, this.width, this.height, this.samples, banded);
    }

    private ImageTypeSpecifier createImageType(int bits, int dataType, boolean banded, ColorSpace cspace) {
        return new ImageTypeSpecifier(this.createColorModel(bits, dataType, cspace), this.createSampleModel(dataType, banded));
    }

    private ColorModel createColorModel(int bits, int dataType, ColorSpace cspace) {
        return this.pmiAfterDecompression.createColorModel(bits, dataType, cspace, this.metadata.getAttributes());
    }

    private void resetInternalState() {
        this.dis = null;
        this.metadata = null;
        this.pixelData = null;
        this.pixelDataFragments = null;
        this.pixelDataVR = null;
        this.pixelDataLength = 0L;
        this.pixeldataBytes = null;
        this.pixelDataFile = null;
        this.frames = 0;
        this.flushedFrames = 0;
        this.width = 0;
        this.height = 0;
        if (this.decompressor != null) {
            this.decompressor.dispose();
            this.decompressor = null;
        }
        this.patchJpegLS = null;
        this.pmi = null;
        this.colorSpaceFactory = null;
    }

    private void checkIndex(int frameIndex) {
        if (this.frames == 0) {
            throw new IllegalStateException("Missing Pixel Data");
        }
        if (frameIndex < 0 || frameIndex >= this.frames) {
            throw new IndexOutOfBoundsException("imageIndex: " + frameIndex);
        }
        if (this.dis != null && frameIndex < this.flushedFrames) {
            throw new IllegalStateException("input stream position already after requested frame #" + (frameIndex + 1));
        }
    }

    public Attributes readPostPixeldata() throws IOException {
        long offset;
        if (this.frames == 0) {
            return this.metadata.getAttributes();
        }
        if (this.dis != null) {
            if (this.flushedFrames > this.frames) {
                return this.metadata.getAttributes();
            }
            this.dis.skipFully((long)((this.frames - this.flushedFrames) * this.frameLength));
            this.flushedFrames = this.frames + 1;
            return this.readPostAttr(this.dis);
        }
        if (this.pixelData != null) {
            offset = this.pixelData.offset() + this.pixelData.longLength();
        } else {
            SegmentedInputImageStream siis = (SegmentedInputImageStream)this.iisOfFrame(-1);
            offset = siis.getOffsetPostPixelData();
        }
        this.iis.seek(offset);
        DicomInputStream dis = new DicomInputStream((InputStream)new ImageInputStreamAdapter(this.iis), this.getTransferSyntaxUID());
        return this.readPostAttr(dis);
    }

    private Attributes readPostAttr(DicomInputStream dis) throws IOException {
        Attributes postAttr = dis.readDataset();
        postAttr.addAll(this.metadata.getAttributes());
        this.metadata = new DicomMetaData(this.metadata.getFileMetaInformation(), postAttr);
        return postAttr;
    }

    @Override
    public void dispose() {
        this.resetInternalState();
    }

    @Override
    public void close() {
        this.dispose();
    }
}

