/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.core.DatasetImpl;
import org.apache.jena.sparql.util.Context;
import virtuoso.jena.driver.VirtDataset;
import virtuoso.jena.driver.VirtGraph;
import virtuoso.jena.driver.VirtuosoQueryExecution;

public class VirtuosoQueryExecutionFactory {
    private VirtuosoQueryExecutionFactory() {
    }

    public static VirtuosoQueryExecution create(Query query, VirtGraph graph) {
        VirtuosoQueryExecution ret = new VirtuosoQueryExecution(query, graph);
        return ret;
    }

    public static VirtuosoQueryExecution create(String query, VirtGraph graph) {
        VirtuosoQueryExecution ret = new VirtuosoQueryExecution(query, graph);
        return ret;
    }

    public static QueryExecution create(Query query, Dataset dataset) {
        if (dataset instanceof VirtDataset) {
            VirtuosoQueryExecution ret = new VirtuosoQueryExecution(query.toString(), (VirtGraph)dataset);
            return ret;
        }
        return VirtuosoQueryExecutionFactory.make(query, dataset);
    }

    public static QueryExecution create(String queryStr, Dataset dataset) {
        if (dataset instanceof VirtDataset) {
            VirtuosoQueryExecution ret = new VirtuosoQueryExecution(queryStr, (VirtGraph)dataset);
            return ret;
        }
        return VirtuosoQueryExecutionFactory.make(VirtuosoQueryExecutionFactory.makeQuery(queryStr), dataset);
    }

    public static QueryExecution create(Query query, Model model) {
        VirtuosoQueryExecutionFactory.checkArg(query);
        VirtuosoQueryExecutionFactory.checkArg(model);
        if (model.getGraph() instanceof VirtGraph) {
            VirtuosoQueryExecution ret = new VirtuosoQueryExecution(query.toString(), (VirtGraph)model.getGraph());
            return ret;
        }
        return VirtuosoQueryExecutionFactory.make(query, (Dataset)new DatasetImpl(model));
    }

    public static QueryExecution create(String queryStr, Model model) {
        VirtuosoQueryExecutionFactory.checkArg(queryStr);
        VirtuosoQueryExecutionFactory.checkArg(model);
        if (model.getGraph() instanceof VirtGraph) {
            VirtuosoQueryExecution ret = new VirtuosoQueryExecution(queryStr, (VirtGraph)model.getGraph());
            return ret;
        }
        return VirtuosoQueryExecutionFactory.create(VirtuosoQueryExecutionFactory.makeQuery(queryStr), model);
    }

    public static QueryExecution create(Query query, VirtGraph graph, QuerySolution initialBinding) {
        VirtuosoQueryExecutionFactory.checkArg(query);
        VirtuosoQueryExecution qe = new VirtuosoQueryExecution(query.toString(), graph);
        if (initialBinding != null) {
            qe.setInitialBinding(initialBinding);
        }
        return qe;
    }

    public static QueryExecution create(String query, VirtGraph graph, QuerySolution initialBinding) {
        VirtuosoQueryExecutionFactory.checkArg(query);
        VirtuosoQueryExecution qe = new VirtuosoQueryExecution(query, graph);
        if (initialBinding != null) {
            qe.setInitialBinding(initialBinding);
        }
        return qe;
    }

    public static QueryExecution create(Query query, Dataset dataset, QuerySolution initialBinding) {
        VirtuosoQueryExecutionFactory.checkArg(query);
        if (dataset instanceof VirtDataset) {
            VirtuosoQueryExecution qe = new VirtuosoQueryExecution(query.toString(), (VirtGraph)dataset);
            if (initialBinding != null) {
                qe.setInitialBinding(initialBinding);
            }
            return qe;
        }
        return VirtuosoQueryExecutionFactory.make(query, dataset);
    }

    public static QueryExecution create(String queryStr, Dataset dataset, QuerySolution initialBinding) {
        VirtuosoQueryExecutionFactory.checkArg(queryStr);
        if (dataset instanceof VirtDataset) {
            VirtuosoQueryExecution qe = new VirtuosoQueryExecution(queryStr, (VirtGraph)dataset);
            if (initialBinding != null) {
                qe.setInitialBinding(initialBinding);
            }
            return qe;
        }
        return VirtuosoQueryExecutionFactory.make(VirtuosoQueryExecutionFactory.makeQuery(queryStr), dataset);
    }

    private static Query makeQuery(String queryStr) {
        return QueryFactory.create((String)queryStr);
    }

    private static QueryExecution make(Query query) {
        return VirtuosoQueryExecutionFactory.make(query, null);
    }

    private static QueryExecution make(Query query, Dataset dataset) {
        return VirtuosoQueryExecutionFactory.make(query, dataset, null);
    }

    private static QueryExecution make(Query query, Dataset dataset, Context context) {
        return null;
    }

    private static void checkNotNull(Object obj, String msg) {
        if (obj == null) {
            throw new IllegalArgumentException(msg);
        }
    }

    private static void checkArg(Model model) {
        VirtuosoQueryExecutionFactory.checkNotNull(model, "Model is a null pointer");
    }

    private static void checkArg(String queryStr) {
        VirtuosoQueryExecutionFactory.checkNotNull(queryStr, "Query string is null");
    }

    private static void checkArg(Query query) {
        VirtuosoQueryExecutionFactory.checkNotNull(query, "Query is null");
    }
}

