/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.core.Quad;
import virtuoso.jena.driver.VirtGraph;
import virtuoso.jena.driver.VirtModel;

public class VirtStreamRDF
implements StreamRDF {
    protected final VirtModel vm;
    protected final VirtGraph vg;
    protected final int batchSize;
    protected final boolean useAutoCommit;
    protected ArrayList<Quad> buff;
    protected final DeadLockHandler dhandler;

    protected VirtStreamRDF(VirtModel vm, boolean useAutoCommit, int batchSize, DeadLockHandler dhandler) {
        this.vm = vm;
        this.vg = (VirtGraph)vm.getGraph();
        this.useAutoCommit = useAutoCommit;
        this.dhandler = dhandler;
        vm.setResetBNodesDictAfterCommit(false);
        if (batchSize > 0) {
            this.vg.setBatchSize(batchSize);
        }
        this.batchSize = this.vg.getBatchSize();
        this.buff = new ArrayList(batchSize);
    }

    public void start() {
        if (!this.useAutoCommit) {
            this.vm.begin();
        }
        try {
            this.vg.startBatchAdd();
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
    }

    public void triple(Triple triple) {
        this.buff.add(new Quad(null, triple));
        this.check_flush(false);
    }

    public void quad(Quad quad) {
        this.buff.add(quad);
        this.check_flush(false);
    }

    public void base(String base) {
    }

    public void prefix(String prefix, String iri) {
        this.vm.setNsPrefix(prefix, iri);
    }

    public void finish() {
        this.check_flush(true);
        try {
            this.vg.stopBatchAdd();
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
        finally {
            this.vm.setResetBNodesDictAfterCommit(true);
        }
    }

    void check_flush(boolean end) throws JenaException {
        if (this.buff.size() >= this.batchSize || end) {
            int pass = 0;
            while (true) {
                try {
                    if (!this.useAutoCommit) {
                        this.vm.begin();
                    }
                    this.vg.streamAdd(this.buff.iterator());
                    if (this.useAutoCommit) break;
                    this.vm.commit();
                }
                catch (Exception e) {
                    boolean deadlock;
                    Throwable ex = e.getCause();
                    boolean bl = deadlock = ex instanceof SQLException && ((SQLException)ex).getSQLState().equals("40001");
                    if (deadlock && this.dhandler != null) {
                        this.vm.abort();
                        boolean rc = this.dhandler.deadLockFired(++pass);
                        if (rc) continue;
                    }
                    throw e;
                }
                break;
            }
            this.buff.clear();
        }
    }

    public static class DeadLockHandler {
        protected final int maxDeadLockCount;

        public DeadLockHandler(int maxDeadLockCount) {
            this.maxDeadLockCount = maxDeadLockCount > 0 ? maxDeadLockCount : 0;
        }

        public boolean deadLockFired(int pass) {
            return this.maxDeadLockCount == 0 || pass <= this.maxDeadLockCount;
        }
    }
}

