/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.mrelib.util;

import cz.zcu.mre.mrelib.util.HashGenerator;

public final class URIUtil {
    private static final String SEPARATOR = "/";

    public static String checksum(String value, boolean checksum, boolean uniq) {
        String output = checksum ? (uniq ? HashGenerator.sha1All(value) : HashGenerator.sha1Text(value)) : value;
        return output;
    }

    public static String property(String base, String name) {
        return URIUtil.resource(base, null, null, name, false, false);
    }

    public static String resource(String base, String value) {
        return URIUtil.resource(base, null, null, value, true, false);
    }

    public static String resource(String base, String type, String name) {
        return URIUtil.resource(base, type, null, name, true, false);
    }

    public static String resource(String base, String type, String typeSeparator, String name, boolean checksum, boolean uniq) {
        StringBuilder sb = new StringBuilder();
        if (base == null) {
            sb.append("https://mre.zcu.cz/id/");
        } else {
            sb.append(base);
        }
        if (type != null) {
            sb.append(type);
            if (typeSeparator == null) {
                sb.append(SEPARATOR);
            } else {
                sb.append(typeSeparator);
            }
        }
        sb.append(URIUtil.checksum(name, checksum, uniq));
        return sb.toString();
    }

    private URIUtil() {
    }
}

