/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.mrelib.util;

import cz.zcu.mre.mrelib.PrefixMap;
import cz.zcu.mre.mrelib.util.DateUtil;
import cz.zcu.mre.mrelib.util.URIUtil;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.StmtIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RDFUtil
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(RDFUtil.class);
    private static final long serialVersionUID = -4492060492382700592L;
    private final Model model;

    public static final Object objectToLiteral(Object object) {
        Model m = ModelFactory.createDefaultModel();
        if (object == null) {
            LOG.warn("Null value");
            return null;
        }
        if (object instanceof Resource || object instanceof Literal || object instanceof Boolean || object instanceof Byte || object instanceof Integer || object instanceof Long || object instanceof Double || object instanceof Float || object instanceof Date || object instanceof Short) {
            return object;
        }
        String value = object.toString();
        if (value.matches("-?\\d+")) {
            try {
                return m.createTypedLiteral((Object)Integer.valueOf(value), (RDFDatatype)XSDDatatype.XSDinteger);
            }
            catch (NumberFormatException e1) {
                try {
                    return m.createTypedLiteral((Object)Long.valueOf(value), (RDFDatatype)XSDDatatype.XSDlong);
                }
                catch (NumberFormatException e2) {
                    try {
                        return m.createTypedLiteral((Object)new BigInteger(value), (RDFDatatype)XSDDatatype.XSDlong);
                    }
                    catch (NumberFormatException e3) {
                        LOG.error("Invalid value {} for both, Integer and Long data type.", (Object)value);
                        LOG.warn("Due to previous error/exception, xsd:string data type used instead of xsd:long for a very big number: {}", (Object)value);
                        return m.createTypedLiteral(value, (RDFDatatype)XSDDatatype.XSDstring);
                    }
                }
            }
        }
        if (value.matches("^([+-]?\\d+\\,?\\d+)$")) {
            try {
                return m.createTypedLiteral((Object)Float.valueOf(value.replace(',', '.')), (RDFDatatype)XSDDatatype.XSDfloat);
            }
            catch (NumberFormatException e) {
                try {
                    return m.createTypedLiteral((Object)Double.valueOf(value.replace(',', '.')), (RDFDatatype)XSDDatatype.XSDdouble);
                }
                catch (NumberFormatException e2) {
                    LOG.error("Invalid format for Float and Double data type in: {}", (Object)value);
                    LOG.error(null, (Throwable)e2);
                }
            }
        } else if (value.matches("^([+-]?\\d+\\.?\\d+)$")) {
            try {
                return m.createTypedLiteral((Object)Float.valueOf(value), (RDFDatatype)XSDDatatype.XSDfloat);
            }
            catch (NumberFormatException e) {
                try {
                    return m.createTypedLiteral((Object)Double.valueOf(value), (RDFDatatype)XSDDatatype.XSDdouble);
                }
                catch (NumberFormatException e2) {
                    LOG.error("Invalid format for Float and Double data type in: {}", (Object)value);
                    LOG.error(null, (Throwable)e2);
                }
            }
        } else if (value.matches("\\d{4}-\\d{2}-\\d{2}")) {
            Date date = DateUtil.stringToDate("yyyy-MM-dd", value);
            if (date != null) {
                return m.createTypedLiteral(DateUtil.format(date, "yyyy-MM-dd"), (RDFDatatype)XSDDatatype.XSDdate);
            }
            LOG.error("Invalid {} date format in: {}", (Object)"yyyy-MM-dd", (Object)value);
        } else if (value.matches("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}")) {
            Date date = DateUtil.stringToDate("yyyy-MM-dd'T'HH:mm:ss", value);
            if (date != null) {
                return m.createTypedLiteral(DateUtil.format(date, "yyyy-MM-dd'T'HH:mm:ssZ"), (RDFDatatype)XSDDatatype.XSDdateTime);
            }
            LOG.error("Invalid yyyy-MM-dd'T'HH:mm:ss date format in: {}", (Object)value);
        } else if (value.matches("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}([+-]\\d{4})?")) {
            Date date = DateUtil.stringToDate("yyyy-MM-dd'T'HH:mm:ssZ", value);
            if (date != null) {
                return m.createTypedLiteral(DateUtil.format(date, "yyyy-MM-dd'T'HH:mm:ssZ"), (RDFDatatype)XSDDatatype.XSDdateTime);
            }
            LOG.error("Invalid yyyy-MM-dd'T'HH:mm:ssZ date format in: {}", (Object)value);
        } else if (value.matches("\\d{2}:\\d{2}:\\d{2}")) {
            Date date = DateUtil.stringToDate("HH:mm:ss", value);
            if (date != null) {
                return m.createTypedLiteral(DateUtil.format(date, "HH:mm:ss"), (RDFDatatype)XSDDatatype.XSDtime);
            }
            LOG.error("Invalid HH:mm:ss date format in: {}", (Object)value);
        } else if (value.matches("\\d{2}:\\d{2}:\\d{2}([+-]\\d{4})?")) {
            Date date = DateUtil.stringToDate("HH:mm:ssZ", value);
            if (date != null) {
                return m.createTypedLiteral(DateUtil.format(date, "HH:mm:ssZ"), (RDFDatatype)XSDDatatype.XSDtime);
            }
            LOG.error("Invalid HH:mm:ssZ date format in: {}", (Object)value);
        }
        return value;
    }

    public RDFUtil(Model m) {
        this.model = m;
    }

    public Property property(String base, String name) {
        return this.model.createProperty(URIUtil.property(base, name));
    }

    public Property prefixedProperty(String prefix, String name) {
        return this.model.createProperty(URIUtil.property(PrefixMap.uri(prefix), name));
    }

    public Resource resource(String uri) {
        return this.model.createResource(uri);
    }

    public Resource resource(String base, String name) {
        return this.resource(base, null, name, false, false);
    }

    public Resource prefixedResource(String prefix, String name) {
        return this.resource(PrefixMap.uri(prefix), null, name, false, false);
    }

    public Resource resource(String base, String type, String name) {
        Resource r = this.resource(base, type, name, true, false);
        return r;
    }

    public Resource prefixedResource(String prefix, String type, String name) {
        Resource r = this.resource(PrefixMap.uri(prefix), type, name, true, false);
        return r;
    }

    public Resource resource(String base, String type, String name, boolean checksum, boolean uniq) {
        Resource r = this.model.createResource(URIUtil.resource(base, type, null, name, checksum, uniq));
        return r;
    }

    public Resource resource(String base, String type, String typeSeparator, String name, boolean checksum, boolean uniq) {
        return this.model.createResource(URIUtil.resource(base, type, typeSeparator, name, checksum, uniq));
    }

    public Resource prefixedResource(String prefix, String type, String typeSeparator, String name, boolean checksum, boolean uniq) {
        return this.model.createResource(URIUtil.resource(PrefixMap.uri(prefix), type, typeSeparator, name, checksum, uniq));
    }

    public Resource mreResource(String name) {
        return this.resource("https://mre.zcu.cz/id/", null, name, true, false);
    }

    public Resource mreResource(String type, String name) {
        Resource r = this.resource("https://mre.zcu.cz/id/", type, name, true, false);
        return r;
    }

    public void add(Resource resource, Property property, String value) {
        if (resource == null || property == null) {
            throw new NullPointerException("s = " + String.valueOf(resource) + " p = " + String.valueOf(property) + " o = " + value);
        }
        if (value == null) {
            LOG.warn("Value is null for subject={} and property={}", (Object)resource.getURI(), (Object)property.getURI());
            return;
        }
        Object literal = RDFUtil.objectToLiteral(value);
        this.triple(resource, property, literal);
    }

    public void add(Resource resource, Property property, Literal literal) {
        this.model.enterCriticalSection(false);
        this.model.add(resource, property, (RDFNode)literal);
        this.model.leaveCriticalSection();
    }

    public void triple(Resource s, Property p, String o) {
        if (s == null || p == null) {
            throw new NullPointerException("ERROR triple: s = " + String.valueOf(s) + " p = " + String.valueOf(p) + " o = " + o);
        }
        if (o != null && !o.isEmpty()) {
            this.model.enterCriticalSection(false);
            this.model.add(s, p, o, (RDFDatatype)XSDDatatype.XSDstring);
            this.model.leaveCriticalSection();
        } else {
            LOG.debug("Value is null for subject={} and property={}", (Object)s, (Object)p);
        }
    }

    public void triple(Resource s, Property p, Boolean o) {
        if (s == null || p == null) {
            throw new NullPointerException("ERROR triple: s = " + String.valueOf(s) + " p = " + String.valueOf(p) + " o = " + o);
        }
        if (o != null) {
            this.model.enterCriticalSection(false);
            this.model.add(s, p, o.toString(), (RDFDatatype)XSDDatatype.XSDboolean);
            this.model.leaveCriticalSection();
        } else {
            LOG.debug("Value is null for subject={} and property={}", (Object)s, (Object)p);
        }
    }

    public void triple(Resource s, Property p, Character o) {
        if (s == null || p == null) {
            throw new NullPointerException("ERROR triple: s = " + String.valueOf(s) + " p = " + String.valueOf(p) + " o = " + o);
        }
        if (o != null) {
            this.model.enterCriticalSection(false);
            this.model.add(s, p, o.toString(), (RDFDatatype)XSDDatatype.XSDstring);
            this.model.leaveCriticalSection();
        } else {
            LOG.debug("Value is null for subject={} and property={}", (Object)s, (Object)p);
        }
    }

    public void triple(Resource s, Property p, Double o) {
        if (s == null || p == null) {
            throw new NullPointerException("ERROR triple: s = " + String.valueOf(s) + " p = " + String.valueOf(p) + " o = " + o);
        }
        if (o != null) {
            this.model.enterCriticalSection(false);
            this.model.add(s, p, o.toString(), (RDFDatatype)XSDDatatype.XSDdouble);
            this.model.leaveCriticalSection();
        } else {
            LOG.debug("Value is null for subject={} and property={}", (Object)s, (Object)p);
        }
    }

    public void triple(Resource s, Property p, Float o) {
        if (s == null || p == null) {
            throw new NullPointerException("ERROR triple: s = " + String.valueOf(s) + " p = " + String.valueOf(p) + " o = " + o);
        }
        if (o != null) {
            this.model.enterCriticalSection(false);
            this.model.add(s, p, o.toString(), (RDFDatatype)XSDDatatype.XSDfloat);
            this.model.leaveCriticalSection();
        } else {
            LOG.debug("Value is null for subject={} and property={}", (Object)s, (Object)p);
        }
    }

    public void triple(Resource s, Property p, Long o) {
        if (s == null || p == null) {
            throw new NullPointerException("ERROR triple: s = " + String.valueOf(s) + " p = " + String.valueOf(p) + " o = " + o);
        }
        if (o != null) {
            this.model.enterCriticalSection(false);
            this.model.add(s, p, o.toString(), (RDFDatatype)XSDDatatype.XSDlong);
            this.model.leaveCriticalSection();
        } else {
            LOG.debug("Value is null for subject={} and property={}", (Object)s, (Object)p);
        }
    }

    public void triple(Resource s, Property p, Integer o) {
        if (s == null || p == null) {
            throw new NullPointerException("ERROR triple: s = " + String.valueOf(s) + " p = " + String.valueOf(p) + " o = " + o);
        }
        if (o != null) {
            this.model.enterCriticalSection(false);
            this.model.add(s, p, o.toString(), (RDFDatatype)XSDDatatype.XSDinteger);
            this.model.leaveCriticalSection();
        } else {
            LOG.debug("Value is null for subject={} and property={}", (Object)s, (Object)p);
        }
    }

    public void triple(Resource s, Property p, Date o, RDFDatatype type) {
        if (s == null || p == null) {
            throw new NullPointerException("ERROR triple: s = " + String.valueOf(s) + " p = " + String.valueOf(p) + " o = " + String.valueOf(o));
        }
        if (o != null) {
            this.model.enterCriticalSection(false);
            if (type == null) {
                this.model.add(s, p, DateUtil.format(o, "yyyy-MM-dd'T'HH:mm:ssZ"));
            } else if (type == XSDDatatype.XSDdate) {
                this.model.add(s, p, DateUtil.format(o, "yyyy-MM-dd"), (RDFDatatype)XSDDatatype.XSDdate);
            } else if (type == XSDDatatype.XSDtime) {
                this.model.add(s, p, DateUtil.format(o, "HH:mm:ssZ"), (RDFDatatype)XSDDatatype.XSDtime);
            } else {
                this.model.add(s, p, DateUtil.format(o, "yyyy-MM-dd'T'HH:mm:ssZ"), (RDFDatatype)XSDDatatype.XSDdateTime);
            }
            this.model.leaveCriticalSection();
        } else {
            LOG.debug("Value is null for subject={} and property={}", (Object)s, (Object)p);
        }
    }

    public void triple(Resource s, Property p, Resource o) {
        if (s == null || p == null) {
            throw new NullPointerException("ERROR triple: s = " + String.valueOf(s) + " p = " + String.valueOf(p) + " o = " + String.valueOf(o));
        }
        if (o != null) {
            this.model.enterCriticalSection(false);
            this.model.add(s, p, (RDFNode)o);
            this.model.leaveCriticalSection();
        } else {
            LOG.debug("Value is null for subject={} and property={}", (Object)s, (Object)p);
        }
    }

    public void triple(Resource s, Property p, Literal o) {
        if (s == null || p == null) {
            throw new NullPointerException("ERROR triple: s = " + String.valueOf(s) + " p = " + String.valueOf(p) + " o = " + String.valueOf(o));
        }
        if (o == null) {
            LOG.debug("Value is null for subject={} and property={}", (Object)s, (Object)p);
            return;
        }
        this.model.enterCriticalSection(false);
        this.model.addLiteral(s, p, o);
        this.model.leaveCriticalSection();
    }

    public void triple(Resource s, Property p, String o, String language) {
        if (s == null || p == null) {
            throw new NullPointerException("ERROR triple: s = " + String.valueOf(s) + " p = " + String.valueOf(p) + " o = " + o);
        }
        if (o != null) {
            this.model.enterCriticalSection(false);
            this.model.add(s, p, o, language);
            this.model.leaveCriticalSection();
        } else {
            LOG.debug("Value is null for subject={} and property={}", (Object)s, (Object)p);
        }
    }

    public void triple(Resource s, Property p, Object o) {
        if (s == null || p == null || o == null) {
            throw new NullPointerException("ERROR triple: s = " + String.valueOf(s) + " p = " + String.valueOf(p) + " o = " + String.valueOf(o));
        }
        if (o instanceof Literal) {
            Literal literal = (Literal)o;
            this.triple(s, p, literal);
        } else if (o instanceof Resource) {
            Resource resource = (Resource)o;
            this.triple(s, p, resource);
        } else if (o instanceof Boolean) {
            Boolean boolean1 = (Boolean)o;
            this.triple(s, p, boolean1);
        } else if (o instanceof Integer) {
            Integer integer = (Integer)o;
            this.triple(s, p, integer);
        } else if (o instanceof Long) {
            Long long1 = (Long)o;
            this.triple(s, p, long1);
        } else if (o instanceof Float) {
            Float float1 = (Float)o;
            this.triple(s, p, float1);
        } else if (o instanceof Double) {
            Double double1 = (Double)o;
            this.triple(s, p, double1);
        } else if (o instanceof Date) {
            Date date = (Date)o;
            this.triple(s, p, date);
        } else if (o instanceof Short) {
            Short short1 = (Short)o;
            this.triple(s, p, short1);
        } else if (o instanceof String) {
            String string = (String)o;
            this.triple(s, p, string);
        } else if (o instanceof Character) {
            Character character = (Character)o;
            this.triple(s, p, character);
        } else {
            this.triple(s, p, o.toString());
        }
    }

    public void update(Resource s, Property p, Object o) {
        if (s == null || p == null || o == null) {
            throw new NullPointerException("ERROR triple: s = " + String.valueOf(s) + " p = " + String.valueOf(p) + " o = " + String.valueOf(o));
        }
        this.model.enterCriticalSection(true);
        StmtIterator stmts = this.model.listStatements(s, p, (String)null);
        List l = stmts.toList();
        this.model.leaveCriticalSection();
        l.stream().map(statement -> {
            this.model.enterCriticalSection(false);
            return statement;
        }).map(statement -> {
            this.model.remove(statement);
            return statement;
        }).forEach(item -> this.model.leaveCriticalSection());
        this.triple(s, p, RDFUtil.objectToLiteral(o));
    }

    public Model getModel() {
        return this.model;
    }
}

