/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.mrelib.util;

import cz.zcu.mre.mrelib.PrefixMap;
import cz.zcu.mre.mrelib.util.ConsoleProgressBar;
import cz.zcu.mre.mrelib.util.QueryThread;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.http.HttpClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.exec.http.QueryExecutionHTTPBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RDFQuery {
    private static final Logger LOG = LoggerFactory.getLogger(RDFQuery.class);
    public static final int DEFAUL_WAIT_MS = 100;
    public static final String DEFAULT_OUTPUT_FORMAT = "csv";
    public static final String DEFAULT_EXPORT_FORMAT = "N-TRIPLE";
    private static String exportFormat = "N-TRIPLE";
    private String fileName = null;
    private List<String> outputFormat = new ArrayList<String>();
    private Model model = null;
    private int threadCount = 1;
    private File outputDirectory;
    private boolean virtuoso = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void outputFormatter(ResultSet results, String f, String outputFormat) {
        FileOutputStream fos = null;
        String file = f + "." + outputFormat;
        try {
            fos = new FileOutputStream(file);
            switch (outputFormat) {
                case "csv": {
                    ResultSetFormatter.outputAsCSV((OutputStream)fos, (ResultSet)results);
                    return;
                }
                case "sse": {
                    ResultSetFormatter.outputAsSSE((OutputStream)fos, (ResultSet)results);
                    return;
                }
                case "tsv": {
                    ResultSetFormatter.outputAsTSV((OutputStream)fos, (ResultSet)results);
                    return;
                }
                case "json": {
                    ResultSetFormatter.outputAsJSON((OutputStream)fos, (ResultSet)results);
                    return;
                }
                case "xml": {
                    ResultSetFormatter.outputAsXML((OutputStream)fos, (ResultSet)results);
                    return;
                }
                case "xmlstring": {
                    ResultSetFormatter.asXMLString((ResultSet)results);
                    return;
                }
                case "text": {
                    ResultSetFormatter.asText((ResultSet)results);
                    return;
                }
                default: {
                    LOG.error("Unknown output format: {}", (Object)outputFormat);
                    return;
                }
            }
        }
        catch (FileNotFoundException ex) {
            LOG.error("Output file not found or no access to {}\n{}", (Object)file, (Object)ex.getMessage());
            return;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                LOG.error(null, (Throwable)ex);
            }
        }
    }

    public static String getExportFormat() {
        if (exportFormat == null) {
            return DEFAULT_EXPORT_FORMAT;
        }
        return exportFormat;
    }

    public static void setExportFormat(String format) {
        exportFormat = format;
    }

    public static ResultSet select(Model m, String q) {
        Query query = QueryFactory.create((String)(String.valueOf(PrefixMap.get()) + q));
        QueryExecution qe = QueryExecutionFactory.create((Query)query, (Model)m);
        ResultSet rs = qe.execSelect();
        return rs;
    }

    public static ResultSet querySPARQLService(String service, HttpClient httpClient, String query) {
        QueryExecution qe = httpClient == null ? (QueryExecution)((QueryExecutionHTTPBuilder)QueryExecution.service((String)service).query(query)).build() : (QueryExecution)((QueryExecutionHTTPBuilder)((QueryExecutionHTTPBuilder)QueryExecution.service((String)service).query(query)).httpClient(httpClient)).build();
        ResultSet results = qe.execSelect();
        return results;
    }

    public static ResultSet querySPARQLService(String service, HttpClient httpClient, String query, List<Object> values) {
        QueryExecution qe = httpClient == null ? (QueryExecution)((QueryExecutionHTTPBuilder)QueryExecution.service((String)service).query(String.format(query, values))).build() : (QueryExecution)((QueryExecutionHTTPBuilder)((QueryExecutionHTTPBuilder)QueryExecution.service((String)service).query(String.format(query, values))).httpClient(httpClient)).build();
        ResultSet results = qe.execSelect();
        return results;
    }

    public RDFQuery() {
    }

    public RDFQuery(Model m) {
        this.setModel(m);
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model m) {
        this.model = m;
    }

    public List<String> getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(List<String> format) {
        this.outputFormat = format;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public synchronized int getThreadCount() {
        return this.threadCount;
    }

    public synchronized void setThreadCount(int count) {
        this.threadCount = count;
    }

    public synchronized File getOutputDirectory() {
        return this.outputDirectory;
    }

    public synchronized void setOutputDirectory(File dir) {
        this.outputDirectory = dir;
    }

    public synchronized void batchQuery(Map<String, String> queries) {
        Set<Map.Entry<String, String>> queriesEntrySet = queries.entrySet();
        Thread[] t = new Thread[this.threadCount];
        ConsoleProgressBar cpb = new ConsoleProgressBar(queries.size());
        cpb.start();
        for (Map.Entry<String, String> entry : queriesEntrySet) {
            LOG.debug("QUERY execute {}", (Object)entry.getKey());
            boolean attached = false;
            while (!attached) {
                for (int i = 0; i < this.threadCount; ++i) {
                    if (t[i] != null && t[i].isAlive()) continue;
                    t[i] = new QueryThread(this, this.model, entry.getValue(), entry.getKey(), this.outputFormat, exportFormat);
                    t[i].setName(entry.getKey());
                    try {
                        t[i].join();
                    }
                    catch (InterruptedException ex) {
                        LOG.error(null, (Throwable)ex);
                    }
                    LOG.info("QUERY EXECUTE {}", (Object)entry.getKey());
                    t[i].start();
                    attached = true;
                    cpb.increment();
                    break;
                }
                try {
                    this.wait(100L);
                }
                catch (InterruptedException ex) {
                    LOG.error(null, (Throwable)ex);
                }
            }
        }
    }

    public boolean isVirtuoso() {
        return this.virtuoso;
    }

    public void setVirtuoso(boolean status) {
        this.virtuoso = status;
    }
}

