/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.mrelib.util;

import cz.zcu.mre.mrelib.Const;
import cz.zcu.mre.mrelib.PrefixMap;
import cz.zcu.mre.mrelib.util.RDFDataAccess;
import cz.zcu.mre.mrelib.util.RDFQuery;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import virtuoso.jena.driver.VirtuosoQueryExecutionFactory;

class QueryThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(QueryThread.class);
    private final RDFQuery rdfQuery;
    private final Model model;
    private final String query;
    private final String file;
    private final List<String> outputFormat;

    QueryThread(RDFQuery rdf, Model m, String q, String f, List<String> of, String ef) {
        this.rdfQuery = rdf;
        this.model = m;
        this.query = q;
        this.file = f;
        this.outputFormat = of;
    }

    @Override
    public void run() {
        LOG.info("QUERY {}, query: {}", (Object)this.getName(), (Object)this.query);
        if (this.outputFormat.isEmpty()) {
            this.outputFormat.add("csv");
        }
        this.outputFormat.stream().forEach(format -> this.doQuery((String)format));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQuery(String format) {
        String[] arr = this.query.split(" ", 2);
        String keyword = arr[0];
        if (keyword.matches("[Pp][Rr][Ee][Ff][Ii][Xx]")) {
            keyword = this.queryKeywordLookup(this.query);
        }
        long milliseconds0 = new Date().getTime();
        try (QueryExecution qe = null;){
            Query q = QueryFactory.create((String)(String.valueOf(PrefixMap.get()) + this.query));
            qe = this.rdfQuery.isVirtuoso() ? VirtuosoQueryExecutionFactory.create((Query)q, (Model)this.model) : QueryExecutionFactory.create((Query)q, (Model)this.model);
            this.outputQueryResult(q, qe, keyword, format);
        }
        long milliseconds1 = new Date().getTime();
        LOG.info("QUERY {}, TIME {} ms, date {}", new Object[]{this.getName(), milliseconds1 - milliseconds0, new Date()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void outputQueryResult(Query q, QueryExecution qe, String keyword, String format) {
        switch (keyword.toLowerCase(Const.LOCALE)) {
            case "ask": {
                Boolean bool = qe.execAsk();
                OutputStream out = null;
                out = new FileOutputStream(this.rdfQuery.getOutputDirectory().getAbsolutePath() + File.separator + this.file + ".ask");
                out.write(bool.toString().getBytes(Const.CHARSET));
                if (out == null) break;
                try {
                    out.close();
                }
                catch (IOException ex) {
                    LOG.error(null, (Throwable)ex);
                }
                break;
                catch (FileNotFoundException ex) {
                    LOG.error(null, (Throwable)ex);
                    if (out == null) break;
                    try {
                        out.close();
                    }
                    catch (IOException ex2) {
                        LOG.error(null, (Throwable)ex2);
                    }
                    break;
                }
                catch (IOException ex2) {
                    LOG.error(null, (Throwable)ex2);
                    if (out == null) break;
                    {
                        catch (Throwable throwable) {
                            if (out != null) {
                                try {
                                    out.close();
                                }
                                catch (IOException ex3) {
                                    LOG.error(null, (Throwable)ex3);
                                }
                            }
                            throw throwable;
                        }
                    }
                    try {
                        out.close();
                    }
                    catch (IOException ex4) {
                        LOG.error(null, (Throwable)ex4);
                    }
                    break;
                }
            }
            case "construct": {
                Model resultModel = qe.execConstruct();
                RDFDataAccess.exportRDFModel(resultModel, new File(this.rdfQuery.getOutputDirectory().getAbsolutePath() + File.separator + this.file + ".rdf"), RDFQuery.getExportFormat());
                break;
            }
            case "describe": {
                Model resultModel = qe.execDescribe();
                RDFDataAccess.exportRDFModel(resultModel, new File(this.rdfQuery.getOutputDirectory().getAbsolutePath() + File.separator + this.file + ".rdf"), RDFQuery.getExportFormat());
                break;
            }
            case "select": {
                ResultSet results = qe.execSelect();
                long milliseconds10 = new Date().getTime();
                RDFQuery.outputFormatter(results, this.rdfQuery.getOutputDirectory().getAbsolutePath() + File.separator + this.file, format);
                long milliseconds11 = new Date().getTime();
                LOG.info("QUERY {}, OUTPUT {} written in {} ms", new Object[]{this.getName(), this.outputFormat, milliseconds11 - milliseconds10});
                break;
            }
            default: {
                LOG.error("Unknown SPARQL keyword ''{}'' for processing the query: {}", (Object)keyword, (Object)q);
            }
        }
    }

    private String queryKeywordLookup(String q) {
        String keyword = "unknown";
        if (q.matches(".*[Ss][Ee][Ll][Ee][Cc][Tt].*")) {
            keyword = "select";
        } else if (q.matches(".*[Aa][Ss][Kk].*")) {
            keyword = "ask";
        } else if (q.matches(".*[Dd][Ee][Ss][Cc][Rr][Ii][Bb][Ee].*")) {
            keyword = "describe";
        } else if (q.matches(".*[Cc][Oo][Nn][Ss][Tt][Rr][Uu][Cc][Tt].*")) {
            keyword = "construct";
        }
        return keyword;
    }
}

