/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.mrelib.util;

import cz.zcu.mre.mrelib.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertiesUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesUtil.class);

    public static String configsRelativePath(String project, String filename) {
        return project.concat(File.separator).concat(filename);
    }

    public static String configsRelativePath(String filename) {
        return PropertiesUtil.configsRelativePath("mre", filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readConfigs(String projectDirName, String filename) {
        String project;
        if (projectDirName == null) {
            LOG.warn("Null project dir name string. Using default project folder: {}", (Object)"mre");
            project = "mre";
        } else {
            project = projectDirName.trim();
        }
        Properties properties = new Properties();
        File file = new File(FileUtil.USER_HOME_PATH.concat(PropertiesUtil.configsRelativePath(project, filename)));
        FileInputStream fis = null;
        try {
            if (file.exists() && file.canRead()) {
                fis = new FileInputStream(file);
                properties.load(fis);
            } else {
                if (FileUtil.IS_UNIX) {
                    file = new File(FileUtil.UNIX_SYSTEM_LOCATION.concat(PropertiesUtil.configsRelativePath(project, filename)));
                } else if (FileUtil.IS_WINDOWS) {
                    file = new File(FileUtil.WINDOWS_SYSTEM_LOCATION.concat(PropertiesUtil.configsRelativePath(project, filename)));
                }
                if (file.exists() && file.canRead()) {
                    fis = new FileInputStream(file);
                    properties.load(fis);
                    LOG.info("Loaded {} by {}", (Object)filename, (Object)file.getAbsolutePath());
                } else {
                    LOG.warn("Unable to load {} from file {}", (Object)filename, (Object)file.getAbsolutePath());
                    InputStream is = ClassLoader.getSystemResourceAsStream(filename);
                    if (is != null) {
                        properties.load(is);
                        LOG.info("Loaded {} by ClassLoader.getSystemResourceAsStream() method", (Object)filename);
                    }
                    if (is == null && (is = PropertiesUtil.class.getResourceAsStream(filename)) != null) {
                        properties.load(is);
                        LOG.info("Loaded {} by PropertiesUtil.class.getResourceAsStream() method", (Object)filename);
                    }
                    if (is == null && PropertiesUtil.class.getClass().getClassLoader() != null && (is = PropertiesUtil.class.getClass().getClassLoader().getResourceAsStream(filename)) != null) {
                        properties.load(is);
                        LOG.info("Loaded {} by PropertiesUtil.class.getClass().getClassLoader() method", (Object)filename);
                    } else {
                        LOG.warn("Unable to load any {}", (Object)filename);
                    }
                    if (is != null) {
                        is.close();
                    }
                }
            }
        }
        catch (FileNotFoundException ex) {
            LOG.error(null, (Throwable)ex);
        }
        catch (IOException ex) {
            LOG.error(null, (Throwable)ex);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    LOG.error(null, (Throwable)ex);
                }
            }
        }
        return properties;
    }

    public static Properties readConfigs(String filename) {
        return PropertiesUtil.readConfigs("mre", filename);
    }

    private PropertiesUtil() {
    }
}

