/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.mrelib.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleProgressBar
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(ConsoleProgressBar.class);
    private static final char[] STATUS_CHARS = new char[]{'|', '/', '-', '\\'};
    private static final int WAIT_TIME = 2000;
    private static final int FINISH_ON_PERCENT_VALUE = 100;
    private double status = 0.0;
    private int finalValue = 100;
    private int actualValue = 0;
    private int threadCount = 0;

    public ConsoleProgressBar(int total) {
        this.finalValue = total;
    }

    @Override
    public final synchronized void run() {
        if (System.console() == null) {
            LOG.info("ConsoleProgressBar is disabled - no tty availaible.");
            return;
        }
        LOG.info("ConsoleProgressBar is enabled.");
        this.threadCount = 1;
        while (this.actualValue < this.finalValue) {
            this.status = (double)this.actualValue / (double)this.finalValue * 100.0;
            System.out.printf("Processing: %.2f %% done %c ... left %d/%d item(s).                \r", this.status, Character.valueOf(STATUS_CHARS[(int)this.status % STATUS_CHARS.length]), this.actualValue, this.finalValue);
            try {
                this.wait(2000L);
            }
            catch (InterruptedException ex) {
                LOG.error(null, (Throwable)ex);
            }
        }
    }

    public final synchronized void setActualValue(int value) {
        this.actualValue = value;
    }

    public final synchronized void increment() {
        ++this.actualValue;
    }

    public final synchronized int getFinalValue() {
        return this.finalValue;
    }

    public final synchronized void setFinalValue(int value) {
        this.finalValue = value;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void close() {
        this.setActualValue(this.getFinalValue());
    }
}

