/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.mrelib.cipher;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MRECipher {
    private static final Logger LOG = LoggerFactory.getLogger(MRECipher.class);
    public static final String DEFAULT_SYMETRIC_ALG = "AES";
    private static final String DEFAULT_SYMETRIC_KEY = "1234567812345678";
    public static final String DEFAULT_ASYMETRIC_ALG = "RSA";
    public static final String DEFAULT_ASYMETRIC_ALG_WITH_PADDING = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";
    public static final int DEFAULT_ASYMETRIC_KEY_SIZE = 4096;
    private String algorithm = "AES";
    private String key = "1234567812345678";

    public static String encrypt(String pKey, String message) {
        return MRECipher.encrypt(DEFAULT_SYMETRIC_ALG, pKey, message);
    }

    public static String encrypt(SecretKey pKey, String message) {
        return MRECipher.encrypt(DEFAULT_SYMETRIC_ALG, pKey, message);
    }

    public static String encrypt(String pAlgorithm, SecretKey key, String message) {
        if (message == null) {
            LOG.warn("Encryption of null message. Result is null value.");
            return null;
        }
        String encryptedtext = null;
        try {
            Cipher cipher = Cipher.getInstance(pAlgorithm);
            cipher.init(1, key);
            byte[] encrypted = cipher.doFinal(message.getBytes(StandardCharsets.UTF_8));
            encryptedtext = DatatypeConverter.printBase64Binary((byte[])encrypted);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            LOG.error("Encryption failed", (Throwable)e);
        }
        return encryptedtext;
    }

    public static String encrypt(String pAlgorithm, String pKey, String message) {
        if (message == null) {
            LOG.warn("Encryption of null message. Result is null value.");
            return null;
        }
        String encodedText = null;
        try {
            SecretKeySpec key = new SecretKeySpec(pKey.getBytes(StandardCharsets.UTF_8), pAlgorithm);
            Cipher cipher = Cipher.getInstance(pAlgorithm);
            cipher.init(1, key);
            byte[] encrypted = cipher.doFinal(message.getBytes(StandardCharsets.UTF_8));
            encodedText = DatatypeConverter.printBase64Binary((byte[])encrypted);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            LOG.error("Encryption failed", (Throwable)e);
        }
        return encodedText;
    }

    public static String decrypt(SecretKey key, String encoded) {
        return MRECipher.decrypt(DEFAULT_SYMETRIC_ALG, key, encoded);
    }

    public static String decrypt(String pAlgorithm, SecretKey key, String encoded) {
        if (encoded == null) {
            LOG.warn("Decryption of null message. Result is null value.");
            return null;
        }
        String message = null;
        try {
            Cipher cipher = Cipher.getInstance(pAlgorithm);
            cipher.init(2, key);
            byte[] encrypted = DatatypeConverter.parseBase64Binary((String)encoded);
            message = new String(cipher.doFinal(encrypted), StandardCharsets.UTF_8);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            LOG.error("Decryption failed", (Throwable)e);
        }
        return message;
    }

    public static String decrypt(String pKey, String encoded) {
        return MRECipher.decrypt(DEFAULT_SYMETRIC_ALG, pKey, encoded);
    }

    public static String decrypt(String pAlgorithm, String pKey, String encoded) {
        if (encoded == null) {
            LOG.warn("Decryption of null message. Result is null value.");
            return null;
        }
        String message = null;
        try {
            SecretKeySpec aesKey = new SecretKeySpec(pKey.getBytes(StandardCharsets.UTF_8), pAlgorithm);
            Cipher cipher = Cipher.getInstance(pAlgorithm);
            cipher.init(2, aesKey);
            byte[] encrypted = DatatypeConverter.parseBase64Binary((String)encoded);
            message = new String(cipher.doFinal(encrypted), StandardCharsets.UTF_8);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            LOG.error("Decryption failed", (Throwable)e);
        }
        return message;
    }

    public static KeyPair buildKeyPair() throws NoSuchAlgorithmException {
        return MRECipher.buildKeyPair(DEFAULT_ASYMETRIC_ALG, 4096);
    }

    public static KeyPair buildKeyPair(String algorithm, int keySize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(algorithm);
        keyPairGenerator.initialize(keySize);
        return keyPairGenerator.genKeyPair();
    }

    public static String encrypt(PublicKey publicKey, String message) {
        if (message == null) {
            LOG.warn("Encryption of null message. Result is null value.");
            return null;
        }
        String encodedText = null;
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_ASYMETRIC_ALG_WITH_PADDING);
            cipher.init(1, publicKey);
            byte[] encrypted = cipher.doFinal(message.getBytes(StandardCharsets.UTF_8));
            encodedText = DatatypeConverter.printBase64Binary((byte[])encrypted);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            LOG.error("Encryption failed", (Throwable)ex);
        }
        return encodedText;
    }

    public static String decrypt(PublicKey publicKey, String encoded) {
        if (encoded == null) {
            LOG.warn("Decryption of null message. Result is null value.");
            return null;
        }
        String message = null;
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_ASYMETRIC_ALG_WITH_PADDING);
            cipher.init(2, publicKey);
            byte[] encrypted = DatatypeConverter.parseBase64Binary((String)encoded);
            message = new String(cipher.doFinal(encrypted), StandardCharsets.UTF_8);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            LOG.error("Decryption failed", (Throwable)ex);
        }
        return message;
    }

    public static String decrypt(PrivateKey privateKey, String encoded) {
        if (encoded == null) {
            LOG.warn("Decryption of null message. Result is null value.");
            return null;
        }
        String message = null;
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_ASYMETRIC_ALG_WITH_PADDING);
            cipher.init(2, privateKey);
            byte[] encrypted = DatatypeConverter.parseBase64Binary((String)encoded);
            message = new String(cipher.doFinal(encrypted), StandardCharsets.UTF_8);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            LOG.error("Decryption failed", (Throwable)ex);
        }
        return message;
    }

    public static String sign(String plainText, PrivateKey privateKey) {
        if (plainText == null) {
            LOG.warn("Signing of null message. Result is null value.");
            return null;
        }
        try {
            Signature privateSignature = Signature.getInstance("SHA256withRSA");
            privateSignature.initSign(privateKey);
            privateSignature.update(plainText.getBytes(StandardCharsets.UTF_8));
            byte[] signature = privateSignature.sign();
            return Base64.getEncoder().encodeToString(signature);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException ex) {
            LOG.error("Signing failed", (Throwable)ex);
            return null;
        }
    }

    public static boolean verify(String plainText, String signature, PublicKey publicKey) {
        if (plainText == null) {
            LOG.warn("Verification of null message. Result is null value.");
            return false;
        }
        try {
            Signature publicSignature = Signature.getInstance("SHA256withRSA");
            publicSignature.initVerify(publicKey);
            publicSignature.update(plainText.getBytes(StandardCharsets.UTF_8));
            byte[] signatureBytes = Base64.getDecoder().decode(signature);
            return publicSignature.verify(signatureBytes);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException ex) {
            LOG.error("Verification failed", (Throwable)ex);
            return false;
        }
    }

    @Deprecated
    public String encrypt(String message) {
        return MRECipher.encrypt(this.algorithm, this.key, message);
    }

    @Deprecated
    public String decrypt(String encoded) {
        return MRECipher.decrypt(this.algorithm, this.key, encoded);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm == null || algorithm.isEmpty() ? DEFAULT_SYMETRIC_ALG : algorithm;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

