/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.mrelib.cipher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KeyDatabase {
    public static final String LIBMED_X500_PRINCIPAL = "CN=LibMed, OU=medical.zcu.cz, O=ZCU, C=CS";
    private static final Logger LOG = LoggerFactory.getLogger(KeyDatabase.class);
    private static final String DEFAULT_FILE_PREFIX = "anonmed";
    public static final String DEFAULT_CONTEXT = "default";
    private static final String DEFAULT_SYMMETRIC_ALG = "AES";
    private static final String DEFAULT_ASYMMETRIC_ALG = "RSA";
    private static final int DEFAULT_SYMMETRIC_KEY_SIZE = 32;
    private static final int DEFAULT_ASYMMETRIC_KEY_SIZE = 4096;
    private static final String DEFAULT_KEYSTORE_TYPE = "JCEKS";
    private static final Map<String, KeyStore> keyStoreMap = new HashMap<String, KeyStore>();
    private static final String DEFAULT_PASSWOWRD = "MRELib";
    private static String password = null;
    private static KeyStore.PasswordProtection passwordProtection;
    private static File keyDirectory;
    private String filePrefix = "anonmed";
    private String algorighmSymmetric = "AES";
    private String algorithmAsymmetric = "RSA";
    private int algorithmAsymmetricSize = 4096;
    private String principal = "CN=LibMed, OU=medical.zcu.cz, O=ZCU, C=CS";

    public static void setKeyDirectory(File keyDirectory) {
        if (!(keyDirectory != null && keyDirectory.exists() && keyDirectory.isDirectory() && keyDirectory.canRead() && keyDirectory.canWrite())) {
            LOG.error("Wrong directory with keys ({}): missing, not a directory or no read/write access.", (Object)keyDirectory);
        }
        KeyDatabase.keyDirectory = keyDirectory;
    }

    public static void setPassword(String password) {
        KeyDatabase.password = password;
        passwordProtection = new KeyStore.PasswordProtection(password.toCharArray());
    }

    public KeyDatabase() {
        KeyDatabase.setPassword(DEFAULT_PASSWOWRD);
    }

    public synchronized SecretKey keySymmetric(String id) {
        return this.keySymmetric(id, DEFAULT_CONTEXT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SecretKey keySymmetric(String id, String context) {
        KEY_TYPE keyType = KEY_TYPE.SYMMETRIC;
        KeyStore keyStore = this.getKeyStore(keyType, context);
        if (keyStore == null) {
            return null;
        }
        try {
            KeyStore.Entry entry = keyStore.getEntry(id, passwordProtection);
            if (entry != null) {
                SecretKey keyRetrieved = ((KeyStore.SecretKeyEntry)entry).getSecretKey();
                LOG.debug("Symmetric key for '{}' and '{}' context found in keystore", (Object)id, (Object)context);
                return keyRetrieved;
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException ex) {
            LOG.error("", (Throwable)ex);
        }
        SecretKey symmetricKey = null;
        FileOutputStream fos = null;
        try {
            KeyGenerator kg = KeyGenerator.getInstance(this.algorighmSymmetric);
            symmetricKey = kg.generateKey();
            KeyStore.SecretKeyEntry keyStoreEntry = new KeyStore.SecretKeyEntry(symmetricKey);
            keyStore.setEntry(id, keyStoreEntry, passwordProtection);
            LOG.debug("New symmetric key for '{}' and '{}' context with length {} stored in keystore", new Object[]{id, context, 32});
            File keyStoreFile = this.getKeyStoreFile(context, keyType);
            fos = new FileOutputStream(keyStoreFile);
            keyStore.store(fos, password.toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
            LOG.error("", (Throwable)ex);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ex) {
                    LOG.error("", (Throwable)ex);
                }
            }
        }
        return symmetricKey;
    }

    public synchronized boolean hasKeySymmetric(String id) {
        return this.hasKeySymmetric(id, DEFAULT_CONTEXT);
    }

    public synchronized boolean hasKeySymmetric(String id, String context) {
        KEY_TYPE keyType = KEY_TYPE.SYMMETRIC;
        KeyStore keyStore = this.getKeyStore(keyType, context);
        if (keyStore == null) {
            return false;
        }
        try {
            KeyStore.Entry entry = keyStore.getEntry(id, passwordProtection);
            if (entry != null) {
                SecretKey keyRetrieved = ((KeyStore.SecretKeyEntry)entry).getSecretKey();
                LOG.debug("Symmetric key for '{}' and '{}' context found={} in keystore", new Object[]{id, context, keyRetrieved != null});
                return keyRetrieved != null;
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException ex) {
            LOG.error("", (Throwable)ex);
        }
        return false;
    }

    public synchronized boolean deleteKeyAsymmetric(String id) {
        return this.deleteKey(KEY_TYPE.ASYMMETRIC, id, DEFAULT_CONTEXT);
    }

    public synchronized boolean deleteKeyAsymmetric(String id, String context) {
        return this.deleteKey(KEY_TYPE.ASYMMETRIC, id, context);
    }

    public synchronized boolean deleteKeySymmetric(String id) {
        return this.deleteKey(KEY_TYPE.SYMMETRIC, id, DEFAULT_CONTEXT);
    }

    public synchronized boolean deleteKeySymmetric(String id, String context) {
        return this.deleteKey(KEY_TYPE.SYMMETRIC, id, context);
    }

    private synchronized boolean deleteKey(KEY_TYPE keyType, String id, String context) {
        KeyStore keyStore = this.getKeyStore(keyType, context);
        if (keyStore == null) {
            return false;
        }
        try {
            keyStore.deleteEntry(id);
            LOG.info("Key with name/alias '{}' were removed", (Object)id);
            return true;
        }
        catch (KeyStoreException ex) {
            LOG.error("", (Throwable)ex);
            return false;
        }
    }

    public synchronized PrivateKey keyPrivate(String id) {
        return this.keyPrivate(id, DEFAULT_CONTEXT, this.principal);
    }

    public synchronized PrivateKey keyPrivate(String id, String context) {
        return this.keyPrivate(id, context, this.principal);
    }

    public synchronized PrivateKey keyPrivate(String id, String context, String principal) {
        KeyPair keyPair = this.keyAsymmetric(id, context, principal);
        if (keyPair == null) {
            return null;
        }
        return keyPair.getPrivate();
    }

    public synchronized PublicKey keyPublic(String id) {
        return this.keyPublic(id, DEFAULT_CONTEXT, this.principal);
    }

    public synchronized PublicKey keyPublic(String id, String context) {
        return this.keyPublic(id, context, this.principal);
    }

    public synchronized PublicKey keyPublic(String id, String context, String principal) {
        KeyPair keyPair = this.keyAsymmetric(id, context, principal);
        if (keyPair == null) {
            return null;
        }
        return keyPair.getPublic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized KeyPair keyAsymmetric(String id, String context, String principal) {
        KEY_TYPE keyType = KEY_TYPE.ASYMMETRIC;
        KeyStore keyStore = this.getKeyStore(keyType, context);
        KeyPair keyPair = null;
        try {
            Key key = keyStore.getKey(id, password.toCharArray());
            if (key instanceof PrivateKey) {
                PrivateKey privateKey = (PrivateKey)key;
                Certificate cert = keyStore.getCertificate(id);
                PublicKey publicKey = cert.getPublicKey();
                LOG.debug("Asymmetric key pair (public/private) for '{}' and '{}' context found in keystore", (Object)id, (Object)context);
                return new KeyPair(publicKey, privateKey);
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ex) {
            LOG.error("", (Throwable)ex);
        }
        FileOutputStream fos = null;
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(this.algorithmAsymmetric);
            keyPairGenerator.initialize(this.algorithmAsymmetricSize);
            keyPair = keyPairGenerator.genKeyPair();
            Certificate certificate = this.generateSelfSignedCertificate(keyPair, principal);
            KeyStore.PrivateKeyEntry entry = new KeyStore.PrivateKeyEntry(keyPair.getPrivate(), new Certificate[]{certificate});
            keyStore.setEntry(id, entry, new KeyStore.PasswordProtection(password.toCharArray()));
            File keyStoreFile = this.getKeyStoreFile(context, keyType);
            fos = new FileOutputStream(keyStoreFile);
            keyStore.store(fos, password.toCharArray());
            LOG.debug("New asymmetric key pair (private/public) for '{}' and '{}' context were stored in keystore", (Object)id, (Object)context);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
            LOG.error("", (Throwable)ex);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ex) {
                    LOG.error("", (Throwable)ex);
                }
            }
        }
        return keyPair;
    }

    public synchronized boolean hasKeyAsymmetric(String id) {
        return this.hasKeyAsymmetric(id, DEFAULT_CONTEXT);
    }

    public synchronized boolean hasKeyAsymmetric(String id, String context) {
        KEY_TYPE keyType = KEY_TYPE.ASYMMETRIC;
        KeyStore keyStore = this.getKeyStore(keyType, context);
        try {
            Key key = keyStore.getKey(id, password.toCharArray());
            if (key instanceof PrivateKey) {
                Certificate cert = keyStore.getCertificate(id);
                PublicKey publicKey = cert.getPublicKey();
                LOG.debug("Asymmetric key pair (public/private) for '{}' and '{}' context found={} in keystore", new Object[]{id, context, publicKey != null});
                return publicKey != null;
            }
            return false;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ex) {
            LOG.error("", (Throwable)ex);
            return false;
        }
    }

    public Certificate generateSelfSignedCertificate(KeyPair keyPair, String dn) {
        try {
            ContentSigner signer = new JcaContentSignerBuilder("SHA1WithRSA").setProvider((Provider)new BouncyCastleProvider()).build(keyPair.getPrivate());
            Calendar start = Calendar.getInstance();
            Calendar expiry = Calendar.getInstance();
            expiry.add(1, 1000);
            X500Principal principalX500 = new X500Principal(dn);
            JcaX509v3CertificateBuilder certificateBuilder = new JcaX509v3CertificateBuilder(principalX500, BigInteger.valueOf(Calendar.getInstance().getTimeInMillis()).abs(), start.getTime(), expiry.getTime(), principalX500, keyPair.getPublic());
            X509CertificateHolder holder = certificateBuilder.build(signer);
            X509Certificate cert = new JcaX509CertificateConverter().setProvider((Provider)new BouncyCastleProvider()).getCertificate(holder);
            return cert;
        }
        catch (CertificateException | OperatorCreationException ex) {
            java.util.logging.Logger.getLogger(KeyDatabase.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore getKeyStore(KEY_TYPE keyType, String context) {
        String keyStoreCode = context + String.valueOf((Object)keyType);
        if (keyStoreMap.containsKey(keyStoreCode)) {
            return keyStoreMap.get(keyStoreCode);
        }
        File keyStoreFile = this.getKeyStoreFile(context, keyType);
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance(DEFAULT_KEYSTORE_TYPE);
            keyStore.load(null, null);
        }
        catch (KeyStoreException ex) {
            LOG.error(null, (Throwable)ex);
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException ex) {
            java.util.logging.Logger.getLogger(KeyDatabase.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (keyStore != null) {
            FileInputStream fis = null;
            if (keyStoreFile.exists()) {
                try {
                    fis = new FileInputStream(keyStoreFile);
                    keyStore.load(fis, password.toCharArray());
                }
                catch (FileNotFoundException ex) {
                    LOG.error("", (Throwable)ex);
                }
                catch (IOException | NoSuchAlgorithmException | CertificateException ex) {
                    LOG.error("", (Throwable)ex);
                }
                finally {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException ex) {
                        LOG.error("", (Throwable)ex);
                    }
                }
            } else {
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(keyStoreFile);
                    keyStore.load(null, password.toCharArray());
                    keyStore.store(fos, password.toCharArray());
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
                    LOG.error("", (Throwable)ex);
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException ex) {
                            LOG.error("", (Throwable)ex);
                        }
                    }
                }
            }
        }
        keyStoreMap.put(keyStoreCode, keyStore);
        return keyStore;
    }

    private File getKeyStoreFile(String context, KEY_TYPE keyType) {
        return new File(keyDirectory.getAbsolutePath().concat(File.separator).concat(this.filePrefix).concat("-").concat(context).concat("-").concat(keyType == KEY_TYPE.SYMMETRIC ? this.algorighmSymmetric.toLowerCase() : this.algorithmAsymmetric.toLowerCase()).concat(".jks"));
    }

    public String getAlgorighmSymmetric() {
        return this.algorighmSymmetric;
    }

    public void setAlgorighmSymmetric(String algorighmSymmetric) {
        this.algorighmSymmetric = algorighmSymmetric;
    }

    public String getAlgorithmAsymmetric() {
        return this.algorithmAsymmetric;
    }

    public void setAlgorithmAsymmetric(String algorithmAsymmetric) {
        this.algorithmAsymmetric = algorithmAsymmetric;
    }

    public int getAlgorithmAsymmetricSize() {
        return this.algorithmAsymmetricSize;
    }

    public void setAlgorithmAsymmetricSize(int algorithmAsymmetricSize) {
        this.algorithmAsymmetricSize = algorithmAsymmetricSize;
    }

    public synchronized String getPrincipal() {
        return this.principal;
    }

    public synchronized void setPrincipal(String principal) {
        this.principal = principal;
    }

    public String getFilePrefix() {
        return this.filePrefix;
    }

    public void setFilePrefix(String filePrefix) {
        this.filePrefix = filePrefix;
    }

    static {
        keyDirectory = new File(System.getProperty("user.dir"));
    }

    private static enum KEY_TYPE {
        SYMMETRIC,
        ASYMMETRIC;

    }
}

