/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.mrelib.cipher;

import cz.zcu.mre.mrelib.cipher.CipherService;
import cz.zcu.mre.mrelib.cipher.KeyDatabase;
import cz.zcu.mre.mrelib.cipher.MRECipher;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCipherServiceImpl
implements CipherService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCipherServiceImpl.class);
    private static final String DEFAULT_KEY_ALIAS = "default";
    private static final String DEFAULT_CONTEXT = "default";
    private KeyDatabase keyDatabase;
    private String context = "default";

    public DefaultCipherServiceImpl() {
    }

    public DefaultCipherServiceImpl(KeyDatabase keyDB) {
        this.setKeyDatabase(keyDB);
    }

    public KeyDatabase getKeyDatabase() {
        return this.keyDatabase;
    }

    public final void setKeyDatabase(KeyDatabase keyDatabase) {
        this.keyDatabase = keyDatabase;
    }

    @Override
    public String encrypt(String alg, String content) {
        return this.encrypt(alg, content, "default");
    }

    @Override
    public String encrypt(String alg, String content, String keyAlias) {
        String alias = keyAlias == null || keyAlias.isEmpty() ? "default" : keyAlias.trim().toLowerCase();
        if (this.isSymmetric(alg)) {
            SecretKey key = this.keyDatabase.keySymmetric(alias, this.context);
            return MRECipher.encrypt(key, content);
        }
        PublicKey key = this.keyDatabase.keyPublic(alias, this.context);
        return MRECipher.encrypt(key, content);
    }

    @Override
    public String decrypt(String alg, String encrypted) {
        return this.decrypt(alg, encrypted, "default");
    }

    @Override
    public String decrypt(String alg, String encrypted, String keyAlias) {
        String alias = keyAlias == null || keyAlias.isEmpty() ? "default" : keyAlias.trim().toLowerCase();
        if (this.isSymmetric(alg)) {
            if (this.keyDatabase.hasKeySymmetric(alias, this.context)) {
                SecretKey key = this.keyDatabase.keySymmetric(alias, this.context);
                return MRECipher.decrypt(key, encrypted);
            }
        } else if (this.keyDatabase.hasKeyAsymmetric(alias, this.context)) {
            PrivateKey key = this.keyDatabase.keyPrivate(alias, this.context);
            return MRECipher.decrypt(key, encrypted);
        }
        return null;
    }

    private boolean isSymmetric(String alg) {
        switch (alg.trim().toLowerCase()) {
            case "aes": {
                return true;
            }
            case "rsa": {
                return false;
            }
        }
        LOG.error("Not supported algorithm {}", (Object)alg);
        return false;
    }

    @Override
    public String getContext() {
        return this.context;
    }

    @Override
    public void setContext(String context) {
        this.context = context != null && !context.isEmpty() ? context : "default";
    }
}

