/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;

class VirtX509KeyManager
extends X509ExtendedKeyManager {
    X509KeyManager defaultKeyManager;
    String defAlias;
    KeyStore tks;
    ArrayList<X509Certificate> certs = new ArrayList(32);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtX509KeyManager(String cert_alias, String keys_file, String keys_pwd, KeyStore tks) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        KeyStore ks = keys_file.endsWith(".p12") || keys_file.endsWith(".pfx") ? KeyStore.getInstance("PKCS12") : KeyStore.getInstance("JKS");
        try (FileInputStream is = null;){
            is = new FileInputStream(keys_file);
            ks.load(is, keys_pwd.toCharArray());
        }
        if (cert_alias == null) {
            String alias = null;
            Enumeration<String> en = ks.aliases();
            if (en.hasMoreElements()) {
                alias = en.nextElement();
                ks.isKeyEntry(alias);
            }
            this.defAlias = alias;
        } else {
            if (!ks.containsAlias(cert_alias)) {
                throw new KeyStoreException("Could not found alias:[" + cert_alias + "] in KeyStore :" + keys_file);
            }
            this.defAlias = cert_alias;
        }
        this.certs.add((X509Certificate)ks.getCertificate(this.defAlias));
        if (tks != null) {
            Enumeration<String> en = tks.aliases();
            while (en.hasMoreElements()) {
                String alias = en.nextElement();
                this.certs.add((X509Certificate)tks.getCertificate(alias));
            }
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(ks, keys_pwd.toCharArray());
        this.defaultKeyManager = (X509KeyManager)kmf.getKeyManagers()[0];
    }

    @Override
    public String[] getClientAliases(String s, Principal[] principals) {
        return this.defaultKeyManager.getClientAliases(s, principals);
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return this.defAlias;
    }

    @Override
    public String[] getServerAliases(String s, Principal[] principals) {
        return this.defaultKeyManager.getServerAliases(s, principals);
    }

    @Override
    public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
        return this.defaultKeyManager.chooseServerAlias(s, principals, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String s) {
        return this.defaultKeyManager.getCertificateChain(s);
    }

    @Override
    public PrivateKey getPrivateKey(String s) {
        return this.defaultKeyManager.getPrivateKey(s);
    }
}

