/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import virtuoso.jdbc4.VirtuosoDate;
import virtuoso.jdbc4.VirtuosoTime;
import virtuoso.jdbc4.VirtuosoTimestamp;

class DateObject {
    Calendar cal_dat = new GregorianCalendar();
    int day;
    int hour;
    int minute;
    int second;
    int fraction;
    int tz;
    int type;
    static final int SPERDAY = 86400;
    static final int GREG_JDAYS = 577737;
    static final int GREG_LAST_DAY = 14;
    static final int GREG_FIRST_DAY = 5;
    static final int GREG_MONTH = 10;
    static final int GREG_YEAR = 1582;
    static final int DAY_LAST = 365;
    static final int DAY_MIN = 1;
    static final int MONTH_MIN = 1;
    static final int MONTH_MAX = 12;
    static final int MONTH_LAST = 31;
    static final int[] days_in_month = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    protected DateObject(int _day, int _hour, int _minute, int _second, int _fraction, int _tz, int _type) {
        this.day = _day;
        this.hour = _hour;
        this.minute = _minute;
        this.second = _second;
        this.fraction = _fraction;
        this.tz = _tz;
        this.type = _type;
    }

    protected Object getValue(boolean sparql_executed) {
        if (sparql_executed) {
            GregorianCalendar cal_gmt = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            this.num2date(this.day, cal_gmt);
            cal_gmt.set(11, this.hour);
            cal_gmt.set(12, this.minute);
            cal_gmt.set(13, this.second);
            cal_gmt.set(14, this.fraction / 1000);
            this.cal_dat.setTime(cal_gmt.getTime());
        } else {
            if (this.tz != 0) {
                int sec = DateObject.time_to_sec(0, this.hour, this.minute, this.second);
                if ((sec += 60 * this.tz) < 0) {
                    this.day -= 1 + -sec / 86400;
                    if ((sec %= 86400) == 0) {
                        ++this.day;
                    }
                    sec = 86400 + sec;
                } else {
                    this.day += sec / 86400;
                    sec %= 86400;
                }
                int dummy_day = sec / 86400;
                this.hour = (sec - dummy_day * 86400) / 3600;
                this.minute = (sec - dummy_day * 86400 - this.hour * 60 * 60) / 60;
                this.second = sec % 60;
            }
            this.num2date(this.day, this.cal_dat);
            this.cal_dat.set(11, this.hour);
            this.cal_dat.set(12, this.minute);
            this.cal_dat.set(13, this.second);
            this.cal_dat.set(14, this.fraction / 1000);
        }
        switch (this.type) {
            case 2: {
                return new VirtuosoDate(this.cal_dat.getTime().getTime(), this.tz, sparql_executed);
            }
            case 3: {
                return new VirtuosoTime(this.cal_dat.getTime().getTime(), this.tz, sparql_executed);
            }
        }
        VirtuosoTimestamp ts = new VirtuosoTimestamp(this.cal_dat.getTime().getTime(), this.tz, sparql_executed);
        int nanos = this.fraction * 1000;
        if (nanos > 999999999) {
            ts.setNanos(this.fraction);
        } else {
            ts.setNanos(nanos);
        }
        return ts;
    }

    static int time_to_sec(int day, int hour, int min, int sec) {
        return day * 86400 + hour * 60 * 60 + min * 60 + sec;
    }

    void num2date(int julian_days, Calendar date) {
        long d_civ;
        long m_civ;
        long y_civ;
        long midhignt_jdn = julian_days + 1721423;
        if (2299161L <= midhignt_jdn) {
            long mj = midhignt_jdn + 32044L;
            long g = mj / 146097L;
            long dg = mj % 146097L;
            long c = (dg / 36524L + 1L) * 3L / 4L;
            long dc = dg - c * 36524L;
            long b = dc / 1461L;
            long db = dc % 1461L;
            long a = (db / 365L + 1L) * 3L / 4L;
            long da = db - a * 365L;
            long y = g * 400L + c * 100L + b * 4L + a;
            long m = (da * 5L + 308L) / 153L - 2L;
            long d = da - (m + 4L) * 153L / 5L + 122L;
            y_civ = y - 4800L + (m + 2L) / 12L;
            m_civ = (m + 2L) % 12L + 1L;
            d_civ = d + 1L;
        } else if (1722884L == midhignt_jdn) {
            m_civ = 1L;
            d_civ = 1L;
            y_civ = 5L;
        } else {
            long c = midhignt_jdn + 32082L;
            long d = (4L * c + 3L) / 1461L;
            long e = c - 1461L * d / 4L;
            long m = (5L * e + 2L) / 153L;
            d_civ = e - (153L * m + 2L) / 5L + 1L;
            m_civ = m + 3L - 12L * (m / 10L);
            y_civ = d - 4800L + m / 10L;
            if (y_civ < 0L) {
                --y_civ;
            }
        }
        if (y_civ < 0L) {
            date.set(0, 0);
            date.set(1, (int)(-y_civ));
        } else {
            date.set(1, (int)y_civ);
        }
        date.set(2, (int)m_civ - 1);
        date.set(5, (int)d_civ);
    }

    static void yearday2date(int yday, boolean is_leap_year, Calendar date) {
        int i;
        boolean decrement_date;
        if (yday > 365 + (is_leap_year ? 1 : 0) || yday < 1) {
            return;
        }
        boolean bl = decrement_date = is_leap_year && yday > 59;
        if (decrement_date) {
            --yday;
        }
        for (i = 1; i < 12; ++i) {
            if ((yday -= days_in_month[i - 1]) > 0) continue;
            yday += days_in_month[i - 1];
            break;
        }
        int month = i;
        int day = yday;
        if (decrement_date && month == 2 && day == 28) {
            ++day;
        }
        date.set(2, month - 1);
        date.set(5, day);
    }
}

