/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.javax;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import virtuoso.javax.BaseRowSet;
import virtuoso.javax.OPLMessage_x;

public class OPLJdbcRowSet
extends BaseRowSet {
    private Connection conn;
    private PreparedStatement pstmt;
    private ResultSet rs;
    private boolean doDisconnect = false;

    public synchronized void finalize() throws Throwable {
        this.close();
    }

    private Connection connect() throws SQLException {
        String connName = this.getDataSourceName();
        if (connName != null) {
            try {
                InitialContext initialcontext = new InitialContext();
                DataSource ds = (DataSource)initialcontext.lookup(connName);
                return ds.getConnection(this.getUsername(), this.getPassword());
            }
            catch (NamingException e) {
                throw OPLMessage_x.makeException(e);
            }
        }
        connName = this.getUrl();
        if (connName != null) {
            return DriverManager.getConnection(connName, this.getUsername(), this.getPassword());
        }
        return null;
    }

    private void setParams(PreparedStatement pstmt, Object[] params) throws SQLException {
        if (params == null) {
            return;
        }
        block14: for (int i = 0; i < params.length; ++i) {
            BaseRowSet.Parameter par = (BaseRowSet.Parameter)params[i];
            switch (par.jType) {
                case 0: {
                    pstmt.setObject(i + 1, par.value);
                    continue block14;
                }
                case 1: {
                    pstmt.setObject(i + 1, par.value, par.sqlType);
                    continue block14;
                }
                case 2: {
                    pstmt.setObject(i + 1, par.value, par.sqlType, par.scale);
                    continue block14;
                }
                case 3: {
                    pstmt.setAsciiStream(i + 1, (InputStream)par.value, par.length);
                    continue block14;
                }
                case 4: {
                    pstmt.setBinaryStream(i + 1, (InputStream)par.value, par.length);
                    continue block14;
                }
                case 5: {
                    pstmt.setUnicodeStream(i + 1, (InputStream)par.value, par.length);
                    continue block14;
                }
                case 6: {
                    pstmt.setCharacterStream(i + 1, (Reader)par.value, par.length);
                    continue block14;
                }
                case 7: {
                    pstmt.setDate(i + 1, (Date)par.value, par.cal);
                    continue block14;
                }
                case 8: {
                    pstmt.setTime(i + 1, (Time)par.value, par.cal);
                    continue block14;
                }
                case 9: {
                    pstmt.setTimestamp(i + 1, (Timestamp)par.value, par.cal);
                    continue block14;
                }
                case 10: {
                    pstmt.setNull(i + 1, par.sqlType);
                    continue block14;
                }
                case 11: {
                    pstmt.setNull(i + 1, par.sqlType, par.typeName);
                    continue block14;
                }
                default: {
                    throw OPLMessage_x.makeException(10);
                }
            }
        }
    }

    @Override
    public synchronized void execute() throws SQLException {
        if (this.conn == null) {
            this.conn = this.connect();
            this.doDisconnect = true;
        }
        if (this.conn == null || this.getCommand() == null) {
            throw OPLMessage_x.makeException(11);
        }
        try {
            this.conn.setTransactionIsolation(this.getTransactionIsolation());
        }
        catch (Exception exception) {
            // empty catch block
        }
        PreparedStatement pstmt = this.conn.prepareStatement(this.getCommand(), this.getType(), this.getConcurrency());
        this.setParams(pstmt, this.getParams());
        try {
            pstmt.setMaxRows(this.getMaxRows());
            pstmt.setMaxFieldSize(this.getMaxFieldSize());
            pstmt.setEscapeProcessing(this.getEscapeProcessing());
            pstmt.setQueryTimeout(this.getQueryTimeout());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.rs = pstmt.executeQuery();
        this.notifyListener(3);
    }

    public void execute(Connection _conn) throws SQLException {
        this.conn = _conn;
        this.execute();
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.rs != null) {
            this.rs.close();
        }
        if (this.pstmt != null) {
            this.pstmt.close();
        }
        if (this.conn != null && this.doDisconnect) {
            this.conn.close();
        }
    }

    @Override
    public synchronized void cancelRowUpdates() throws SQLException {
        this.check_close();
        this.rs.cancelRowUpdates();
        this.notifyListener(2);
    }

    @Override
    public synchronized boolean next() throws SQLException {
        this.check_close();
        boolean ret = this.rs.next();
        this.notifyListener(1);
        return ret;
    }

    @Override
    public synchronized boolean previous() throws SQLException {
        this.check_close();
        boolean ret = this.rs.previous();
        this.notifyListener(1);
        return ret;
    }

    @Override
    public synchronized boolean first() throws SQLException {
        this.check_close();
        boolean ret = this.rs.first();
        this.notifyListener(1);
        return ret;
    }

    @Override
    public synchronized boolean last() throws SQLException {
        this.check_close();
        boolean ret = this.rs.last();
        this.notifyListener(1);
        return ret;
    }

    @Override
    public synchronized boolean absolute(int row) throws SQLException {
        this.check_close();
        boolean ret = this.rs.absolute(row);
        this.notifyListener(1);
        return ret;
    }

    @Override
    public synchronized boolean relative(int rows) throws SQLException {
        this.check_close();
        boolean ret = this.rs.relative(rows);
        this.notifyListener(1);
        return ret;
    }

    @Override
    public synchronized void beforeFirst() throws SQLException {
        this.check_close();
        this.rs.beforeFirst();
        this.notifyListener(1);
    }

    @Override
    public synchronized void afterLast() throws SQLException {
        this.check_close();
        this.rs.afterLast();
        this.notifyListener(1);
    }

    @Override
    public synchronized boolean isBeforeFirst() throws SQLException {
        this.check_close();
        return this.rs.isBeforeFirst();
    }

    @Override
    public synchronized boolean isAfterLast() throws SQLException {
        this.check_close();
        return this.rs.isAfterLast();
    }

    @Override
    public synchronized boolean isFirst() throws SQLException {
        this.check_close();
        return this.rs.isFirst();
    }

    @Override
    public synchronized boolean isLast() throws SQLException {
        this.check_close();
        return this.rs.isLast();
    }

    @Override
    public synchronized int getRow() throws SQLException {
        this.check_close();
        return this.rs.getRow();
    }

    @Override
    public synchronized boolean rowUpdated() throws SQLException {
        this.check_close();
        return this.rs.rowUpdated();
    }

    @Override
    public synchronized boolean rowInserted() throws SQLException {
        this.check_close();
        return this.rs.rowInserted();
    }

    @Override
    public synchronized boolean rowDeleted() throws SQLException {
        this.check_close();
        return this.rs.rowDeleted();
    }

    @Override
    public synchronized void refreshRow() throws SQLException {
        this.check_close();
        this.rs.refreshRow();
    }

    @Override
    public synchronized void insertRow() throws SQLException {
        this.check_close();
        this.rs.insertRow();
        this.notifyListener(2);
    }

    @Override
    public synchronized void updateRow() throws SQLException {
        this.check_close();
        this.rs.updateRow();
        this.notifyListener(2);
    }

    @Override
    public synchronized void deleteRow() throws SQLException {
        this.check_close();
        this.rs.deleteRow();
        this.notifyListener(2);
    }

    @Override
    public synchronized void moveToInsertRow() throws SQLException {
        this.check_close();
        this.rs.moveToInsertRow();
    }

    @Override
    public synchronized void moveToCurrentRow() throws SQLException {
        this.check_close();
        this.rs.moveToCurrentRow();
    }

    @Override
    public synchronized boolean wasNull() throws SQLException {
        this.check_close();
        return this.rs.wasNull();
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        this.check_close();
        return this.rs.getWarnings();
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.check_close();
        this.rs.clearWarnings();
    }

    @Override
    public synchronized String getCursorName() throws SQLException {
        this.check_close();
        return this.rs.getCursorName();
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        this.check_close();
        return this.rs.getMetaData();
    }

    @Override
    public synchronized int findColumn(String columnName) throws SQLException {
        this.check_close();
        return this.rs.findColumn(columnName);
    }

    @Override
    public synchronized String getString(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getString(columnIndex);
    }

    @Override
    public synchronized boolean getBoolean(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getBoolean(columnIndex);
    }

    @Override
    public synchronized byte getByte(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getByte(columnIndex);
    }

    @Override
    public synchronized short getShort(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getShort(columnIndex);
    }

    @Override
    public synchronized int getInt(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getInt(columnIndex);
    }

    @Override
    public synchronized long getLong(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getLong(columnIndex);
    }

    @Override
    public synchronized float getFloat(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getFloat(columnIndex);
    }

    @Override
    public synchronized double getDouble(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getDouble(columnIndex);
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getBigDecimal(columnIndex);
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.check_close();
        return this.rs.getBigDecimal(columnIndex, scale);
    }

    @Override
    public synchronized byte[] getBytes(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getBytes(columnIndex);
    }

    @Override
    public synchronized Date getDate(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getDate(columnIndex);
    }

    @Override
    public synchronized Time getTime(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getTime(columnIndex);
    }

    @Override
    public synchronized Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getTimestamp(columnIndex);
    }

    @Override
    public synchronized InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getAsciiStream(columnIndex);
    }

    @Override
    public synchronized InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getUnicodeStream(columnIndex);
    }

    @Override
    public synchronized InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getBinaryStream(columnIndex);
    }

    @Override
    public synchronized Object getObject(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getObject(columnIndex);
    }

    @Override
    public synchronized String getString(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getString(columnName);
    }

    @Override
    public synchronized boolean getBoolean(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getBoolean(columnName);
    }

    @Override
    public synchronized byte getByte(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getByte(columnName);
    }

    @Override
    public synchronized short getShort(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getShort(columnName);
    }

    @Override
    public synchronized int getInt(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getInt(columnName);
    }

    @Override
    public synchronized long getLong(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getLong(columnName);
    }

    @Override
    public synchronized float getFloat(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getFloat(columnName);
    }

    @Override
    public synchronized double getDouble(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getDouble(columnName);
    }

    @Override
    public synchronized BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        this.check_close();
        return this.rs.getBigDecimal(columnName, scale);
    }

    @Override
    public synchronized byte[] getBytes(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getBytes(columnName);
    }

    @Override
    public synchronized Date getDate(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getDate(columnName);
    }

    @Override
    public synchronized Time getTime(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getTime(columnName);
    }

    @Override
    public synchronized Timestamp getTimestamp(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getTimestamp(columnName);
    }

    @Override
    public synchronized InputStream getAsciiStream(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getAsciiStream(columnName);
    }

    @Override
    public synchronized InputStream getUnicodeStream(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getUnicodeStream(columnName);
    }

    @Override
    public synchronized InputStream getBinaryStream(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getBinaryStream(columnName);
    }

    @Override
    public synchronized Object getObject(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getObject(columnName);
    }

    @Override
    public synchronized Reader getCharacterStream(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getCharacterStream(columnIndex);
    }

    @Override
    public synchronized Reader getCharacterStream(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getCharacterStream(columnName);
    }

    @Override
    public synchronized BigDecimal getBigDecimal(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getBigDecimal(columnName);
    }

    @Override
    public synchronized void updateNull(int columnIndex) throws SQLException {
        this.check_close();
        this.rs.updateNull(columnIndex);
    }

    @Override
    public synchronized void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.check_close();
        this.rs.updateBoolean(columnIndex, x);
    }

    @Override
    public synchronized void updateByte(int columnIndex, byte x) throws SQLException {
        this.check_close();
        this.rs.updateByte(columnIndex, x);
    }

    @Override
    public synchronized void updateShort(int columnIndex, short x) throws SQLException {
        this.check_close();
        this.rs.updateShort(columnIndex, x);
    }

    @Override
    public synchronized void updateInt(int columnIndex, int x) throws SQLException {
        this.check_close();
        this.rs.updateInt(columnIndex, x);
    }

    @Override
    public synchronized void updateLong(int columnIndex, long x) throws SQLException {
        this.check_close();
        this.rs.updateLong(columnIndex, x);
    }

    @Override
    public synchronized void updateFloat(int columnIndex, float x) throws SQLException {
        this.check_close();
        this.rs.updateFloat(columnIndex, x);
    }

    @Override
    public synchronized void updateDouble(int columnIndex, double x) throws SQLException {
        this.check_close();
        this.rs.updateDouble(columnIndex, x);
    }

    @Override
    public synchronized void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.check_close();
        this.rs.updateBigDecimal(columnIndex, x);
    }

    @Override
    public synchronized void updateString(int columnIndex, String x) throws SQLException {
        this.check_close();
        this.rs.updateString(columnIndex, x);
    }

    @Override
    public synchronized void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.check_close();
        this.rs.updateBytes(columnIndex, x);
    }

    @Override
    public synchronized void updateDate(int columnIndex, Date x) throws SQLException {
        this.check_close();
        this.rs.updateDate(columnIndex, x);
    }

    @Override
    public synchronized void updateTime(int columnIndex, Time x) throws SQLException {
        this.check_close();
        this.rs.updateTime(columnIndex, x);
    }

    @Override
    public synchronized void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.check_close();
        this.rs.updateTimestamp(columnIndex, x);
    }

    @Override
    public synchronized void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.check_close();
        this.rs.updateAsciiStream(columnIndex, x, length);
    }

    @Override
    public synchronized void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.check_close();
        this.rs.updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public synchronized void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.check_close();
        this.rs.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.check_close();
        this.rs.updateObject(columnIndex, x, scale);
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object x) throws SQLException {
        this.check_close();
        this.rs.updateObject(columnIndex, x);
    }

    @Override
    public synchronized void updateNull(String columnName) throws SQLException {
        this.check_close();
        this.rs.updateNull(columnName);
    }

    @Override
    public synchronized void updateBoolean(String columnName, boolean x) throws SQLException {
        this.check_close();
        this.rs.updateBoolean(columnName, x);
    }

    @Override
    public synchronized void updateByte(String columnName, byte x) throws SQLException {
        this.check_close();
        this.rs.updateByte(columnName, x);
    }

    @Override
    public synchronized void updateShort(String columnName, short x) throws SQLException {
        this.check_close();
        this.rs.updateShort(columnName, x);
    }

    @Override
    public synchronized void updateInt(String columnName, int x) throws SQLException {
        this.check_close();
        this.rs.updateInt(columnName, x);
    }

    @Override
    public synchronized void updateLong(String columnName, long x) throws SQLException {
        this.check_close();
        this.rs.updateLong(columnName, x);
    }

    @Override
    public synchronized void updateFloat(String columnName, float x) throws SQLException {
        this.check_close();
        this.rs.updateFloat(columnName, x);
    }

    @Override
    public synchronized void updateDouble(String columnName, double x) throws SQLException {
        this.check_close();
        this.rs.updateDouble(columnName, x);
    }

    @Override
    public synchronized void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.check_close();
        this.rs.updateBigDecimal(columnName, x);
    }

    @Override
    public synchronized void updateString(String columnName, String x) throws SQLException {
        this.check_close();
        this.rs.updateString(columnName, x);
    }

    @Override
    public synchronized void updateBytes(String columnName, byte[] x) throws SQLException {
        this.check_close();
        this.rs.updateBytes(columnName, x);
    }

    @Override
    public synchronized void updateDate(String columnName, Date x) throws SQLException {
        this.check_close();
        this.rs.updateDate(columnName, x);
    }

    @Override
    public synchronized void updateTime(String columnName, Time x) throws SQLException {
        this.check_close();
        this.rs.updateTime(columnName, x);
    }

    @Override
    public synchronized void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.check_close();
        this.rs.updateTimestamp(columnName, x);
    }

    @Override
    public synchronized void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.check_close();
        this.rs.updateAsciiStream(columnName, x, length);
    }

    @Override
    public synchronized void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.check_close();
        this.rs.updateBinaryStream(columnName, x, length);
    }

    @Override
    public synchronized void updateCharacterStream(String columnName, Reader x, int length) throws SQLException {
        this.check_close();
        this.rs.updateCharacterStream(columnName, x, length);
    }

    @Override
    public synchronized void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.check_close();
        this.rs.updateObject(columnName, x, scale);
    }

    @Override
    public synchronized void updateObject(String columnName, Object x) throws SQLException {
        this.check_close();
        this.rs.updateObject(columnName, x);
    }

    @Override
    public synchronized Statement getStatement() throws SQLException {
        this.check_close();
        return this.rs.getStatement();
    }

    @Override
    public synchronized Object getObject(int colIndex, Map<String, Class<?>> map) throws SQLException {
        this.check_close();
        return this.rs.getObject(colIndex, map);
    }

    @Override
    public synchronized Ref getRef(int colIndex) throws SQLException {
        this.check_close();
        return this.rs.getRef(colIndex);
    }

    @Override
    public synchronized Blob getBlob(int colIndex) throws SQLException {
        this.check_close();
        return this.rs.getBlob(colIndex);
    }

    @Override
    public synchronized Clob getClob(int colIndex) throws SQLException {
        this.check_close();
        return this.rs.getClob(colIndex);
    }

    @Override
    public synchronized Array getArray(int colIndex) throws SQLException {
        this.check_close();
        return this.rs.getArray(colIndex);
    }

    @Override
    public synchronized Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        this.check_close();
        return this.rs.getObject(colName, map);
    }

    @Override
    public synchronized Ref getRef(String colName) throws SQLException {
        this.check_close();
        return this.rs.getRef(colName);
    }

    @Override
    public synchronized Blob getBlob(String colName) throws SQLException {
        this.check_close();
        return this.rs.getBlob(colName);
    }

    @Override
    public synchronized Clob getClob(String colName) throws SQLException {
        this.check_close();
        return this.rs.getClob(colName);
    }

    @Override
    public synchronized Array getArray(String colName) throws SQLException {
        this.check_close();
        return this.rs.getArray(colName);
    }

    @Override
    public synchronized Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.check_close();
        return this.rs.getDate(columnIndex, cal);
    }

    @Override
    public synchronized Date getDate(String columnName, Calendar cal) throws SQLException {
        this.check_close();
        return this.rs.getDate(columnName, cal);
    }

    @Override
    public synchronized Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.check_close();
        return this.rs.getTime(columnIndex, cal);
    }

    @Override
    public synchronized Time getTime(String columnName, Calendar cal) throws SQLException {
        this.check_close();
        return this.rs.getTime(columnName, cal);
    }

    @Override
    public synchronized Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.check_close();
        return this.rs.getTimestamp(columnIndex, cal);
    }

    @Override
    public synchronized Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        this.check_close();
        return this.rs.getTimestamp(columnName, cal);
    }

    @Override
    public synchronized URL getURL(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getURL(columnIndex);
    }

    @Override
    public synchronized URL getURL(String columnName) throws SQLException {
        this.check_close();
        return this.rs.getURL(columnName);
    }

    @Override
    public synchronized void updateRef(int columnIndex, Ref x) throws SQLException {
        this.check_close();
        this.rs.updateRef(columnIndex, x);
    }

    @Override
    public synchronized void updateRef(String columnName, Ref x) throws SQLException {
        this.check_close();
        this.rs.updateRef(columnName, x);
    }

    @Override
    public synchronized void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.check_close();
        this.rs.updateBlob(columnIndex, x);
    }

    @Override
    public synchronized void updateBlob(String columnName, Blob x) throws SQLException {
        this.check_close();
        this.rs.updateBlob(columnName, x);
    }

    @Override
    public synchronized void updateClob(int columnIndex, Clob x) throws SQLException {
        this.check_close();
        this.rs.updateClob(columnIndex, x);
    }

    @Override
    public synchronized void updateClob(String columnName, Clob x) throws SQLException {
        this.check_close();
        this.rs.updateClob(columnName, x);
    }

    @Override
    public synchronized void updateArray(int columnIndex, Array x) throws SQLException {
        this.check_close();
        this.rs.updateArray(columnIndex, x);
    }

    @Override
    public synchronized void updateArray(String columnName, Array x) throws SQLException {
        this.check_close();
        this.rs.updateArray(columnName, x);
    }

    @Override
    public synchronized RowId getRowId(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getRowId(columnIndex);
    }

    @Override
    public synchronized RowId getRowId(String columnLabel) throws SQLException {
        this.check_close();
        return this.rs.getRowId(columnLabel);
    }

    @Override
    public synchronized void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.check_close();
        this.rs.updateRowId(columnIndex, x);
    }

    @Override
    public synchronized void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.check_close();
        this.rs.updateRowId(columnLabel, x);
    }

    @Override
    public synchronized int getHoldability() throws SQLException {
        this.check_close();
        return this.rs.getHoldability();
    }

    @Override
    public synchronized boolean isClosed() throws SQLException {
        if (this.rs != null) {
            return this.rs.isClosed();
        }
        return true;
    }

    @Override
    public synchronized void updateNString(int columnIndex, String nString) throws SQLException {
        this.check_close();
        this.rs.updateNString(columnIndex, nString);
    }

    @Override
    public synchronized void updateNString(String columnLabel, String nString) throws SQLException {
        this.check_close();
        this.rs.updateNString(columnLabel, nString);
    }

    @Override
    public synchronized void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.check_close();
        this.rs.updateNClob(columnIndex, nClob);
    }

    @Override
    public synchronized void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.check_close();
        this.rs.updateNClob(columnLabel, nClob);
    }

    @Override
    public synchronized NClob getNClob(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getNClob(columnIndex);
    }

    @Override
    public synchronized NClob getNClob(String columnLabel) throws SQLException {
        this.check_close();
        return this.rs.getNClob(columnLabel);
    }

    @Override
    public synchronized SQLXML getSQLXML(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getSQLXML(columnIndex);
    }

    @Override
    public synchronized SQLXML getSQLXML(String columnLabel) throws SQLException {
        this.check_close();
        return this.rs.getSQLXML(columnLabel);
    }

    @Override
    public synchronized void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.check_close();
        this.rs.updateSQLXML(columnIndex, xmlObject);
    }

    @Override
    public synchronized void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.check_close();
        this.rs.updateSQLXML(columnLabel, xmlObject);
    }

    @Override
    public synchronized String getNString(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getNString(columnIndex);
    }

    @Override
    public synchronized String getNString(String columnLabel) throws SQLException {
        this.check_close();
        return this.rs.getNString(columnLabel);
    }

    @Override
    public synchronized Reader getNCharacterStream(int columnIndex) throws SQLException {
        this.check_close();
        return this.rs.getNCharacterStream(columnIndex);
    }

    @Override
    public synchronized Reader getNCharacterStream(String columnLabel) throws SQLException {
        this.check_close();
        return this.rs.getNCharacterStream(columnLabel);
    }

    @Override
    public synchronized void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.check_close();
        this.rs.updateNCharacterStream(columnIndex, x, length);
    }

    @Override
    public synchronized void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.check_close();
        this.rs.updateNCharacterStream(columnLabel, reader, length);
    }

    @Override
    public synchronized void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.check_close();
        this.rs.updateAsciiStream(columnIndex, x, length);
    }

    @Override
    public synchronized void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.check_close();
        this.rs.updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public synchronized void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.check_close();
        this.rs.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public synchronized void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.check_close();
        this.rs.updateAsciiStream(columnLabel, x, length);
    }

    @Override
    public synchronized void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.check_close();
        this.rs.updateBinaryStream(columnLabel, x, length);
    }

    @Override
    public synchronized void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.check_close();
        this.rs.updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public synchronized void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.check_close();
        this.rs.updateBlob(columnIndex, inputStream, length);
    }

    @Override
    public synchronized void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.check_close();
        this.rs.updateBlob(columnLabel, inputStream, length);
    }

    @Override
    public synchronized void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.check_close();
        this.rs.updateClob(columnIndex, reader, length);
    }

    @Override
    public synchronized void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.check_close();
        this.rs.updateClob(columnLabel, reader, length);
    }

    @Override
    public synchronized void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.check_close();
        this.rs.updateNClob(columnIndex, reader, length);
    }

    @Override
    public synchronized void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.check_close();
        this.rs.updateNClob(columnLabel, reader, length);
    }

    @Override
    public synchronized void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.check_close();
        this.rs.updateNCharacterStream(columnIndex, x);
    }

    @Override
    public synchronized void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.check_close();
        this.rs.updateNCharacterStream(columnLabel, reader);
    }

    @Override
    public synchronized void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.check_close();
        this.rs.updateAsciiStream(columnIndex, x);
    }

    @Override
    public synchronized void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.check_close();
        this.rs.updateBinaryStream(columnIndex, x);
    }

    @Override
    public synchronized void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.check_close();
        this.rs.updateCharacterStream(columnIndex, x);
    }

    @Override
    public synchronized void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.check_close();
        this.rs.updateAsciiStream(columnLabel, x);
    }

    @Override
    public synchronized void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.check_close();
        this.rs.updateBinaryStream(columnLabel, x);
    }

    @Override
    public synchronized void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.check_close();
        this.rs.updateCharacterStream(columnLabel, reader);
    }

    @Override
    public synchronized void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.check_close();
        this.rs.updateBlob(columnIndex, inputStream);
    }

    @Override
    public synchronized void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.check_close();
        this.rs.updateBlob(columnLabel, inputStream);
    }

    @Override
    public synchronized void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.check_close();
        this.rs.updateClob(columnIndex, reader);
    }

    @Override
    public synchronized void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.check_close();
        this.rs.updateClob(columnLabel, reader);
    }

    @Override
    public synchronized void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.check_close();
        this.rs.updateNClob(columnIndex, reader);
    }

    @Override
    public synchronized void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.check_close();
        this.rs.updateNClob(columnLabel, reader);
    }

    @Override
    public synchronized <T> T unwrap(Class<T> iface) throws SQLException {
        this.check_close();
        return this.rs.unwrap(iface);
    }

    @Override
    public synchronized boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.check_close();
        return this.rs.isWrapperFor(iface);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        if (type == null) {
            throw new SQLException("Type parameter cannot be null", "S1009");
        }
        if (type.equals(String.class)) {
            return (T)this.getString(columnIndex);
        }
        if (type.equals(BigDecimal.class)) {
            return (T)this.getBigDecimal(columnIndex);
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return (T)Boolean.valueOf(this.getBoolean(columnIndex));
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return (T)Integer.valueOf(this.getInt(columnIndex));
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return (T)Long.valueOf(this.getLong(columnIndex));
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return (T)Float.valueOf(this.getFloat(columnIndex));
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return (T)Double.valueOf(this.getDouble(columnIndex));
        }
        if (type.equals(byte[].class)) {
            return (T)this.getBytes(columnIndex);
        }
        if (type.equals(Date.class)) {
            return (T)this.getDate(columnIndex);
        }
        if (type.equals(Time.class)) {
            return (T)this.getTime(columnIndex);
        }
        if (type.equals(Timestamp.class)) {
            return (T)this.getTimestamp(columnIndex);
        }
        if (type.equals(Clob.class)) {
            return (T)this.getClob(columnIndex);
        }
        if (type.equals(Blob.class)) {
            return (T)this.getBlob(columnIndex);
        }
        if (type.equals(Array.class)) {
            return (T)this.getArray(columnIndex);
        }
        if (type.equals(Ref.class)) {
            return (T)this.getRef(columnIndex);
        }
        if (type.equals(URL.class)) {
            return (T)this.getURL(columnIndex);
        }
        try {
            return (T)this.getObject(columnIndex);
        }
        catch (ClassCastException cce) {
            throw new SQLException("Conversion not supported for type " + type.getName(), "S1009");
        }
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }

    private void check_close() throws SQLException {
        if (this.rs == null) {
            throw OPLMessage_x.makeException(7);
        }
    }
}

