/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.anonmed.anonymizer;

import cz.zcu.mre.anonmed.AnonMedConfiguration;
import cz.zcu.mre.anonmed.AnonMedException;
import cz.zcu.mre.anonmed.AnonymousIdentification;
import cz.zcu.mre.anonmed.anonymizer.AbstractAnonymizer;
import cz.zcu.mre.anonmed.rule.Rule;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaderSAX2Factory;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLAnonymizer
extends AbstractAnonymizer {
    private static final Logger LOG = LoggerFactory.getLogger(XMLAnonymizer.class);
    private Document xmlDocument;
    private String anonymousIdentification;

    public XMLAnonymizer(AnonMedConfiguration config) {
        super(config);
        this.setFileType("application/xml");
        this.setFileExtension("xml");
    }

    @Override
    public final void fileOpen(File file) {
        XMLReaderSAX2Factory xmlrjdomf = new XMLReaderSAX2Factory(false, "org.apache.xerces.parsers.SAXParser");
        SAXBuilder saxBuilder = new SAXBuilder((XMLReaderJDOMFactory)xmlrjdomf);
        saxBuilder.setFeature("http://apache.org/xml/features/validation/schema", false);
        this.anonymousIdentification = null;
        try {
            this.xmlDocument = saxBuilder.build(file);
            this.setActiveFile(file);
        }
        catch (JDOMException ex) {
            LOG.error("JDOM exception {} {}", (Object)file.getAbsolutePath(), (Object)ex.getMessage());
            this.setActiveFile(null);
            this.xmlDocument = null;
        }
        catch (IOException ex) {
            LOG.error("IOException {} {}", (Object)file.getAbsolutePath(), (Object)ex.getMessage());
            this.setActiveFile(null);
            this.xmlDocument = null;
        }
        if (this.xmlDocument == null) {
            LOG.error("IGNORE_FILE {}", (Object)file.getAbsolutePath());
            this.report(null, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void fileWrite(String filename) throws AnonMedException {
        File file = new File(filename);
        if (!this.getConfig().isOverwriteFile().booleanValue() && file.exists()) {
            throw new AnonMedException("ERROR Overwrite not allowed and the output file '" + file.getAbsolutePath() + "' exists", -1);
        }
        FileOutputStream outputStream = null;
        try {
            this.fileWriteDocType();
            outputStream = new FileOutputStream(file);
            XMLOutputter outputter = new XMLOutputter();
            outputter.setFormat(Format.getPrettyFormat());
            outputter.output(this.xmlDocument, (OutputStream)outputStream);
        }
        catch (FileNotFoundException ex) {
            LOG.error("ERROR File {} not found. {}", (Object)file.getAbsolutePath(), (Object)ex.getMessage());
        }
        catch (IOException ex) {
            LOG.error("ERROR IOException {} {}", (Object)file.getAbsolutePath(), (Object)ex.getMessage());
        }
        finally {
            if (outputStream != null) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException ex) {
                    LOG.error(null, (Throwable)ex);
                }
            }
        }
    }

    protected void fileWriteDocType() {
    }

    @Override
    public final void ruleAppendAfter(Rule rule) {
        XPathExpression xpath = XPathFactory.instance().compile(rule.getRule());
        List nodeList = xpath.evaluate((Object)this.xmlDocument);
        nodeList.stream().forEach(object -> {
            if (object instanceof Attribute) {
                String oldValue = ((Attribute)object).getValue();
                String newValue = ((Attribute)object).getValue().concat(rule.getNewValue());
                this.report(rule, oldValue, newValue);
                ((Attribute)object).setValue(newValue);
            } else if (object instanceof Element) {
                String oldValue = ((Element)object).getValue();
                String newValue = ((Element)object).getValue().concat(rule.getNewValue());
                this.report(rule, oldValue, newValue);
                ((Element)object).setText(newValue);
            }
        });
    }

    @Override
    public final void ruleAppendBefore(Rule rule) {
        XPathExpression xpath = XPathFactory.instance().compile(rule.getRule());
        List nodeList = xpath.evaluate((Object)this.xmlDocument);
        nodeList.stream().forEach(object -> {
            if (object instanceof Attribute) {
                String oldValue = ((Attribute)object).getValue();
                String newValue = rule.getNewValue().concat(((Attribute)object).getValue());
                this.report(rule, oldValue, newValue);
                ((Attribute)object).setValue(newValue);
            } else if (object instanceof Element) {
                String oldValue = ((Element)object).getValue();
                String newValue = rule.getNewValue().concat(((Element)object).getValue());
                this.report(rule, oldValue, newValue);
                ((Element)object).setText(newValue);
            }
        });
    }

    @Override
    public final void ruleEmpty(Rule rule) {
        XPathExpression xpath = XPathFactory.instance().compile(rule.getRule());
        List nodeList = xpath.evaluate((Object)this.xmlDocument);
        nodeList.stream().forEach(object -> {
            if (object instanceof Attribute) {
                String oldValue = ((Attribute)object).getValue();
                this.report(rule, oldValue, "[EMPTY]");
                ((Attribute)object).setValue(null);
            } else if (object instanceof Element) {
                String oldValue = ((Element)object).getValue();
                this.report(rule, oldValue, "[EMPTY]");
                ((Element)object).setText(null);
            }
        });
    }

    @Override
    public final void ruleChange(Rule rule) {
        XPathExpression xpath = XPathFactory.instance().compile(rule.getRule());
        List nodeList = xpath.evaluate((Object)this.xmlDocument);
        nodeList.stream().forEach(object -> {
            if (object instanceof Attribute) {
                String oldValue = ((Attribute)object).getValue();
                String newValue = rule.getNewValue();
                this.report(rule, oldValue, newValue);
                ((Attribute)object).setValue(rule.getNewValue());
            } else if (object instanceof Element) {
                String oldValue = ((Element)object).getValue();
                String newValue = rule.getNewValue();
                this.report(rule, oldValue, newValue);
                ((Element)object).setText(rule.getNewValue());
            }
        });
    }

    @Override
    public final void ruleIdentification(Rule rule) {
        XPathExpression xpath = XPathFactory.instance().compile(rule.getRule());
        List nodeList = xpath.evaluate((Object)this.xmlDocument);
        nodeList.stream().forEach(object -> {
            if (object instanceof Attribute) {
                if (this.anonymousIdentification == null) {
                    this.anonymousIdentification = AnonymousIdentification.anonymize(((Attribute)object).getValue());
                }
                String oldValue = ((Attribute)object).getValue();
                this.report(rule, oldValue, this.anonymousIdentification);
                ((Attribute)object).setValue(this.anonymousIdentification);
            } else if (object instanceof Element) {
                if (this.anonymousIdentification == null) {
                    this.anonymousIdentification = AnonymousIdentification.anonymize(((Element)object).getValue());
                }
                String oldValue = ((Element)object).getValue();
                this.report(rule, oldValue, this.anonymousIdentification);
                ((Element)object).setText(this.anonymousIdentification);
            }
        });
    }

    @Override
    public final void ruleKeep(Rule rule) {
    }

    @Override
    public final void ruleRemove(Rule rule) {
        XPathExpression xpath = XPathFactory.instance().compile(rule.getRule());
        List nodeList = xpath.evaluate((Object)this.xmlDocument);
        nodeList.stream().forEach(object -> {
            if (object instanceof Attribute) {
                String oldValue = ((Attribute)object).getValue();
                this.report(rule, oldValue, "[REMOVED]");
                ((Attribute)object).detach();
            } else if (object instanceof Element) {
                String oldValue = ((Element)object).getValue();
                this.report(rule, oldValue, "[REMOVED]");
                ((Element)object).detach();
            }
        });
    }

    @Override
    public final void ruleSpecific(Rule rule) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void strictMode() {
    }

    @Override
    public void ruleDecrypt(Rule rule) {
        XPathExpression xpath = XPathFactory.instance().compile(rule.getRule());
        List nodeList = xpath.evaluate((Object)this.xmlDocument);
        nodeList.stream().forEach(object -> {
            if (object instanceof Attribute) {
                String oldValue = ((Attribute)object).getValue();
                String newValue = this.makeDecrypt(rule, oldValue);
                this.report(rule, oldValue, newValue);
                ((Attribute)object).setValue(newValue);
            } else if (object instanceof Element) {
                String oldValue = ((Element)object).getValue();
                String newValue = this.makeDecrypt(rule, oldValue);
                this.report(rule, oldValue, newValue);
                ((Element)object).setText(newValue);
            }
        });
    }

    @Override
    public void ruleEncrypt(Rule rule) {
        XPathExpression xpath = XPathFactory.instance().compile(rule.getRule());
        List nodeList = xpath.evaluate((Object)this.xmlDocument);
        nodeList.stream().forEach(object -> {
            if (object instanceof Attribute) {
                String oldValue = ((Attribute)object).getValue();
                String newValue = this.makeEncrypt(rule, oldValue);
                this.report(rule, oldValue, newValue);
                ((Attribute)object).setValue(newValue);
            } else if (object instanceof Element) {
                String oldValue = ((Element)object).getValue();
                String newValue = this.makeEncrypt(rule, oldValue);
                this.report(rule, oldValue, newValue);
                ((Element)object).setText(newValue);
            }
        });
    }

    public final Document getXmlDocument() {
        return this.xmlDocument;
    }

    public final void setXmlDocument(Document doc) {
        this.xmlDocument = doc;
    }

    @Override
    public void ruleSubstitute(Rule rule) {
        XPathExpression xpath = XPathFactory.instance().compile(rule.getRule());
        List nodeList = xpath.evaluate((Object)this.xmlDocument);
        nodeList.stream().forEach(object -> {
            if (object instanceof Attribute) {
                String oldValue = ((Attribute)object).getValue();
                String newValue = this.makeSubstitute(rule, oldValue);
                this.report(rule, oldValue, newValue);
                ((Attribute)object).setValue(newValue);
            } else if (object instanceof Element) {
                String oldValue = ((Element)object).getValue();
                String newValue = this.makeSubstitute(rule, oldValue);
                this.report(rule, oldValue, newValue);
                ((Element)object).setText(newValue);
            }
        });
    }

    @Override
    public void ruleSubstring(Rule rule) {
        XPathExpression xpath = XPathFactory.instance().compile(rule.getRule());
        List nodeList = xpath.evaluate((Object)this.xmlDocument);
        nodeList.stream().forEach(object -> {
            if (object instanceof Attribute) {
                String oldValue = ((Attribute)object).getValue();
                String newValue = this.makeSubstring(rule, oldValue);
                this.report(rule, oldValue, newValue);
                ((Attribute)object).setValue(newValue);
            } else if (object instanceof Element) {
                String oldValue = ((Element)object).getValue();
                String newValue = this.makeSubstring(rule, oldValue);
                this.report(rule, oldValue, newValue);
                ((Element)object).setText(newValue);
            }
        });
    }

    @Override
    public void ruleLowercase(Rule rule) {
        XPathExpression xpath = XPathFactory.instance().compile(rule.getRule());
        List nodeList = xpath.evaluate((Object)this.xmlDocument);
        nodeList.stream().forEach(object -> {
            if (object instanceof Attribute) {
                String oldValue = ((Attribute)object).getValue();
                String newValue = this.makeLowercase(rule, oldValue);
                this.report(rule, oldValue, newValue);
                ((Attribute)object).setValue(newValue);
            } else if (object instanceof Element) {
                String oldValue = ((Element)object).getValue();
                String newValue = this.makeLowercase(rule, oldValue);
                this.report(rule, oldValue, newValue);
                ((Element)object).setText(newValue);
            }
        });
    }

    @Override
    public void ruleUppercase(Rule rule) {
        XPathExpression xpath = XPathFactory.instance().compile(rule.getRule());
        List nodeList = xpath.evaluate((Object)this.xmlDocument);
        nodeList.stream().forEach(object -> {
            if (object instanceof Attribute) {
                String oldValue = ((Attribute)object).getValue();
                String newValue = this.makeUppercase(rule, oldValue);
                this.report(rule, oldValue, newValue);
                ((Attribute)object).setValue(newValue);
            } else if (object instanceof Element) {
                String oldValue = ((Element)object).getValue();
                String newValue = this.makeUppercase(rule, oldValue);
                this.report(rule, oldValue, newValue);
                ((Element)object).setText(newValue);
            }
        });
    }
}

