/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.anonmed.anonymizer;

import cz.zcu.mre.anonmed.AnonMedConfiguration;
import cz.zcu.mre.anonmed.AnonMedException;
import cz.zcu.mre.anonmed.AnonymousIdentification;
import cz.zcu.mre.anonmed.anonymizer.AbstractAnonymizer;
import cz.zcu.mre.anonmed.rule.Rule;
import cz.zcu.mre.mrelib.Const;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVAnonymizer
extends AbstractAnonymizer {
    private static final Logger LOG = LoggerFactory.getLogger(CSVAnonymizer.class);
    private static final int COLUMN = 0;
    private static final int ROW = 1;
    private char columnDelimiter = (char)59;
    private final List<List<String>> content = new ArrayList<List<String>>();

    public CSVAnonymizer(AnonMedConfiguration config) {
        super(config);
        this.setFileType("application/csv");
        this.setFileExtension("csv");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void fileOpen(File file) {
        this.content.clear();
        this.setAnonymousIdentification(null);
        Reader in = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Const.CHARSET));
            CSVParser parser = CSVFormat.Builder.create((CSVFormat)CSVFormat.DEFAULT).setDelimiter(this.columnDelimiter).build().parse(in);
            for (CSVRecord record : parser.getRecords()) {
                ArrayList<String> columns = new ArrayList<String>();
                for (String value : record) {
                    columns.add(value);
                }
                this.content.add(columns);
            }
            this.setActiveFile(file);
            in.close();
        }
        catch (FileNotFoundException ex) {
            LOG.error(null, (Throwable)ex);
            this.setActiveFile(null);
        }
        catch (IOException ex) {
            LOG.error(null, (Throwable)ex);
            this.setActiveFile(null);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                LOG.error(null, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void fileWrite(String filename) throws AnonMedException {
        File file = new File(filename);
        if (!this.getConfig().isOverwriteFile().booleanValue() && file.exists()) {
            throw new AnonMedException("ERROR Overwrite not allowed and the output file '" + file.getAbsolutePath() + "' exists", -1);
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            for (List<String> columns : this.content) {
                int j = 1;
                for (String value : columns) {
                    if (value.contains(String.valueOf(this.columnDelimiter)) || value.trim().contains(" ")) {
                        ((OutputStream)outputStream).write("\"".getBytes(Const.CHARSET));
                        ((OutputStream)outputStream).write(value.getBytes(Const.CHARSET));
                        ((OutputStream)outputStream).write("\"".getBytes(Const.CHARSET));
                    } else {
                        ((OutputStream)outputStream).write(value.getBytes(Const.CHARSET));
                    }
                    if (j < columns.size()) {
                        ((OutputStream)outputStream).write(this.columnDelimiter);
                    }
                    ++j;
                }
                ((OutputStream)outputStream).write(10);
            }
        }
        catch (FileNotFoundException ex) {
            LOG.error("ERROR File {} not found. {}", (Object)file.getAbsolutePath(), (Object)ex.getMessage());
        }
        catch (IOException ex) {
            LOG.error("ERROR IOException {} {}", (Object)file.getAbsolutePath(), (Object)ex.getMessage());
        }
        finally {
            if (outputStream != null) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException ex) {
                    LOG.error(null, (Throwable)ex);
                }
            }
        }
    }

    protected final boolean canAnonymize(Rule rule, Integer[] coord) {
        return this.content.get(coord[1]) != null && this.content.get(coord[1]).get(coord[0]) != null;
    }

    @Override
    public final void ruleAppendAfter(Rule rule) {
        Integer[] id = this.rule2Coordinates(rule);
        if (!this.canAnonymize(rule, id)) {
            return;
        }
        String oldValue = this.content.get(id[1]).get(id[0]);
        String newValue = this.content.get(id[1]).get(id[0]) + rule.getNewValue();
        this.report(rule, oldValue, newValue);
        this.content.get(id[1]).set(id[0], newValue);
    }

    @Override
    public final void ruleAppendBefore(Rule rule) {
        Integer[] id = this.rule2Coordinates(rule);
        if (!this.canAnonymize(rule, id)) {
            return;
        }
        String oldValue = this.content.get(id[1]).get(id[0]);
        String newValue = rule.getNewValue() + this.content.get(id[1]).get(id[0]);
        this.report(rule, oldValue, newValue);
        this.content.get(id[1]).set(id[0], newValue);
    }

    @Override
    public final void ruleEmpty(Rule rule) {
        Integer[] id = this.rule2Coordinates(rule);
        if (!this.canAnonymize(rule, id)) {
            return;
        }
        String oldValue = this.content.get(id[1]).get(id[0]);
        this.report(rule, oldValue, "[EMPTY]");
        this.content.get(id[1]).set(id[0], "");
    }

    @Override
    public final void ruleChange(Rule rule) {
        Integer[] id = this.rule2Coordinates(rule);
        if (!this.canAnonymize(rule, id)) {
            return;
        }
        String oldValue = this.content.get(id[1]).get(id[0]);
        String newValue = rule.getNewValue();
        this.report(rule, oldValue, newValue);
        this.content.get(id[1]).set(id[0], newValue);
    }

    @Override
    public final void ruleIdentification(Rule rule) {
        Integer[] id = this.rule2Coordinates(rule);
        if (!this.canAnonymize(rule, id)) {
            return;
        }
        String oldValue = this.content.get(id[1]).get(id[0]);
        if (this.getAnonymousIdentification() == null) {
            this.setAnonymousIdentification(AnonymousIdentification.anonymize(oldValue));
        }
        this.report(rule, oldValue, this.getAnonymousIdentification());
        this.content.get(id[1]).set(id[0], this.getAnonymousIdentification());
    }

    @Override
    public final void ruleKeep(Rule rule) {
    }

    @Override
    public final void ruleRemove(Rule rule) {
        Integer[] id = this.rule2Coordinates(rule);
        if (!this.canAnonymize(rule, id)) {
            return;
        }
        String oldValue = this.content.get(id[1]).get(id[0]);
        this.report(rule, oldValue, "[REMOVED]");
        this.content.get(id[1]).set(id[0], null);
    }

    @Override
    public final void ruleSpecific(Rule rule) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public final void strictMode() {
    }

    @Override
    public void ruleDecrypt(Rule rule) {
        Integer[] id = this.rule2Coordinates(rule);
        if (!this.canAnonymize(rule, id)) {
            return;
        }
        String oldValue = this.content.get(id[1]).get(id[0]);
        String newValue = this.makeDecrypt(rule, oldValue);
        this.report(rule, oldValue, newValue);
        this.content.get(id[1]).set(id[0], newValue);
    }

    @Override
    public void ruleEncrypt(Rule rule) {
        Integer[] id = this.rule2Coordinates(rule);
        if (!this.canAnonymize(rule, id)) {
            return;
        }
        String oldValue = this.content.get(id[1]).get(id[0]);
        String newValue = this.makeEncrypt(rule, oldValue);
        this.report(rule, oldValue, newValue);
        this.content.get(id[1]).set(id[0], newValue);
    }

    protected final Integer[] rule2Coordinates(Rule rule) {
        Integer[] id = new Integer[2];
        String[] s = rule.getRule().split(",");
        id[1] = Integer.parseInt(s[1]) - 1;
        id[0] = Integer.parseInt(s[0]) - 1;
        return id;
    }

    public final char getColumnDelimiter() {
        return this.columnDelimiter;
    }

    public final void setColumnDelimiter(char delim) {
        this.columnDelimiter = delim;
    }

    @Override
    public void ruleSubstitute(Rule rule) {
        Integer[] id = this.rule2Coordinates(rule);
        if (!this.canAnonymize(rule, id)) {
            return;
        }
        String oldValue = this.content.get(id[1]).get(id[0]);
        String newValue = this.makeSubstitute(rule, oldValue);
        this.report(rule, oldValue, newValue);
        this.content.get(id[1]).set(id[0], newValue);
    }

    @Override
    public void ruleSubstring(Rule rule) {
        Integer[] id = this.rule2Coordinates(rule);
        if (!this.canAnonymize(rule, id)) {
            return;
        }
        String oldValue = this.content.get(id[1]).get(id[0]);
        String newValue = this.makeSubstring(rule, oldValue);
        this.report(rule, oldValue, newValue);
        this.content.get(id[1]).set(id[0], newValue);
    }

    @Override
    public void ruleLowercase(Rule rule) {
        Integer[] id = this.rule2Coordinates(rule);
        if (!this.canAnonymize(rule, id)) {
            return;
        }
        String oldValue = this.content.get(id[1]).get(id[0]);
        String newValue = this.makeLowercase(rule, oldValue);
        this.report(rule, oldValue, newValue);
        this.content.get(id[1]).set(id[0], newValue);
    }

    @Override
    public void ruleUppercase(Rule rule) {
        Integer[] id = this.rule2Coordinates(rule);
        if (!this.canAnonymize(rule, id)) {
            return;
        }
        String oldValue = this.content.get(id[1]).get(id[0]);
        String newValue = this.makeUppercase(rule, oldValue);
        this.report(rule, oldValue, newValue);
        this.content.get(id[1]).set(id[0], newValue);
    }
}

