/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.anonmed.anonymizer;

import cz.zcu.mre.anonmed.AnonMedConfiguration;
import cz.zcu.mre.anonmed.AnonMedException;
import cz.zcu.mre.anonmed.FilenameGenerator;
import cz.zcu.mre.anonmed.anonymizer.Anonymizer;
import cz.zcu.mre.anonmed.report.AnonMedReport;
import cz.zcu.mre.anonmed.rule.Operation;
import cz.zcu.mre.anonmed.rule.Profile;
import cz.zcu.mre.anonmed.rule.Rule;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAnonymizer
implements Anonymizer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAnonymizer.class);
    private AnonMedConfiguration config = null;
    private String fileType = null;
    private String fileExtension = null;
    private File activeFile = null;
    private Boolean uncertain = false;
    protected long originalLastModified = 0L;
    private String anonymousIdentification;

    public AbstractAnonymizer(AnonMedConfiguration conf) {
        this.setConfig(conf);
    }

    protected final void setConfig(AnonMedConfiguration conf) {
        if (conf == null) {
            throw new NullPointerException("Application config is null.");
        }
        this.config = conf;
    }

    @Override
    public final AnonMedConfiguration getConfig() {
        return this.config;
    }

    protected final void setFileExtension(String extension) {
        this.fileExtension = extension;
    }

    public final File getActiveFile() {
        return this.activeFile;
    }

    protected final void setActiveFile(File value) {
        this.activeFile = value;
        if (value != null) {
            this.originalLastModified = value.lastModified();
        }
    }

    @Override
    public final String getFileType() {
        return this.fileType;
    }

    protected final void setFileType(String type) {
        this.fileType = type;
    }

    public final Boolean isUncertain() {
        return this.uncertain;
    }

    protected final void setUncertain(Boolean value) {
        this.uncertain = value;
    }

    protected final String filenameGenerator() {
        String output = this.config.getOutputDirectory().getAbsolutePath();
        if (this.isUncertain().booleanValue()) {
            output = this.config.getUncertainDirectory().getAbsolutePath();
        }
        Object filename = this.config.isChangeFilename() != false ? FilenameGenerator.generateFileName().concat(".").concat(this.fileExtension) : File.separator + this.activeFile.getName();
        LOG.debug("OUTPUT in file {}", (Object)output.concat((String)filename));
        return output.concat((String)filename);
    }

    @Override
    public final File anonymize(File file) throws AnonMedException {
        this.fileOpen(file);
        if (this.getActiveFile() != null) {
            this.processRules();
            if (this.getConfig().isStrictMode().booleanValue()) {
                this.strictMode();
            }
            String outputFileName = this.filenameGenerator();
            this.fileWrite(outputFileName);
            File anonymousFile = new File(outputFileName);
            if (!anonymousFile.setLastModified(this.originalLastModified)) {
                LOG.error("ERROR Fail to change last modified time stamp {}", (Object)file.getAbsolutePath());
                return null;
            }
            return anonymousFile;
        }
        LOG.error("ERROR Fail to anonymise file {}", (Object)file.getAbsolutePath());
        return null;
    }

    @Override
    public final void processRules() {
        Profile<Rule> profile = this.config.getProfileBuilder().getProfile(this.getFileType());
        if (profile == null) {
            LOG.error("No profile for ''{}'' file type.", (Object)this.getFileType());
            return;
        }
        block20: for (Rule r : profile) {
            switch (r.getOperation()) {
                case APPEND_AFTER: {
                    this.ruleAppendAfter(r);
                    continue block20;
                }
                case APPEND_BEFORE: {
                    this.ruleAppendBefore(r);
                    continue block20;
                }
                case CHANGE: {
                    this.ruleChange(r);
                    continue block20;
                }
                case DECRYPT: {
                    this.ruleDecrypt(r);
                    continue block20;
                }
                case EMPTY: {
                    this.ruleEmpty(r);
                    continue block20;
                }
                case ENCRYPT: {
                    this.ruleEncrypt(r);
                    continue block20;
                }
                case EXTERNAL: {
                    try {
                        this.ruleExternal(r);
                    }
                    catch (AnonMedException e) {
                        LOG.error("Error during external application call: ", (Throwable)e);
                    }
                    continue block20;
                }
                case IDENTIFICATION: {
                    this.ruleIdentification(r);
                    continue block20;
                }
                case KEEP: {
                    this.ruleKeep(r);
                    continue block20;
                }
                case LOWERCASE: {
                    this.ruleLowercase(r);
                    continue block20;
                }
                case NONE: {
                    this.ruleNone(r);
                    continue block20;
                }
                case REMOVE: {
                    this.ruleRemove(r);
                    continue block20;
                }
                case SPECIFIC: {
                    this.ruleSpecific(r);
                    continue block20;
                }
                case SUBSTRING: {
                    this.ruleSubstring(r);
                    continue block20;
                }
                case SUBSTITUTE: {
                    this.ruleSubstitute(r);
                    continue block20;
                }
                case UPPERCASE: {
                    this.ruleUppercase(r);
                    continue block20;
                }
            }
            LOG.error("Not supported requested operation {}", (Object)r.getOperation());
        }
    }

    @Override
    public abstract void fileOpen(File var1) throws AnonMedException;

    @Override
    public abstract void fileWrite(String var1) throws AnonMedException;

    @Override
    public final void ruleExternal(Rule rule) throws AnonMedException {
        try {
            Process p = Runtime.getRuntime().exec(rule.getRule() + " " + String.valueOf(this.getActiveFile()) + " " + rule.getNewValue());
            if (p.exitValue() != 0) {
                throw new AnonMedException(p.exitValue());
            }
        }
        catch (IOException e) {
            LOG.error(null, (Throwable)e);
        }
    }

    @Override
    public void ruleKeep(Rule rule) {
    }

    @Override
    public void ruleNone(Rule rule) {
    }

    @Override
    public final Boolean isStrictModeRemove(String rule) {
        Profile<Rule> profile = this.config.getProfileBuilder().getProfile(this.getFileType());
        for (Rule r : profile) {
            if (!this.testForSameRule(r.getRule(), rule).booleanValue() || r.getOperation() != Operation.CHANGE && r.getOperation() != Operation.EMPTY && r.getOperation() != Operation.IDENTIFICATION && r.getOperation() != Operation.KEEP && r.getOperation() != Operation.ENCRYPT) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean testForSameRule(String rule1, String rule2) {
        if (rule1.equals(rule2)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected String makeEncrypt(Rule rule, String oldValue) {
        if (rule == null) {
            throw new IllegalArgumentException("The rule cannot be null");
        }
        String value = rule.getNewValue();
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("Missing or wrong argument(s) for ENCRYPT operation");
        }
        String[] settings = value.split(",");
        switch (settings.length) {
            case 0: {
                throw new IllegalArgumentException("Missing argument for ENCRYPT operation");
            }
            case 1: {
                String alg = settings[0].trim().toLowerCase();
                String alias = this.getAnonymousIdentification();
                LOG.debug("Use encrypt algorithm {} and key with alias {}", (Object)alg, (Object)alias);
                return this.config.getCipherService().encrypt(alg, oldValue, alias);
            }
            case 2: {
                String alg = settings[0].trim().toLowerCase();
                String alias = settings[1].trim().toLowerCase();
                LOG.debug("Use encrypt algorithm {} and key with alias {}", (Object)alg, (Object)alias);
                return this.config.getCipherService().encrypt(alg, oldValue, alias);
            }
        }
        throw new IllegalArgumentException("Only two arguments are allowed per ENCRYPT rule");
    }

    protected String makeDecrypt(Rule rule, String encrypted) {
        if (rule == null) {
            throw new IllegalArgumentException("The rule cannot be null");
        }
        String value = rule.getNewValue();
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("Missing or wrong argument(s) for ENCRYPT operation");
        }
        String[] settings = value.split(",");
        switch (settings.length) {
            case 0: {
                throw new IllegalArgumentException("Missing argument for ENCRYPT operation");
            }
            case 1: {
                String alg = settings[0].trim().toLowerCase();
                String alias = this.getAnonymousIdentification();
                LOG.debug("Use decrypt algorithm {} and key with alias {}", (Object)alg, (Object)alias);
                return this.config.getCipherService().decrypt(alg, encrypted, alias);
            }
            case 2: {
                String alg = settings[0].trim().toLowerCase();
                String alias = settings[1].trim().toLowerCase();
                LOG.debug("Use decrypt algorithm {} and key with alias {}", (Object)alg, (Object)alias);
                return this.config.getCipherService().decrypt(alg, encrypted, alias);
            }
        }
        throw new IllegalArgumentException("Only two arguments are allowed per ENCRYPT rule");
    }

    protected void report(Rule rule, String oldValue, String newValue) {
        AnonMedReport.add(this.activeFile, rule, oldValue, newValue);
    }

    protected String makeSubstitute(Rule rule, String oldValue) {
        if (rule == null || oldValue == null || oldValue.isEmpty()) {
            LOG.debug("Empty or null value for SUBSTITUTE {}", (Object)rule);
            return "";
        }
        String ruleValue = rule.getNewValue();
        if (ruleValue != null && !ruleValue.isEmpty()) {
            String[] conf = ruleValue.split("#");
            switch (conf.length) {
                case 2: {
                    return oldValue.replaceFirst(conf[0], conf[1]);
                }
                case 3: {
                    if (conf[2].equals("g")) {
                        return oldValue.replaceAll(conf[0], conf[1]);
                    }
                    return oldValue.replaceFirst(conf[0], conf[1]);
                }
            }
            LOG.debug("Wrong parameters (e.g. missing '#' separator) for SUBSTITUTE {}", (Object)rule);
        }
        return oldValue;
    }

    protected String makeSubstring(Rule rule, String oldValue) {
        if (rule == null || oldValue == null || oldValue.isEmpty()) {
            return "";
        }
        int beginIndex = 0;
        int endIndex = oldValue.length();
        String ruleValue = rule.getNewValue();
        if (ruleValue != null) {
            String[] conf = ruleValue.split(",");
            switch (conf.length) {
                case 0: {
                    LOG.error("Missing configuration for the SUBSTRING {}", (Object)rule);
                    return oldValue;
                }
                case 1: {
                    try {
                        beginIndex = Integer.parseInt(conf[0]);
                        return oldValue.substring(beginIndex);
                    }
                    catch (NumberFormatException ex) {
                        LOG.error("Wrong substring number in the rule {}", (Object)rule);
                        break;
                    }
                }
                case 2: {
                    if (conf[0].equals("MIN")) {
                        beginIndex = 0;
                    } else {
                        try {
                            beginIndex = Integer.parseInt(conf[0]);
                        }
                        catch (NumberFormatException ex) {
                            LOG.error("Wrong substring number in the rule {}", (Object)rule);
                        }
                    }
                    if (conf[1].equals("MAX")) {
                        endIndex = oldValue.length();
                        break;
                    }
                    try {
                        endIndex = Integer.parseInt(conf[1]);
                    }
                    catch (NumberFormatException ex) {
                        LOG.error("Wrong substring number in the rule {}", (Object)rule);
                    }
                    break;
                }
                default: {
                    LOG.error("The rule configuration should have two arguments - numbers, MIN or MAX string instead. Wrong parameters for substring: {}", (Object)rule);
                }
            }
        }
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if (endIndex > oldValue.length()) {
            endIndex = oldValue.length();
        }
        return oldValue.substring(beginIndex, endIndex);
    }

    protected String makeLowercase(Rule rule, String oldValue) {
        return oldValue.toLowerCase();
    }

    protected String makeUppercase(Rule rule, String oldValue) {
        return oldValue.toUpperCase();
    }

    @Override
    public String getAnonymousIdentification() {
        return this.anonymousIdentification;
    }

    protected void setAnonymousIdentification(String anonymousIdentification) {
        this.anonymousIdentification = anonymousIdentification;
    }
}

