/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.anonmed;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class FilenameGenerator {
    private static FilenameGenerator instance = null;
    public static final String DEFAULT_DATE_PATTERN = "yyyyMMddHHmmss";
    public static final String DEFAUL_SEQUENCE_PATTERN = "0000000000";
    private static Long sequenceNumber = 0L;
    private final Date date = new Date();
    private String datePattern = "yyyyMMddHHmmss";
    private String sequencePattern = "0000000000";
    private NumberFormat sequenceFormat = new DecimalFormat(this.sequencePattern);
    private SimpleDateFormat dateFormat = new SimpleDateFormat(this.datePattern);

    public static synchronized FilenameGenerator get() {
        if (instance == null) {
            instance = new FilenameGenerator();
        }
        return instance;
    }

    public static synchronized Long getFilenameSequence() {
        sequenceNumber = sequenceNumber + 1L;
        return sequenceNumber;
    }

    public static synchronized String generateFileName() {
        Object hostname = null;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        hostname = hostname == null ? "" : (String)hostname + "-";
        return File.separator + (String)hostname + FilenameGenerator.get().dateFormat.format(FilenameGenerator.get().date) + "-" + FilenameGenerator.get().sequenceFormat.format(FilenameGenerator.getFilenameSequence());
    }

    private FilenameGenerator() {
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(String value) {
        this.datePattern = value;
        this.dateFormat = new SimpleDateFormat(value);
    }

    public String getSequencePattern() {
        return this.sequencePattern;
    }

    public void setSequencePattern(String pattern) {
        this.sequencePattern = pattern;
        this.sequenceFormat = new DecimalFormat(pattern);
    }
}

