/*
 * Decompiled with CFR 0.152.
 */
package cz.zcu.mre.anonmed;

import cz.zcu.mre.mrelib.Const;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnonymousIdentification {
    private static final Logger LOG = LoggerFactory.getLogger(AnonymousIdentification.class);
    public static final String EMPTY_ANONYMOUS_IDENTIFICATION = "";
    private static final String SEPARATOR = "\t";
    private static File databaseSource = null;
    private static File sequenceSource = null;

    public static synchronized String anonymize(String oldValue) {
        String anonymousIdentification = AnonymousIdentification.lookup(oldValue);
        if (anonymousIdentification == null) {
            anonymousIdentification = AnonymousIdentification.create(oldValue);
        }
        return anonymousIdentification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String lookup(String oldValue) {
        String anonymous = null;
        BufferedReader in = null;
        try {
            String record;
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(databaseSource), Const.CHARSET));
            while ((record = in.readLine()) != null) {
                String[] columns = record.split(SEPARATOR, 2);
                if (!columns[0].equals(oldValue)) continue;
                anonymous = columns[1];
                break;
            }
        }
        catch (IOException e) {
            LOG.error(null, (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                LOG.error(null, (Throwable)e);
            }
        }
        return anonymous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String create(String oldValue) {
        BufferedWriter out = null;
        Long newIdentification = AnonymousIdentification.getUnused();
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(databaseSource, true), Const.CHARSET));
            out.write(oldValue + SEPARATOR + newIdentification + "\n");
        }
        catch (IOException e) {
            LOG.error(null, (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                LOG.error(null, (Throwable)e);
            }
        }
        return newIdentification.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Long getUnused() {
        BufferedReader in = null;
        Long nextSequenceIdentification = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sequenceSource), Const.CHARSET));
            String unused = in.readLine();
            nextSequenceIdentification = Long.valueOf(unused);
        }
        catch (IOException e) {
            LOG.error(null, (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                LOG.error(null, (Throwable)e);
            }
        }
        if (nextSequenceIdentification != null) {
            AnonymousIdentification.saveNextSequence(nextSequenceIdentification + 1L);
        }
        return nextSequenceIdentification;
    }

    private static void saveNextSequence(Long sequence) {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(sequenceSource, false), "UTF8"));
            out.write(sequence.toString());
        }
        catch (IOException e) {
            LOG.error(null, (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                LOG.error(null, (Throwable)e);
            }
        }
    }

    public static void setDatabaseSource(File source) {
        if (!(source != null && source.exists() && source.canRead() && source.canWrite())) {
            LOG.error("Missing or no access to Identification Database.");
        }
        databaseSource = source;
    }

    public static void setSequenceSource(File sequence) {
        if (!(sequence != null && sequence.exists() && sequence.canRead() && sequence.canWrite())) {
            LOG.error("Missing or no access to sequence source.");
        }
        sequenceSource = sequence;
    }

    private AnonymousIdentification() {
    }
}

