/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.codec.jpeg;

import java.io.IOException;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.ImageOutputStreamImpl;
import org.dcm4che3.imageio.codec.jpeg.JPEGLSCodingParam;
import org.dcm4che3.imageio.codec.jpeg.PatchJPEGLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchJPEGLSImageOutputStream
extends ImageOutputStreamImpl {
    private static final Logger LOG = LoggerFactory.getLogger(PatchJPEGLSImageOutputStream.class);
    private final ImageOutputStream ios;
    private final PatchJPEGLS patchJpegLS;
    private byte[] jpegheader;
    private int jpegheaderIndex;

    public PatchJPEGLSImageOutputStream(ImageOutputStream ios, PatchJPEGLS patchJpegLS) throws IOException {
        if (ios == null) {
            throw new NullPointerException("ios");
        }
        this.streamPos = ios.getStreamPosition();
        this.flushedPos = ios.getFlushedPosition();
        this.ios = ios;
        this.patchJpegLS = patchJpegLS;
        this.jpegheader = patchJpegLS != null ? new byte[256] : null;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.jpegheader == null) {
            this.ios.write(b, off, len);
        } else {
            int len0 = Math.min(this.jpegheader.length - this.jpegheaderIndex, len);
            System.arraycopy(b, off, this.jpegheader, this.jpegheaderIndex, len0);
            this.jpegheaderIndex += len0;
            if (this.jpegheaderIndex >= this.jpegheader.length) {
                JPEGLSCodingParam param = this.patchJpegLS.createJPEGLSCodingParam(this.jpegheader);
                if (param == null) {
                    this.ios.write(this.jpegheader);
                } else {
                    LOG.debug("Patch JPEG-LS with {}", (Object)param);
                    int offset = param.getOffset();
                    this.ios.write(this.jpegheader, 0, offset);
                    this.ios.write(param.getBytes());
                    this.ios.write(this.jpegheader, offset, this.jpegheader.length - offset);
                }
                this.ios.write(b, off + len0, len - len0);
                this.jpegheader = null;
            }
        }
        this.streamPos += (long)len;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.jpegheader == null) {
            this.ios.write(b);
            ++this.streamPos;
        } else {
            this.write(new byte[]{(byte)b}, 0, 1);
        }
    }

    @Override
    public int read() throws IOException {
        return this.ios.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.ios.read(b, off, len);
    }
}

