/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.codec;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import javax.imageio.IIOImage;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.BulkData;
import org.dcm4che3.data.Fragments;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.image.BufferedImageUtils;
import org.dcm4che3.image.Overlays;
import org.dcm4che3.image.PaletteColorModel;
import org.dcm4che3.image.PhotometricInterpretation;
import org.dcm4che3.imageio.codec.CompressionVerificationException;
import org.dcm4che3.imageio.codec.ExtMemoryCacheImageOutputStream;
import org.dcm4che3.imageio.codec.ImageDescriptor;
import org.dcm4che3.imageio.codec.ImageReaderFactory;
import org.dcm4che3.imageio.codec.ImageWriterFactory;
import org.dcm4che3.imageio.codec.TransferSyntaxType;
import org.dcm4che3.imageio.codec.jpeg.PatchJPEGLSImageInputStream;
import org.dcm4che3.imageio.codec.jpeg.PatchJPEGLSImageOutputStream;
import org.dcm4che3.imageio.stream.EncapsulatedPixelDataImageInputStream;
import org.dcm4che3.io.BulkDataDescriptor;
import org.dcm4che3.io.DicomEncodingOptions;
import org.dcm4che3.io.DicomInputHandler;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.util.ByteUtils;
import org.dcm4che3.util.Property;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.util.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transcoder
implements Closeable {
    public static final ColorSpace sRGB = ColorSpace.getInstance(1000);
    private static final Logger LOG = LoggerFactory.getLogger(Transcoder.class);
    private static final int BUFFER_SIZE = 8192;
    private static final int[] cmTags = new int[]{2625793, 2625794, 2625795, 2625945, 2626049, 2626050, 2626051, 0x281221, 0x281222, 2626083, 0x282000};
    private final DicomInputStream dis;
    private final String srcTransferSyntax;
    private final TransferSyntaxType srcTransferSyntaxType;
    private final Attributes dataset;
    private boolean retainFileMetaInformation;
    private boolean includeFileMetaInformation;
    private boolean includeImplementationVersionName = true;
    private boolean nullifyPixelData;
    private DicomEncodingOptions encOpts = DicomEncodingOptions.DEFAULT;
    private boolean closeInputStream = true;
    private boolean closeOutputStream = true;
    private boolean deleteBulkDataFiles = true;
    private String destTransferSyntax;
    private TransferSyntaxType destTransferSyntaxType;
    private boolean lossyCompression;
    private int bitsCompressed = 0;
    private int maxPixelValueError = -1;
    private int avgPixelValueBlockSize = 1;
    private Attributes fileMetaInformation;
    private DicomOutputStream dos;
    private Handler handler;
    private ImageDescriptor imageDescriptor;
    private ImageDescriptor compressorImageDescriptor;
    private EncapsulatedPixelDataImageInputStream encapsulatedPixelData;
    private ImageReaderFactory.ImageReaderParam decompressorParam;
    private ImageReader decompressor;
    private ImageReadParam decompressParam;
    private ImageWriterFactory.ImageWriterParam compressorParam;
    private ImageWriter compressor;
    private ImageWriteParam compressParam;
    private ImageReader verifier;
    private ImageReadParam verifyParam;
    private boolean ybr2rgb;
    private boolean palette2rgb;
    private BufferedImage originalBi;
    private BufferedImage bi;
    private BufferedImage bi2;
    private String pixelDataBulkDataURI;
    private byte[] buffer;
    private final DicomInputHandler dicomInputHandler = new DicomInputHandler(){

        public void readValue(DicomInputStream dis, Attributes attrs) throws IOException {
            int tag = dis.tag();
            if (dis.level() == 0 && tag == 2145386512) {
                if (Transcoder.this.nullifyPixelData) {
                    Transcoder.this.dataset.setNull(2145386512, dis.vr());
                    Transcoder.this.skipPixelData();
                } else {
                    Transcoder.this.imageDescriptor = new ImageDescriptor(attrs, Transcoder.this.bitsCompressed);
                    Transcoder.this.setDestinationTransferSyntax(Transcoder.this.adaptSuitableSyntax(Transcoder.this.destTransferSyntax));
                    Transcoder.this.initDicomOutputStream();
                    Transcoder.this.processPixelData();
                }
            } else {
                dis.readValue(dis, attrs);
            }
        }

        public void readValue(DicomInputStream dis, Sequence seq) throws IOException {
            dis.readValue(dis, seq);
        }

        public void readValue(DicomInputStream dis, Fragments frags) throws IOException {
            if (Transcoder.this.dos == null) {
                if (Transcoder.this.nullifyPixelData) {
                    StreamUtils.skipFully((InputStream)dis, (long)dis.unsignedLength());
                } else {
                    dis.readValue(dis, frags);
                }
            } else {
                long length = dis.unsignedLength();
                Transcoder.this.dos.writeHeader(-73728, null, (int)(length + 1L) & 0xFFFFFFFE);
                StreamUtils.copy((InputStream)dis, (OutputStream)Transcoder.this.dos, (long)length, (byte[])Transcoder.this.buffer());
                if ((length & 1L) != 0L) {
                    LOG.info("Odd length of Pixel Data Fragment: {} - append NULL byte to ensure even length", (Object)length);
                    Transcoder.this.dos.write(0);
                }
            }
        }

        public void startDataset(DicomInputStream dis) throws IOException {
        }

        public void endDataset(DicomInputStream dis) throws IOException {
        }
    };

    public Transcoder(File f) throws IOException {
        this(new DicomInputStream(f));
    }

    public Transcoder(InputStream in) throws IOException {
        this(new DicomInputStream(in));
    }

    public Transcoder(InputStream in, String tsuid) throws IOException {
        this(new DicomInputStream(in, tsuid));
    }

    public Transcoder(DicomInputStream dis) throws IOException {
        this.dis = dis;
        dis.readFileMetaInformation();
        dis.setDicomInputHandler(this.dicomInputHandler);
        this.dataset = new Attributes(dis.bigEndian(), 64);
        this.srcTransferSyntax = dis.getTransferSyntax();
        this.srcTransferSyntaxType = TransferSyntaxType.forUID(this.srcTransferSyntax);
        this.destTransferSyntax = this.srcTransferSyntax;
        this.destTransferSyntaxType = this.srcTransferSyntaxType;
    }

    public void setEncodingOptions(DicomEncodingOptions encOpts) {
        this.encOpts = Objects.requireNonNull(encOpts);
    }

    public void setConcatenateBulkDataFiles(boolean catBlkFiles) {
        this.dis.setConcatenateBulkDataFiles(catBlkFiles);
    }

    public void setIncludeBulkData(DicomInputStream.IncludeBulkData includeBulkData) {
        this.dis.setIncludeBulkData(includeBulkData);
    }

    public void setBulkDataDescriptor(BulkDataDescriptor bulkDataDescriptor) {
        this.dis.setBulkDataDescriptor(bulkDataDescriptor);
    }

    public void setBulkDataDirectory(File blkDirectory) {
        this.dis.setBulkDataDirectory(blkDirectory);
    }

    public boolean isCloseInputStream() {
        return this.closeInputStream;
    }

    public void setCloseInputStream(boolean closeInputStream) {
        this.closeInputStream = closeInputStream;
    }

    public boolean isCloseOutputStream() {
        return this.closeOutputStream;
    }

    public void setCloseOutputStream(boolean closeOutputStream) {
        this.closeOutputStream = closeOutputStream;
    }

    public boolean isDeleteBulkDataFiles() {
        return this.deleteBulkDataFiles;
    }

    public void setDeleteBulkDataFiles(boolean deleteBulkDataFiles) {
        this.deleteBulkDataFiles = deleteBulkDataFiles;
    }

    public boolean isIncludeFileMetaInformation() {
        return this.includeFileMetaInformation;
    }

    public void setIncludeFileMetaInformation(boolean includeFileMetaInformation) {
        this.includeFileMetaInformation = includeFileMetaInformation;
    }

    public boolean isRetainFileMetaInformation() {
        return this.retainFileMetaInformation;
    }

    public void setRetainFileMetaInformation(boolean retainFileMetaInformation) {
        this.retainFileMetaInformation = retainFileMetaInformation;
    }

    public boolean isIncludeImplementationVersionName() {
        return this.includeImplementationVersionName;
    }

    public void setIncludeImplementationVersionName(boolean includeImplementationVersionName) {
        this.includeImplementationVersionName = includeImplementationVersionName;
    }

    public boolean isNullifyPixelData() {
        return this.nullifyPixelData;
    }

    public void setNullifyPixelData(boolean nullifyPixelData) {
        this.nullifyPixelData = nullifyPixelData;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    public String getSourceTransferSyntax() {
        return this.dis.getTransferSyntax();
    }

    public TransferSyntaxType getSourceTransferSyntaxType() {
        return this.srcTransferSyntaxType;
    }

    public String getDestinationTransferSyntax() {
        return this.destTransferSyntax;
    }

    public void setDestinationTransferSyntax(String tsuid) {
        if (tsuid.equals(this.destTransferSyntax)) {
            return;
        }
        this.destTransferSyntaxType = TransferSyntaxType.forUID(tsuid);
        this.lossyCompression = TransferSyntaxType.isLossyCompression(tsuid);
        this.destTransferSyntax = tsuid;
        if (this.srcTransferSyntaxType.isPixeldataEncapsulated()) {
            this.initDecompressor();
        } else if (this.decompressor != null) {
            this.decompressor.dispose();
            this.decompressor = null;
        }
        if (this.destTransferSyntaxType.isPixeldataEncapsulated()) {
            this.initCompressor(tsuid);
        } else if (this.compressor != null) {
            this.compressor.dispose();
            this.compressor = null;
        }
    }

    private String adaptSuitableSyntax(String dstTsuid) {
        int bitsStored = this.imageDescriptor.getBitsStored();
        if (this.imageDescriptor.getBitsAllocated() == 1 && TransferSyntaxType.forUID(dstTsuid) != TransferSyntaxType.NATIVE) {
            return this.srcTransferSyntax;
        }
        switch (dstTsuid) {
            case "1.2.840.10008.1.2.4.50": {
                return bitsStored <= 8 ? dstTsuid : (!this.imageDescriptor.isSigned() && bitsStored <= 12 ? "1.2.840.10008.1.2.4.51" : (bitsStored <= 16 ? "1.2.840.10008.1.2.4.70" : "1.2.840.10008.1.2.1"));
            }
            case "1.2.840.10008.1.2.4.51": 
            case "1.2.840.10008.1.2.4.53": 
            case "1.2.840.10008.1.2.4.55": {
                return !this.imageDescriptor.isSigned() && bitsStored <= 12 ? dstTsuid : (bitsStored <= 16 ? "1.2.840.10008.1.2.4.70" : "1.2.840.10008.1.2.1");
            }
            case "1.2.840.10008.1.2.4.57": 
            case "1.2.840.10008.1.2.4.70": 
            case "1.2.840.10008.1.2.4.80": 
            case "1.2.840.10008.1.2.4.81": 
            case "1.2.840.10008.1.2.4.90": 
            case "1.2.840.10008.1.2.4.91": 
            case "1.2.840.10008.1.2.4.201": 
            case "1.2.840.10008.1.2.4.202": 
            case "1.2.840.10008.1.2.4.203": {
                return bitsStored <= 16 ? dstTsuid : "1.2.840.10008.1.2.1";
            }
            case "1.2.840.10008.1.2.4.110": {
                return bitsStored <= 32 ? dstTsuid : "1.2.840.10008.1.2.1";
            }
            case "1.2.840.10008.1.2.4.111": 
            case "1.2.840.10008.1.2.4.112": {
                return bitsStored <= 8 ? dstTsuid : (bitsStored <= 32 ? "1.2.840.10008.1.2.4.110" : "1.2.840.10008.1.2.1");
            }
        }
        return dstTsuid;
    }

    public String getPixelDataBulkDataURI() {
        return this.pixelDataBulkDataURI;
    }

    public void setPixelDataBulkDataURI(String pixelDataBulkDataURI) {
        this.pixelDataBulkDataURI = pixelDataBulkDataURI;
    }

    public List<File> getBulkDataFiles() {
        return this.dis.getBulkDataFiles();
    }

    public Attributes getFileMetaInformation() {
        return this.fileMetaInformation;
    }

    private void initDecompressor() {
        this.decompressorParam = ImageReaderFactory.getImageReaderParam(this.srcTransferSyntax);
        if (this.decompressorParam == null) {
            throw new UnsupportedOperationException("Unsupported Transfer Syntax: " + this.srcTransferSyntax);
        }
        this.decompressor = ImageReaderFactory.getImageReader(this.decompressorParam);
        LOG.debug("Decompressor: {}", (Object)this.decompressor.getClass().getName());
        this.decompressParam = this.decompressor.getDefaultReadParam();
    }

    private void initCompressor(String tsuid) {
        this.compressorParam = ImageWriterFactory.getImageWriterParam(tsuid);
        if (this.compressorParam == null) {
            throw new UnsupportedOperationException("Unsupported Transfer Syntax: " + tsuid);
        }
        this.compressor = ImageWriterFactory.getImageWriter(this.compressorParam);
        LOG.debug("Compressor: {}", (Object)this.compressor.getClass().getName());
        this.compressParam = this.compressor.getDefaultWriteParam();
        this.setCompressParams(this.compressorParam.getImageWriteParams());
    }

    public void setCompressParams(Property ... imageWriteParams) {
        if (this.compressorParam == null) {
            return;
        }
        for (Property property : imageWriteParams) {
            String name = property.getName();
            if (name.equals("maxPixelValueError")) {
                this.maxPixelValueError = ((Number)property.getValue()).intValue();
                continue;
            }
            if (name.equals("avgPixelValueBlockSize")) {
                this.avgPixelValueBlockSize = ((Number)property.getValue()).intValue();
                continue;
            }
            if (name.equals("bitsCompressed")) {
                this.bitsCompressed = ((Number)property.getValue()).intValue();
                continue;
            }
            if (this.compressParam.getCompressionMode() != 2) {
                this.compressParam.setCompressionMode(2);
            }
            property.setAt((Object)this.compressParam);
        }
        if (this.maxPixelValueError >= 0) {
            ImageReaderFactory.ImageReaderParam readerParam = ImageReaderFactory.getImageReaderParam(this.destTransferSyntax);
            if (readerParam == null) {
                throw new UnsupportedOperationException("Unsupported Transfer Syntax: " + this.destTransferSyntax);
            }
            this.verifier = ImageReaderFactory.getImageReader(readerParam);
            this.verifyParam = this.verifier.getDefaultReadParam();
            LOG.debug("Verifier: {}", (Object)this.verifier.getClass().getName());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.decompressor != null) {
            this.decompressor.dispose();
        }
        if (this.compressor != null) {
            this.compressor.dispose();
        }
        if (this.verifier != null) {
            this.verifier.dispose();
        }
        if (this.closeInputStream) {
            SafeClose.close((Closeable)this.dis);
        }
        if (this.closeOutputStream) {
            SafeClose.close((Closeable)this.dos);
        }
        if (this.deleteBulkDataFiles) {
            for (File tmpFile : this.dis.getBulkDataFiles()) {
                tmpFile.delete();
            }
        }
    }

    public void transcode(Handler handler) throws IOException {
        this.handler = handler;
        this.dis.readAllAttributes(this.dataset);
        if (this.dos == null) {
            if (this.compressor != null) {
                this.destTransferSyntax = "1.2.840.10008.1.2.1";
                this.destTransferSyntaxType = TransferSyntaxType.NATIVE;
                this.lossyCompression = false;
            }
            this.initDicomOutputStream();
            this.writeDataset();
        } else {
            this.dataset.writePostPixelDataTo(this.dos);
        }
        this.dos.finish();
    }

    private void processPixelData() throws IOException {
        VR vr;
        if (this.decompressor != null) {
            this.initEncapsulatedPixelData();
        }
        if (this.compressor != null) {
            vr = VR.OB;
            this.compressPixelData();
        } else if (this.decompressor != null) {
            vr = VR.OW;
            this.decompressPixelData();
        } else {
            vr = this.dis.vr();
            this.copyPixelData();
        }
        this.setPixelDataBulkData(vr);
    }

    private void initEncapsulatedPixelData() throws IOException {
        this.encapsulatedPixelData = new EncapsulatedPixelDataImageInputStream(this.dis, this.imageDescriptor);
    }

    private void decompressPixelData() throws IOException {
        int length = this.imageDescriptor.getLength();
        int padding = length & 1;
        this.adjustDataset();
        this.writeDataset();
        this.dos.writeHeader(2145386512, VR.OW, length + padding);
        for (int i = 0; i < this.imageDescriptor.getFrames(); ++i) {
            this.decompressFrame(i);
            this.writeFrame();
        }
        if (padding != 0) {
            this.dos.write(0);
        }
    }

    private void skipPixelData() throws IOException {
        int length = this.dis.length();
        if (length == -1) {
            this.dis.readValue(this.dis, this.dataset);
        } else {
            StreamUtils.skipFully((InputStream)this.dis, (long)length);
        }
    }

    private void copyPixelData() throws IOException {
        long length = this.dis.unsignedLength();
        this.writeDataset();
        if (length == -1L) {
            this.dos.writeHeader(2145386512, this.dis.vr(), -1);
            this.dis.readValue(this.dis, this.dataset);
            this.dos.writeHeader(-73507, null, 0);
        } else {
            this.dos.writeHeader(2145386512, this.dis.vr(), (int)(length + 1L) & 0xFFFFFFFE);
            if (this.dis.bigEndian() == this.dos.isBigEndian()) {
                StreamUtils.copy((InputStream)this.dis, (OutputStream)this.dos, (long)length, (byte[])this.buffer());
            } else {
                StreamUtils.copy((InputStream)this.dis, (OutputStream)this.dos, (long)length, (int)this.dis.vr().numEndianBytes(), (byte[])this.buffer());
            }
            if ((length & 1L) != 0L) {
                LOG.info("Odd length of Pixel Data: {} - append NULL byte to ensure even length", (Object)length);
                this.dos.write(0);
            }
        }
    }

    private void compressPixelData() throws IOException {
        int padding = (int)(this.dis.unsignedLength() - (long)this.imageDescriptor.getLength());
        for (int i = 0; i < this.imageDescriptor.getFrames(); ++i) {
            if (this.decompressor == null) {
                this.readFrame();
            } else {
                this.decompressFrame(i);
            }
            if (i == 0) {
                this.extractEmbeddedOverlays();
                this.adjustDataset();
                this.writeDataset();
                this.dos.writeHeader(2145386512, VR.OB, -1);
                this.dos.writeHeader(-73728, null, 0);
            }
            this.nullifyUnusedBits();
            this.bi = this.palette2rgb ? BufferedImageUtils.convertPalettetoRGB((BufferedImage)this.originalBi, (BufferedImage)this.bi) : (this.ybr2rgb ? BufferedImageUtils.convertYBRtoRGB((BufferedImage)this.originalBi, (BufferedImage)this.bi) : (this.imageDescriptor.is16BitsAllocated8BitsStored() ? BufferedImageUtils.convertShortsToBytes((BufferedImage)this.originalBi, (BufferedImage)this.bi) : this.originalBi));
            this.compressFrame(i);
        }
        this.dis.skipFully((long)padding);
        this.dos.writeHeader(-73507, null, 0);
    }

    private void setPixelDataBulkData(VR vr) {
        if (this.pixelDataBulkDataURI != null) {
            this.dataset.setValue(2145386512, vr, (Object)new BulkData(null, this.pixelDataBulkDataURI, false));
        }
    }

    private void adjustDataset() {
        PhotometricInterpretation pmi = this.imageDescriptor.getPhotometricInterpretation();
        if (this.decompressor != null) {
            if (this.imageDescriptor.getSamples() == 3) {
                if (pmi.isYBR() && TransferSyntaxType.isYBRCompression(this.srcTransferSyntax)) {
                    pmi = PhotometricInterpretation.RGB;
                    this.dataset.setString(2621444, VR.CS, pmi.toString());
                }
                this.dataset.setInt(2621446, VR.US, new int[]{this.srcTransferSyntaxType.getPlanarConfiguration()});
            } else if (this.srcTransferSyntaxType.adjustBitsStoredTo12(this.dataset)) {
                LOG.info("Adjust invalid Bits Stored: {} of {} to 12", (Object)this.imageDescriptor.getBitsStored(), (Object)this.srcTransferSyntaxType);
            }
        }
        if (this.compressor != null) {
            if (pmi == PhotometricInterpretation.PALETTE_COLOR && this.lossyCompression) {
                this.palette2rgb = true;
                this.dataset.removeSelected(cmTags);
                this.dataset.setInt(0x280002, VR.US, new int[]{3});
                this.dataset.setInt(2621696, VR.US, new int[]{8});
                this.dataset.setInt(2621697, VR.US, new int[]{8});
                this.dataset.setInt(2621698, VR.US, new int[]{7});
                pmi = PhotometricInterpretation.RGB;
                LOG.warn("Converting PALETTE_COLOR model into a lossy format is not recommended, prefer a lossless format");
            } else if (pmi.isSubSampled() && !this.srcTransferSyntaxType.isPixeldataEncapsulated() || pmi == PhotometricInterpretation.YBR_FULL && (TransferSyntaxType.isYBRCompression(this.destTransferSyntax) || this.destTransferSyntaxType == TransferSyntaxType.JPEG_LS)) {
                this.ybr2rgb = true;
                pmi = PhotometricInterpretation.RGB;
                LOG.debug("Conversion to an RGB color model is required before compression.");
            } else if (this.destTransferSyntaxType.adjustBitsStoredTo12(this.dataset)) {
                LOG.debug("Adjust Bits Stored: {} for {} to 12", (Object)this.imageDescriptor.getBitsStored(), (Object)this.destTransferSyntaxType);
            }
            this.dataset.setString(2621444, VR.CS, this.pmiForCompression(pmi).toString());
            this.compressorImageDescriptor = new ImageDescriptor(this.dataset, this.bitsCompressed);
            pmi = pmi.compress(this.destTransferSyntax);
            this.dataset.setString(2621444, VR.CS, pmi.toString());
            if (this.dataset.getInt(0x280002, 1) > 1) {
                this.dataset.setInt(2621446, VR.US, new int[]{this.destTransferSyntaxType.getPlanarConfiguration()});
            }
            if (this.lossyCompression) {
                this.dataset.setString(2629904, VR.CS, "01");
                try {
                    this.dataset.setFloat(0x282112, VR.DS, new float[]{((Number)this.compressParam.getClass().getMethod("getCompressionRatiofactor", new Class[0]).invoke((Object)this.compressParam, new Object[0])).floatValue()});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private PhotometricInterpretation pmiForCompression(PhotometricInterpretation pmi) {
        return pmi.isYBR() && (this.destTransferSyntaxType == TransferSyntaxType.JPEG_LOSSLESS || this.destTransferSyntaxType == TransferSyntaxType.JPEG_LS) ? PhotometricInterpretation.RGB : pmi;
    }

    private void extractEmbeddedOverlays() {
        for (int gg0000 : this.imageDescriptor.getEmbeddedOverlays()) {
            int ovlyRow = this.dataset.getInt(0x60000010 | gg0000, 0);
            int ovlyColumns = this.dataset.getInt(0x60000011 | gg0000, 0);
            int ovlyBitPosition = this.dataset.getInt(0x60000102 | gg0000, 0);
            int mask = 1 << ovlyBitPosition;
            int ovlyLength = ovlyRow * ovlyColumns;
            byte[] ovlyData = new byte[(ovlyLength + 7 >>> 3) + 1 & 0xFFFFFFFE];
            Overlays.extractFromPixeldata((Raster)this.originalBi.getRaster(), (int)mask, (byte[])ovlyData, (int)0, (int)ovlyLength);
            this.dataset.setInt(0x60000100 | gg0000, VR.US, new int[]{1});
            this.dataset.setInt(0x60000102 | gg0000, VR.US, new int[]{0});
            this.dataset.setBytes(0x60003000 | gg0000, VR.OB, ovlyData);
            LOG.debug("Extracted embedded overlay #{} from bit #{}", (Object)((gg0000 >>> 17) + 1), (Object)ovlyBitPosition);
        }
    }

    private void nullifyUnusedBits() {
        if (this.imageDescriptor.getBitsStored() < this.imageDescriptor.getBitsAllocated()) {
            DataBuffer db = this.originalBi.getRaster().getDataBuffer();
            switch (db.getDataType()) {
                case 1: {
                    this.nullifyUnusedBits(((DataBufferUShort)db).getData());
                    break;
                }
                case 2: {
                    this.extendSignUnusedBits(((DataBufferShort)db).getData());
                }
            }
        }
    }

    private void nullifyUnusedBits(short[] data) {
        int mask = (1 << this.imageDescriptor.getBitsStored()) - 1;
        int i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = (short)(data[n] & mask);
        }
    }

    private void extendSignUnusedBits(short[] data) {
        int unused = 32 - this.imageDescriptor.getBitsStored();
        for (int i = 0; i < data.length; ++i) {
            data[i] = (short)(data[i] << unused >> unused);
        }
    }

    private BufferedImage decompressFrame(int frameIndex) throws IOException {
        this.decompressor.setInput(this.decompressorParam.patchJPEGLS != null ? new PatchJPEGLSImageInputStream(this.encapsulatedPixelData, this.decompressorParam.patchJPEGLS) : this.encapsulatedPixelData);
        if (this.srcTransferSyntaxType == TransferSyntaxType.RLE) {
            this.initBufferedImage();
        }
        this.decompressParam.setDestination(this.originalBi);
        long start = System.currentTimeMillis();
        this.originalBi = this.adjustColorModel(this.decompressor.read(0, this.decompressParam));
        long end = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Decompressed frame #{} in {} ms, ratio 1:{}", new Object[]{frameIndex + 1, end - start, Float.valueOf((float)this.imageDescriptor.getFrameLength() / (float)this.encapsulatedPixelData.getStreamPosition())});
        }
        this.encapsulatedPixelData.seekNextFrame();
        return this.originalBi;
    }

    private BufferedImage adjustColorModel(BufferedImage bi) {
        PhotometricInterpretation pmi = this.imageDescriptor.getPhotometricInterpretation();
        if (pmi == PhotometricInterpretation.PALETTE_COLOR && !(bi.getColorModel() instanceof PaletteColorModel)) {
            ColorModel cm;
            if (this.originalBi != null) {
                cm = this.originalBi.getColorModel();
            } else {
                int bitsStored = Math.min(this.imageDescriptor.getBitsStored(), this.destTransferSyntaxType.getMaxBitsStored());
                int dataType = bi.getSampleModel().getDataType();
                cm = pmi.createColorModel(bitsStored, dataType, sRGB, this.dataset);
            }
            bi = new BufferedImage(cm, bi.getRaster(), false, null);
        }
        return bi;
    }

    private void compressFrame(int frameIndex) throws IOException {
        ExtMemoryCacheImageOutputStream ios = new ExtMemoryCacheImageOutputStream(this.compressorImageDescriptor);
        this.compressor.setOutput(this.compressorParam.patchJPEGLS != null ? new PatchJPEGLSImageOutputStream(ios, this.compressorParam.patchJPEGLS) : ios);
        long start = System.currentTimeMillis();
        this.compressor.write(null, new IIOImage(this.bi, null, null), this.compressParam);
        long end = System.currentTimeMillis();
        int length = (int)ios.getStreamPosition();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Compressed frame #{} in {} ms, ratio {}:1", new Object[]{frameIndex + 1, end - start, Float.valueOf((float)this.imageDescriptor.getFrameLength() / (float)length)});
        }
        this.verify(ios, frameIndex);
        if ((length & 1) != 0) {
            ios.write(0);
            ++length;
        }
        this.dos.writeHeader(-73728, null, length);
        ios.setOutputStream((OutputStream)this.dos);
        ios.flush();
    }

    private void readFrame() throws IOException {
        this.initBufferedImage();
        WritableRaster raster = this.originalBi.getRaster();
        DataBuffer dataBuffer = raster.getDataBuffer();
        switch (dataBuffer.getDataType()) {
            case 2: {
                this.readFully(((DataBufferShort)dataBuffer).getData());
                break;
            }
            case 1: {
                this.readFully(((DataBufferUShort)dataBuffer).getData());
                break;
            }
            case 0: {
                this.readFully(((DataBufferByte)dataBuffer).getBankData());
            }
        }
    }

    private void readFully(byte[][] bb) throws IOException {
        for (byte[] b : bb) {
            this.dis.readFully(b);
        }
        if (this.dis.bigEndian() && this.dis.vr() == VR.OW) {
            ByteUtils.swapShorts((byte[][])bb);
        }
    }

    private void readFully(short[] s) throws IOException {
        int nelts;
        int off = 0;
        byte[] b = this.buffer();
        for (int len = s.length; len > 0; len -= nelts) {
            nelts = Math.min(len, b.length / 2);
            this.dis.readFully(b, 0, nelts * 2);
            this.toShorts(b, s, off, nelts, this.dis.bigEndian());
            off += nelts;
        }
    }

    private void toShorts(byte[] b, short[] s, int off, int len, boolean bigEndian) {
        int boff = 0;
        if (bigEndian) {
            for (int j = 0; j < len; ++j) {
                byte b0 = b[boff];
                int b1 = b[boff + 1] & 0xFF;
                s[off + j] = (short)(b0 << 8 | b1);
                boff += 2;
            }
        } else {
            for (int j = 0; j < len; ++j) {
                byte b0 = b[boff + 1];
                int b1 = b[boff] & 0xFF;
                s[off + j] = (short)(b0 << 8 | b1);
                boff += 2;
            }
        }
    }

    private byte[] buffer() {
        if (this.buffer == null) {
            this.buffer = new byte[8192];
        }
        return this.buffer;
    }

    private void writeFrame() throws IOException {
        WritableRaster raster = this.originalBi.getRaster();
        SampleModel sm = raster.getSampleModel();
        DataBuffer db = raster.getDataBuffer();
        switch (db.getDataType()) {
            case 0: {
                this.write(sm, ((DataBufferByte)db).getBankData());
                break;
            }
            case 1: {
                this.write(sm, ((DataBufferUShort)db).getData());
                break;
            }
            case 2: {
                this.write(sm, ((DataBufferShort)db).getData());
                break;
            }
            case 3: {
                this.write(sm, ((DataBufferInt)db).getData());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported Datatype: " + db.getDataType());
            }
        }
    }

    private void write(SampleModel sm, byte[][] bankData) throws IOException {
        int h = sm.getHeight();
        int w = sm.getWidth();
        ComponentSampleModel csm = (ComponentSampleModel)sm;
        int len = w * csm.getPixelStride();
        int stride = csm.getScanlineStride();
        if (csm.getBandOffsets()[0] != 0) {
            Transcoder.bgr2rgb(bankData[0]);
        }
        if (this.imageDescriptor.getBitsAllocated() == 16) {
            byte[] buf = new byte[len << 1];
            int j0 = this.dos.isBigEndian() ? 1 : 0;
            for (byte[] b : bankData) {
                int y = 0;
                int off = 0;
                while (y < h) {
                    this.dos.write(Transcoder.to16BitsAllocated(b, off, len, buf, j0));
                    ++y;
                    off += stride;
                }
            }
        } else {
            for (byte[] b : bankData) {
                int y = 0;
                int off = 0;
                while (y < h) {
                    this.dos.write(b, off, len);
                    ++y;
                    off += stride;
                }
            }
        }
    }

    private static byte[] to16BitsAllocated(byte[] b, int off, int len, byte[] buf, int j0) {
        int i = 0;
        int j = j0;
        while (i < len) {
            buf[j] = b[off + i];
            ++i;
            ++j;
            ++j;
        }
        return buf;
    }

    private static void bgr2rgb(byte[] bs) {
        int i = 0;
        for (int j = 2; j < bs.length; j += 3) {
            byte b = bs[i];
            bs[i] = bs[j];
            bs[j] = b;
            i += 3;
        }
    }

    private void write(SampleModel sm, short[] data) throws IOException {
        int h = sm.getHeight();
        int w = sm.getWidth();
        int stride = ((ComponentSampleModel)sm).getScanlineStride();
        byte[] b = new byte[w * 2];
        for (int y = 0; y < h; ++y) {
            int i = 0;
            int j = y * stride;
            while (i < b.length) {
                short s = data[j++];
                b[i++] = (byte)s;
                b[i++] = (byte)(s >> 8);
            }
            this.dos.write(b);
        }
    }

    private void write(SampleModel sm, int[] data) throws IOException {
        int h = sm.getHeight();
        int w = sm.getWidth();
        int stride = ((SinglePixelPackedSampleModel)sm).getScanlineStride();
        byte[] b = new byte[w * 3];
        for (int y = 0; y < h; ++y) {
            int i = 0;
            int j = y * stride;
            while (i < b.length) {
                int s = data[j++];
                b[i++] = (byte)(s >> 16);
                b[i++] = (byte)(s >> 8);
                b[i++] = (byte)s;
            }
            this.dos.write(b);
        }
    }

    private void initDicomOutputStream() throws IOException {
        this.dos = new DicomOutputStream(this.handler.newOutputStream(this, this.dataset), this.includeFileMetaInformation ? "1.2.840.10008.1.2.1" : this.destTransferSyntax);
        this.dos.setEncodingOptions(this.encOpts);
    }

    private void writeDataset() throws IOException {
        Attributes fmi = null;
        if (this.includeFileMetaInformation) {
            if (this.retainFileMetaInformation) {
                fmi = this.dis.getFileMetaInformation();
            }
            if (fmi == null) {
                fmi = this.dataset.createFileMetaInformation(this.destTransferSyntax, this.includeImplementationVersionName);
            } else {
                fmi.setString(131088, VR.UI, this.destTransferSyntax);
            }
        }
        this.dos.writeDataset(fmi, this.dataset);
        this.fileMetaInformation = fmi;
    }

    private void initBufferedImage() {
        if (this.originalBi != null) {
            return;
        }
        int rows = this.imageDescriptor.getRows();
        int cols = this.imageDescriptor.getColumns();
        int samples = this.imageDescriptor.getSamples();
        int bitsAllocated = this.imageDescriptor.getBitsAllocated();
        int bitsStored = Math.min(this.imageDescriptor.getBitsStored(), this.destTransferSyntaxType.getMaxBitsStored());
        boolean signed = this.imageDescriptor.isSigned() && this.destTransferSyntaxType.canEncodeSigned();
        boolean banded = this.imageDescriptor.isBanded() || this.srcTransferSyntaxType == TransferSyntaxType.RLE;
        PhotometricInterpretation pmi = this.imageDescriptor.getPhotometricInterpretation();
        int dataType = bitsAllocated > 8 ? (signed ? 2 : 1) : 0;
        ColorModel cm = pmi.createColorModel(bitsStored, dataType, sRGB, this.dataset);
        SampleModel sm = pmi.createSampleModel(dataType, cols, rows, samples, banded);
        WritableRaster raster = Raster.createWritableRaster(sm, null);
        this.originalBi = new BufferedImage(cm, raster, false, null);
    }

    private void verify(ImageOutputStream cache, int index) throws IOException {
        if (this.verifier == null) {
            return;
        }
        long prevStreamPosition = cache.getStreamPosition();
        int prevBitOffset = cache.getBitOffset();
        cache.seek(0L);
        this.verifier.setInput(cache);
        this.verifyParam.setDestination(this.bi2);
        long start = System.currentTimeMillis();
        this.bi2 = this.verifier.read(0, this.verifyParam);
        int maxDiff = this.maxDiff(this.bi.getRaster(), this.bi2.getRaster());
        long end = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Verified compressed frame #{} in {} ms - max pixel value error: {}", new Object[]{index + 1, end - start, maxDiff});
        }
        if (maxDiff > this.maxPixelValueError) {
            throw new CompressionVerificationException(maxDiff);
        }
        cache.seek(prevStreamPosition);
        cache.setBitOffset(prevBitOffset);
    }

    private int maxDiff(WritableRaster raster, WritableRaster raster2) {
        ComponentSampleModel csm = (ComponentSampleModel)raster.getSampleModel();
        ComponentSampleModel csm2 = (ComponentSampleModel)raster2.getSampleModel();
        DataBuffer db = raster.getDataBuffer();
        DataBuffer db2 = raster2.getDataBuffer();
        int blockSize = this.avgPixelValueBlockSize;
        if (blockSize > 1) {
            int w = csm.getWidth();
            int h = csm.getHeight();
            int maxY = (h / blockSize - 1) * blockSize;
            int maxX = (w / blockSize - 1) * blockSize;
            int[] samples = new int[blockSize * blockSize];
            int maxDiff = 0;
            for (int b = 0; b < csm.getNumBands(); ++b) {
                for (int y = 0; y < maxY; y += blockSize) {
                    for (int x = 0; x < maxX; x += blockSize) {
                        int diff = Math.abs(this.sum(csm.getSamples(x, y, blockSize, blockSize, b, samples, db)) - this.sum(csm2.getSamples(x, y, blockSize, blockSize, b, samples, db2)));
                        if (maxDiff >= diff) continue;
                        maxDiff = diff;
                    }
                }
            }
            return maxDiff / samples.length;
        }
        return db.getDataType() == 0 ? this.maxDiff(csm, ((DataBufferByte)db).getBankData(), csm2, ((DataBufferByte)db2).getBankData()) : this.maxDiff(csm, Transcoder.toShortData(db), csm2, Transcoder.toShortData(db2));
    }

    private static short[] toShortData(DataBuffer db) {
        return db.getDataType() == 2 ? ((DataBufferShort)db).getData() : ((DataBufferUShort)db).getData();
    }

    private int sum(int[] samples) {
        int sum = 0;
        for (int sample : samples) {
            sum += sample;
        }
        return sum;
    }

    private int maxDiff(ComponentSampleModel csm, short[] data, ComponentSampleModel csm2, short[] data2) {
        int w = csm.getWidth() * csm.getPixelStride();
        int h = csm.getHeight();
        int stride = csm.getScanlineStride();
        int stride2 = csm2.getScanlineStride();
        int maxDiff = 0;
        for (int y = 0; y < h; ++y) {
            int j = w;
            int i = y * stride;
            int i2 = y * stride2;
            while (j-- > 0) {
                int diff = Math.abs(data[i] - data2[i2]);
                if (maxDiff < diff) {
                    maxDiff = diff;
                }
                ++i;
                ++i2;
            }
        }
        return maxDiff;
    }

    private int maxDiff(ComponentSampleModel csm, byte[][] banks, ComponentSampleModel csm2, byte[][] banks2) {
        int w = csm.getWidth();
        int h = csm.getHeight();
        int bands = csm.getNumBands();
        int stride = csm.getScanlineStride();
        int pixelStride = csm.getPixelStride();
        int[] bankIndices = csm.getBankIndices();
        int[] bandOffsets = csm.getBandOffsets();
        int stride2 = csm2.getScanlineStride();
        int pixelStride2 = csm2.getPixelStride();
        int[] bankIndices2 = csm2.getBankIndices();
        int[] bandOffsets2 = csm2.getBandOffsets();
        int maxDiff = 0;
        for (int b = 0; b < bands; ++b) {
            byte[] bank = banks[bankIndices[b]];
            byte[] bank2 = banks2[bankIndices2[b]];
            int off = bandOffsets[b];
            int off2 = bandOffsets2[b];
            for (int y = 0; y < h; ++y) {
                int x = w;
                int i = y * stride + off;
                int i2 = y * stride2 + off2;
                while (x-- > 0) {
                    int diff = Math.abs(bank[i] - bank2[i2]);
                    if (maxDiff < diff) {
                        maxDiff = diff;
                    }
                    i += pixelStride;
                    i2 += pixelStride2;
                }
            }
        }
        return maxDiff;
    }

    public static interface Handler {
        public OutputStream newOutputStream(Transcoder var1, Attributes var2) throws IOException;
    }
}

