/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.codec;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import org.dcm4che3.imageio.codec.FormatNameFilterIterator;
import org.dcm4che3.imageio.codec.jpeg.PatchJPEGLS;
import org.dcm4che3.util.Property;
import org.dcm4che3.util.ResourceLocator;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageWriterFactory
implements Serializable {
    private static final long serialVersionUID = 6328126996969794374L;
    private static final Logger LOG = LoggerFactory.getLogger(ImageWriterFactory.class);
    private static volatile ImageWriterFactory defaultFactory;
    private PatchJPEGLS patchJPEGLS;
    private final TreeMap<String, ImageWriterParam> map = new TreeMap();

    private static String nullify(String s) {
        return s == null || s.isEmpty() || s.equals("*") ? null : s;
    }

    public static ImageWriterFactory getDefault() {
        if (defaultFactory == null) {
            defaultFactory = ImageWriterFactory.initDefault();
        }
        return defaultFactory;
    }

    public static void resetDefault() {
        defaultFactory = null;
    }

    public static void setDefault(ImageWriterFactory factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        defaultFactory = factory;
    }

    private static ImageWriterFactory initDefault() {
        ImageWriterFactory factory = new ImageWriterFactory();
        String name = System.getProperty(ImageWriterFactory.class.getName(), "org/dcm4che3/imageio/codec/ImageWriterFactory.properties");
        try {
            factory.load(name);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load Image Writer Factory configuration from: " + name, e);
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String name) throws IOException {
        URL url;
        block5: {
            try {
                url = new URL(name);
            }
            catch (MalformedURLException e) {
                url = ResourceLocator.getResourceURL((String)name, this.getClass());
                if (url != null) break block5;
                throw new IOException("No such resource: " + name);
            }
        }
        InputStream in = url.openStream();
        try {
            this.load(in);
        }
        finally {
            SafeClose.close((Closeable)in);
        }
    }

    public void load(InputStream in) throws IOException {
        Properties props = new Properties();
        props.load(in);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String[] ss = StringUtils.split((String)((String)entry.getValue()), (char)':');
            this.map.put((String)entry.getKey(), new ImageWriterParam(ss[0], ss[1], ss[2], StringUtils.split((String)ss[3], (char)';')));
        }
    }

    public final PatchJPEGLS getPatchJPEGLS() {
        return this.patchJPEGLS;
    }

    public final void setPatchJPEGLS(PatchJPEGLS patchJPEGLS) {
        this.patchJPEGLS = patchJPEGLS;
    }

    public ImageWriterParam get(String tsuid) {
        return this.map.get(tsuid);
    }

    public ImageWriterParam put(String tsuid, ImageWriterParam param) {
        return this.map.put(tsuid, param);
    }

    public ImageWriterParam remove(String tsuid) {
        return this.map.remove(tsuid);
    }

    public Set<Map.Entry<String, ImageWriterParam>> getEntries() {
        return Collections.unmodifiableMap(this.map).entrySet();
    }

    public void clear() {
        this.map.clear();
    }

    public static ImageWriterParam getImageWriterParam(String tsuid) {
        return ImageWriterFactory.getDefault().get(tsuid);
    }

    public static ImageWriter getImageWriter(ImageWriterParam param) {
        return Boolean.getBoolean("org.dcm4che3.imageio.codec.useServiceLoader") ? ImageWriterFactory.getImageWriterFromServiceLoader(param) : ImageWriterFactory.getImageWriterFromImageIOServiceRegistry(param);
    }

    public static ImageWriter getImageWriterFromImageIOServiceRegistry(ImageWriterParam param) {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(param.formatName);
        if (!iter.hasNext()) {
            throw new RuntimeException("No Writer for format: " + param.formatName + " registered");
        }
        ImageWriter writer = iter.next();
        if (param.className != null) {
            while (!param.className.equals(writer.getClass().getName())) {
                if (iter.hasNext()) {
                    writer = iter.next();
                    continue;
                }
                LOG.warn("No preferred Writer {} for format: {} - use {}", new Object[]{param.className, param.formatName, writer.getClass().getName()});
                break;
            }
        }
        return writer;
    }

    public static ImageWriter getImageWriterFromServiceLoader(ImageWriterParam param) {
        try {
            return ImageWriterFactory.getImageWriterSpi(param).createWriterInstance();
        }
        catch (IOException e) {
            throw new RuntimeException("Error instantiating Writer for format: " + param.formatName, e);
        }
    }

    private static ImageWriterSpi getImageWriterSpi(ImageWriterParam param) {
        FormatNameFilterIterator<ImageWriterSpi> iter = new FormatNameFilterIterator<ImageWriterSpi>(ServiceLoader.load(ImageWriterSpi.class).iterator(), param.formatName);
        if (!iter.hasNext()) {
            throw new RuntimeException("No Writer for format: " + param.formatName + " registered");
        }
        ImageWriterSpi spi = (ImageWriterSpi)iter.next();
        if (param.className != null) {
            while (!param.className.equals(spi.getPluginClassName())) {
                if (iter.hasNext()) {
                    spi = (ImageWriterSpi)iter.next();
                    continue;
                }
                LOG.warn("No preferred Writer {} for format: {} - use {}", new Object[]{param.className, param.formatName, spi.getPluginClassName()});
                break;
            }
        }
        return spi;
    }

    public static class ImageWriterParam
    implements Serializable {
        private static final long serialVersionUID = 3521737269113651910L;
        public final String formatName;
        public final String className;
        public final PatchJPEGLS patchJPEGLS;
        public final Property[] imageWriteParams;

        public ImageWriterParam(String formatName, String className, PatchJPEGLS patchJPEGLS, Property[] imageWriteParams) {
            this.formatName = formatName;
            this.className = ImageWriterFactory.nullify(className);
            this.patchJPEGLS = patchJPEGLS;
            this.imageWriteParams = imageWriteParams;
        }

        public ImageWriterParam(String formatName, String className, String patchJPEGLS, String[] imageWriteParams) {
            this(formatName, className, patchJPEGLS != null && !patchJPEGLS.isEmpty() ? PatchJPEGLS.valueOf(patchJPEGLS) : null, Property.valueOf((String[])imageWriteParams));
        }

        public Property[] getImageWriteParams() {
            return this.imageWriteParams;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImageWriterParam that = (ImageWriterParam)o;
            if (!this.formatName.equals(that.formatName)) {
                return false;
            }
            if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
                return false;
            }
            if (this.patchJPEGLS != that.patchJPEGLS) {
                return false;
            }
            return Arrays.equals(this.imageWriteParams, that.imageWriteParams);
        }

        public int hashCode() {
            int result = this.formatName.hashCode();
            result = 31 * result + (this.className != null ? this.className.hashCode() : 0);
            result = 31 * result + (this.patchJPEGLS != null ? this.patchJPEGLS.hashCode() : 0);
            result = 31 * result + Arrays.hashCode(this.imageWriteParams);
            return result;
        }

        public String toString() {
            return "ImageWriterParam{formatName='" + this.formatName + '\'' + ", className='" + this.className + '\'' + ", patchJPEGLS=" + (Object)((Object)this.patchJPEGLS) + ", imageWriteParams=" + Arrays.toString(this.imageWriteParams) + '}';
        }
    }
}

